/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.searchbar;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import oracle.ide.searchbar.Provider;
import oracle.ide.searchbar.Result;

class ResultModel {
    private List<Result<?>> results = new ArrayList();
    private List<Result<?>> pendingResults = new ArrayList();
    private List<ResultListener> resultListeners = new ArrayList<ResultListener>();
    private boolean isRunning = false;
    private Timer pendingTimer;
    private static int PENDING_INT = 500;
    static int SOFT_LIMIT = 1000;
    private Map<Provider, Integer> providerCountMap = new HashMap<Provider, Integer>();

    ResultModel() {
        this.pendingTimer = new Timer(PENDING_INT, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultModel.this.addPendingResults();
            }
        });
        this.pendingTimer.setCoalesce(true);
        this.pendingTimer.setRepeats(true);
    }

    int getTotalResultCount() {
        int totalCount = 0;
        for (Integer i : this.providerCountMap.values()) {
            totalCount += i.intValue();
        }
        return totalCount;
    }

    int getCountForProvider(Provider provider) {
        Integer i = this.providerCountMap.get(provider);
        if (i == null) {
            i = 0;
        }
        return i;
    }

    public void add(Result<?> result) {
        this.pendingResults.add(result);
        if (!this.pendingTimer.isRunning()) {
            this.pendingTimer.start();
        }
    }

    private void addPendingResults() {
        if (this.pendingResults.size() > 0) {
            ArrayList addedResults = new ArrayList();
            for (Result<?> r : this.pendingResults) {
                if (this.results.contains(r)) continue;
                if (this.results.size() < SOFT_LIMIT) {
                    this.results.add(r);
                    addedResults.add(r);
                }
                int i = this.getCountForProvider(r.provider());
                this.providerCountMap.put(r.provider(), ++i);
            }
            this.fireNewResults(addedResults);
            this.pendingResults.clear();
        }
    }

    void clear() {
        this.results.clear();
        this.pendingResults.clear();
        this.fireClearResults();
        this.providerCountMap.clear();
    }

    Collection<Result<?>> getAllResults() {
        this.addPendingResults();
        ArrayList allResults = new ArrayList(this.results);
        return allResults;
    }

    void delete(Result result) {
        this.results.remove(result);
        this.pendingResults.remove(result);
        this.fireDeletedResult(result);
        int i = this.getCountForProvider(result.provider());
        this.providerCountMap.put(result.provider(), --i);
    }

    void deleteAll(Provider provider) {
        this.addPendingResults();
        ArrayList newResults = new ArrayList();
        ArrayList deletedResults = new ArrayList();
        for (Result<?> r : this.results) {
            if (!r.provider().equals(provider)) {
                newResults.add(r);
                continue;
            }
            deletedResults.add(r);
        }
        this.results = newResults;
        this.fireDeletedResults(deletedResults);
        this.providerCountMap.put(provider, 0);
    }

    void setRunning(final boolean isRunning) {
        if (this.isRunning == isRunning) {
            return;
        }
        this.isRunning = isRunning;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!isRunning) {
                    ResultModel.this.addPendingResults();
                    ResultModel.this.pendingTimer.stop();
                }
                ResultModel.this.fireRunningChange();
            }
        });
    }

    boolean isRunning() {
        return this.isRunning;
    }

    void addResultListener(ResultListener rl) {
        if (!this.resultListeners.contains(rl)) {
            this.resultListeners.add(rl);
        }
    }

    void removeResultListener(ResultListener rl) {
        this.resultListeners.remove(rl);
    }

    private void fireDeletedResult(Result result) {
        for (ResultListener l : this.resultListeners) {
            l.deletedResult(result);
        }
    }

    private void fireDeletedResults(Collection<Result<?>> results) {
        for (ResultListener l : this.resultListeners) {
            l.deletedResults(results);
        }
    }

    private void fireNewResults(Collection<Result<?>> newResults) {
        for (ResultListener l : this.resultListeners) {
            l.newResults(newResults);
        }
    }

    private void fireClearResults() {
        for (ResultListener l : this.resultListeners) {
            l.clearResults();
        }
    }

    private void fireRunningChange() {
        for (ResultListener l : this.resultListeners) {
            l.runningChange(this.isRunning);
        }
    }

    static interface ResultListener {
        public void newResults(Collection<Result<?>> var1);

        public void clearResults();

        public void runningChange(boolean var1);

        public void deletedResult(Result var1);

        public void deletedResults(Collection<Result<?>> var1);
    }
}

