/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.control;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ModifiableObservableListBase;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import oracle.dbtools.raptor.metrics.control.Edge;
import oracle.dbtools.raptor.metrics.control.GraphObject;
import oracle.dbtools.raptor.metrics.control.Vertex;

public class Graph<T, V extends Vertex<T, V, E>, E extends Edge<T, V, E>> {
    private final ObservableList<E> edges = new ModifiableObservableListBase<E>(){
        private final List<E> delegate = new ArrayList();

        public E get(int n) {
            return (Edge)this.delegate.get(n);
        }

        public int size() {
            return this.delegate.size();
        }

        public void clear() {
            while (this.delegate.size() > 0) {
                this.remove(0);
            }
        }

        public boolean removeAll(Collection<?> collection) {
            boolean bl = false;
            for (Object obj : collection) {
                bl |= this.remove(obj);
            }
            return bl;
        }

        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        public ListIterator<E> listIterator(int n) {
            final ListIterator listIterator = this.delegate.listIterator(n);
            return new ListIterator<E>(){
                private E lastEdge;

                @Override
                public boolean hasNext() {
                    return listIterator.hasNext();
                }

                @Override
                public E next() {
                    this.lastEdge = (Edge)listIterator.next();
                    return this.lastEdge;
                }

                @Override
                public boolean hasPrevious() {
                    return listIterator.hasPrevious();
                }

                @Override
                public E previous() {
                    this.lastEdge = (Edge)listIterator.previous();
                    return this.lastEdge;
                }

                @Override
                public int nextIndex() {
                    return listIterator.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return listIterator.previousIndex();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(E e) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void add(E e) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public Iterator<E> iterator() {
            final Iterator iterator = this.delegate.iterator();
            return new Iterator<E>(){
                private E lastEdge;

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public E next() {
                    this.lastEdge = (Edge)iterator.next();
                    return this.lastEdge;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        protected void doAdd(int n, E e) {
            if (!Graph.this.beforeAddEdge(e)) {
                throw new IllegalArgumentException();
            }
            this.delegate.add(n, e);
            Graph.this.afterAddEdge(e);
        }

        protected E doSet(int n, E e) {
            if (!Graph.this.beforeAddEdge(e)) {
                throw new IllegalArgumentException();
            }
            Edge edge = (Edge)this.delegate.set(n, e);
            if (edge != null) {
                Graph.this.afterRemoveEdge(edge);
            }
            Graph.this.afterAddEdge(e);
            return edge;
        }

        protected E doRemove(int n) {
            Edge edge = (Edge)this.delegate.remove(n);
            if (edge != null) {
                Graph.this.afterRemoveEdge(edge);
            }
            return edge;
        }
    };
    private final ObservableList<V> vertices = FXCollections.observableArrayList();
    private final ObservableList<V> unmodifiableVertices = FXCollections.unmodifiableObservableList(this.vertices);
    private boolean dirty = false;
    private int maxVertexLevel = 0;
    private int nextId = 0;
    private boolean notificationPending;
    private EventHandler<ActionEvent> updateHandler;

    public ObservableList<E> getEdges() {
        return this.edges;
    }

    public ObservableList<V> getVertices() {
        return this.unmodifiableVertices;
    }

    public int getMaxVertexLevel() {
        this.verifyGlobal();
        return this.maxVertexLevel;
    }

    public void setUpdateHandler(EventHandler<ActionEvent> eventHandler) {
        this.updateHandler = eventHandler;
    }

    protected boolean beforeAddEdge(E e) {
        if (((GraphObject)e).getGraph() != null) {
            return false;
        }
        Object v = ((Edge)e).getSource();
        if (((GraphObject)v).getGraph() != null && ((GraphObject)v).getGraph() != this) {
            return false;
        }
        Object v2 = ((Edge)e).getDest();
        if (((GraphObject)v2).getGraph() != null && ((GraphObject)v2).getGraph() != this) {
            return false;
        }
        return !this.vertices.contains(v) || !this.vertices.contains(v2) || !((Vertex)v).isNeighbor(v2);
    }

    protected void afterAddEdge(E e) {
        Object v;
        ((GraphObject)e).setId(this.nextId++);
        ((GraphObject)e).setGraph(this);
        Object v2 = ((Edge)e).getSource();
        if (((GraphObject)v2).getGraph() == null) {
            ((GraphObject)v2).setGraph(this);
        }
        if (((GraphObject)(v = ((Edge)e).getDest())).getGraph() == null) {
            ((GraphObject)v).setGraph(this);
        }
        if (!this.vertices.contains(v2)) {
            this.vertices.add(v2);
            ((GraphObject)v2).setId(this.nextId++);
        }
        ((Vertex)v2).getDestToOutEdgeMap().put(v, e);
        if (!this.vertices.contains(v)) {
            this.vertices.add(v);
            ((GraphObject)v).setId(this.nextId++);
        }
        ((Vertex)v).getSourceToInEdgeMap().put(v2, e);
        this.notifyChanges();
    }

    protected void afterRemoveEdge(E e) {
        Object v = ((Edge)e).getSource();
        Object v2 = ((Edge)e).getDest();
        if (this.vertices.contains(v)) {
            ((Vertex)v).getDestToOutEdgeMap().remove(v2);
            if (((Vertex)v).getDegree() == 0) {
                this.vertices.remove(v);
                for (Edge edge : ((Vertex)v).getIncidentEdges()) {
                    this.edges.remove((Object)edge);
                }
            }
        }
        if (this.vertices.contains(v2)) {
            ((Vertex)v2).getSourceToInEdgeMap().remove(v);
            if (((Vertex)v2).getDegree() == 0) {
                this.vertices.remove(v2);
                for (Edge edge : ((Vertex)v2).getIncidentEdges()) {
                    this.edges.remove((Object)edge);
                }
            }
        }
        this.notifyChanges();
    }

    protected void verifyGlobal() {
        if (this.dirty) {
            this.calculateGlobal();
            this.dirty = false;
        }
    }

    protected void calculateGlobal() {
        this.calculateLevels();
    }

    protected void notifyChanges() {
        this.dirty = true;
        if (!this.notificationPending) {
            this.notificationPending = true;
            Platform.runLater(() -> {
                this.notificationPending = false;
                if (this.updateHandler != null) {
                    this.updateHandler.handle((Event)new ActionEvent((Object)this, null));
                }
            });
        }
    }

    ObservableList<V> getModifiableVertices() {
        return this.vertices;
    }

    private void calculateLevels() {
        for (Vertex vertex : this.vertices) {
            vertex.setRawLevel(-1);
        }
        for (Vertex vertex : this.vertices) {
            if (this.getLevel(vertex, vertex) >= 0) continue;
            throw new IllegalStateException("cyclic graph");
        }
        this.maxVertexLevel = -1;
        for (Vertex vertex : this.vertices) {
            int n = vertex.getRawLevel();
            if (n <= this.maxVertexLevel) continue;
            this.maxVertexLevel = n;
        }
    }

    private int getLevel(V v, V v2) {
        int n = ((Vertex)v).getRawLevel();
        if (n < 0) {
            if (((Vertex)v).getDegree() == 0) {
                return -1;
            }
            int n2 = -1;
            for (Vertex vertex : ((Vertex)v).getPredecessors()) {
                if (vertex == v2) {
                    return -1;
                }
                int n3 = this.getLevel(vertex, v2);
                if (n3 < 0) {
                    return n3;
                }
                if (n3 <= n2) continue;
                n2 = n3;
            }
            n = n2 + 1;
            ((Vertex)v).setRawLevel(n);
        }
        return n;
    }
}

