/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.control;

import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.geometry.Insets;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.layout.Region;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;

public class IntervalSlider
extends Region {
    private final DoubleProperty bracketHeightPercentProperty = new SimpleDoubleProperty(0.0);
    private final DoubleProperty sliderMinimumPercentProperty = new SimpleDoubleProperty(0.0);
    private final DoubleProperty sliderMaximumPercentProperty = new SimpleDoubleProperty(100.0);
    private final DoubleProperty intervalLowerPercentProperty = new SimpleDoubleProperty(33.3);
    private final DoubleProperty intervalUpperPercentProperty = new SimpleDoubleProperty(66.7);
    private final Path slider;
    private final Path bracket;
    private final Line leftEdge;
    private final Line rightEdge;
    private double sliderLeftMin;
    private double sliderRightMax;
    private double sliderLeft;
    private double sliderRight;
    private Cursor originalCursor;
    private CursorMode mouseMode;
    private CursorMode dragMode;
    private double dragStartMouseX;
    private double dragDeltaMouseX;
    private double dragStartSliderLeft;
    private double dragStartSliderRight;
    private static final double SLIDER_GRAB_ZONE_WIDTH = 5.0;

    public IntervalSlider() {
        this.getStyleClass().setAll((Object[])new String[]{"interval"});
        this.slider = new Path();
        this.slider.getStyleClass().setAll((Object[])new String[]{"slider"});
        this.bracket = new Path();
        this.bracket.getStyleClass().setAll((Object[])new String[]{"bracket"});
        this.leftEdge = new Line();
        this.leftEdge.getStyleClass().setAll((Object[])new String[]{"edge"});
        this.rightEdge = new Line();
        this.rightEdge.getStyleClass().setAll((Object[])new String[]{"edge"});
        this.getChildren().setAll((Object[])new Node[]{this.slider, this.bracket, this.leftEdge, this.rightEdge});
        this.sliderMinimumPercentProperty.addListener(observable -> this.onSliderPosDependencyChanged());
        this.sliderMaximumPercentProperty.addListener(observable -> this.onSliderPosDependencyChanged());
        this.intervalLowerPercentProperty.addListener(observable -> this.onSliderPosDependencyChanged());
        this.intervalUpperPercentProperty.addListener(observable -> this.onSliderPosDependencyChanged());
        this.widthProperty().addListener(observable -> this.onSliderPosDependencyChanged());
        this.heightProperty().addListener(observable -> this.onSliderPosDependencyChanged());
        this.paddingProperty().addListener(observable -> this.onSliderPosDependencyChanged());
        this.slider.setOnMouseDragged(mouseEvent -> this.onMouseDragged(this.sceneToLocal(mouseEvent.getSceneX(), mouseEvent.getSceneY()).getX()));
        this.slider.setOnMouseReleased(mouseEvent -> this.onMouseReleased(this.sceneToLocal(mouseEvent.getSceneX(), mouseEvent.getSceneY()).getX()));
        this.slider.setOnMouseEntered(mouseEvent -> this.onMouseEntered(this.sceneToLocal(mouseEvent.getSceneX(), mouseEvent.getSceneY()).getX()));
        this.slider.setOnMouseMoved(mouseEvent -> this.onMouseMoved(this.sceneToLocal(mouseEvent.getSceneX(), mouseEvent.getSceneY()).getX()));
        this.slider.setOnMouseExited(mouseEvent -> this.onMouseExited());
    }

    public double getBracketHeightPercent() {
        return this.bracketHeightPercentProperty.get();
    }

    public void setBracketHeightPercent(double d) {
        this.bracketHeightPercentProperty.set(d);
    }

    public DoubleProperty bracketHeightPercentProperty() {
        return this.bracketHeightPercentProperty;
    }

    public double getSliderMinimumPercent() {
        return this.sliderMinimumPercentProperty.get();
    }

    public void setSliderMinimumPercent(double d) {
        this.sliderMinimumPercentProperty.set(d);
    }

    public DoubleProperty sliderMinimumPercentProperty() {
        return this.sliderMinimumPercentProperty;
    }

    public double getSliderMaximumPercent() {
        return this.sliderMaximumPercentProperty.get();
    }

    public void setSliderMaximumPercent(double d) {
        this.sliderMaximumPercentProperty.set(d);
    }

    public DoubleProperty sliderMaximumPercentProperty() {
        return this.sliderMaximumPercentProperty;
    }

    public double getIntervalLowerPercent() {
        return this.intervalLowerPercentProperty.get();
    }

    public void setIntervalLowerPercent(double d) {
        this.intervalLowerPercentProperty.set(d);
    }

    public DoubleProperty intervalLowerPercentProperty() {
        return this.intervalLowerPercentProperty;
    }

    public double getIntervalUpperPercent() {
        return this.intervalUpperPercentProperty.get();
    }

    public void setIntervalUpperPercent(double d) {
        this.intervalUpperPercentProperty.set(d);
    }

    public DoubleProperty intervalUpperPercentProperty() {
        return this.intervalUpperPercentProperty;
    }

    protected double computeMinWidth(double d) {
        Insets insets = this.getPadding();
        return 15.0 + insets.getRight() + insets.getLeft();
    }

    protected void layoutChildren() {
        double d;
        double d2;
        double d3 = this.snappedTopInset();
        double d4 = this.snappedLeftInset();
        double d5 = this.snappedRightInset();
        double d6 = this.snappedBottomInset();
        double d7 = this.getWidth();
        double d8 = this.getHeight();
        double d9 = d8 - d3 - d6;
        double d10 = this.getBracketHeightPercent();
        boolean bl = d10 > 0.0 && d10 < 100.0;
        double d11 = d8 - d6;
        double d12 = d7 - d5;
        if (bl) {
            d2 = d10 / 100.0;
            d = d9 * (1.0 - d2);
        } else {
            d = d9;
        }
        d2 = d3 + d;
        this.slider.getElements().setAll((Object[])new PathElement[]{new MoveTo(this.sliderLeft, d2), new LineTo(this.sliderLeft, d3), new LineTo(this.sliderRight, d3), new LineTo(this.sliderRight, d2), new LineTo(this.sliderLeft, d2), new ClosePath()});
        if (bl) {
            double d13 = d2 + (d11 - d2) / 2.0;
            this.bracket.getElements().setAll((Object[])new PathElement[]{new MoveTo(this.sliderRight, d2), new CubicCurveTo(this.sliderRight, d13, d12, d13, d12, d11), new LineTo(d4, d11), new CubicCurveTo(d4, d13, this.sliderLeft, d13, this.sliderLeft, d2), new LineTo(this.sliderLeft, d2), new ClosePath()});
        }
        this.leftEdge.setStartX(this.sliderLeft);
        this.leftEdge.setStartY(d3);
        this.leftEdge.setEndX(this.sliderLeft);
        this.leftEdge.setEndY(d2);
        this.rightEdge.setStartX(this.sliderRight);
        this.rightEdge.setStartY(d3);
        this.rightEdge.setEndX(this.sliderRight);
        this.rightEdge.setEndY(d2);
    }

    private void onSliderPosDependencyChanged() {
        if (this.dragMode == null) {
            this.recalcSliderPos();
        }
    }

    private void recalcSliderPos() {
        double d;
        Insets insets = this.getPadding();
        double d2 = insets.getLeft();
        double d3 = insets.getRight();
        double d4 = this.getWidth();
        double d5 = d4 - d2 - d3;
        double d6 = this.getSliderMinimumPercent();
        this.sliderLeftMin = d6 > 0.0 && d6 < 100.0 ? d2 + d5 * d6 / 100.0 : d2;
        double d7 = this.getSliderMaximumPercent();
        this.sliderRightMax = d7 > 0.0 && d7 < 100.0 ? d4 - d3 - d5 * (100.0 - d7) / 100.0 : d4 - d3;
        double d8 = this.sliderRightMax - this.sliderLeftMin;
        double d9 = 15.0;
        if (d8 < d9) {
            d = (d9 - d8) / 2.0;
            d8 = d9;
            this.sliderLeftMin -= d;
            this.sliderRightMax += d;
        }
        this.sliderLeft = (d = this.getIntervalLowerPercent()) >= 0.0 && d < 100.0 ? this.sliderLeftMin + d8 * d / 100.0 : this.sliderLeftMin;
        double d10 = this.getIntervalUpperPercent();
        this.sliderRight = d10 > d && d10 <= 100.0 ? this.sliderLeftMin + d8 * d10 / 100.0 : this.sliderRightMax;
        this.requestLayout();
    }

    private void onMouseEntered(double d) {
        if (this.mouseMode == null) {
            if (this.dragMode == null) {
                this.mouseMode = this.mouseXToCursorMode(d);
                this.originalCursor = this.getScene().getCursor();
                this.setCursorFromCursorMode(this.mouseMode);
            } else {
                this.mouseMode = this.dragMode;
            }
        } else {
            this.getLogger().log(Level.WARNING, "invalid cursor state on mouse enter: {0}/{1}", new Object[]{this.mouseMode, this.dragMode});
        }
    }

    private void onMouseMoved(double d) {
        if (this.mouseMode != null) {
            if (this.dragMode == null) {
                this.mouseMode = this.mouseXToCursorMode(d);
                this.setCursorFromCursorMode(this.mouseMode);
            }
        } else {
            this.getLogger().log(Level.WARNING, "invalid cursor state on mouse move: {0}/{1}", new Object[]{this.mouseMode, this.dragMode});
        }
    }

    private void onMouseExited() {
        if (this.mouseMode != null) {
            if (this.dragMode == null) {
                this.getScene().setCursor(this.originalCursor);
                this.originalCursor = null;
            }
            this.mouseMode = null;
        } else {
            this.getLogger().log(Level.WARNING, "invalid cursor state on mouse exit: {0}/{1}", new Object[]{this.mouseMode, this.dragMode});
        }
    }

    private void onMouseDragged(double d) {
        if (this.dragMode == null) {
            this.dragMode = this.mouseXToCursorMode(d);
            if (this.mouseMode != null) {
                this.mouseMode = this.dragMode;
            }
            this.setCursorFromCursorMode(this.dragMode);
            this.beginDrag(d);
        } else {
            this.drag(d, this.dragMode);
            this.requestLayout();
        }
    }

    private void onMouseReleased(double d) {
        if (this.dragMode != null) {
            if (this.mouseMode != null) {
                if (this.mouseMode != null) {
                    this.mouseMode = this.mouseXToCursorMode(d);
                }
                this.setCursorFromCursorMode(this.mouseMode);
            } else {
                this.getScene().setCursor(this.originalCursor);
                this.originalCursor = null;
            }
            this.endDrag();
            this.dragMode = null;
        } else {
            this.getLogger().log(Level.WARNING, "invalid cursor state on mouse release: {0}/{1}", new Object[]{this.mouseMode, this.dragMode});
        }
    }

    private void beginDrag(double d) {
        this.dragStartSliderLeft = this.sliderLeft;
        this.dragStartSliderRight = this.sliderRight;
        this.dragStartMouseX = d;
        this.dragDeltaMouseX = 0.0;
    }

    private void drag(double d, CursorMode cursorMode) {
        this.dragDeltaMouseX = d - this.dragStartMouseX;
        switch (cursorMode) {
            case RESIZE_LEFT: {
                double d2 = this.dragStartSliderLeft + this.dragDeltaMouseX;
                if (d2 < this.sliderLeftMin) {
                    this.sliderLeft = this.sliderLeftMin;
                    break;
                }
                if (d2 > this.sliderRight - 15.0) {
                    this.sliderLeft = this.sliderRight - 15.0;
                    break;
                }
                this.sliderLeft = d2;
                break;
            }
            case RESIZE_RIGHT: {
                double d3 = this.dragStartSliderRight + this.dragDeltaMouseX;
                if (d3 > this.sliderRightMax) {
                    this.sliderRight = this.sliderRightMax;
                    break;
                }
                if (d3 < this.sliderLeft + 15.0) {
                    this.sliderRight = this.sliderLeft + 15.0;
                    break;
                }
                this.sliderRight = d3;
                break;
            }
            case MOVE: {
                if (this.dragStartSliderLeft + this.dragDeltaMouseX < this.sliderLeftMin) {
                    this.sliderLeft = this.sliderLeftMin;
                    this.sliderRight = this.sliderLeft + this.dragStartSliderRight - this.dragStartSliderLeft;
                    break;
                }
                if (this.dragStartSliderRight + this.dragDeltaMouseX > this.sliderRightMax) {
                    this.sliderLeft = this.sliderRightMax - this.dragStartSliderRight + this.dragStartSliderLeft;
                    this.sliderRight = this.sliderRightMax;
                    break;
                }
                this.sliderLeft = this.dragStartSliderLeft + this.dragDeltaMouseX;
                this.sliderRight = this.dragStartSliderRight + this.dragDeltaMouseX;
            }
        }
    }

    private void endDrag() {
        double d = this.sliderRightMax - this.sliderLeftMin;
        double d2 = 100.0 * (this.sliderLeft - this.sliderLeftMin) / d;
        double d3 = 100.0 * (this.sliderRight - this.sliderLeftMin) / d;
        this.setIntervalLowerPercent(d2);
        this.setIntervalUpperPercent(d3);
    }

    private CursorMode mouseXToCursorMode(double d) {
        double d2 = d - this.sliderLeft;
        CursorMode cursorMode = d2 < 5.0 ? CursorMode.RESIZE_LEFT : (d2 > this.sliderRight - this.sliderLeft - 5.0 ? CursorMode.RESIZE_RIGHT : CursorMode.MOVE);
        return cursorMode;
    }

    private Cursor cursorModeToCursor(CursorMode cursorMode) {
        Cursor cursor;
        switch (cursorMode) {
            case RESIZE_LEFT: {
                cursor = Cursor.W_RESIZE;
                break;
            }
            case RESIZE_RIGHT: {
                cursor = Cursor.E_RESIZE;
                break;
            }
            default: {
                cursor = Cursor.OPEN_HAND;
            }
        }
        return cursor;
    }

    private void setCursorFromCursorMode(CursorMode cursorMode) {
        Scene scene;
        Cursor cursor = this.cursorModeToCursor(cursorMode);
        if (cursor != (scene = this.getScene()).getCursor()) {
            scene.setCursor(cursor);
        }
    }

    private Logger getLogger() {
        return Logger.getLogger(IntervalSlider.class.getName());
    }

    private static enum CursorMode {
        RESIZE_LEFT,
        RESIZE_RIGHT,
        MOVE;

    }
}

