/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.dataobject;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import oracle.dbtools.raptor.metrics.dataobject.AbstractCalcDataObject;
import oracle.dbtools.raptor.metrics.dataobject.ValueWhen;
import oracle.dbtools.raptor.metrics.panel.DataObject;

@DefaultProperty(value="whenClauses")
public abstract class AbstractConditionalDataObject<T>
extends AbstractCalcDataObject<T> {
    private BooleanExpression availableProperty;
    private BooleanExpression connectedProperty;
    private final ObjectProperty<DataObject<?>> switchProperty = new SimpleObjectProperty((Object)this, "switch");
    private final ObservableList<ValueWhen<T>> whenClauses = FXCollections.observableArrayList();
    private final ObjectProperty<DataObject<T>> otherwiseProperty = new SimpleObjectProperty((Object)this, "otherwise");

    public DataObject<?> getSwitch() {
        return (DataObject)this.switchProperty.get();
    }

    public void setSwitch(DataObject<?> dataObject) {
        this.switchProperty.set(dataObject);
    }

    public ObjectProperty<DataObject<?>> switchProperty() {
        return this.switchProperty;
    }

    public ObservableList<ValueWhen<T>> getWhenClauses() {
        return this.whenClauses;
    }

    public DataObject<T> getOtherwise() {
        return (DataObject)this.otherwiseProperty.get();
    }

    public void setOtherwise(DataObject<T> dataObject) {
        this.otherwiseProperty.set(dataObject);
    }

    public ObjectProperty<DataObject<T>> otherwiseProperty() {
        return this.otherwiseProperty;
    }

    @Override
    public BooleanExpression availableProperty() {
        if (this.availableProperty == null) {
            this.resolveBinding();
        }
        return this.availableProperty;
    }

    @Override
    public BooleanExpression connectedProperty() {
        if (this.connectedProperty == null) {
            this.resolveBinding();
        }
        return this.connectedProperty;
    }

    protected abstract void initBinding(List<ObservableValue<?>> var1);

    protected T calculateValue() {
        Object object = this.getSwitch().valueProperty().getValue();
        for (ValueWhen valueWhen : this.whenClauses) {
            if (!valueWhen.isSelected(object)) continue;
            return (T)valueWhen.getItem().valueProperty().getValue();
        }
        DataObject<T> dataObject = this.getOtherwise();
        if (dataObject != null) {
            return (T)dataObject.valueProperty().getValue();
        }
        return null;
    }

    private void resolveBinding() {
        ArrayList arrayList = new ArrayList();
        DataObject<?> dataObject = this.getSwitch();
        arrayList.add(dataObject.valueProperty());
        this.availableProperty = dataObject.availableProperty();
        this.connectedProperty = dataObject.connectedProperty();
        for (ValueWhen valueWhen : this.whenClauses) {
            DataObject dataObject2 = valueWhen.getItem();
            arrayList.add(dataObject2.valueProperty());
            this.availableProperty = this.availableProperty.and((ObservableBooleanValue)dataObject2.availableProperty());
            this.connectedProperty = this.connectedProperty.and((ObservableBooleanValue)dataObject2.connectedProperty());
        }
        this.initBinding(arrayList);
    }
}

