/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import oracle.dbtools.raptor.metrics.MetricsResources;
import oracle.dbtools.raptor.metrics.engine.Command;
import oracle.dbtools.raptor.metrics.engine.DXException;
import oracle.dbtools.raptor.metrics.engine.ExecutionService;
import oracle.dbtools.raptor.metrics.engine.Handle;
import oracle.dbtools.raptor.metrics.engine.Notification;
import oracle.dbtools.raptor.metrics.engine.OperationAutomatonActions;
import oracle.dbtools.raptor.metrics.engine.OperationInstance;
import oracle.dbtools.raptor.metrics.engine.OperationType;
import oracle.dbtools.raptor.metrics.engine.RunnableAutomaton;
import oracle.dbtools.raptor.metrics.engine.SourceAutomaton;
import oracle.dbtools.raptor.metrics.engine.Task;
import oracle.dbtools.raptor.metrics.listener.DXError;
import oracle.dbtools.raptor.metrics.listener.DXOperationCallback;

class OperationAutomaton
extends RunnableAutomaton<OperationAutomatonActions> {
    private final OperationInstance operation;
    private final DXOperationCallback callback;
    private ExecutionService executionService;
    private final OperationActions QUEUED = new QueuedActions();
    private final OperationActions RUNNING = new RunningActions();
    private final OperationActions COMPLETE = new CompleteActions();
    private final OperationActions REMOVED = null;

    OperationAutomaton(OperationInstance operationInstance, DXOperationCallback dXOperationCallback) {
        this.operation = operationInstance;
        this.callback = dXOperationCallback;
    }

    @Override
    void start() {
        super.start();
        this.executionService = this.getContext().getExecutionService();
    }

    void invoke() {
        SourceAutomaton sourceAutomaton = this.operation.getSource().getAutomaton();
        this.executionService.addEvent(sourceAutomaton.createRunnablePinned());
        this.executionService.addEvent(sourceAutomaton.createRunnableActivated());
        this.executionService.addEvent(sourceAutomaton.createQueueRunnable(this.operation));
    }

    @Override
    OperationAutomatonActions getInitialState() {
        return this.QUEUED;
    }

    @Override
    OperationInstance getFocusObject() {
        return this.operation;
    }

    private class CompleteActions
    extends OperationActions {
        CompleteActions() {
            super("COMPLETE");
        }

        @Override
        boolean isRunning() {
            return false;
        }

        @Override
        OperationAutomatonActions remove() {
            OperationAutomaton.this.operation.remove();
            return OperationAutomaton.this.REMOVED;
        }
    }

    private class RunningActions
    extends OperationActions {
        RunningActions() {
            super("RUNNING");
        }

        @Override
        boolean isRunning() {
            return true;
        }

        @Override
        OperationActions runCompleted(long l, long l2, boolean bl, final DXException dXException) {
            if (!bl && dXException == null) {
                OperationAutomaton.this.getContext().getLogger().log(Level.INFO, "operation run complete ''{0}'' in {1} seconds", new Object[]{OperationAutomaton.this.operation.getId(), (double)l / 1.0E9});
                OperationAutomaton.this.getContext().getObjectManager().invokeTriggers(OperationAutomaton.this.operation);
            } else if (dXException != null) {
                OperationAutomaton.this.getContext().getLogger().log(Level.WARNING, "job run failure for '" + OperationAutomaton.this.operation.getId() + "'", dXException);
            } else {
                OperationAutomaton.this.getContext().getLogger().log(Level.WARNING, "job run canceled for ''{0}''", OperationAutomaton.this.operation.getId());
            }
            SourceAutomaton sourceAutomaton = OperationAutomaton.this.operation.getSource().getAutomaton();
            OperationAutomaton.this.executionService.addEvent(sourceAutomaton.createRunCompleted(dXException));
            OperationAutomaton.this.executionService.addEvent(sourceAutomaton.createRunnableInactivated());
            OperationAutomaton.this.executionService.addEvent(sourceAutomaton.createRunnableUnpinned());
            OperationAutomaton.this.executionService.addEvent(OperationAutomaton.this.createRemove());
            OperationAutomaton.this.executionService.addNotification(new Notification(){

                @Override
                void execute() {
                    OperationAutomaton.this.callback.onComplete(new DXError(OperationAutomaton.this.operation.getId(), dXException));
                }
            });
            return OperationAutomaton.this.COMPLETE;
        }
    }

    private class QueuedActions
    extends OperationActions {
        QueuedActions() {
            super("QUEUED");
        }

        @Override
        boolean isRunning() {
            return false;
        }

        @Override
        OperationAutomatonActions startRun() {
            OperationAutomaton.this.getContext().getLogger().log(Level.INFO, "operation run submit ''{0}''", new Object[]{OperationAutomaton.this.operation.getId()});
            this.submitInvoke();
            return OperationAutomaton.this.RUNNING;
        }

        void submitInvoke() {
            Handle handle = OperationAutomaton.this.getContext().getObjectManager().createHandle(OperationAutomaton.this.operation.getId());
            String string = handle.getPath();
            Map<String, String> map = handle.getNormalizedQueryParameters();
            OperationType operationType = OperationAutomaton.this.operation.getRunnableType();
            if (operationType == null) {
                throw new DXException("unable to invoke '" + string + "' for '" + OperationAutomaton.this.operation.getId() + "' because source does not exist");
            }
            final Map<String, Object> map2 = operationType.getParameterTypes().convertToRaw(OperationAutomaton.this.operation.getSource().getValueConverter(), map);
            OperationAutomaton.this.getContext().getExecutionService().submitTask(new Task(){

                @Override
                void execute() {
                    QueuedActions.this.callInvoke(map2);
                }

                @Override
                boolean cancel() {
                    OperationAutomaton.this.operation.cancelRun();
                    return OperationAutomaton.this.operation.isRunCanceled();
                }

                @Override
                String getLabel() {
                    return MetricsResources.format("METRICS_LABEL_RUNNING_JOB", OperationAutomaton.this.operation.getRunLabel());
                }

                @Override
                URI getId() {
                    return OperationAutomaton.this.operation.getId();
                }

                @Override
                String getName() {
                    return "invoke";
                }
            });
        }

        void callInvoke(Map<String, Object> map) {
            DXException dXException = null;
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            long l = threadMXBean.getCurrentThreadCpuTime();
            long l2 = System.nanoTime();
            try {
                OperationAutomaton.this.operation.invoke(map);
            }
            catch (DXException dXException2) {
                dXException = dXException2;
            }
            catch (RuntimeException runtimeException) {
                dXException = new DXException(runtimeException);
            }
            final long l3 = System.nanoTime() - l2;
            final long l4 = l >= 0L ? threadMXBean.getCurrentThreadCpuTime() - l : -1L;
            final boolean bl = OperationAutomaton.this.operation.isRunCanceled();
            final DXException dXException3 = dXException;
            OperationAutomaton.this.executionService.enqueueCommand(new Command(){

                @Override
                void execute() {
                    OperationAutomaton.this.executionService.addEvent(OperationAutomaton.this.createRunCompleted(l3, l4, bl, dXException3));
                }

                @Override
                URI getId() {
                    return OperationAutomaton.this.operation.getId();
                }

                @Override
                String getName() {
                    return "runCompleted";
                }
            });
        }
    }

    private abstract class OperationActions
    extends OperationAutomatonActions {
        OperationActions(String string) {
            super(string);
        }

        @Override
        void logStateEventError() {
            OperationAutomaton.this.getContext().getLogger().log(Level.SEVERE, "unexpected state machine event whilst in state '" + ((OperationAutomatonActions)OperationAutomaton.this.getState()).getName() + "' for operation '" + OperationAutomaton.this.operation.getId() + "'", new IllegalStateException());
        }
    }
}

