/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.StackedBarChart;
import javafx.scene.chart.XYChart;
import oracle.dbtools.raptor.metrics.facet.CategoryAxisProperties;
import oracle.dbtools.raptor.metrics.facet.GraphicalChartMonitor;
import oracle.dbtools.raptor.metrics.facet.PointAxisProperties;
import oracle.dbtools.raptor.metrics.observable.DXRow;
import oracle.dbtools.raptor.metrics.panel.Context;

@DefaultProperty(value="item")
public class CategoryChartMonitor
extends GraphicalChartMonitor<String, Number, String, Double> {
    private CategoryAxisProperties xAxisProperties;
    private PointAxisProperties yAxisProperties;
    private boolean stacked;
    private List<Comparable<?>> xOrderValues;

    public CategoryChartMonitor() {
        this.init(new Listener());
    }

    @Override
    protected void initializeAxes(Context context, XYChart<String, Number> xYChart) {
        this.xAxisProperties = this.findAndInitializeAxisProperties(CategoryAxisProperties.class, context, (CategoryAxis)xYChart.getXAxis());
        this.yAxisProperties = this.findAndInitializeAxisProperties(PointAxisProperties.class, context, (NumberAxis)xYChart.getYAxis());
        this.stacked = xYChart instanceof StackedBarChart;
        if (this.xAxisProperties != null && this.xAxisProperties.getXOrderColumn() != null) {
            this.xOrderValues = new ArrayList();
        }
    }

    @Override
    protected String getXValue(ObservableValue<?> observableValue) {
        String string;
        String string2 = observableValue.getValue().toString();
        if (this.xAxisProperties != null && (string = (String)this.xAxisProperties.getCategoryNlsMap().get((Object)string2)) != null) {
            string2 = string;
        }
        return string2;
    }

    @Override
    protected String getXValue(String string) {
        return string;
    }

    @Override
    protected Double getYValue(ObservableValue<?> observableValue) {
        return this.yAxisProperties != null ? this.yAxisProperties.convertValueToDouble(observableValue.getValue()) : 0.0;
    }

    @Override
    protected void updateBounds(List<ObservableList<XYChart.Data<String, Number>>> list) {
        int n = list.get(0).size();
        if (n > 0) {
            int n2 = list.size();
            double d = Double.MAX_VALUE;
            double d2 = Double.MIN_VALUE;
            if (this.stacked) {
                for (int i = 0; i < n; ++i) {
                    double d3 = 0.0;
                    for (int j = 0; j < n2; ++j) {
                        d3 += ((Number)((XYChart.Data)list.get(j).get(i)).getYValue()).doubleValue();
                    }
                    if (d3 < d) {
                        d = d3;
                    }
                    if (!(d3 > d2)) continue;
                    d2 = d3;
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    List list2 = (List)list.get(i);
                    for (int j = 0; j < n; ++j) {
                        double d4 = ((Number)((XYChart.Data)list2.get(j)).getYValue()).doubleValue();
                        if (d4 > d2) {
                            d2 = d4;
                        }
                        if (!(d4 < d)) continue;
                        d = d4;
                    }
                }
            }
            if (this.yAxisProperties != null) {
                this.yAxisProperties.update(d, d2);
            }
        }
    }

    @Override
    protected int findInsertionIndex(String string, DXRow dXRow) {
        int n;
        if (this.xAxisProperties != null && this.xOrderValues != null) {
            Comparable comparable = (Comparable)dXRow.get(this.xAxisProperties.getXOrderColumn()).get();
            n = 0;
            for (Comparable<?> comparable2 : this.xOrderValues) {
                if (comparable.compareTo(comparable2) <= 0) break;
                ++n;
            }
            this.xOrderValues.add(n, comparable);
        } else {
            n = super.findInsertionIndex(string, dXRow);
        }
        return n;
    }

    @Override
    protected void onRemoveInsertionIndex(int n) {
        if (this.xOrderValues != null) {
            this.xOrderValues.remove(n);
        }
    }

    protected class Listener
    extends GraphicalChartMonitor.Listener {
        protected Listener() {
            super(CategoryChartMonitor.this);
        }
    }
}

