/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import oracle.dbtools.raptor.metrics.facet.AxisValueHelper;

class NumberAxisValueHelper
extends AxisValueHelper {
    private final DoubleProperty tickIntervalProperty = new SimpleDoubleProperty((Object)this, "tickInterval", 1.0);
    private final StringProperty suffixesProperty = new SimpleStringProperty((Object)this, "suffixes");
    private String[] cachedSuffixes;

    NumberAxisValueHelper() {
    }

    double getTickInterval() {
        return this.tickIntervalProperty.get();
    }

    void setTickInterval(double d) {
        this.tickIntervalProperty.set(d);
    }

    DoubleProperty tickIntervalProperty() {
        return this.tickIntervalProperty;
    }

    String getSuffixes() {
        return (String)this.suffixesProperty.get();
    }

    void setSuffixes(String string) {
        this.suffixesProperty.set((Object)string);
    }

    StringProperty suffixesProperty() {
        return this.suffixesProperty;
    }

    @Override
    String formatDouble(double d) {
        if (this.getSuffixes() != null && this.cachedSuffixes == null) {
            this.cachedSuffixes = this.getSuffixes().split("\\s*,\\s*");
        }
        String string = null;
        if (this.cachedSuffixes != null) {
            for (int i = 0; i < this.cachedSuffixes.length - 1; ++i) {
                if (d < 1000.0) {
                    string = this.cachedSuffixes[i];
                    break;
                }
                d /= 1000.0;
            }
            if (string == null) {
                string = this.cachedSuffixes[this.cachedSuffixes.length - 1];
            }
        }
        Object object = super.formatDouble(d);
        if (string != null) {
            object = (String)object + string;
        }
        return object;
    }

    @Override
    double convertValueToDouble(Object object) {
        return ((Number)object).doubleValue();
    }

    @Override
    Object convertDoubleToValue(double d) {
        return d;
    }
}

