/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.util.Duration;
import oracle.dbtools.raptor.metrics.facet.AxisValueHelper;

class TimeAxisValueHelper
extends AxisValueHelper {
    private final ObjectProperty<Duration> tickIntervalProperty = new SimpleObjectProperty((Object)this, "minimumTickInterval", (Object)Duration.seconds((double)0.0));

    TimeAxisValueHelper() {
    }

    Duration getTickInterval() {
        return (Duration)this.tickIntervalProperty.get();
    }

    void setTickInterval(Duration duration) {
        this.tickIntervalProperty.set((Object)duration);
    }

    ObjectProperty<Duration> tickIntervalProperty() {
        return this.tickIntervalProperty;
    }

    @Override
    double convertValueToDouble(Object object) {
        if (object instanceof LocalDateTime) {
            return ((LocalDateTime)object).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        }
        return ((Number)object).doubleValue();
    }

    @Override
    Object convertDoubleToValue(double d) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli((long)d), ZoneId.systemDefault());
    }
}

