/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.generation;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import oracle.dbtools.raptor.config.CustomFormat;
import oracle.dbtools.raptor.metrics.generation.AbstractGenerationElement;
import oracle.dbtools.raptor.metrics.panel.GenerationResult;

public class FormattedSQL
extends AbstractGenerationElement {
    private final StringProperty sqlProperty = new SimpleStringProperty((Object)this, "sql");

    public String getSql() {
        return (String)this.sqlProperty.get();
    }

    public void setSql(String string) {
        this.sqlProperty.set((Object)string);
    }

    public StringProperty sqlProperty() {
        return this.sqlProperty;
    }

    @Override
    boolean isSynchronous() {
        return true;
    }

    @Override
    void generate(Consumer<GenerationResult> consumer) {
        String string;
        String string2 = this.getSql();
        try {
            string = new CustomFormat().format(string2);
        }
        catch (IOException | AssertionError object) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "error formatting SQL \n" + string2, (Throwable)object);
            string = string2;
        }
        consumer.accept(new GenerationResult(true, this.getGenerationSettings().processEscapes(string)));
    }
}

