/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.generation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javafx.beans.DefaultProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import oracle.dbtools.raptor.metrics.generation.AbstractGenerationElement;
import oracle.dbtools.raptor.metrics.generation.AbstractGenerationObject;
import oracle.dbtools.raptor.metrics.generation.GenerationSettings;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.GenerationResult;
import oracle.dbtools.raptor.metrics.panel.GenerationSpecification;
import oracle.dbtools.raptor.metrics.panel.Namespace;

@DefaultProperty(value="elements")
public class Generation
extends AbstractGenerationObject
implements GenerationSpecification {
    private final ObservableList<AbstractGenerationElement> elements = FXCollections.observableArrayList();
    private final StringProperty escapesProperty = new SimpleStringProperty((Object)this, "escapes");

    public ObservableList<AbstractGenerationElement> getElements() {
        return this.elements;
    }

    public String getEscapes() {
        return (String)this.escapesProperty.get();
    }

    public void setEscapes(String string) {
        this.escapesProperty.set((Object)string);
    }

    public StringProperty escapesProperty() {
        return this.escapesProperty;
    }

    @Override
    public boolean isSynchronous() {
        return this.isAggregateSynchronous((List<? extends AbstractGenerationElement>)this.elements);
    }

    @Override
    public void generate(Context context, Namespace namespace, Consumer<GenerationResult> consumer) {
        GenerationSettings generationSettings = new GenerationSettings(context, namespace, this.getEscapes());
        this.aggregateGenerate((List<AbstractGenerationElement>)this.elements, generationSettings, this.createGenerationParameters(context.getLocals()), consumer);
    }

    private Map<String, Object> createGenerationParameters(Namespace namespace) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (String string : namespace.getNames()) {
            hashMap.put(string, namespace.get(string));
        }
        return hashMap;
    }
}

