/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.observable;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.ObjectProperty;
import oracle.dbtools.raptor.metrics.listener.DXTableChanges;
import oracle.dbtools.raptor.metrics.observable.DXKey;

class Key
implements DXKey {
    private final List<String> keyNames;
    private final Map<String, Comparable<?>> keyMap = new HashMap();

    Key(DXTableChanges.Key key) {
        this.keyNames = key.getKeyCellNames();
        for (String string : key.getKeyCellNames()) {
            this.keyMap.put(string, key.getCellValue(string, Comparable.class));
        }
    }

    Key(List<String> list, Map<String, ObjectProperty<Comparable<?>>> map) {
        this.keyNames = list;
        for (String string : list) {
            this.keyMap.put(string, (Comparable)map.get(string).get());
        }
    }

    @Override
    public List<String> getNames() {
        return this.keyNames;
    }

    @Override
    public <T extends Comparable<?>> T get(String string, Class<T> clazz) {
        Comparable<?> comparable = this.keyMap.get(string);
        if (comparable == null || clazz.isAssignableFrom(comparable.getClass())) {
            return (T)comparable;
        }
        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Type mismatch for column ''{0}}'': required ''{1}'', found ''{2}''", new Object[]{string, clazz.getName(), comparable.getClass().getName()});
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DXKey)) {
            return false;
        }
        return this.compareTo((DXKey)object) == 0;
    }

    public int hashCode() {
        int n = 7;
        n = 19 * n + Objects.hashCode(this.keyMap);
        return n;
    }

    @Override
    public int compareTo(DXKey dXKey) {
        for (String string : this.keyNames) {
            Comparable<?> comparable = this.keyMap.get(string);
            Comparable comparable2 = dXKey.get(string, Comparable.class);
            if (comparable == null) {
                if (comparable2 == null) continue;
                return -1;
            }
            if (comparable2 == null) {
                return 1;
            }
            int n = comparable.compareTo(comparable2);
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    public String toString() {
        return this.keyMap.toString();
    }
}

