/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.sqlsource;

import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import oracle.dbtools.raptor.metrics.engine.AbstractJob;
import oracle.dbtools.raptor.metrics.sqlsource.Query;
import oracle.dbtools.raptor.metrics.sqlsource.SQLJobType;
import oracle.dbtools.raptor.metrics.sqlsource.SQLLibrary;
import oracle.dbtools.raptor.metrics.sqlsource.SQLOperationType;
import oracle.dbtools.raptor.metrics.sqlsource.SQLSource;
import oracle.dbtools.raptor.metrics.sqlsource.SQLSourceType;

public class SQLJob
extends AbstractJob<SQLJobType, SQLSourceType, SQLOperationType, SQLLibrary> {
    private final BooleanProperty textProcessingProperty = new SimpleBooleanProperty();
    private final ObservableList<Query> queries = FXCollections.observableArrayList();

    public boolean isTextProcessing() {
        return this.textProcessingProperty.get();
    }

    public void setTextProcessing(boolean bl) {
        this.textProcessingProperty.set(bl);
    }

    public BooleanProperty textProcessingProperty() {
        return this.textProcessingProperty;
    }

    public ObservableList<Query> getQueries() {
        return this.queries;
    }

    @Override
    public SQLJobType createTypeObject(ClassLoader classLoader, SQLSourceType sQLSourceType) {
        SQLJobType sQLJobType = new SQLJobType(sQLSourceType);
        this.initializeTypeObject(classLoader, sQLJobType);
        return sQLJobType;
    }

    @Override
    protected void initializeTypeObject(ClassLoader classLoader, SQLJobType sQLJobType) {
        super.initializeTypeObject(classLoader, sQLJobType);
        sQLJobType.setTextProcessing(this.isTextProcessing());
        SQLSource sQLSource = (SQLSource)this.getSource();
        sQLJobType.setObjectQueries(sQLSource.createObjectQueries(classLoader, (List<Query>)this.queries));
    }
}

