/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import oracle.dbtools.raptor.metrics.panel.LocalsService;
import oracle.dbtools.raptor.metrics.panel.PageTemplateFactory;
import oracle.dbtools.raptor.metrics.panel.PanelTemplate;
import oracle.dbtools.raptor.metrics.panel.TemplateInstance;
import oracle.dbtools.raptor.metrics.viewer.AbstractPanelAdapter;
import oracle.dbtools.raptor.metrics.viewer.MetricsPanelCommand;

public class MetricsPanelAdapter
extends AbstractPanelAdapter {
    private final PageTemplateFactory<Region> factory;
    private volatile JFXPanel fxPanel;
    private TemplateInstance<Region> rootPanel;
    private Scene scene;
    private MetricsPane sceneRoot;
    private boolean built = false;
    private final String connectionName;
    private final Collection<MetricsPanelCommand> commands;
    private final Map<String, Consumer<Boolean>> externalCallListeners = new HashMap<String, Consumer<Boolean>>();

    public MetricsPanelAdapter(PageTemplateFactory<Region> pageTemplateFactory, String string, Collection<MetricsPanelCommand> collection) {
        super(new BorderLayout());
        this.factory = pageTemplateFactory;
        this.connectionName = string;
        this.commands = collection;
    }

    public Scene getScene() {
        return this.scene;
    }

    public void open(Map<String, Object> map) {
        if (!this.built) {
            this.built = true;
            this.fxPanel = new JFXPanel();
            this.add((Component)this.fxPanel, "Center");
            CountDownLatch countDownLatch = new CountDownLatch(1);
            Platform.runLater(() -> {
                try {
                    this.createFXUI(map);
                    countDownLatch.countDown();
                }
                catch (RuntimeException runtimeException) {
                    Logger.getLogger(MetricsPanelAdapter.class.getName()).log(Level.SEVERE, "error creating FX viewer UI", runtimeException);
                }
            });
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(MetricsPanelAdapter.class.getName()).log(Level.SEVERE, "swing thread interrupted waiting for fx initialization");
            }
        }
    }

    public void close() {
        Platform.runLater(() -> this.closeFXUI());
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
    }

    private void createFXUI(Map<String, Object> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("ConnectionName", this.connectionName);
        hashMap.put("Snapshot", false);
        PanelTemplate<Region> panelTemplate = this.factory.newPageTemplate(hashMap);
        panelTemplate.getParameters().putAll(map);
        this.rootPanel = panelTemplate.newPanel();
        if (this.rootPanel != null) {
            LocalsService localsService = this.rootPanel.getContext().getLocals();
            for (MetricsPanelCommand metricsPanelCommand : this.commands) {
                metricsPanelCommand.initialize(localsService);
            }
            this.sceneRoot = new MetricsPane((Parent)this.rootPanel.getRootObject());
            this.scene = new Scene((Parent)this.sceneRoot);
            this.fxPanel.setScene(this.scene);
        }
    }

    private void closeFXUI() {
        this.sceneRoot.getChildren().clear();
    }

    private class MetricsPane
    extends Pane {
        private final Parent instanceRoot;

        MetricsPane(Parent parent) {
            super(new Node[]{parent});
            this.instanceRoot = parent;
        }

        protected double computePrefHeight(double d) {
            return this.instanceRoot.prefHeight(d);
        }

        protected double computePrefWidth(double d) {
            return this.instanceRoot.prefWidth(d);
        }

        protected double computeMinHeight(double d) {
            return this.instanceRoot.minHeight(d);
        }

        protected double computeMinWidth(double d) {
            return this.instanceRoot.minWidth(d);
        }

        protected double computeMaxHeight(double d) {
            return this.instanceRoot.maxHeight(d);
        }

        protected double computeMaxWidth(double d) {
            return this.instanceRoot.maxWidth(d);
        }

        protected void layoutChildren() {
            this.layoutInArea((Node)this.instanceRoot, 0.0, 0.0, this.getWidth(), this.getHeight(), 0.0, HPos.LEFT, VPos.TOP);
        }
    }
}

