/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.viewer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javax.swing.Action;
import oracle.dbtools.raptor.controls.display.IModifyToolbar;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.metrics.viewer.MetricsToolbarAdapter;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;

public class MetricsToolbar
implements IModifyToolbar {
    private static MetricsToolbarAdapter toolbarAdapter;

    static void setAdapter(MetricsToolbarAdapter metricsToolbarAdapter) {
        toolbarAdapter = metricsToolbarAdapter;
    }

    public void modifyToolbar(Toolbar toolbar) {
        Platform.runLater(() -> toolbarAdapter.openToolbarUI(toolbar));
    }

    public void modifyToolbar(Toolbar toolbar, Map<String, Object> map) {
        List<String> list = this.getToolbarLayoutTokens();
        if (list != null) {
            this.layoutToolbar(toolbar, list, toolbarAdapter.getActions());
        }
        Platform.runLater(() -> toolbarAdapter.openToolbarUI(toolbar));
    }

    private List<String> getToolbarLayoutTokens() {
        String[] stringArray = null;
        String string = toolbarAdapter.getToolbarLayout();
        if (string != null) {
            stringArray = string.split("\\s+");
        }
        return Arrays.asList(stringArray);
    }

    private void layoutToolbar(Toolbar toolbar, List<String> list, List<ObjectAction> list2) {
        HashMap<String, ObjectAction> hashMap = new HashMap<String, ObjectAction>();
        for (ObjectAction objectAction : list2) {
            hashMap.put(objectAction.getCommandName(), objectAction);
        }
        Iterator<ObjectAction> iterator = list.listIterator();
        boolean bl = true;
        block13: while (bl && iterator.hasNext()) {
            String string;
            switch (string = (String)iterator.next()) {
                case "{ActionMenuButton}": {
                    bl = this.processActionMenu(toolbar, (Map<String, ObjectAction>)hashMap, (ListIterator<String>)iterator);
                    continue block13;
                }
                case "{Button}": {
                    bl = this.processButton(toolbar, (Map<String, ObjectAction>)hashMap, (ListIterator<String>)iterator);
                    continue block13;
                }
                case "{Separator}": {
                    this.processSeparator(toolbar);
                    continue block13;
                }
                case "": {
                    continue block13;
                }
            }
            bl = false;
        }
        if (!bl) {
            Logger.getLogger(MetricsToolbar.class.getName()).log(Level.SEVERE, "invalid toolbar layout at ''{0}'' for ''{1}''", new Object[]{iterator.previous(), toolbarAdapter.getToolbarLayout()});
        }
    }

    private boolean processActionMenu(Toolbar toolbar, Map<String, ObjectAction> map, ListIterator<String> listIterator) {
        String string;
        ObjectAction objectAction;
        if (listIterator.hasNext() && (objectAction = map.get(string = listIterator.next())) != null) {
            Action[] actionArray;
            ArrayList<IdeAction> arrayList = new ArrayList<IdeAction>();
            boolean bl = false;
            block8: while (!bl && listIterator.hasNext()) {
                switch (actionArray = listIterator.next()) {
                    case "{MenuItem}": {
                        if (!listIterator.hasNext()) continue block8;
                        String string2 = listIterator.next();
                        ObjectAction objectAction2 = map.get(string2);
                        if (objectAction2 == null) {
                            return false;
                        }
                        arrayList.add(objectAction2.getAction());
                        continue block8;
                    }
                    case "{End}": {
                        bl = true;
                        continue block8;
                    }
                }
                return false;
            }
            if (bl) {
                actionArray = toolbar.addActionMenuButton((Action)objectAction.getAction());
                Action[] actionArray2 = new Action[arrayList.size()];
                arrayList.toArray(actionArray2);
                actionArray.setMenuActions(actionArray2);
                return true;
            }
        }
        return false;
    }

    private boolean processButton(Toolbar toolbar, Map<String, ObjectAction> map, ListIterator<String> listIterator) {
        String string;
        ObjectAction objectAction;
        if (listIterator.hasNext() && (objectAction = map.get(string = listIterator.next())) != null) {
            IdeAction ideAction = objectAction.getAction();
            toolbar.add((ToggleAction)ideAction);
            return true;
        }
        return false;
    }

    private void processSeparator(Toolbar toolbar) {
        toolbar.addSeparator();
    }
}

