/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.dialogs.SQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.connection.TTSQLExceptionListener;
import oracle.dbtools.raptor.utils.Connections;

public class TTSQLExceptionScrubber
implements SQLExceptionScrubber {
    private static final String theRegEx = "\\[TimesTen[^\\]]*\\]";
    private static final String theDetails = "\\s+--\\s+.*";
    private static Logger theLogger = Logger.getLogger(TTSQLExceptionScrubber.class.getPackage().getName());
    private static TTSQLExceptionScrubber theInstance;
    private final TTSQLExceptionListener theExceptionHandler = TTSQLExceptionListener.getTheInstance();

    private TTSQLExceptionScrubber() {
    }

    public static synchronized TTSQLExceptionScrubber getInstance() {
        if (theInstance == null) {
            theInstance = new TTSQLExceptionScrubber();
        }
        return theInstance;
    }

    public String getMessage(String string, SQLException sQLException) {
        return this.getMessage(string, null, sQLException);
    }

    public String getMessage(String string, String string2, SQLException sQLException) {
        Connections connections = Connections.getInstance();
        if (connections == null) {
            return null;
        }
        if (string == null) {
            return null;
        }
        if (!connections.isTimesTen(string)) {
            return null;
        }
        this.theExceptionHandler.handleSQLError(string, sQLException);
        return TTSQLExceptionScrubber.getMessage(sQLException.getLocalizedMessage(), string2);
    }

    public String getMessage(Connection connection, String string, SQLException sQLException) {
        Connections connections = Connections.getInstance();
        if (connections == null) {
            return null;
        }
        if (!connections.isTimesTen(connection)) {
            return null;
        }
        this.theExceptionHandler.handleSQLError(connection, sQLException);
        return TTSQLExceptionScrubber.getMessage(sQLException.getLocalizedMessage(), string);
    }

    public static String getMessage(String string, String string2) {
        return TTSQLExceptionScrubber.getMessage(string, string2, theLogger);
    }

    public static String getMessage(String string, String string2, Logger logger) {
        Pattern pattern = Pattern.compile(theRegEx);
        Matcher matcher = pattern.matcher(string);
        boolean bl = false;
        if (matcher.find()) {
            bl = true;
        }
        if (!bl) {
            return string;
        }
        if (logger != null) {
            logger.log(Level.SEVERE, string, Thread.currentThread().getStackTrace());
        }
        String string3 = matcher.replaceAll("");
        String string4 = string3.replaceAll(theDetails, "");
        if (string2 != null && string2.contains("\n") && string4.contains(" character position: ")) {
            string4 = TTSQLExceptionScrubber.fixLineCol(string2, string4);
        }
        return string4;
    }

    private static String fixLineCol(String string, String string2) {
        Object object;
        int n = 0;
        if (string2.matches(".+character position: [0-9]+")) {
            object = string2.replaceAll(".+character position: ([0-9]+)", "$1");
            try {
                n = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return string2;
            }
        }
        object = string.toCharArray();
        int n2 = 1;
        int n3 = 0;
        for (int i = 0; i < Math.min(n, ((char[])object).length); ++i) {
            char c = object[i];
            if (c == '\n') {
                ++n2;
                n3 = 0;
            } else {
                ++n3;
            }
            if (c != '\r' || n3 <= 1) continue;
            --n3;
        }
        String string3 = string2.replaceAll(", character position: ([0-9]+)", "\nError at Line: " + n2 + " Column: " + n3);
        return string3;
    }

    public static SQLException cloneScrubbedSQLException(SQLException sQLException, String string) {
        String string2 = TTSQLExceptionScrubber.getMessage(sQLException.getLocalizedMessage(), string);
        String string3 = sQLException.getSQLState();
        int n = sQLException.getErrorCode();
        SQLException sQLException2 = new SQLException(string2, string3, n);
        return sQLException2;
    }
}

