/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.raptor.timesten.TimesTenPlugInDatabaseImpl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.jdbc.DMDBuilder;

public class TTSequenceBuilder
extends DMDBuilder<Sequence> {
    public static final String BATCH_VALUE = "batchValue";
    private static final String BATCH_VALUE_SQL = "SELECT BATCHSIZE from sys.sequences  WHERE NAME = ? AND OWNER = ?";

    public TTSequenceBuilder(JdbcDatabase jdbcDatabase, String string) {
        super(jdbcDatabase, string, "SEQUENCE");
    }

    public Sequence createObject(String string, Schema schema, DBObjectID dBObjectID) {
        Sequence sequence = new Sequence(string, schema);
        sequence.setID(dBObjectID);
        return sequence;
    }

    public boolean canBuildEditableObject() {
        return true;
    }

    protected boolean canBuildComponents() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AbstractDBObjectBuilder.PropertyBuilder(value={"batchValue"})
    public void buildTimestenElement(Sequence sequence) throws DBException {
        Connection connection = this.getConnection();
        Connections.getInstance().lock(connection);
        String string = null;
        if (TimesTenPlugInDatabaseImpl.isGridDatabase(connection)) {
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = connection.prepareStatement(BATCH_VALUE_SQL);
                preparedStatement.setString(1, sequence.getName());
                preparedStatement.setString(2, sequence.getSchema().getName());
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    string = resultSet.getString(1);
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        if (connection != null) {
            Connections.getInstance().unlock(connection);
        }
        sequence.setProperty(BATCH_VALUE, string);
    }
}

