/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.connection;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.connection.TTComponentView;
import oracle.dbtools.raptor.timesten.connection.TTConnectionPanel;
import oracle.dbtools.raptor.timesten.connection.TimesTenConnectionType;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.db.ConnectionException;

public class TTAdvancedPanel
extends JPanel
implements TTComponentView {
    private static final String[] ERROR_STRINGS = new String[]{Messages.getString("TTConnectionPanel.ConnectionCannotBeEmptyForUserSpecifiedDSN"), Messages.getString("TTConnectionPanel.ConnectionStringNeedsToIncludeDSNAttribure"), Messages.getString("TTConnectionPanel.ConnectionStringCannotContainDSNAttribute"), Messages.getString("TTConnectionPanel.ConnectionStringCannotContainOraclePWD"), Messages.getString("TTConnectionPanel.AccessControlIsEnabledUsernameORPassword"), Messages.getString("TTConnectionPanel.OraclePwdnull")};
    private static final String CLIENT_SERVER_ACTION_COMMAND = "C/S";
    private static final String DIRECT_ACTION_COMMAND = Messages.getString("TTConnectionPanel.Direct");
    protected ButtonGroup theDriverButtonGroup;
    protected JRadioButton theCSButton;
    protected JRadioButton theDirectButton;
    protected JTextField theConnStrField;
    protected JCheckBox theEnableOraclePwdJCB = new JCheckBox();
    private JLabel theEnableOraclePwdLabel = new JLabel();
    public static final String ORACLE_PWD = "oraclePassword";
    private JLabel cachePWDLabel = new JLabel(Messages.getString("TTConnectionPanel.oraclePassword"));
    protected JPasswordField theCachePWDField = new JPasswordField(16);
    private TTConnectionPanel theConnPanel;
    private JLabel theOraServiceNameLbl = new JLabel();
    protected JTextField theOraServiceNameJTF = new JTextField(15);

    public TTAdvancedPanel(TTConnectionPanel tTConnectionPanel) {
        try {
            this.theConnPanel = tTConnectionPanel;
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    @Override
    public void populateComponent(Properties properties) throws ConnectionException {
        String string = this.getDSNUrl();
        properties.put("URL", string);
        properties.put("customUrl", string);
        if (this.theEnableOraclePwdJCB.isSelected()) {
            String string2 = new String(this.theCachePWDField.getPassword());
            if (string2.length() <= 0) {
                this.theConnPanel.setErrorStatus(ERROR_STRINGS[5]);
                throw new ConnectionException(ERROR_STRINGS[5]);
            }
            properties.put(ORACLE_PWD, string2);
            if (this.theOraServiceNameJTF.getText().length() > 0) {
                properties.put("ORANETSERVICENAME", this.theOraServiceNameJTF.getText().toUpperCase().trim());
            }
        }
        properties.put("ENABLECACHE", Boolean.toString(this.theEnableOraclePwdJCB.isSelected()));
        properties.setProperty("TimesTenConnectionType", TimesTenConnectionType.ADVANCED.name());
    }

    private void jbInit() throws Exception {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        this.setLayout(new GridBagLayout());
        this.theDriverButtonGroup = new ButtonGroup();
        this.theCSButton = jRadioButton2 = new JRadioButton(Messages.getString("TTConnectionPanel.clientServer"), true);
        jRadioButton2.setActionCommand(CLIENT_SERVER_ACTION_COMMAND);
        this.theDirectButton = jRadioButton = new JRadioButton(Messages.getString("TTConnectionPanel.direct"));
        jRadioButton.setActionCommand(DIRECT_ACTION_COMMAND);
        this.theDriverButtonGroup.add(jRadioButton2);
        this.theDriverButtonGroup.add(jRadioButton);
        Insets insets = new Insets(2, 2, 0, 0);
        this.add((Component)new JLabel(Messages.getString("TTConnectionPanel.DriverType")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(jRadioButton2);
        jPanel.add(jRadioButton);
        this.add((Component)jPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.1, 23, 0, insets, 0, 0));
        JLabel jLabel = new JLabel(Messages.getString("TTConnectionPanel.connectionString"));
        this.add((Component)jLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        this.theConnStrField = new JTextField(" ", 32);
        this.add((Component)this.theConnStrField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 23, 2, insets, 0, 0));
        ResourceUtils.resLabel((JLabel)this.theEnableOraclePwdLabel, (Component)this.theEnableOraclePwdJCB, (String)Messages.getString("TTConnectionPanel.enableCacheFromOracle"));
        this.add((Component)this.theEnableOraclePwdLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this.theEnableOraclePwdJCB, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        ResourceUtils.resLabel((JLabel)this.cachePWDLabel, (Component)this.theCachePWDField, (String)Messages.getString("TTConnectionPanel.oraclePassword"));
        this.add((Component)this.cachePWDLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this.theCachePWDField, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        ResourceUtils.resLabel((JLabel)this.theOraServiceNameLbl, (Component)this.theOraServiceNameJTF, (String)Messages.getString("TTConnectionPanel.oracleServiceName"));
        this.add((Component)this.theOraServiceNameLbl, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this.theOraServiceNameJTF, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.theCachePWDField.setEnabled(false);
        this.theOraServiceNameJTF.setEnabled(false);
        this.theEnableOraclePwdJCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                System.err.println(itemEvent.getStateChange());
                if (itemEvent.getStateChange() == 1) {
                    TTAdvancedPanel.this.theCachePWDField.setEnabled(true);
                    TTAdvancedPanel.this.theOraServiceNameJTF.setEnabled(true);
                } else {
                    TTAdvancedPanel.this.theCachePWDField.setEnabled(false);
                    TTAdvancedPanel.this.theOraServiceNameJTF.setEnabled(false);
                    TTAdvancedPanel.this.cleanCacheParameters();
                }
            }
        });
    }

    private String getDSNUrl() throws ConnectionException {
        boolean bl = false;
        String string = this.theConnStrField.getText().toUpperCase().trim();
        StringBuffer stringBuffer = new StringBuffer(256);
        String string2 = this.theOraServiceNameJTF.getText().toUpperCase().trim();
        Object object = "";
        if (this.theEnableOraclePwdJCB.isSelected() && (string2 != null || string2.length() > 0)) {
            object = "OracleNetServiceName=" + string2 + ";";
        }
        stringBuffer.append("jdbc:timesten:");
        if (this.theConnPanel.hasPassword(string)) {
            this.theConnPanel.setErrorStatus(ERROR_STRINGS[3]);
            throw new ConnectionException(ERROR_STRINGS[3]);
        }
        if (this.theDriverButtonGroup.getSelection().getActionCommand().equals(CLIENT_SERVER_ACTION_COMMAND)) {
            bl = true;
        }
        stringBuffer.append(bl ? "client:" : "direct:");
        stringBuffer.append(string);
        if (!string.endsWith(";")) {
            stringBuffer.append(";");
        }
        stringBuffer.append((String)object);
        stringBuffer.append("ConnectionName=");
        stringBuffer.append(this.theConnPanel.getConnectionName());
        return stringBuffer.toString();
    }

    @Override
    public void clear() {
    }

    @Override
    public void setDefaultPrompts() {
        this.clear();
    }

    public void cleanCacheParameters() {
        this.theCachePWDField.setText("");
        this.theOraServiceNameJTF.setText("");
    }
}

