/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.ddlgen;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.timesten.ddlgen.TimesTenDDLType;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ddl.BundleDDLGenerator;
import oracle.javatools.db.ddl.TokenDDLGenerator;
import oracle.javatools.db.ddl.TokenGenerator;
import oracle.javatools.db.ora.ddl.OracleDDLSupport;

public class TimesTenBundleGenerator
extends BundleDDLGenerator<TimesTenDDLType> {
    private static String[] theBundles = new String[]{"/oracle/dbtools/raptor/timesten/ddlgen/TimesTenDDL.properties"};

    public TimesTenBundleGenerator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider, theBundles);
        OracleDDLSupport oracleDDLSupport = OracleDDLSupport.getInstance();
        for (Map.Entry entry : oracleDDLSupport.getGlobalTokenGenerators().entrySet()) {
            this.registerTokenGenerator((String)entry.getKey(), (TokenGenerator)entry.getValue());
        }
        oracleDDLSupport.includeOracleSyntax((TokenDDLGenerator)this, "PACKAGE", false);
        oracleDDLSupport.includeOracleSyntax((TokenDDLGenerator)this, "FUNCTION", false);
        oracleDDLSupport.includeOracleSyntax((TokenDDLGenerator)this, "PROCEDURE", false);
    }

    protected TimesTenDDLType getDDLType(String string) {
        return TimesTenDDLType.getDDLType(string);
    }

    protected boolean canChangeWithAlter(SystemObject systemObject, SystemObject systemObject2, String string) {
        if (systemObject instanceof Table && (string.contains("TIMESTENELEMENT") || string.contains("TTPrimaryKeyIndexType"))) {
            return true;
        }
        if (systemObject instanceof Table && this.hasPK((Table)systemObject) && !this.hasPK((Table)systemObject2)) {
            return false;
        }
        if (systemObject instanceof Sequence) {
            return true;
        }
        return super.canChangeWithAlter(systemObject, systemObject2, string);
    }

    public boolean supportsProperty(Class<? extends DBObject> clazz, String string) {
        if (clazz.equals(Table.class) && (string.contains("TIMESTENELEMENT") || string.contains("TTPrimaryKeyIndexType"))) {
            return true;
        }
        if (clazz.equals(Sequence.class) && string.contains("batchValue")) {
            return true;
        }
        return super.supportsProperty(clazz, string);
    }

    private boolean hasPK(Table table) {
        for (Constraint constraint : table.getConstraints()) {
            if (!(constraint instanceof PKConstraint)) continue;
            return true;
        }
        return false;
    }

    public Collection getAllowedPropertyValues(DBObject dBObject, DBObject dBObject2, String string) {
        List<FKConstraint.ReferentialAction> list = null;
        if (string.equals("onDeleteAction")) {
            list = Arrays.asList(FKConstraint.ReferentialAction.RESTRICT, FKConstraint.ReferentialAction.CASCADE);
            return list;
        }
        return super.getAllowedPropertyValues(dBObject, dBObject2, string);
    }
}

