/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.connection;

import java.awt.Dialog;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.timesten.dialogs.OutdatedTableStatsAlertDialog;
import oracle.dbtools.raptor.utils.Connections;
import oracle.i18n.text.OraSimpleDateFormat;

public class TableStatistics {
    private static Logger LOGGER = Logger.getLogger(TableStatistics.class.getPackage().getName());
    private final Connection theConnection;
    private Frame frame;
    private Dialog dialog;
    private static final String ROW_COUNT_UPDATED_STATISTICS = "SELECT count(*) FROM sys.tbl_stats s1, sys.tables s2 WHERE s1.tblid = s2.tblid AND s2.tblowner NOT IN ('PUBLIC', 'SYS', 'TTREP', 'GRID', 'SYSTEM') AND TO_DATE(rtrim(s1.LASTSTATSUPDATE),'Dy Mon  DD HH24:MI:SS YYYY') > TIMESTAMPADD (SQL_TSI_HOUR, :hours, SYSDATE)";
    private boolean theConfirmOrCancel;
    private static final String COUNT_NO_STATS_TABLES = "SELECT count(*) FROM all_tables where owner NOT IN ('PUBLIC', 'SYS', 'TTREP', 'GRID', 'SYSTEM') and(owner,table_name) not in (SELECT trim(tblowner) as owner, trim(tblname) as table_name  FROM sys.tbl_stats s1, sys.tables s2 WHERE s1.tblid = s2.tblid)";
    private static final String COUNT_STATS_TABLES = "SELECT count(*) FROM sys.tbl_stats s1, sys.tables s2 WHERE s1.tblid = s2.tblid AND s2.tblowner NOT IN ('PUBLIC', 'SYS', 'TTREP', 'GRID', 'SYSTEM')";
    private static final String LAST_UPDATED_TABLE = "SELECT LASTSTATSUPDATE,TBLNAME,TBLOWNER FROM sys.tbl_stats s1, sys.tables s2 WHERE s1.tblid = s2.tblid and LASTSTATSUPDATE = (select max(LASTSTATSUPDATE) FROM sys.tbl_stats s1, sys.tables s2 WHERE s1.tblid = s2.tblid AND s2.tblowner NOT IN ('PUBLIC', 'SYS', 'TTREP', 'GRID', 'SYSTEM'))";
    private static final String LEAST_UPDATED_TABLE = "SELECT LASTSTATSUPDATE,TBLNAME,TBLOWNER FROM sys.tbl_stats s1, sys.tables s2 WHERE s1.tblid = s2.tblid and LASTSTATSUPDATE = (select min(LASTSTATSUPDATE) FROM sys.tbl_stats s1, sys.tables s2 WHERE s1.tblid = s2.tblid AND s2.tblowner NOT IN ('PUBLIC', 'SYS', 'TTREP', 'GRID', 'SYSTEM'))";

    public TableStatistics(Connection connection) {
        this.theConnection = connection;
    }

    public TableStatistics(Connection connection, Frame frame) {
        this.theConnection = connection;
        this.frame = frame;
    }

    public TableStatistics(Connection connection, Dialog dialog) {
        this.theConnection = connection;
        this.dialog = dialog;
    }

    public int displayWarning() {
        return this.displayWarning(24);
    }

    public int displayWarning(int n) {
        boolean bl = this.anyUpdatesInTheLastDay();
        final StatsTableInfo statsTableInfo = this.getLastStatTable();
        final StatsTableInfo statsTableInfo2 = this.getLeastStatTable();
        final int n2 = this.getTableCountWithNoStatistics();
        final int n3 = this.getTableCountWithStatistics();
        this.theConfirmOrCancel = true;
        if (!(bl || this.frame == null && this.dialog == null)) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    OutdatedTableStatsAlertDialog outdatedTableStatsAlertDialog = null;
                    outdatedTableStatsAlertDialog = TableStatistics.this.frame != null ? new OutdatedTableStatsAlertDialog(TableStatistics.this.frame, n3, n2, statsTableInfo, statsTableInfo2) : new OutdatedTableStatsAlertDialog(TableStatistics.this.dialog, n3, n2, statsTableInfo, statsTableInfo2);
                    TableStatistics.this.theConfirmOrCancel = outdatedTableStatsAlertDialog.runDialog();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (InvocationTargetException invocationTargetException) {
                    LOGGER.log(Level.SEVERE, "Can't excecute warning ", invocationTargetException);
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.log(Level.SEVERE, "Can't excecute warning ", interruptedException);
                }
            }
        }
        return this.theConfirmOrCancel ? 1 : 0;
    }

    public boolean anyUpdatesInTheLastDay() {
        return this.anyUpdatesInTheLastDay(24);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean anyUpdatesInTheLastDay(int n) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("hours", -n);
        Connections.getInstance().lock(this.theConnection);
        ResultSet resultSet = DBUtil.getInstance((Connection)this.theConnection).executeQuery(ROW_COUNT_UPDATED_STATISTICS, hashMap);
        boolean bl = false;
        try {
            if (resultSet.next()) {
                LOGGER.log(Level.INFO, resultSet.getInt(1) + " table statistics have been updated in the last " + n);
                boolean bl2 = bl = resultSet.getInt(1) > 0;
            }
            if (!bl) {
                LOGGER.log(Level.WARNING, "Table statistics have not been update in the last " + n);
            }
        }
        catch (SQLException sQLException) {
            LOGGER.log(Level.SEVERE, "Cannot assess when table statistics was updated", sQLException);
        }
        finally {
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(this.theConnection);
        }
        return bl;
    }

    public int getTableCountWithNoStatistics() {
        return this.countNumberTablesHelper(COUNT_NO_STATS_TABLES);
    }

    public int getTableCountWithStatistics() {
        return this.countNumberTablesHelper(COUNT_STATS_TABLES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countNumberTablesHelper(String string) {
        Statement statement = null;
        try {
            statement = this.theConnection.createStatement();
            Connections.getInstance().lock(this.theConnection);
            ResultSet resultSet = statement.executeQuery(string);
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
        }
        catch (SQLException sQLException) {
            LOGGER.log(Level.SEVERE, "Cannot count tables with stats", sQLException);
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.SEVERE, "Cannot close statement", sQLException);
            }
            Connections.getInstance().unlock(this.theConnection);
        }
        return -1;
    }

    public StatsTableInfo getLastStatTable() {
        return this.getTableStatsHelper(LAST_UPDATED_TABLE);
    }

    public StatsTableInfo getLeastStatTable() {
        return this.getTableStatsHelper(LEAST_UPDATED_TABLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatsTableInfo getTableStatsHelper(String string) {
        StatsTableInfo statsTableInfo = new StatsTableInfo();
        Statement statement = null;
        try {
            statement = this.theConnection.createStatement();
            Connections.getInstance().lock(this.theConnection);
            ResultSet resultSet = statement.executeQuery(string);
            if (resultSet.next()) {
                statsTableInfo.name = resultSet.getString(2).trim();
                statsTableInfo.owner = resultSet.getString(3).trim();
                statsTableInfo.setUpdatedOn(resultSet.getString(1).trim());
            }
            StatsTableInfo statsTableInfo2 = statsTableInfo;
            return statsTableInfo2;
        }
        catch (SQLException sQLException) {
            LOGGER.log(Level.SEVERE, "Cannot get updated table info", sQLException);
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.SEVERE, "Cannot close statement", sQLException);
            }
            Connections.getInstance().unlock(this.theConnection);
        }
        return null;
    }

    public class StatsTableInfo {
        public String name;
        public String owner;
        public String updatedOn;
        private final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Locale.US);

        public void setUpdatedOn(String string) {
            DBConfig dBConfig = DBConfig.getInstance();
            if (dBConfig != null) {
                String string2 = "";
                try {
                    string2 = dBConfig.getString("NLS_DATE_FORM");
                    OraSimpleDateFormat oraSimpleDateFormat = new OraSimpleDateFormat(string2, Locale.getDefault());
                    LOGGER.log(Level.INFO, "Trying to convert date to : " + string2);
                    try {
                        Date date = this.dateFormat.parse(string);
                        this.updatedOn = oraSimpleDateFormat.format(date);
                    }
                    catch (ParseException parseException) {
                        LOGGER.log(Level.INFO, "Can't parse date : " + string);
                        this.updatedOn = string;
                    }
                }
                catch (Exception exception) {
                    LOGGER.log(Level.SEVERE, "Can't compile pattern : " + string2, exception);
                    this.updatedOn = string;
                }
            } else {
                this.updatedOn = string;
            }
        }

        public String toString() {
            return "Table name: " + this.name + " Owner: " + this.owner + " Stats updated on: " + this.updatedOn;
        }
    }
}

