/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.index;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import oracle.dbtools.raptor.images.BaseRaptorImages;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.index.IndexInfoPanel;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.javatools.db.Column;
import oracle.javatools.db.Index;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.ui.Reorderable;
import oracle.javatools.ui.ReorderableBar;

public class SelectColumnIndexPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private SelectColumnTable columnsTable;
    private JList<Column> fromList;
    private DefaultListModel<Column> listModel;
    private List<Column> selectedColumns = new ArrayList<Column>();
    private HashMap<Column, String> orderedBy = new HashMap();
    private HashMap<Column, IndexObject> indexObjects = new HashMap();
    private JButton addAll;
    private JButton remAll;
    private JButton addOne;
    private JButton remOne;
    private JScrollPane listScroll;
    private JScrollPane tableScroll;
    private Index index;
    private IndexInfoPanel editor;
    private final String ASC = "ASC";
    private final String DESC = "DESC";

    public SelectColumnIndexPanel(IndexInfoPanel indexInfoPanel, Index index) {
        this.index = index;
        this.editor = indexInfoPanel;
        this.columnsTable = new SelectColumnTable();
        this.listModel = new DefaultListModel();
        this.fromList = new JList<Column>(this.listModel);
        this.listScroll = new JScrollPane(this.fromList);
        this.tableScroll = new JScrollPane(this.columnsTable);
        this.addAll = new JButton();
        this.addOne = new JButton();
        this.remAll = new JButton();
        this.remOne = new JButton();
        this.initButtons();
        this.createGUI();
        this.updatePanel();
    }

    public void updatePanel() {
        if (this.index.getTable() != null) {
            Column[] columnArray = this.index.getTable().getColumns();
            this.listModel.removeAllElements();
            for (Column column : columnArray) {
                this.listModel.addElement(column);
            }
            this.selectedColumns.clear();
            this.orderedBy.clear();
            this.indexObjects.clear();
            this.columnsTable.refreshData();
        } else {
            this.listModel.removeAllElements();
            this.selectedColumns.clear();
            this.orderedBy.clear();
            this.indexObjects.clear();
            this.columnsTable.refreshData();
        }
    }

    private void refreshIndexExpressions() {
        IndexObject[] indexObjectArray = this.index.getColumnExpressions();
        for (IndexObject indexObject : indexObjectArray) {
            this.index.removeColumnExpression(indexObject);
        }
        for (Column column : this.selectedColumns) {
            this.index.addColumnExpression(this.indexObjects.get(column));
        }
    }

    private void createGUI() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.listScroll, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)6, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
        this.add((Component)new JPanel(), LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2BUTTON_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.Y));
        this.add((Component)this.addOne, LayoutControl.GBC.gbc((int)1, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP));
        this.add((Component)this.addAll, LayoutControl.GBC.gbc((int)1, (int)2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP));
        this.add((Component)this.remOne, LayoutControl.GBC.gbc((int)1, (int)3, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP));
        this.add((Component)this.remAll, LayoutControl.GBC.gbc((int)1, (int)4, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP));
        this.add((Component)new JPanel(), LayoutControl.GBC.gbc((int)1, (int)5, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.Y));
        this.add((Component)this.tableScroll, LayoutControl.GBC.gbc((int)2, (int)0, (int)1, (int)6, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2BUTTON_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
        this.add((Component)this.columnsTable.getReorderBar(), LayoutControl.GBC.gbc((int)3, (int)0, (int)1, (int)6, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.Y));
    }

    private void initButtons() {
        this.addAll.setActionCommand(">>");
        this.addAll.getAccessibleContext().setAccessibleName(UiResources.getString((String)"ADD_ALL"));
        this.addAll.setName(UiResources.getString((String)"ADD_ALL"));
        this.addAll.setToolTipText(UiResources.getString((String)"ADD_ALL"));
        this.addAll.setIcon(BaseRaptorImages.getIcon((String)"LAST_ENA"));
        this.addAll.addActionListener(this);
        this.addOne.setActionCommand(">");
        this.addOne.getAccessibleContext().setAccessibleName(UiResources.getString((String)"ADD_SELECTED"));
        this.addOne.setName(UiResources.getString((String)"ADD_SELECTED"));
        this.addOne.setToolTipText(UiResources.getString((String)"ADD_SELECTED"));
        this.addOne.setIcon(BaseRaptorImages.getIcon((String)"NEXT_ENA"));
        this.addOne.addActionListener(this);
        this.remAll.setActionCommand("<<");
        this.remAll.getAccessibleContext().setAccessibleName(UiResources.getString((String)"REMOVE_ALL"));
        this.remAll.setName(UiResources.getString((String)"REMOVE_ALL"));
        this.remAll.setToolTipText(UiResources.getString((String)"REMOVE_ALL"));
        this.remAll.setIcon(BaseRaptorImages.getIcon((String)"FIRST_ENA"));
        this.remAll.addActionListener(this);
        this.remOne.setActionCommand("<");
        this.remOne.getAccessibleContext().setAccessibleName(UiResources.getString((String)"REMOVE_SELECTED"));
        this.remOne.setName(UiResources.getString((String)"REMOVE_SELECTED"));
        this.remOne.setToolTipText(UiResources.getString((String)"REMOVE_SELECTED"));
        this.remOne.setIcon(BaseRaptorImages.getIcon((String)"PREV_ENA"));
        this.remOne.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.addAll) {
            this.doAddAll();
        } else if (actionEvent.getSource() == this.remAll) {
            this.doRemovAll();
        } else if (actionEvent.getSource() == this.addOne) {
            this.addSelected();
        } else if (actionEvent.getSource() == this.remOne) {
            this.removeSelected();
        }
        this.refreshIndexExpressions();
    }

    private void doAddAll() {
        while (!this.listModel.isEmpty()) {
            Column column = this.listModel.remove(0);
            this.selectedColumns.add(column);
            this.indexObjects.put(column, new IndexObject((SQLFragment)new ColumnUsage(column.getID())));
        }
        this.columnsTable.refreshData();
    }

    private void doRemovAll() {
        while (!this.selectedColumns.isEmpty()) {
            Column column = this.selectedColumns.remove(0);
            this.orderedBy.remove(column);
            this.indexObjects.remove(column);
            this.listModel.addElement(column);
        }
        this.columnsTable.refreshData();
    }

    private void addSelected() {
        List<Column> list = this.fromList.getSelectedValuesList();
        this.selectedColumns.addAll(list);
        for (Column column : list) {
            this.listModel.removeElement(column);
            this.indexObjects.put(column, new IndexObject((SQLFragment)new ColumnUsage(column.getID())));
        }
        this.columnsTable.refreshData();
    }

    private void removeSelected() {
        int[] nArray = this.columnsTable.getSelectedRows();
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n = nArray[i];
            Column column = this.selectedColumns.get(n);
            this.indexObjects.remove(column);
            this.orderedBy.remove(column);
            this.listModel.addElement(column);
            this.selectedColumns.remove(column);
        }
        this.columnsTable.refreshData();
    }

    private class SelectColumnTable
    extends JTable
    implements Reorderable {
        private ReorderableBar orderBar;
        private SelectColumnModel model = new SelectColumnModel();
        private OrderCellEditor editor = new OrderCellEditor();

        public SelectColumnTable() {
            this.setModel(this.model);
            this.getColumnModel().getColumn(1).setCellEditor(this.editor);
            this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
            this.orderBar = new ReorderableBar((Reorderable)this, true);
        }

        public void refreshData() {
            this.model.fireTableDataChanged();
        }

        public ReorderableBar getReorderBar() {
            return this.orderBar;
        }

        public boolean isSelectionTopMobile() {
            int[] nArray = this.getSelectedRows();
            return nArray.length > 0 && nArray[0] > 0;
        }

        public boolean isSelectionBottomMobile() {
            int[] nArray = this.getSelectedRows();
            return nArray.length > 0 && nArray[nArray.length - 1] < SelectColumnIndexPanel.this.selectedColumns.size() - 1;
        }

        public void moveSelectionTop() {
            int[] nArray = this.getSelectedRows();
            int n = 0;
            for (n = 0; n < nArray.length; ++n) {
                Column column = SelectColumnIndexPanel.this.selectedColumns.remove(nArray[n]);
                SelectColumnIndexPanel.this.selectedColumns.add(n, column);
            }
            this.model.fireTableDataChanged();
            this.getSelectionModel().addSelectionInterval(0, n - 1);
            SelectColumnIndexPanel.this.refreshIndexExpressions();
        }

        public void moveSelectionBottom() {
            int[] nArray = this.getSelectedRows();
            int n = 0;
            int n2 = 0;
            for (n = nArray.length - 1; n >= 0; --n) {
                Column column = SelectColumnIndexPanel.this.selectedColumns.remove(nArray[n]);
                SelectColumnIndexPanel.this.selectedColumns.add(SelectColumnIndexPanel.this.selectedColumns.size() - n2, column);
                ++n2;
            }
            this.model.fireTableDataChanged();
            this.getSelectionModel().addSelectionInterval(SelectColumnIndexPanel.this.selectedColumns.size() - n2, SelectColumnIndexPanel.this.selectedColumns.size() - 1);
            SelectColumnIndexPanel.this.refreshIndexExpressions();
        }

        public boolean isSelectionUpwardlyMobile() {
            return this.isSelectionTopMobile();
        }

        public boolean isSelectionDownwardlyMobile() {
            return this.isSelectionBottomMobile();
        }

        public void moveSelectionUp() {
            int n;
            int[] nArray = this.getSelectedRows();
            for (n = 0; n < nArray.length; ++n) {
                Column column = SelectColumnIndexPanel.this.selectedColumns.remove(nArray[n]);
                SelectColumnIndexPanel.this.selectedColumns.add(nArray[n] - 1, column);
            }
            this.model.fireTableDataChanged();
            for (n = 0; n < nArray.length; ++n) {
                this.getSelectionModel().addSelectionInterval(nArray[n] - 1, nArray[n] - 1);
            }
            SelectColumnIndexPanel.this.refreshIndexExpressions();
        }

        public void moveSelectionDown() {
            int n;
            int[] nArray = this.getSelectedRows();
            for (n = nArray.length - 1; n >= 0; --n) {
                Column column = SelectColumnIndexPanel.this.selectedColumns.remove(nArray[n]);
                SelectColumnIndexPanel.this.selectedColumns.add(nArray[n] + 1, column);
            }
            this.model.fireTableDataChanged();
            for (n = 0; n < nArray.length; ++n) {
                this.getSelectionModel().addSelectionInterval(nArray[n] + 1, nArray[n] + 1);
            }
            SelectColumnIndexPanel.this.refreshIndexExpressions();
        }

        public void addSelectionListener(ListSelectionListener listSelectionListener) {
            this.getSelectionModel().addListSelectionListener(listSelectionListener);
        }

        public void removeSelectionListener(ListSelectionListener listSelectionListener) {
            this.getSelectionModel().removeListSelectionListener(listSelectionListener);
        }

        private class OrderCellEditor
        extends AbstractCellEditor
        implements TableCellEditor {
            private static final long serialVersionUID = 1L;
            private JComboBox<String> orderCombo = new JComboBox<String>(new String[]{"", "ASC", "DESC"});

            private OrderCellEditor() {
            }

            @Override
            public Object getCellEditorValue() {
                return this.orderCombo.getSelectedItem();
            }

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                this.orderCombo.setSelectedItem(object);
                return this.orderCombo;
            }
        }

        private class SelectColumnModel
        extends AbstractTableModel {
            private static final long serialVersionUID = 1L;
            private String[] TITLES = new String[]{Messages.getString("IndexEditorPanel.column"), Messages.getString("IndexEditorPanel.order")};

            private SelectColumnModel() {
            }

            @Override
            public int getRowCount() {
                return SelectColumnIndexPanel.this.selectedColumns.size();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                switch (n2) {
                    case 0: {
                        return SelectColumnIndexPanel.this.selectedColumns.get(n);
                    }
                    case 1: {
                        return SelectColumnIndexPanel.this.orderedBy.get(SelectColumnIndexPanel.this.selectedColumns.get(n));
                    }
                }
                return null;
            }

            @Override
            public String getColumnName(int n) {
                return this.TITLES[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 1;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                SelectColumnIndexPanel.this.orderedBy.put(SelectColumnIndexPanel.this.selectedColumns.get(n), (String)object);
                if (object.equals("ASC")) {
                    SelectColumnIndexPanel.this.indexObjects.get(SelectColumnIndexPanel.this.selectedColumns.get(n)).setOrderType(IndexObject.OrderType.ASC);
                } else if (object.equals("DESC")) {
                    SelectColumnIndexPanel.this.indexObjects.get(SelectColumnIndexPanel.this.selectedColumns.get(n)).setOrderType(IndexObject.OrderType.DESC);
                } else {
                    SelectColumnIndexPanel.this.indexObjects.get(SelectColumnIndexPanel.this.selectedColumns.get(n)).setOrderType(null);
                }
            }
        }
    }
}

