/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.lfo;

import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.JDialog;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardListener;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.AdvancedConfigTraversablePanel;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.ChooseModeTraversablePanel;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.Common;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadSelectedTraversablePanel;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadSummaryTraversablePanel;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.dbtools.raptor.ui.wizard.BigWizardDialog;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;

public class LFOWizardMain {
    static final String CHOOSE_MODE_STATE = "ChooseModeState";
    static final String LOAD_SELECTED_STATE = "LoadSelectedState";
    static final String ADVANCED_CONFIG_STATE = "AdvancedConfigState";
    static final String LOAD_SUMMARY_STATE = "LoadSummaryState";
    static final String CHOOSE_MODE_TRANSITION = "Choose";
    static final String LOAD_SELECTED_TRANSITION = "LoadSelected";
    static final String ADVANCED_CONFIG_TRANSITION = "AdvancedConfig";
    static final String LOAD_SUMMARY_TRANSITION = "LoadSummary";
    private static LFOWizardMain INSTANCE;
    private static WizardDialog _currentDialog;

    public static LFOWizardMain getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LFOWizardMain();
        }
        return INSTANCE;
    }

    public void launchWizard(DBObject dBObject) {
        Common.setTTVersion(dBObject);
        this.launchWizard(LFOWizardMain.getFSM(), dBObject);
    }

    private static FSM getFSM() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(Messages.getString("LoadTablesFromOracle.chooseMode"), ChooseModeTraversablePanel.class, TimesTenHelpID.LFO_CHOOSE_MODE.toString());
        fSMBuilder.newStartState(step, null);
        fSMBuilder.addStateTrans((Object)LOAD_SELECTED_TRANSITION, (Object)LOAD_SELECTED_STATE);
        fSMBuilder.addStateTrans((Object)ADVANCED_CONFIG_TRANSITION, (Object)ADVANCED_CONFIG_STATE);
        Step step2 = new Step(Messages.getString("LoadTablesFromOracle.advancedConfig"), AdvancedConfigTraversablePanel.class, TimesTenHelpID.LFO_ADVANCED_CONFIG.toString());
        fSMBuilder.newState((Object)ADVANCED_CONFIG_STATE, step2, (Object)LOAD_SELECTED_STATE);
        Step step3 = new Step(Messages.getString("LoadTablesFromOracle.loadSelectedTables"), LoadSelectedTraversablePanel.class, TimesTenHelpID.LFO_LOAD_SELECTED_TABLES.toString());
        fSMBuilder.newState((Object)LOAD_SELECTED_STATE, step3, (Object)LOAD_SUMMARY_STATE);
        Step step4 = new Step(Messages.getString("LoadTablesFromOracle.loadSummary"), LoadSummaryTraversablePanel.class, TimesTenHelpID.LFO_LOAD_SUMMARY.toString());
        fSMBuilder.newFinalState((Object)LOAD_SUMMARY_STATE, step4);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }

    private void launchWizard(FSM fSM, DBObject dBObject) {
        Namespace namespace = new Namespace();
        namespace.put("DBOBJECT", (Object)dBObject);
        FSMWizard fSMWizard = new FSMWizard(fSM, namespace);
        fSMWizard.addWizardListener(new WizardListener(){

            public void wizardSelectionChanged(WizardEvent wizardEvent) {
            }

            public void wizardFinished(WizardEvent wizardEvent) {
            }

            public void wizardCanceled(WizardEvent wizardEvent) {
                DefaultTraversablePanel defaultTraversablePanel = (DefaultTraversablePanel)wizardEvent.getPage().getContent();
                if (defaultTraversablePanel instanceof LoadSummaryTraversablePanel) {
                    LoadSummaryTraversablePanel loadSummaryTraversablePanel = (LoadSummaryTraversablePanel)defaultTraversablePanel;
                    loadSummaryTraversablePanel.saveProfileIfRequired();
                }
            }

            public void wizardApplyState(WizardEvent wizardEvent) {
            }
        });
        BigWizardDialog bigWizardDialog = new BigWizardDialog((BaseWizard)fSMWizard, (Frame)Ide.getMainWindow());
        _currentDialog = bigWizardDialog;
        fSMWizard.setDialog((WizardDialog)bigWizardDialog);
        bigWizardDialog.setPreferredSize(new Dimension(860, 580));
        fSMWizard.setWizardTitle(Messages.getString("LoadTablesFromOracle.loadTablesTitle"));
        fSMWizard.setRoadmapVisible(false);
        WizardDialog wizardDialog = fSMWizard.getDialog((Frame)Ide.getMainWindow());
        WizardLauncher.runDialog((JDialog)wizardDialog);
    }

    public synchronized WizardDialog getCurrentWizardDialog() {
        return _currentDialog;
    }
}

