/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.lfo;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.TimesTenPassthrough;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.Common;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadOptions;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadOptionsPanel;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadSelectedTraversablePanel;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadTableRow;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.MultipleOracleLoadable;
import oracle.dbtools.raptor.timesten.utils.TableColumnSizer;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.dialogs.progress.ProgressPanel;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.language.LanguageModule;

public class LoadOracleTableDataOnlyPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static Logger _logger = Logger.getLogger(LoadSelectedTraversablePanel.class.getPackage().getName());
    private DBObject _dbObject;
    private JEWTDialog _dialog;
    private JButton _loadButton;
    private BasicEditorPane _queryEditor;
    private JLabel _queryEditorLabel;
    private JLabel _threadCountLabel;
    private JLabel _ttUsernameLabel;
    private JLabel _tableNameLabel;
    private JLabel _oraUsernameLabel;
    private JLabel _loadOptionsLabel;
    private JTextField _threadCountJTF;
    private JTextField _ttUsernameJTF;
    private JTextField _tableNameJTF;
    private JTextField _oraUsernameJTF;
    private LoadOptionsPanel _loPanel;
    private LoadOptions loadOptions;

    public LoadOracleTableDataOnlyPanel(DBObject dBObject, MultipleOracleLoadable multipleOracleLoadable) {
        this._dbObject = dBObject;
        Common.setTTVersion(this._dbObject);
        this._loadButton = new JButton(StringUtils.stripMnemonic((String)Messages.getString("LoadTablesFromOracle.loadButton")));
        this._loadButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("LoadTablesFromOracle.loadButton")));
        this.setLayout(new GridBagLayout());
        this._ttUsernameLabel = new JLabel(Messages.getString("LoadTablesFromOracle.timestenUsername"));
        this._ttUsernameJTF = new JTextField(15);
        this._ttUsernameJTF.setEditable(false);
        this._tableNameLabel = new JLabel(Messages.getString("LoadTablesFromOracle.timesTenTableName"));
        this._tableNameJTF = new JTextField(15);
        this._tableNameJTF.setEditable(false);
        this._oraUsernameLabel = new JLabel(Messages.getString("LoadTablesFromORacle.schemaName"));
        this._oraUsernameJTF = new JTextField(15);
        this._oraUsernameJTF.setEditable(false);
        this._threadCountLabel = new JLabel(Messages.getString("LoadTablesFromOracle.parallelThreadcount"));
        this._threadCountJTF = new JTextField(15);
        this._threadCountJTF.setText(String.valueOf(4));
        this._queryEditorLabel = new JLabel(Messages.getString("LoadTablesFromOracle.selectQuery"));
        this._queryEditor = EditorFactory.createIdeEditorPane();
        BasicDocument basicDocument = (BasicDocument)this._queryEditor.getDocument();
        basicDocument.setLanguageSupport(LanguageModule.createSupportForFileType((String)".sql"));
        this._queryEditor.setPreferredSize(new Dimension(200, 200));
        this._queryEditorLabel.setVerticalAlignment(1);
        this._queryEditorLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        ResourceUtils.resLabel((JLabel)this._ttUsernameLabel, (Component)this._ttUsernameJTF, (String)Messages.getString("LoadTablesFromOracle.timestenUsername"));
        ResourceUtils.resLabel((JLabel)this._oraUsernameLabel, (Component)this._oraUsernameJTF, (String)Messages.getString("LoadTablesFromORacle.schemaName"));
        ResourceUtils.resLabel((JLabel)this._threadCountLabel, (Component)this._threadCountJTF, (String)Messages.getString("LoadTablesFromOracle.parallelThreadcount"));
        ResourceUtils.resLabel((JLabel)this._tableNameLabel, (Component)this._tableNameJTF, (String)Messages.getString("LoadTablesFromOracle.timesTenTableName"));
        ResourceUtils.resLabel((JLabel)this._queryEditorLabel, (Component)this._queryEditor, (String)Messages.getString("LoadTablesFromOracle.selectQuery"));
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)this._oraUsernameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this._oraUsernameJTF, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)this._ttUsernameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this._ttUsernameJTF, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)this._tableNameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this._tableNameJTF, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)this._queryEditorLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)new JScrollPane((Component)this._queryEditor), new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
        this._tableNameJTF.setText(this._dbObject.getObjectName());
        this._ttUsernameJTF.setText(this._dbObject.getSchemaName());
        try {
            this._oraUsernameJTF.setText(this._dbObject.getConnection().getMetaData().getUserName());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this._loadButton.addActionListener(this);
        if (Common.isAcadia().booleanValue()) {
            this.addOptionsPanel();
        } else {
            this.add((Component)this._threadCountLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
            this.add((Component)this._threadCountJTF, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        }
    }

    private void addOptionsPanel() {
        Insets insets = new Insets(2, 2, 2, 2);
        this.loadOptions = new LoadOptions();
        this._loPanel = new LoadOptionsPanel(this.loadOptions);
        this._loPanel.setDefaultValues();
        this._loPanel.setBorder(BorderFactory.createTitledBorder(""));
        this._loadOptionsLabel = new JLabel(Messages.getString("LoadTablesFromOracle.options"));
        this._loadOptionsLabel.setLabelFor(this._loPanel);
        this.add((Component)this._loadOptionsLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this._loPanel, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 18, 2, insets, 0, 0));
    }

    public void setDialog(JEWTDialog jEWTDialog) {
        this._dialog = jEWTDialog;
        this._dialog.addCustomButton((Component)this._loadButton);
    }

    public void setEnabledLoadButton(boolean bl) {
        if (this._dialog != null) {
            this._loadButton.setEnabled(bl);
        }
    }

    public JEWTDialog getDialog() {
        return this._dialog;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._loadButton && this.validateInput()) {
            try {
                this.loadData(this._ttUsernameJTF.getText(), this._tableNameJTF.getText(), this._queryEditor.getText(), this._threadCountJTF.getText(), this);
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "Error on loading table " + this._tableNameJTF.getText(), actionEvent);
            }
        }
    }

    private void loadData(final String string, final String string2, final String string3, final String string4, final LoadOracleTableDataOnlyPanel loadOracleTableDataOnlyPanel) throws Exception {
        final LoadProgressMonitor loadProgressMonitor = new LoadProgressMonitor(loadOracleTableDataOnlyPanel, Messages.getString("TimesTen.common.pleaseWait"));
        final TimesTenPassthrough timesTenPassthrough = new TimesTenPassthrough(this._dbObject);
        final String string5 = this.getSelectCountSQL(string3);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){
            String errorMessage = "";
            List<LoadTableRow.LFOError> errorList = new ArrayList<LoadTableRow.LFOError>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Void doInBackground() throws Exception {
                loadProgressMonitor.display();
                Statement statement = null;
                Connection connection = null;
                SwingWorker swingWorker = null;
                int n = -1;
                try {
                    connection = LoadOracleTableDataOnlyPanel.this._dbObject.getConnection();
                    if (Common.isNetworkTiomeoutSupported(connection).booleanValue()) {
                        n = connection.getNetworkTimeout();
                        connection.setNetworkTimeout(Executors.newFixedThreadPool(1), 0);
                    }
                    Connections.getInstance().lock(connection);
                    Long l = timesTenPassthrough.executeTableCountOnOracle(string5);
                    String string6 = "call ttLoadFromOracle('#tblOwner#', '#tblName#', '#Query#', #numThreads# #options#);".replace("#tblOwner#", Common.doubleSingleQuotedString(string, true)).replace("#tblName#", Common.doubleSingleQuotedString(string2, true)).replace("#Query#", Common.doubleSingleQuotedString(string3, false)).replace("#numThreads#", string4).replace("#options#", (CharSequence)(LoadOracleTableDataOnlyPanel.this.loadOptions == null ? "" : ",'" + LoadOracleTableDataOnlyPanel.this.loadOptions.toString() + "'"));
                    loadProgressMonitor.updateMessage(string2);
                    swingWorker = new QueryForUpdate(l, string5, loadProgressMonitor, string2);
                    swingWorker.execute();
                    statement = connection.createStatement();
                    ResultSet resultSet = statement.executeQuery(string6);
                    if (resultSet != null && resultSet.next() && Common.isAcadia().booleanValue()) {
                        LoadTableRow.LoadDataResult loadDataResult = new LoadTableRow.LoadDataResult(string3, 0, resultSet.getLong(1), resultSet.getLong(2), resultSet.getInt(3), resultSet.getString(4));
                        while (resultSet.next()) {
                            this.errorList.add(new LoadTableRow.LFOError(resultSet.getInt(3), resultSet.getString(4)));
                        }
                        loadDataResult.setErrors(this.errorList);
                        if (loadDataResult.getErrorCode() != 0) {
                            Common.saveErrorLog(string, string2, Common.getOracleTableFromQuery(string3), loadDataResult);
                            throw new LoadTableException(loadDataResult.getErrorString());
                        }
                    }
                    statement.execute("commit;");
                    loadProgressMonitor.updateMessage(MessageFormat.format(Messages.getString("LoadTablesFromOracle.updatingTableStats"), string2));
                    statement.execute("call ttOptUpdateStats('#owner#.#table#', 1, 0);".replace("#table#", Common.doubleSingleQuotedString(string2, true)).replace("#owner#", Common.doubleSingleQuotedString(string, true)));
                }
                catch (SQLException sQLException) {
                    _logger.log(Level.SEVERE, "Error while loading table from Oracle DB", sQLException);
                    this.errorMessage = connection != null ? (statement != null ? TTSQLExceptionScrubber.getInstance().getMessage(connection, statement.toString(), sQLException) : TTSQLExceptionScrubber.getMessage(sQLException.getMessage(), "")) : TTSQLExceptionScrubber.getMessage(sQLException.getMessage(), "");
                }
                catch (LoadTableException loadTableException) {
                    this.errorMessage = loadTableException.getMessage();
                }
                finally {
                    if (swingWorker != null) {
                        swingWorker.cancel(true);
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException) {
                            _logger.log(Level.SEVERE, "Couldn't  close statement", sQLException);
                            this.errorMessage = TTSQLExceptionScrubber.getInstance().getMessage(connection, statement.toString(), sQLException);
                        }
                    }
                    if (connection != null) {
                        if (Common.isNetworkTiomeoutSupported(connection).booleanValue()) {
                            connection.setNetworkTimeout(Executors.newFixedThreadPool(1), n);
                        }
                        Connections.getInstance().unlock(connection);
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                loadProgressMonitor.close();
                if (this.errorMessage.equals("")) {
                    loadOracleTableDataOnlyPanel.getDialog().dispose();
                    MessageDialog.information(null, (Object)MessageFormat.format(Messages.getString("LoadTablesFromOracle.successfulLoadMessage"), LoadOracleTableDataOnlyPanel.this._tableNameJTF.getText()), (String)Messages.getString("LoadTablesFromOracle.loadTableTitle"), null);
                } else {
                    JPanel jPanel = new JPanel(new GridBagLayout());
                    jPanel.setPreferredSize(new Dimension(450, 100));
                    JTable jTable = new JTable(new ErrorTableModel(this.errorMessage, this.errorList)){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public String getToolTipText(MouseEvent mouseEvent) {
                            String string = "";
                            Point point = mouseEvent.getPoint();
                            int n = this.rowAtPoint(point);
                            int n2 = this.columnAtPoint(point);
                            string = this.getValueAt(n, n2).toString();
                            return string;
                        }
                    };
                    jTable.setTableHeader(null);
                    TableColumnSizer.setColumnsWidthToFit(jTable, false, false);
                    jPanel.add((Component)new JScrollPane(jTable, 20, 30), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, new Insets(2, 2, 2, 2), 0, 0));
                    MessageDialog.error(null, (Object)jPanel, (String)Messages.getString("TimesTen.common.error"), null);
                }
            }
        };
        loadProgressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }

    private boolean validateInput() {
        if (this._queryEditor.getText() == null || this._queryEditor.getText().length() <= 0) {
            MessageDialog.error(null, (Object)Messages.getString("LoadTablesFromOracle.selectQueryError"), (String)Messages.getString("TimesTen.common.error"), null);
            return false;
        }
        if (Common.isAcadia().booleanValue()) {
            try {
                this._loPanel.validInput();
            }
            catch (NumberFormatException numberFormatException) {
                MessageDialog.error((Component)this, (Object)numberFormatException.getMessage(), (String)Messages.getString("TimesTen.common.error"), null);
                return false;
            }
        }
        try {
            Integer n = new Integer(this._threadCountJTF.getText().trim());
            if (n < 2) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.error((Component)this, (Object)(MessageFormat.format(Messages.getString("LoadTablesFromOracle.parallelThreadCountError"), this._threadCountJTF.getText().trim()) + " " + Messages.getString("LoadTablesFromOracle.parallelThreadHint")), (String)Messages.getString("TimesTen.common.error"), null);
            return false;
        }
        return true;
    }

    public String getSelectCountSQL(String string) {
        return "SELECT count(*) FROM (" + string + ")";
    }

    private static class LoadTableException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public LoadTableException(String string) {
            super(string);
        }

        @Override
        public String getMessage() {
            return super.getMessage();
        }
    }

    private class QueryForUpdate
    extends SwingWorker<Void, Void> {
        private Long rowCount;
        private Long currentRowsLoaded;
        private LoadProgressMonitor monitor;
        private String rowCountQuery = "";
        private String tableName;

        public QueryForUpdate(Long l, String string, LoadProgressMonitor loadProgressMonitor, String string2) {
            this.rowCount = l;
            this.monitor = loadProgressMonitor;
            this.rowCountQuery = string;
            this.tableName = string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Void doInBackground() throws Exception {
            Connection connection = null;
            Statement statement = null;
            try {
                connection = Connections.getInstance().getUniqueConnection(LoadOracleTableDataOnlyPanel.this._dbObject.getConnectionName());
                statement = connection.createStatement();
                Connections.getInstance().lock(connection);
                this.currentRowsLoaded = 0L;
                while (!this.isCancelled() && this.currentRowsLoaded < this.rowCount) {
                    ResultSet resultSet = statement.executeQuery(this.rowCountQuery);
                    while (resultSet.next()) {
                        this.currentRowsLoaded = resultSet.getLong(1);
                        int n = (int)((double)this.currentRowsLoaded.longValue() / ((double)this.rowCount.longValue() * 1.0)) * 100;
                        this.monitor.updateRowsLoaded(Long.toString(this.currentRowsLoaded), Integer.toString(n), this.tableName);
                    }
                    Thread.sleep(3000L);
                }
            }
            catch (InterruptedException interruptedException) {
                _logger.log(Level.INFO, "Not able to count rows: " + interruptedException.getMessage());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
                Connections.getInstance().unlock(connection);
            }
            return null;
        }
    }

    private class LoadProgressMonitor
    extends IndeterminateProgressMonitor
    implements ChangeListener {
        private ProgressPanel progressPanel;
        private String message;
        private SwingWorker<Void, Void> worker;

        public LoadProgressMonitor(Component component, String string) {
            super(component, string);
            this.progressPanel = this.getPanel();
            this.setCancellable(true);
            this.setCloseOnFinish(false);
            this.addCancellationListener(this);
        }

        public void setSwingWorker(SwingWorker<Void, Void> swingWorker) {
            this.worker = swingWorker;
        }

        public void updateMessage(final String string) {
            this.message = string;
            if (SwingUtilities.isEventDispatchThread()) {
                this.progressPanel.setMessage(this.message);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LoadProgressMonitor.this.progressPanel.setMessage(string);
                    }
                });
            }
        }

        public void updateRowsLoaded(final String string, final String string2, final String string3) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.progressPanel.setMessage(MessageFormat.format(Messages.getString("LoadTablesFromOracle.insertMessage"), string, string3, string2));
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LoadProgressMonitor.this.progressPanel.setMessage(MessageFormat.format(Messages.getString("LoadTablesFromOracle.insertMessage"), string, string3, string2));
                    }
                });
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.worker.cancel(true);
            this.close();
        }
    }

    private class ErrorTableModel
    extends AbstractTableModel {
        List<LoadTableRow.LFOError> errorList;

        public ErrorTableModel(String string, List<LoadTableRow.LFOError> list) {
            this.errorList = list;
            if (list.size() == 0) {
                this.errorList.add(new LoadTableRow.LFOError(0, string));
            }
        }

        @Override
        public int getRowCount() {
            return this.errorList.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return n + 1;
                }
                case 1: {
                    return this.errorList.get(n).getErrorMessage();
                }
            }
            return n;
        }
    }
}

