/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.lfo;

import java.awt.Component;
import java.awt.Dimension;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.TimesTenPassthrough;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.Common;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.IndexInfo;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.IndexUtil;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadOptions;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadSelectedTraversablePanel;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadTableRow;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadTablesTable;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoaderPanel;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.MultipleOracleLoadable;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.TableRefresher;
import oracle.dbtools.raptor.timesten.grid.TTGridTextPane;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.dialogs.progress.ProgressPanel;
import oracle.jdeveloper.db.ConnectionException;

public class OracleTableLoader
implements MultipleOracleLoadable {
    private static Logger _logger = Logger.getLogger(OracleTableLoader.class.getPackage().getName());
    private DBObject _dbObject;
    private static final String CONSTRAINT_REGX = ".*alter\\s+table\\s+.*\\s+add\\s+constraint.*";
    private static final Pattern constraintPattern = Pattern.compile(".*alter\\s+table\\s+.*\\s+add\\s+constraint.*", 2);
    private static final String DISTRIBUTE_REGX = ".*alter\\s+table\\s+.*\\s+distribute\\s+by.*";
    private static final Pattern distributePattern = Pattern.compile(".*alter\\s+table\\s+.*\\s+distribute\\s+by.*", 2);

    public OracleTableLoader(DBObject dBObject) {
        this._dbObject = dBObject;
    }

    @Override
    public void loadData(LoadTablesTable loadTablesTable, LoaderPanel loaderPanel) {
        LoadProgressMonitor loadProgressMonitor = new LoadProgressMonitor(loaderPanel.getLoadComponent(), Messages.getString("LoadTablesFromOracle.loadTablesTitle"), Messages.getString("TimesTen.common.pleaseWait"));
        TimesTenPassthrough timesTenPassthrough = new TimesTenPassthrough(this._dbObject);
        MainLoaderThread mainLoaderThread = new MainLoaderThread(loadProgressMonitor, loadTablesTable, timesTenPassthrough, loaderPanel);
        loadProgressMonitor.setThread(mainLoaderThread);
        mainLoaderThread.start();
    }

    private void createTTIndexes(Connection connection, TimesTenPassthrough timesTenPassthrough, LoadTableRow loadTableRow, LoadOptions.IndexCreationPolicy indexCreationPolicy, LoadProgressMonitor loadProgressMonitor) {
        Object object;
        Iterator<IndexInfo> iterator;
        Object object2;
        Object object3;
        boolean bl = false;
        String string = loadTableRow.getOracleTable();
        if (indexCreationPolicy == LoadOptions.IndexCreationPolicy.COPY_UNIQUE_IDXS) {
            bl = true;
        }
        try {
            object3 = MessageFormat.format(Messages.getString("LoadTablesFromOracle.indexCreationIdxImportMsg"), string);
            loadProgressMonitor.updateMessage((String)object3, true, MessageType.MESSAGE);
            object2 = IndexUtil.getIndexesFromOracle(timesTenPassthrough, connection.getMetaData().getUserName(), string);
            if (loadTableRow.hasSkippedColumns()) {
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = (IndexInfo)iterator.next();
                    if (!((IndexInfo)object).getType().contains("FUNCTION-BASED")) continue;
                    boolean bl2 = false;
                    for (IndexInfo.ColumnInfo columnInfo : ((IndexInfo)object).getColumns()) {
                        Pattern pattern = Pattern.compile("SYS_EXTRACT_UTC\\((\".*\")\\)");
                        Matcher matcher = pattern.matcher(columnInfo.getExpression());
                        boolean bl3 = matcher.matches();
                        if (bl3) {
                            columnInfo.setExpression("");
                            columnInfo.name = matcher.group(1);
                            continue;
                        }
                        if (columnInfo.expression.equals("")) continue;
                        bl2 = true;
                    }
                    if (bl2) continue;
                    ((IndexInfo)object).setType("NORMAL");
                }
                object2.removeIf(indexInfo -> indexInfo.getColumns().stream().anyMatch(columnInfo -> loadTableRow.isColumnSkipped(columnInfo.getName())));
            }
            if (bl) {
                iterator = new ArrayList();
                object = object2.iterator();
                while (object.hasNext()) {
                    IndexInfo indexInfo2 = (IndexInfo)object.next();
                    IndexInfo.ConstraintType constraintType = indexInfo2.getConstraintType();
                    if (!indexInfo2.isUnique() && constraintType != IndexInfo.ConstraintType.PRIMARY && constraintType != IndexInfo.ConstraintType.UNIQUE) continue;
                    iterator.add(indexInfo2);
                }
                loadTableRow.setIndexes((List<IndexInfo>)((Object)iterator));
            } else {
                loadTableRow.setIndexes((List<IndexInfo>)object2);
            }
        }
        catch (SQLException sQLException) {
            StringBuilder stringBuilder = new StringBuilder(MessageFormat.format(Messages.getString("LoadTablesFromOracle.indexCreationIdxImportError"), string));
            stringBuilder.append("");
            stringBuilder.append(sQLException.getMessage());
            loadTableRow.setIdxImportError(stringBuilder.toString());
            loadProgressMonitor.updateDetails(stringBuilder.toString(), MessageType.ERROR);
            return;
        }
        object3 = loadTableRow.getIndexes();
        if (object3.isEmpty()) {
            object2 = bl ? MessageFormat.format(Messages.getString("LoadTablesFromOracle.indexCreationNoUniqueIndexes"), string) : MessageFormat.format(Messages.getString("LoadTablesFromOracle.indexCreationNoIndexes"), string);
            loadTableRow.setIdxImportError((String)object2);
            loadProgressMonitor.updateDetails((String)object2, MessageType.ERROR);
            return;
        }
        int n = 0;
        iterator = object3.iterator();
        while (iterator.hasNext()) {
            object = (IndexInfo)iterator.next();
            StringBuilder stringBuilder = new StringBuilder(MessageFormat.format(Messages.getString("LoadTablesFromOracle.indexCreationCreatedIndexCount"), n, object3.size()));
            stringBuilder.append(" ");
            stringBuilder.append(MessageFormat.format(Messages.getString("LoadTablesFromOracle.indexCreationCreatingIdxMsg"), ((IndexInfo)object).getTTName()));
            loadProgressMonitor.updateMessage(stringBuilder.toString(), true, MessageType.MESSAGE);
            IndexUtil.createTTIndex(connection, (IndexInfo)object, loadTableRow.getTimesTenTable(), loadTableRow.getTimesTenUser());
            if (((IndexInfo)object).getIndexStatus() == IndexInfo.IndexStatus.CREATED) {
                ++n;
            }
            stringBuilder = new StringBuilder(MessageFormat.format(Messages.getString("LoadTablesFromOracle.indexCreationCreatedIndexCount"), n, object3.size()));
            stringBuilder.append(" ");
            stringBuilder.append(((IndexInfo)object).getStatusMsg());
            loadProgressMonitor.updateMessage(stringBuilder.toString(), true, MessageType.MESSAGE);
        }
    }

    private boolean canCreateIndexes(LoadOptions.IndexCreationPolicy indexCreationPolicy, String string) {
        return indexCreationPolicy != LoadOptions.IndexCreationPolicy.NO_COPY_IDXS && Common.validQuery(string);
    }

    static enum MessageType {
        ERROR,
        MESSAGE,
        FINISH;

    }

    private class LoadFromOracleThread
    extends Thread {
        private String sql;
        private String loadSql;
        private Statement statement;
        private LoadTableRow table;
        private Connection conn;
        private SQLException exception;
        private int parallelLoadIndex;

        public LoadFromOracleThread(LoadTableRow loadTableRow, String string, int n, LoadOptions loadOptions) {
            this.table = loadTableRow;
            this.sql = string;
            this.parallelLoadIndex = n;
            String string2 = this.getLoadOptionsStr(loadTableRow, loadOptions);
            this.loadSql = "call ttLoadFromOracle('#tblOwner#', '#tblName#', '#Query#', #numThreads# #options#);".replace("#tblOwner#", Common.doubleSingleQuotedString(loadTableRow.getTimesTenUser(), true)).replace("#tblName#", Common.doubleSingleQuotedString(loadTableRow.getTimesTenTable(), true)).replace("#Query#", Common.doubleSingleQuotedString(string, false)).replace("#numThreads#", String.valueOf(loadOptions.getNumberOfThreads())).replace("#options#", (CharSequence)(Common.isAcadia() != false ? ", '" + string2 + "'" : string2));
        }

        private String getLoadOptionsStr(LoadTableRow loadTableRow, LoadOptions loadOptions) {
            if (Common.isAcadia().booleanValue()) {
                if (loadTableRow.getOracleSCN() != null) {
                    Long l = loadOptions.getResumeFromSCN();
                    loadOptions.setResumeFromSCN(loadTableRow.getOracleSCN());
                    String string = loadOptions.toString();
                    loadOptions.setResumeFromSCN(l);
                    return string;
                }
                return loadOptions.toString();
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int n = -1;
            try {
                this.conn = Connections.getInstance().getUniqueConnection(OracleTableLoader.this._dbObject.getConnectionName());
                if (Common.isNetworkTiomeoutSupported(this.conn).booleanValue()) {
                    n = this.conn.getNetworkTimeout();
                    this.conn.setNetworkTimeout(Executors.newFixedThreadPool(1), 0);
                }
                this.conn.setAutoCommit(false);
                Connections.getInstance().lock(this.conn);
                this.statement = this.conn.createStatement();
                if (this.isInterrupted()) {
                    return;
                }
                ResultSet resultSet = this.statement.executeQuery(this.loadSql);
                if (resultSet != null) {
                    if (Common.isAcadia().booleanValue()) {
                        if (resultSet.next()) {
                            LoadTableRow.LoadDataResult loadDataResult = new LoadTableRow.LoadDataResult(this.sql, this.parallelLoadIndex, resultSet.getLong(1), resultSet.getLong(2), resultSet.getInt(3), resultSet.getString(4));
                            this.table.setLoadDataResult(loadDataResult);
                            this.table.setStatus(this.table.getStatusFromLoadResult());
                            ArrayList<LoadTableRow.LFOError> arrayList = new ArrayList<LoadTableRow.LFOError>();
                            while (resultSet.next()) {
                                arrayList.add(new LoadTableRow.LFOError(resultSet.getInt(3), resultSet.getString(4)));
                            }
                            loadDataResult.setErrors(arrayList);
                        }
                    } else if (resultSet.next()) {
                        this.table.setStatus(Common.LoadStatus.LOADED);
                    }
                } else {
                    _logger.log(Level.SEVERE, "Null result set in query: " + this.loadSql);
                }
            }
            catch (SQLException sQLException) {
                if (Common.isAcadia().booleanValue()) {
                    LoadTableRow.LoadDataResult loadDataResult = new LoadTableRow.LoadDataResult(this.sql, this.parallelLoadIndex, sQLException.getMessage());
                    ArrayList<LoadTableRow.LFOError> arrayList = new ArrayList<LoadTableRow.LFOError>();
                    arrayList.add(new LoadTableRow.LFOError(sQLException.getErrorCode(), sQLException.getMessage()));
                    loadDataResult.setErrors(arrayList);
                    this.table.setLoadDataResult(loadDataResult);
                }
                this.exception = sQLException;
            }
            catch (ConnectionException connectionException) {
                _logger.log(Level.SEVERE, "Can't get new connection", connectionException);
            }
            finally {
                if (this.statement != null) {
                    try {
                        this.statement.close();
                    }
                    catch (SQLException sQLException) {
                        _logger.log(Level.WARNING, "Error while closing statement: ", sQLException);
                    }
                }
                if (this.conn != null) {
                    try {
                        if (Common.isNetworkTiomeoutSupported(this.conn).booleanValue()) {
                            this.conn.setNetworkTimeout(Executors.newFixedThreadPool(1), n);
                        }
                        Connections.getInstance().unlock(this.conn);
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {
                        _logger.log(Level.SEVERE, "Can't close connection", sQLException);
                    }
                }
            }
        }

        public SQLException getException() {
            return this.exception;
        }

        public void cancelThreadExecution() {
            try {
                this.statement.cancel();
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, "Can't cancel statement", sQLException);
            }
            if (this.isAlive()) {
                this.interrupt();
            }
        }
    }

    private class MainLoaderThread
    extends Thread {
        private LoadProgressMonitor waitDialog;
        private TimesTenPassthrough passthrough;
        private List<LoadTableRow> data;
        private LoaderPanel panel;
        private LoadFromOracleThread[] threads;
        private boolean cancelled;
        private LoadTablesTable table;

        public MainLoaderThread(LoadProgressMonitor loadProgressMonitor, LoadTablesTable loadTablesTable, TimesTenPassthrough timesTenPassthrough, LoaderPanel loaderPanel) {
            this.waitDialog = loadProgressMonitor;
            this.data = loadTablesTable.getData();
            this.passthrough = timesTenPassthrough;
            this.panel = loaderPanel;
            this.table = loadTablesTable;
        }

        public LoadFromOracleThread[] getThreads() {
            return this.threads;
        }

        private void rearrangeTables() {
            Collections.sort(this.data);
            TableRefresher tableRefresher = (TableRefresher)((Object)this.panel);
            tableRefresher.refreshTheCompleteTable();
        }

        void setCancelledStatus() {
            for (LoadTableRow loadTableRow : this.data) {
                if (loadTableRow.getStatus() != Common.LoadStatus.WAITING && loadTableRow.getStatus() != Common.LoadStatus.IN_PROGRESS) continue;
                loadTableRow.setStatus(Common.LoadStatus.CANCELLED);
            }
        }

        void setCancelled() {
            this.cancelled = true;
        }

        void loadConstraints() {
            for (LoadTableRow loadTableRow : this.data) {
                if (loadTableRow.getConstraints() != null) continue;
                this.obtainConstraints(loadTableRow);
            }
            LoadSelectedTraversablePanel loadSelectedTraversablePanel = new LoadSelectedTraversablePanel();
            loadSelectedTraversablePanel.loadReferences(this.table);
        }

        public void obtainConstraints(LoadTableRow loadTableRow) {
            StringBuilder stringBuilder = new StringBuilder();
            String[] stringArray = null;
            String string = null;
            Object var5_5 = null;
            LoadSelectedTraversablePanel loadSelectedTraversablePanel = new LoadSelectedTraversablePanel();
            loadSelectedTraversablePanel.setPassthrough(this.passthrough);
            try {
                loadSelectedTraversablePanel.obtainTableConstraints(loadTableRow);
                stringArray = loadTableRow.getCreateGridTableStatement().split(";");
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].length() <= 0 || constraintPattern.matcher(string = stringArray[i].replaceAll("(\\n|\\r)", " ")).matches() || distributePattern.matcher(string).matches()) continue;
                    stringBuilder.append(stringArray[i]);
                    stringBuilder.append(";");
                }
                loadTableRow.setCreateTableStatement(stringBuilder.toString());
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, "Couldn't get table constraints", sQLException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Could not resolve type clashes
         * Loose catch block
         */
        @Override
        public void run() {
            Connection connection;
            Statement statement;
            block64: {
                this.waitDialog.start();
                statement = null;
                connection = null;
                SwingWorker swingWorker = null;
                LoadOptions.IndexCreationPolicy indexCreationPolicy = this.panel.getLoadOptions().getIndexCreationtPolicy();
                try {
                    connection = OracleTableLoader.this._dbObject.getConnection();
                    connection.setAutoCommit(false);
                    statement = connection.createStatement();
                    Connections.getInstance().lock(connection);
                    if (Common.isGrid().booleanValue()) {
                        this.waitDialog.updateMessage(Messages.getString("LoadTablesFromOracle.loadingConstraints"), true, MessageType.MESSAGE);
                        this.loadConstraints();
                        this.rearrangeTables();
                    }
                    for (LoadTableRow loadTableRow : this.data) {
                        Object object3;
                        int n;
                        int n2;
                        block63: {
                            if (this.isInterrupted() || this.cancelled) {
                                throw new InterruptedException();
                            }
                            loadTableRow.setStatus(Common.LoadStatus.IN_PROGRESS);
                            if (loadTableRow.getRowCount() == null) {
                                Long l = this.passthrough.executeTableCountOnOracle(loadTableRow.getSelectCountSQL());
                                this.waitDialog.setCurrentRowCount(l);
                                loadTableRow.setRowCount(l);
                            }
                            if (this.isInterrupted() || this.cancelled) {
                                throw new InterruptedException();
                            }
                            n2 = loadTableRow.getParallelLoads();
                            if (n2 > 16) {
                                n2 = 16;
                            }
                            this.waitDialog.updateMessage(MessageFormat.format(Messages.getString("LoadTablesFromOracle.creatingTable"), loadTableRow.getTimesTenTable()), true, MessageType.MESSAGE);
                            try {
                                loadTableRow.setAlreadyExist(OracleTableLoader.this._dbObject);
                                if (loadTableRow.alreadyExist()) {
                                    this.waitDialog.updateDetails(MessageFormat.format(Messages.getString("LoadTablesFromOracle.tableAlreadyExists"), loadTableRow.getTimesTenTable()), MessageType.MESSAGE);
                                    ResultSet resultSet = statement.executeQuery(loadTableRow.getTimestenTableCountSQL());
                                    if (resultSet.next()) {
                                        loadTableRow.setInitialTTRowCount(resultSet.getLong(1));
                                        loadTableRow.setTimestenRowCount(resultSet.getLong(1));
                                    }
                                    if (loadTableRow.getCreateTableOnly()) {
                                        loadTableRow.setStatus(Common.LoadStatus.SQL_EXCEPTION);
                                        loadTableRow.setError(MessageFormat.format(Messages.getString("LoadTablesFromOracle.tableAlreadyExists"), loadTableRow.getTimesTenTable()));
                                        this.waitDialog.updateDetails(MessageFormat.format(Messages.getString("LoadTablesFromOracle.tableAlreadyExists"), loadTableRow.getTimesTenTable()), MessageType.ERROR);
                                        continue;
                                    }
                                } else {
                                    if (Common.isGrid().booleanValue()) {
                                        String[] stringArray = loadTableRow.getCreateGridTableStatement().split(";");
                                        for (n = 0; n < stringArray.length; ++n) {
                                            if (stringArray[n].length() <= 0) continue;
                                            statement.execute(stringArray[n]);
                                        }
                                    } else {
                                        statement.execute(loadTableRow.getCreateTableStatement());
                                    }
                                    loadTableRow.setTimestenRowCount(0L);
                                }
                            }
                            catch (SQLException sQLException) {
                                if (2207 == sQLException.getErrorCode()) break block63;
                                loadTableRow.setStatus(Common.LoadStatus.SQL_EXCEPTION);
                                loadTableRow.setError(TTSQLExceptionScrubber.getInstance().getMessage(OracleTableLoader.this._dbObject.getConnectionName(), sQLException));
                                this.waitDialog.updateDetails(TTSQLExceptionScrubber.getInstance().getMessage(OracleTableLoader.this._dbObject.getConnectionName(), sQLException), MessageType.ERROR);
                                continue;
                            }
                        }
                        loadTableRow.setStatus(Common.LoadStatus.CREATED);
                        if (this.isInterrupted() || this.cancelled) {
                            throw new InterruptedException();
                        }
                        if (loadTableRow.getCreateTableOnly()) {
                            if (!OracleTableLoader.this.canCreateIndexes(indexCreationPolicy, loadTableRow.getSelectQuery())) continue;
                            loadTableRow.setOracleTable(Common.getOracleTableFromQuery(loadTableRow.getSelectQuery()));
                            OracleTableLoader.this.createTTIndexes(connection, this.panel.getPassthrough(), loadTableRow, indexCreationPolicy, this.waitDialog);
                            continue;
                        }
                        swingWorker = new QueryForUpdate(loadTableRow, this.waitDialog);
                        swingWorker.execute();
                        this.waitDialog.updateMessage(MessageFormat.format(Messages.getString("LoadTablesFromOracle.loadingTable"), loadTableRow.getTimesTenTable()), true, MessageType.MESSAGE);
                        this.threads = new LoadFromOracleThread[n2];
                        for (int i = 0; i < n2; ++i) {
                            LoadFromOracleThread loadFromOracleThread;
                            if (Common.isParallelLoadEnabled(loadTableRow.getParallelLoads())) {
                                Object object2 = loadTableRow.getSelectQuery();
                                if (((String)object2).toUpperCase().indexOf("WHERE") != -1) {
                                    Object object3 = " WHERE ORA_HASH(ROWID,#SEED#)=#SEEDCOUNT# AND";
                                    object3 = ((String)object3).replaceAll("#SEED#", Integer.toString(n2 - 1));
                                    object3 = ((String)object3).replaceAll("#SEEDCOUNT#", Integer.toString(i));
                                    object2 = ((String)object2).replaceAll("where", "WHERE");
                                    object2 = ((String)object2).replaceFirst("WHERE", (String)object3);
                                } else {
                                    Object object3 = " WHERE ORA_HASH(ROWID,#SEED#)=#SEEDCOUNT#";
                                    object3 = ((String)object3).replaceAll("#SEED#", Integer.toString(n2 - 1));
                                    object3 = ((String)object3).replaceAll("#SEEDCOUNT#", Integer.toString(i));
                                    object2 = (String)object2 + (String)object3;
                                }
                                loadFromOracleThread = new LoadFromOracleThread(loadTableRow, (String)object2, i + 1, this.panel.getLoadOptions());
                            } else {
                                loadFromOracleThread = new LoadFromOracleThread(loadTableRow, loadTableRow.getSelectQuery(), i + 1, this.panel.getLoadOptions());
                            }
                            this.threads[i] = loadFromOracleThread;
                            loadFromOracleThread.start();
                            if (!this.isInterrupted() && !this.cancelled) continue;
                            throw new InterruptedException();
                        }
                        for (Object object3 : this.threads) {
                            try {
                                ((Thread)object3).join();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        LoadFromOracleThread[] loadFromOracleThreadArray = this.threads;
                        n = loadFromOracleThreadArray.length;
                        for (int i = 0; i < n; ++i) {
                            object3 = loadFromOracleThreadArray[i];
                            if (((LoadFromOracleThread)object3).getException() == null) continue;
                            SQLException sQLException = ((LoadFromOracleThread)object3).getException();
                            loadTableRow.setStatus(Common.LoadStatus.SQL_EXCEPTION);
                            loadTableRow.setError(TTSQLExceptionScrubber.getInstance().getMessage(OracleTableLoader.this._dbObject.getConnectionName(), sQLException));
                            connection.rollback();
                            if (sQLException.getErrorCode() != 802) continue;
                            throw sQLException;
                        }
                        swingWorker.cancel(true);
                        if (Common.isAcadia().booleanValue()) {
                            boolean bl = false;
                            if (this.panel.getLoadOptions().createIndexesIfNoErrors()) {
                                bl = loadTableRow.getStatus() == Common.LoadStatus.LOADED;
                            } else {
                                boolean bl2 = bl = loadTableRow.getStatus() == Common.LoadStatus.LOADED || loadTableRow.getStatus() == Common.LoadStatus.LOADED_ERROR;
                            }
                            if (bl && OracleTableLoader.this.canCreateIndexes(indexCreationPolicy, loadTableRow.getSelectQuery())) {
                                loadTableRow.setOracleTable(Common.getOracleTableFromQuery(loadTableRow.getSelectQuery()));
                                OracleTableLoader.this.createTTIndexes(connection, this.panel.getPassthrough(), loadTableRow, indexCreationPolicy, this.waitDialog);
                            }
                        } else if (loadTableRow.getStatus() != Common.LoadStatus.SQL_EXCEPTION && OracleTableLoader.this.canCreateIndexes(indexCreationPolicy, loadTableRow.getSelectQuery())) {
                            loadTableRow.setOracleTable(Common.getOracleTableFromQuery(loadTableRow.getSelectQuery()));
                            OracleTableLoader.this.createTTIndexes(connection, this.panel.getPassthrough(), loadTableRow, indexCreationPolicy, this.waitDialog);
                        }
                        if (loadTableRow.getStatus() == Common.LoadStatus.LOADED || loadTableRow.getStatus() == Common.LoadStatus.LOADED_ERROR) {
                            statement.execute("commit;");
                        }
                        if (this.isInterrupted() || this.cancelled) {
                            throw new InterruptedException();
                        }
                        this.waitDialog.updateMessage(MessageFormat.format(Messages.getString("LoadTablesFromOracle.updatingTableStats"), loadTableRow.getTimesTenTable()), true, MessageType.MESSAGE);
                        statement.execute("call ttOptUpdateStats('#owner#.#table#', 1, 0);".replace("#table#", Common.doubleSingleQuotedString(loadTableRow.getTimesTenTable(), true)).replace("#owner#", Common.doubleSingleQuotedString(loadTableRow.getTimesTenUser(), true)));
                    }
                    if (Common.isGrid().booleanValue()) {
                        TableRefresher tableRefresher = (TableRefresher)((Object)this.panel);
                        tableRefresher.refreshTheCompleteTable();
                    }
                    this.waitDialog.updateDetails(null, MessageType.FINISH);
                    if (!this.cancelled) break block64;
                    this.setCancelledStatus();
                }
                catch (SQLException sQLException) {
                    block65: {
                        LoadFromOracleThread[] loadFromOracleThreadArray;
                        _logger.log(Level.SEVERE, "Error while loading table from Oracle DB", sQLException);
                        if (swingWorker != null && !swingWorker.isCancelled()) {
                            swingWorker.cancel(true);
                        }
                        if ((loadFromOracleThreadArray = this.getThreads()) != null) {
                            for (LoadFromOracleThread loadFromOracleThread : loadFromOracleThreadArray) {
                                loadFromOracleThread.cancelThreadExecution();
                            }
                        }
                        this.setCancelledStatus();
                        MessageDialog.error(null, (Object)TTSQLExceptionScrubber.getInstance().getMessage(connection, statement.toString(), sQLException), (String)Messages.getString("TimesTen.common.error"), null);
                        if (!this.cancelled) break block65;
                        this.setCancelledStatus();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MainLoaderThread.this.waitDialog.close();
                        }
                    });
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException2) {
                            _logger.log(Level.SEVERE, "Couldn't  close statement", sQLException2);
                        }
                    }
                    if (connection != null) {
                        Connections.getInstance().unlock(connection);
                    }
                    this.panel.updateOnFinish();
                }
                catch (InterruptedException interruptedException) {
                    block66: {
                        LoadFromOracleThread[] loadFromOracleThreadArray = this.getThreads();
                        if (loadFromOracleThreadArray != null) {
                            for (LoadFromOracleThread loadFromOracleThread : loadFromOracleThreadArray) {
                                loadFromOracleThread.cancelThreadExecution();
                            }
                        }
                        if (!this.cancelled) break block66;
                        this.setCancelledStatus();
                        {
                            catch (Throwable throwable) {
                                if (this.cancelled) {
                                    this.setCancelledStatus();
                                }
                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                if (statement != null) {
                                    try {
                                        statement.close();
                                    }
                                    catch (SQLException sQLException) {
                                        _logger.log(Level.SEVERE, "Couldn't  close statement", sQLException);
                                    }
                                }
                                if (connection != null) {
                                    Connections.getInstance().unlock(connection);
                                }
                                this.panel.updateOnFinish();
                                throw throwable;
                            }
                        }
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException3) {
                            _logger.log(Level.SEVERE, "Couldn't  close statement", sQLException3);
                        }
                    }
                    if (connection != null) {
                        Connections.getInstance().unlock(connection);
                    }
                    this.panel.updateOnFinish();
                }
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    _logger.log(Level.SEVERE, "Couldn't  close statement", sQLException);
                }
            }
            if (connection != null) {
                Connections.getInstance().unlock(connection);
            }
            this.panel.updateOnFinish();
        }
    }

    private class QueryForUpdate
    extends SwingWorker<Void, Void> {
        private LoadTableRow row;
        private long currentRowsLoaded;
        private LoadProgressMonitor monitor;

        public QueryForUpdate(LoadTableRow loadTableRow, LoadProgressMonitor loadProgressMonitor) {
            this.row = loadTableRow;
            this.monitor = loadProgressMonitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Void doInBackground() throws Exception {
            Connection connection = null;
            Statement statement = null;
            try {
                connection = Connections.getInstance().getUniqueConnection(OracleTableLoader.this._dbObject.getConnectionName());
                statement = connection.createStatement();
                Connections.getInstance().lock(connection);
                while (!this.isCancelled() && this.currentRowsLoaded < this.row.getRowCount()) {
                    ResultSet resultSet = statement.executeQuery(this.row.getTimestenTableCountSQL());
                    while (resultSet.next()) {
                        long l = resultSet.getLong(1);
                        this.monitor.updateRowsLoaded(l, this.row.getTimesTenTable());
                        this.currentRowsLoaded = l;
                    }
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (this.isCancelled()) {
                        break;
                    }
                    Thread.sleep(3000L);
                }
            }
            catch (InterruptedException interruptedException) {
                _logger.info("Interrupted while executing query to update row count: " + interruptedException.getMessage());
            }
            catch (Exception exception) {
                _logger.severe("Error when executing query for updating row count: " + exception.getMessage());
            }
            finally {
                if (statement != null) {
                    ResultSet resultSet = statement.executeQuery(this.row.getTimestenTableCountSQL());
                    if (resultSet.next()) {
                        long l = resultSet.getLong(1);
                        this.row.setTimestenRowCount(l);
                    }
                    resultSet.close();
                    statement.close();
                }
                Connections.getInstance().unlock(connection);
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {
                        _logger.log(Level.SEVERE, "Can't close connection", sQLException);
                    }
                }
            }
            return null;
        }
    }

    private class LoadProgressMonitor
    extends IndeterminateProgressMonitor
    implements ChangeListener {
        private MainLoaderThread thread;
        private Long currentTotalRowCount;
        private TTGridTextPane _textPane;
        private JScrollPane _scrollPane;
        private ProgressPanel _progressPanel;
        private static final int HEIGHT = 300;
        private static final int WIDTH = 500;

        public LoadProgressMonitor(Component component, String string, String string2) {
            super(component, string, (Object)string2, null);
            this._progressPanel = this.getPanel();
            this.setCancellable(true);
            this.setCloseOnFinish(false);
            this.addCancellationListener(this);
            this.setMillisToPopup(0);
            this.setModal(true);
            this.setBarVisible(true);
            this.setDetailsTextAreaActivated(true);
            this.setEditableTextArea(false);
            this.setTextAreaPreferredSize(500, 300);
        }

        public void setThread(MainLoaderThread mainLoaderThread) {
            this.thread = mainLoaderThread;
        }

        public void setEditableTextArea(boolean bl) {
            this._textPane.setEditable(bl);
        }

        protected void setTextAreaPreferredSize(int n, int n2) {
            this._scrollPane.setPreferredSize(new Dimension(n, n2));
        }

        public void setDetailsTextAreaActivated(boolean bl) {
            if (bl) {
                if (this.getDetailContent() == null) {
                    this._textPane = new TTGridTextPane();
                    this._scrollPane = new JScrollPane(this._textPane);
                    this._scrollPane.setPreferredSize(new Dimension(300, 100));
                    if (SwingUtilities.isEventDispatchThread()) {
                        this.setDetailContent(this._scrollPane);
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                LoadProgressMonitor.this.setDetailContent(LoadProgressMonitor.this._scrollPane);
                            }
                        });
                    }
                }
            } else {
                this.setDetailContent(null);
                this._textPane = null;
                this._scrollPane = null;
            }
        }

        public void updateRowsLoaded(final Long l, final String string) {
            if (SwingUtilities.isEventDispatchThread()) {
                long l2 = 0L;
                if (this.currentTotalRowCount > 0L) {
                    l2 = l * 100L / this.currentTotalRowCount;
                }
                this.updateMessage(MessageFormat.format(Messages.getString("LoadTablesFromOracle.insertMessage"), l, string, l2), false, MessageType.MESSAGE);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        long l2 = 0L;
                        if (LoadProgressMonitor.this.currentTotalRowCount > 0L) {
                            l2 = l * 100L / LoadProgressMonitor.this.currentTotalRowCount;
                        }
                        LoadProgressMonitor.this.updateMessage(MessageFormat.format(Messages.getString("LoadTablesFromOracle.insertMessage"), l, string, l2), false, MessageType.MESSAGE);
                    }
                });
            }
        }

        public void setCurrentRowCount(Long l) {
            this.currentTotalRowCount = l;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.thread.interrupt();
            this.thread.setCancelled();
            this.setCancellable(false);
        }

        public void updateMessage(final String string, final boolean bl, final MessageType messageType) {
            if (SwingUtilities.isEventDispatchThread()) {
                if (bl) {
                    this.updateDetails(string, messageType);
                }
                this._progressPanel.setMessage(string);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (bl) {
                            LoadProgressMonitor.this.updateDetails(string, messageType);
                        }
                        LoadProgressMonitor.this._progressPanel.setMessage(string);
                    }
                });
            }
        }

        public void updateDetails(String string, MessageType messageType) {
            if (messageType == MessageType.MESSAGE || messageType == MessageType.ERROR) {
                Object object = messageType == MessageType.ERROR ? "Error: " + string : string;
                this._textPane.updateText((String)object);
            } else {
                this.updateMessage(Messages.getString("IndexAdvisor.completed"), false, MessageType.MESSAGE);
                this.finish();
            }
        }
    }
}

