/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.lfo.tablemodels;

import java.util.List;
import javax.swing.JButton;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.Common;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadTableRow;

public class LoadTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private List<LoadTableRow> data;
    private boolean editable;
    private boolean isTTGrid;
    static final String[] HEADER = new String[]{Messages.getString("LoadTablesFromOracle.timesTenUsernameHeader"), Messages.getString("LoadTablesFromOracle.timesTenTableNameHeader"), Messages.getString("LoadTablesFromOracle.timesTenSelectQueryHeader"), Messages.getString("LoadTablesFromOracle.rowCountHeader"), Messages.getString("LoadTablesFromOracle.onlyCreateTable"), Messages.getString("LoadTablesFromOracle.createStatementHeader"), Messages.getString("LoadTablesFromOracle.distSchemeHeader"), Messages.getString("LoadTablesFromOracle.statusHeader")};

    public LoadTableModel(List<LoadTableRow> list, boolean bl, boolean bl2) {
        this.data = list;
        this.editable = bl;
        this.isTTGrid = bl2;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        int n = HEADER.length;
        if (!this.isTTGrid) {
            --n;
        }
        if (this.editable) {
            --n;
        }
        return n;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == Common.ColIdx.USERNAME.getValue()) {
            return this.data.get(n).getTimesTenUser();
        }
        if (n2 == Common.ColIdx.TABLENAME.getValue()) {
            return this.data.get(n).getTimesTenTable();
        }
        if (n2 == Common.ColIdx.QUERY.getValue()) {
            return this.data.get(n).getSelectQuery();
        }
        if (n2 == Common.ColIdx.ROWCOUNT.getValue()) {
            return this.data.get(n).getRowCount();
        }
        if (n2 == Common.ColIdx.ONLY_CREATE_TABLE.getValue()) {
            return this.data.get(n).getCreateTableOnly();
        }
        if (n2 == Common.ColIdx.CREATE.getValue()) {
            return this.data.get(n).getCreateTableStatement();
        }
        if (this.isTTGrid && n2 == Common.ColIdx.DISTRIBUTION.getValue()) {
            return this.editable ? Messages.getString("LoadTablesFromOracle.viewEdit") : Messages.getString("LoadTablesFromOracle.view");
        }
        if (n2 == Common.ColIdx.STATUS.getValue() || !this.isTTGrid && n2 + 1 == Common.ColIdx.STATUS.getValue()) {
            return this.data.get(n).getStatus() == null ? Messages.getString("TimesTen.common.unknown") : this.data.get(n).getStatus();
        }
        return null;
    }

    @Override
    public String getColumnName(int n) {
        if (!this.isTTGrid && n == HEADER.length - 2) {
            return HEADER[n + 1];
        }
        return HEADER[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (!this.editable) {
            return false;
        }
        return n2 == Common.ColIdx.USERNAME.getValue() || n2 == Common.ColIdx.TABLENAME.getValue() || n2 == Common.ColIdx.ONLY_CREATE_TABLE.getValue();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        LoadTableRow loadTableRow = null;
        if (n2 == Common.ColIdx.USERNAME.getValue()) {
            loadTableRow = this.data.get(n);
            loadTableRow.setTimesTenUser((String)object);
            this.fireTableCellUpdated(n, Common.ColIdx.CREATE.getValue());
        } else if (n2 == Common.ColIdx.TABLENAME.getValue()) {
            loadTableRow = this.data.get(n);
            loadTableRow.setTimesTenTable((String)object);
            this.fireTableCellUpdated(n, Common.ColIdx.CREATE.getValue());
        } else if (n2 == Common.ColIdx.QUERY.getValue()) {
            if (!Common.validQuery((String)object)) {
                this.data.get(n).setParallelLoads(1);
            }
            this.data.get(n).setSelectQuery((String)object);
        } else if (n2 == Common.ColIdx.ROWCOUNT.getValue()) {
            this.data.get(n).setRowCount((Long)object);
        } else if (n2 == Common.ColIdx.ONLY_CREATE_TABLE.getValue()) {
            this.data.get(n).setCreateTableOnly((Boolean)object);
        } else if (n2 == Common.ColIdx.CREATE.getValue()) {
            this.data.get(n).setCreateTableStatement((String)object);
        }
        this.fireTableCellUpdated(n, n2);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == Common.ColIdx.USERNAME.getValue() || n == Common.ColIdx.TABLENAME.getValue() || n == Common.ColIdx.QUERY.getValue() || n == Common.ColIdx.ROWCOUNT.getValue() || n == Common.ColIdx.CREATE.getValue() || n == Common.ColIdx.STATUS.getValue()) {
            return String.class;
        }
        if (n == Common.ColIdx.ONLY_CREATE_TABLE.getValue()) {
            return Boolean.class;
        }
        if (n == Common.ColIdx.DISTRIBUTION.getValue()) {
            return JButton.class;
        }
        return null;
    }
}

