/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.user;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.timesten.dialogs.user.TTPrivilegeObject;

public class TTUserObject {
    private Connection conn;
    private String userName = null;
    private boolean isExternalUser;
    private boolean supportUserProfiles;
    private boolean alter;
    private String password;
    private boolean pwdExpired;
    private boolean accountLocked;
    private String profile;
    private Map<String, TTPrivilegeObject> privs = new HashMap<String, TTPrivilegeObject>();
    private static Logger logger = Logger.getLogger(TTUserObject.class.getName());

    private final Query getQueryFromFile(Connection connection, String string) {
        String string2 = "/oracle/dbtools/raptor/timesten/dialogs/user/UserQueries.xml";
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(this.getClass().getClassLoader(), string2));
        Query query = queryXMLSupport.getQuery(string, connection);
        return query;
    }

    protected final String getQuery(Connection connection, String string) {
        Query query = this.getQueryFromFile(connection, string);
        return query.getSql();
    }

    public TTUserObject(Connection connection, String string, boolean bl, boolean bl2) {
        this.userName = string;
        this.conn = connection;
        this.isExternalUser = bl;
        this.supportUserProfiles = bl2;
        this.loadUser();
        this.loadPrivs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadUser() {
        Statement statement = null;
        ResultSet resultSet = null;
        if (this.userName != null) {
            this.alter = true;
            try {
                statement = this.conn.prepareCall(this.getQuery(this.conn, "get_user"));
                statement.setString(1, this.userName);
                resultSet = statement.executeQuery();
                if (!resultSet.next()) return;
                String string = resultSet.getString(1).toUpperCase();
                this.pwdExpired = string.contains("EXPIRED");
                this.accountLocked = string.contains("LOCKED");
                this.profile = resultSet.getString(2);
                return;
            }
            catch (SQLException sQLException) {
                logger.severe("Error while getting user data: " + sQLException.getMessage());
                return;
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
        this.alter = false;
        this.profile = "DEFAULT";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPrivs() {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.conn.prepareCall(this.getQuery(this.conn, "get_privs"));
            statement.setString(1, this.userName);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = "No";
                TTPrivilegeObject tTPrivilegeObject = new TTPrivilegeObject(string, string2, string3);
                if (string.equalsIgnoreCase("CREATE ANY DIRECTORY") || string.equalsIgnoreCase("DROP ANY DIRECTORY")) continue;
                this.privs.put(string, tTPrivilegeObject);
            }
        }
        catch (SQLException sQLException) {
            logger.severe("Error while getting user privileges: " + sQLException.getMessage());
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    public String getSql() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.password != null && this.password.trim().length() > 0;
        stringBuffer.append("-- USER SQL\n");
        if (this.alter) {
            if (this.supportUserProfiles) {
                stringBuffer.append("ALTER USER \"");
                stringBuffer.append(this.userName);
                stringBuffer.append("\" ");
                if (this.isExternalUser) {
                    stringBuffer.append("IDENTIFIED EXTERNALLY");
                } else if (bl) {
                    stringBuffer.append("IDENTIFIED BY ");
                    stringBuffer.append(this.password);
                }
                stringBuffer.append("\n");
                stringBuffer.append(" PROFILE ");
                stringBuffer.append("\"" + this.profile + "\"");
                stringBuffer.append("\n");
                stringBuffer.append(" ACCOUNT ");
                if (this.accountLocked) {
                    stringBuffer.append("LOCK");
                } else {
                    stringBuffer.append("UNLOCK");
                }
                if (this.pwdExpired && !this.isExternalUser) {
                    stringBuffer.append("\n");
                    stringBuffer.append(" PASSWORD EXPIRE");
                }
                stringBuffer.append(";\n");
            } else if (bl) {
                stringBuffer.append("ALTER USER \"");
                stringBuffer.append(this.userName);
                stringBuffer.append("\" ");
                stringBuffer.append(" IDENTIFIED BY ");
                stringBuffer.append(this.password);
                stringBuffer.append(" ");
                stringBuffer.append(";\n");
            }
        } else if (this.userName != null) {
            stringBuffer.append("CREATE USER \"");
            stringBuffer.append(this.userName);
            stringBuffer.append("\" IDENTIFIED BY ");
            stringBuffer.append(this.password);
            if (this.supportUserProfiles) {
                stringBuffer.append("\n");
                stringBuffer.append(" PROFILE ");
                stringBuffer.append("\"" + this.profile + "\"");
                stringBuffer.append("\n");
                stringBuffer.append(" ACCOUNT ");
                if (this.accountLocked) {
                    stringBuffer.append("LOCK");
                } else {
                    stringBuffer.append("UNLOCK");
                }
                if (this.pwdExpired) {
                    stringBuffer.append("\n");
                    stringBuffer.append(" PASSWORD EXPIRE");
                }
            }
            stringBuffer.append(";\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("-- SYSTEM PRIVILEGES\n");
        for (String string : this.privs.keySet()) {
            TTPrivilegeObject tTPrivilegeObject = this.privs.get(string);
            if (tTPrivilegeObject.doGrant()) {
                stringBuffer.append("GRANT ");
                stringBuffer.append(string);
                stringBuffer.append(" TO \"");
                stringBuffer.append(this.userName);
                stringBuffer.append("\" ");
                if (tTPrivilegeObject.isAdmin()) {
                    stringBuffer.append(" WITH ADMIN OPTION");
                }
                stringBuffer.append(";\n");
            }
            if (!tTPrivilegeObject.doRevoke()) continue;
            stringBuffer.append("REVOKE ");
            stringBuffer.append(string);
            stringBuffer.append(" FROM \"");
            stringBuffer.append(this.userName);
            stringBuffer.append("\";\n");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    boolean isPasswordExpired() {
        return this.pwdExpired;
    }

    void setPasswordExpired(boolean bl) {
        this.pwdExpired = bl;
    }

    boolean isAccountLocked() {
        return this.accountLocked;
    }

    void setAccountLocked(boolean bl) {
        this.accountLocked = bl;
    }

    String getProfile() {
        return this.profile;
    }

    void setProfile(String string) {
        this.profile = string;
    }

    List<String> getProfiles() throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Statement statement = this.conn.createStatement();
        ResultSet resultSet = statement.executeQuery(this.getQuery(this.conn, "get_profiles"));
        while (resultSet.next()) {
            arrayList.add(resultSet.getString(1));
        }
        resultSet.close();
        return arrayList;
    }

    public void updatePriv(String string, boolean bl, boolean bl2) {
        this.privs.get(string).setGranted(bl);
        this.privs.get(string).setAdmin(bl2);
    }

    public void updatePrivs(TTPrivilegeObject tTPrivilegeObject) {
        TTPrivilegeObject tTPrivilegeObject2 = this.privs.get(tTPrivilegeObject.getName());
        tTPrivilegeObject2.setAdmin(tTPrivilegeObject.isAdmin());
        tTPrivilegeObject2.setGranted(tTPrivilegeObject.isGranted());
    }

    public Map<String, TTPrivilegeObject> getPrivs() {
        return this.privs;
    }

    public boolean isAlter() {
        return this.alter;
    }
}

