/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.user;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;

public class TTUserPasswordResetPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static Logger _logger = Logger.getLogger(Common.class.getPackage().getName());
    private JEWTDialog _containerDialog;
    private JTextField user;
    private JPasswordField currentPass;
    private JPasswordField newPass;
    private JPasswordField confirmPass;
    private JButton okButton;
    private DBObject _db;

    public TTUserPasswordResetPanel(DBObject dBObject, String string) {
        this._db = dBObject;
        this.init(string);
    }

    private void init(String string) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel();
        int n = 0;
        jPanel.setLayout(gridBagLayout);
        this.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        this.user = new JTextField(string);
        this.currentPass = new JPasswordField();
        this.newPass = new JPasswordField();
        this.confirmPass = new JPasswordField();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TTUserPasswordResetPanel.this.resetPassword();
            }
        };
        jLabel.setText(Messages.getString("TTCreateUser.username"));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.user.getAccessibleContext().setAccessibleName(Messages.getString("TTCreateUser.username"));
        this.user.setEnabled(false);
        jPanel.add((Component)this.user, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 0, 10), 0, 0));
        jLabel2.setText(Messages.getString("TTCreateUser.currentPass"));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.currentPass.addActionListener(actionListener);
        this.currentPass.getAccessibleContext().setAccessibleName(Messages.getString("TTCreateUser.currentPass"));
        jPanel.add((Component)this.currentPass, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 0, 10), 0, 0));
        jLabel3.setText(Messages.getString("TTCreateUser.newPass"));
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.newPass.addActionListener(actionListener);
        this.newPass.getAccessibleContext().setAccessibleName(Messages.getString("TTCreateUser.newPass"));
        jPanel.add((Component)this.newPass, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 0, 10), 0, 0));
        jLabel4.setText(Messages.getString("TTCreateUser.confirmPass"));
        jPanel.add((Component)jLabel4, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.confirmPass.addActionListener(actionListener);
        this.confirmPass.getAccessibleContext().setAccessibleName(Messages.getString("TTCreateUser.confirmPass"));
        jPanel.add((Component)this.confirmPass, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)jPanel, "North");
        this.okButton = new JButton(Messages.getString("TTCreateUser.ok"));
        this.okButton.getAccessibleContext().setAccessibleName(Messages.getString("TTCreateUser.ok"));
        this.okButton.addActionListener(actionListener);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, TimesTenHelpID.RESET_PASS.toString());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void setDialog(JEWTDialog jEWTDialog) {
        this._containerDialog = jEWTDialog;
        jEWTDialog.setSize(350, 200);
        jEWTDialog.addCustomButton((Component)this.okButton);
    }

    private final void resetPassword() {
        ResetPasswordObject resetPasswordObject = this.isInformationCompleted();
        if (resetPasswordObject != null) {
            Object object;
            if (!this.checkCurrPassword(resetPasswordObject)) {
                return;
            }
            Connection connection = this._db.getConnection();
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            stringBuffer.append("ALTER USER \"");
            stringBuffer.append(resetPasswordObject.getUserName());
            stringBuffer.append("\" ");
            stringBuffer.append("IDENTIFIED BY ");
            stringBuffer.append(resetPasswordObject.getNewPass());
            stringBuffer.append(";");
            try {
                object = connection.prepareStatement(stringBuffer.toString());
                try {
                    object.executeUpdate();
                }
                finally {
                    if (object != null) {
                        object.close();
                    }
                }
            }
            catch (Exception exception) {
                _logger.log(Level.INFO, exception.getMessage());
                Common.displayErrorMsg((Component)Ide.getMainWindow(), exception.getMessage());
                bl = false;
            }
            if (bl) {
                try {
                    object = new Properties();
                    String string = this._db.getConnectionName();
                    String string2 = Connections.getStoreName((String)string);
                    String string3 = Connections.getConnectionName((String)string);
                    DatabaseConnections databaseConnections = DatabaseConnectionStores.getInstance().getStore(string2);
                    Properties properties = databaseConnections.getProperties(string3);
                    String string4 = properties.getProperty("SavePassword");
                    ((Properties)object).putAll((Map<?, ?>)properties);
                    ((Properties)object).setProperty("password", resetPasswordObject.newPass);
                    try {
                        Connection connection2 = DatabaseConnections.getInstance().getConnection((Properties)object);
                        if (connection2 != null) {
                            connection2.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        _logger.log(Level.INFO, sQLException.getMessage());
                        Common.displayErrorMsg((Component)Ide.getMainWindow(), sQLException.getMessage());
                        return;
                    }
                    if (string4.equals("true")) {
                        properties.setProperty("password", resetPasswordObject.newPass);
                        databaseConnections.updateConnection(string3, string3, properties, true);
                    }
                }
                catch (ConnectionException connectionException) {
                    _logger.log(Level.INFO, connectionException.getMessage());
                    Common.displayErrorMsg((Component)Ide.getMainWindow(), connectionException.getMessage());
                    return;
                }
                Common.displayInfoMsg(this, Messages.getString("TTCreateUser.passwordResetSuccess"), Messages.getString("TTCreateUser.passwordReset"));
                this._containerDialog.dispose();
            }
        }
    }

    private Properties copyProps() throws ConnectionException {
        Properties properties = new Properties();
        String string = this._db.getConnectionName();
        String string2 = Connections.getStoreName((String)string);
        String string3 = Connections.getConnectionName((String)string);
        DatabaseConnections databaseConnections = DatabaseConnectionStores.getInstance().getStore(string2);
        Properties properties2 = databaseConnections.getProperties(string3);
        properties.putAll((Map<?, ?>)properties2);
        return properties;
    }

    private boolean checkCurrPassword(ResetPasswordObject resetPasswordObject) {
        try {
            Properties properties = this.copyProps();
            properties.setProperty("password", resetPasswordObject.getCurrentPass());
            try {
                Connection connection = DatabaseConnections.getInstance().getConnection(properties);
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {
                _logger.log(Level.INFO, sQLException.getMessage());
                Common.displayErrorMsg((Component)Ide.getMainWindow(), sQLException.getMessage());
                return false;
            }
        }
        catch (ConnectionException connectionException) {
            _logger.log(Level.INFO, connectionException.getMessage());
            Common.displayErrorMsg((Component)Ide.getMainWindow(), connectionException.getMessage());
            return false;
        }
        return true;
    }

    private ResetPasswordObject isInformationCompleted() {
        String string = this.user.getText();
        String string2 = new String(this.currentPass.getPassword());
        String string3 = new String(this.newPass.getPassword());
        String string4 = new String(this.confirmPass.getPassword());
        if (string2.isEmpty()) {
            Common.displayErrorMsg(this, Messages.getString("TTCreateUser.noCurrentPwd"));
            return null;
        }
        if (string3.isEmpty()) {
            Common.displayErrorMsg(this, Messages.getString("TTCreateUser.pwdRequired"));
            return null;
        }
        if (string4.isEmpty()) {
            Common.displayErrorMsg(this, Messages.getString("TTCreateUser.confirmNewPwd"));
            return null;
        }
        if (!string3.equals(string4)) {
            Common.displayErrorMsg(this, Messages.getString("TTCreateUser.passwordNotMatch"));
            return null;
        }
        return new ResetPasswordObject(string.trim(), string2.trim(), string3.trim());
    }

    private class ResetPasswordObject {
        private String userName;
        private String currentPass;
        private String newPass;

        public ResetPasswordObject(String string, String string2, String string3) {
            this.currentPass = string2;
            this.userName = string;
            this.newPass = string3;
        }

        public String getCurrentPass() {
            return this.currentPass;
        }

        public String getNewPass() {
            return this.newPass;
        }

        public String getUserName() {
            return this.userName;
        }
    }
}

