/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.ClosableEscMenuItem;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.SSHChannel;
import oracle.dbtools.raptor.timesten.grid.SecondStepPanel;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.InstallationObject;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.grid.object.InvalidInputException;
import oracle.dbtools.raptor.timesten.grid.object.MySSHException;
import oracle.dbtools.raptor.timesten.grid.topology.TopologyElement;
import oracle.dbtools.raptor.timesten.utils.AutoCompleteComponent;
import oracle.ide.Ide;

public class DataInstancesPanel
extends SecondStepPanel
implements ActionListener,
TreeSelectionListener {
    private JPanel _leftPanel;
    private JPopupMenu _treePopupMenu;
    private JTree _dataInstTree;
    private JScrollPane _treeScrollPane;
    private DefaultTreeModel _treeModel;
    private DefaultMutableTreeNode _treeRoot;
    private ClosableEscMenuItem _new;
    private ClosableEscMenuItem _duplicate;
    private ClosableEscMenuItem _delete;
    private JSplitPane _splitPane;
    private JPanel _rightPanel;
    private DataInstancePanel _dataInstPanel = null;
    private JLabel _newInstanceLabel;
    private static final String INSTRUCTIONS_PANEL = "Inst";
    private static final String DATA_INSTANCE_PANEL = "Data";
    private List<Instance> dataInstances = new ArrayList<Instance>();
    private Instance mgmtInstance;
    private static Logger _logger = Logger.getLogger(DataInstancesPanel.class.getName());

    public DataInstancesPanel() {
        this.init();
        this.initPopupMenus();
    }

    private void init() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.initLeftPanel();
        this.initRightPanel();
        this._splitPane = new JSplitPane(1);
        this._splitPane.setLeftComponent(this._leftPanel);
        this._splitPane.setRightComponent(this._rightPanel);
        this._splitPane.setResizeWeight(0.0);
        this._splitPane.setDividerLocation(125);
        this._splitPane.setContinuousLayout(true);
        this.add((Component)this._splitPane, "Center");
    }

    private void initRightPanel() {
        this._rightPanel = new JPanel(new CardLayout());
        this._newInstanceLabel = new JLabel(Messages.getString("TimesTenGrid.newInstLabel"));
        this._rightPanel.add((Component)this._newInstanceLabel, INSTRUCTIONS_PANEL);
        this._dataInstPanel = new DataInstancePanel();
        this._rightPanel.add((Component)this._dataInstPanel, DATA_INSTANCE_PANEL);
    }

    private void initLeftPanel() {
        this._leftPanel = new JPanel(new BorderLayout());
        this._treeRoot = new DefaultMutableTreeNode(Messages.getString("TimesTenGrid.DataInstances"));
        this._treeModel = new DefaultTreeModel(this._treeRoot);
        this._dataInstTree = new JTree(this._treeModel);
        this._dataInstTree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._dataInstTree.getSelectionModel().setSelectionMode(4);
        this._dataInstTree.addTreeSelectionListener(this);
        this._dataInstTree.setCellRenderer(new CustomTreeIconRenderer());
        this._dataInstTree.setToggleClickCount(0);
        this._dataInstTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    TreePath treePath;
                    TreePath treePath2 = DataInstancesPanel.this._dataInstTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath2 != (treePath = DataInstancesPanel.this._dataInstTree.getSelectionModel().getSelectionPath())) {
                        if (!DataInstancesPanel.this._dataInstTree.getSelectionModel().isPathSelected(treePath2)) {
                            DataInstancesPanel.this._dataInstTree.getSelectionModel().setSelectionPath(treePath2);
                        }
                        DataInstancesPanel.this.displayTreePopup();
                    } else if (treePath2 != null) {
                        DataInstancesPanel.this.displayTreePopup();
                    }
                }
            }
        });
        this._treeScrollPane = new JScrollPane(this._dataInstTree);
        this._leftPanel.add((Component)this._treeScrollPane, "Center");
        this._leftPanel.setMinimumSize(new Dimension(130, 500));
    }

    private void initPopupMenus() {
        this._treePopupMenu = new JPopupMenu();
        this._new = new ClosableEscMenuItem(Messages.getString("TimesTenGrid.new"), this._treePopupMenu);
        this._duplicate = new ClosableEscMenuItem(Messages.getString("TimesTenGrid.duplicate"), this._treePopupMenu);
        this._delete = new ClosableEscMenuItem(Messages.getString("TimesTenGrid.delete"), this._treePopupMenu);
        this._new.addActionListener(this);
        this._duplicate.addActionListener(this);
        this._delete.addActionListener(this);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(121, 1, true);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(525, 0);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(27, 0);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataInstancesPanel.this.displayTreePopup();
            }
        };
        this._dataInstTree.registerKeyboardAction(actionListener, keyStroke, 0);
        this._dataInstTree.registerKeyboardAction(actionListener, keyStroke2, 0);
        this._treePopupMenu.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataInstancesPanel.this._treePopupMenu.setVisible(false);
            }
        }, keyStroke3, 0);
    }

    private void displayTreePopup() {
        TreePath treePath = this._dataInstTree.getSelectionModel().getSelectionPath();
        if (treePath != null) {
            this.checkNotSavedInstance(false);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            this._treePopupMenu.removeAll();
            if (!defaultMutableTreeNode.isRoot()) {
                this._treePopupMenu.add(this._duplicate);
                this._treePopupMenu.addSeparator();
                this._treePopupMenu.add(this._delete);
            } else {
                this._treePopupMenu.add(this._new);
            }
            Rectangle rectangle = this._dataInstTree.getPathBounds(treePath);
            this._treePopupMenu.show(this._dataInstTree, rectangle.x + 100, rectangle.y);
        }
    }

    private void checkNotSavedInstance(boolean bl) {
        if (this._dataInstPanel.isEditingInstance()) {
            if (Common.displayConfirm(this, MessageFormat.format(Messages.getString("TimesTenGrid.notSavedInstance"), this._dataInstTree.getSelectionModel().getSelectionPath().getLastPathComponent()), Messages.getString("TimesTen.common.warning"), null)) {
                this._dataInstPanel.saveInstance();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._dataInstTree.getSelectionModel().getSelectionPath().getLastPathComponent();
                defaultMutableTreeNode.setUserObject(this._dataInstPanel.getInstanceInPanel().getCompositeName());
                this._treeModel.reload(defaultMutableTreeNode);
            } else {
                if (bl) {
                    this._dataInstPanel._saveButton.setEnabled(false);
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._dataInstTree.getSelectionModel().getSelectionPath().getLastPathComponent();
                    int n = this._treeRoot.getIndex(defaultMutableTreeNode);
                    this.removeInstance(this.dataInstances.get(n), defaultMutableTreeNode);
                    this._treeModel.reload(this._treeRoot);
                }
                this._dataInstPanel.setInstance(this._dataInstPanel.instance);
            }
        }
    }

    @Override
    protected void validateInput() throws InvalidInputException {
        this.checkNotSavedInstance(true);
        int n = (Integer)this.dataContext.get("K_SAFETY");
        if (this.dataInstances.size() < n) {
            throw new InvalidInputException(MessageFormat.format(Messages.getString("TimesTenGrid.notEnoughInstances"), n));
        }
        int n2 = 1;
        String string = null;
        FocusedComponent focusedComponent = null;
        for (Instance instance : this.dataInstances) {
            if (instance.getHostName().isEmpty() && !instance.getUseDefaultHostName()) {
                string = Messages.getString("TimesTenGrid.noHostNameError");
                focusedComponent = FocusedComponent.HOST_NAME_TXTFIELD;
                break;
            }
            string = Common.validateName(instance.getHostName(), Messages.getString("TimesTenGrid.hostNameColumn"));
            if (string != null) {
                focusedComponent = FocusedComponent.HOST_NAME_TXTFIELD;
                break;
            }
            if (instance.getInternalAddress().isEmpty()) {
                string = Messages.getString("TimesTenGrid.noInternalAddrError");
                focusedComponent = FocusedComponent.INT_ADDR_TXTFIELD;
                break;
            }
            if (!Common.validAddress(instance.getInternalAddress())) {
                string = Messages.getString("TimesTenGrid.addressFormatError");
                focusedComponent = FocusedComponent.INT_ADDR_TXTFIELD;
                break;
            }
            if (instance.getExternalAddress().isEmpty()) {
                string = Messages.getString("TimesTenGrid.noExternalAddrError");
                focusedComponent = FocusedComponent.EXT_ADDR_TXTFIELD;
                break;
            }
            if (!Common.validAddress(instance.getExternalAddress())) {
                string = Messages.getString("TimesTenGrid.addressFormatError");
                focusedComponent = FocusedComponent.EXT_ADDR_TXTFIELD;
                break;
            }
            if (instance.getName().isEmpty()) {
                string = Messages.getString("TimesTenGrid.noNameError");
                focusedComponent = FocusedComponent.NAME_TXTFIELD;
                break;
            }
            string = Common.validateName(instance.getName(), Messages.getString("TimesTenGrid.instanceName"));
            if (string != null) {
                focusedComponent = FocusedComponent.NAME_TXTFIELD;
                break;
            }
            if (instance.equals(this.mgmtInstance)) {
                string = Messages.getString("TimesTenGrid.repeatedInstMgmt");
                focusedComponent = FocusedComponent.NAME_TXTFIELD;
                break;
            }
            if (instance.getLocation().isEmpty()) {
                string = Messages.getString("TimesTenGrid.noInstLocError");
                focusedComponent = FocusedComponent.LOCATION_TXTFIELD;
                break;
            }
            if (!Common.validPort(instance.getDaemonPort())) {
                string = Messages.getString("TimesTenGrid.invalidDaemonPortError");
                focusedComponent = FocusedComponent.DAEMON_PORT_TXTFIELD;
                break;
            }
            if (!Common.validPort(instance.getCSPort())) {
                string = Messages.getString("TimesTenGrid.invalidCSPortError");
                focusedComponent = FocusedComponent.CS_PORT_TXTFIELD;
                break;
            }
            if (instance.getDaemonPort() == instance.getCSPort()) {
                string = Messages.getString("TimesTenGrid.invalidSamePort");
                focusedComponent = FocusedComponent.DAEMON_PORT_TXTFIELD;
                break;
            }
            if (instance.getInstallLocation().isEmpty()) {
                string = Messages.getString("TimesTenGrid.noInstallLocationError");
                focusedComponent = FocusedComponent.INSTALL_LOC_TXTFIELD;
                break;
            }
            ++n2;
        }
        if (string != null) {
            TreePath treePath = this._dataInstTree.getPathForRow(n2);
            this._dataInstTree.getSelectionModel().setSelectionPath(treePath);
            if (focusedComponent != null) {
                switch (focusedComponent) {
                    case HOST_NAME_TXTFIELD: {
                        this._dataInstPanel._hostTxtField.requestFocus();
                        break;
                    }
                    case INT_ADDR_TXTFIELD: {
                        this._dataInstPanel._intAddressTxtField.requestFocus();
                        break;
                    }
                    case EXT_ADDR_TXTFIELD: {
                        this._dataInstPanel._extAddressTxtField.requestFocus();
                        break;
                    }
                    case NAME_TXTFIELD: {
                        this._dataInstPanel._nameTxtField.requestFocus();
                        break;
                    }
                    case LOCATION_TXTFIELD: {
                        this._dataInstPanel._locationTxtField.requestFocus();
                        break;
                    }
                    case DAEMON_PORT_TXTFIELD: {
                        this._dataInstPanel._daemonPortTxtField.requestFocus();
                        break;
                    }
                    case CS_PORT_TXTFIELD: {
                        this._dataInstPanel._csPortTxtField.requestFocus();
                        break;
                    }
                    case INSTALL_LOC_TXTFIELD: {
                        this._dataInstPanel._installLocationTxtField.requestFocus();
                    }
                }
            }
            throw new InvalidInputException(string);
        }
        string = this.checkInstances();
        if (string != null) {
            throw new InvalidInputException(string);
        }
        this.testAdditionalHostConn();
        throw new InvalidInputException(null);
    }

    private void testAdditionalHostConn() {
        final String string = (String)this.dataContext.get("INSTANCE_ADMIN");
        final char[] cArray = (char[])this.dataContext.get("PWD");
        final String string2 = (String)this.dataContext.get("SSH_KEY_FILE");
        final CustomProgressMonitor customProgressMonitor = new CustomProgressMonitor(this, Messages.getString("TimesTenGrid.testAddHostConn"), Messages.getString("TimesTen.common.pleaseWait"), null);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){
            StringBuilder error = new StringBuilder();
            int row = 1;
            List<String> dirsToCreate;

            @Override
            protected Void doInBackground() {
                customProgressMonitor.start();
                this.dirsToCreate = new ArrayList<String>();
                String[] stringArray = new String[Common.PARAMCHECK_COUNT];
                boolean[] blArray = new boolean[Common.PARAMCHECK_COUNT];
                blArray[Common.CheckIndex.INSTDIR_IDX.ordinal()] = true;
                blArray[Common.CheckIndex.INSTALLLOC_IDX.ordinal()] = true;
                for (Instance instance : DataInstancesPanel.this.dataInstances) {
                    String string4 = instance.getExternalAddress();
                    stringArray[Common.CheckIndex.INSTDIR_IDX.ordinal()] = instance.getLocation();
                    stringArray[Common.CheckIndex.INSTALLLOC_IDX.ordinal()] = instance.getInstallLocation();
                    stringArray[Common.CheckIndex.INSTNAME_IDX.ordinal()] = instance.getName();
                    try {
                        String string22;
                        String string3 = SSHChannel.tryConnect(string4, string, cArray, string2, blArray, stringArray);
                        if (this.isCancelled()) {
                            return null;
                        }
                        if (instance.getUseDefaultHostName()) {
                            instance.setHostName(string3);
                        }
                        if (stringArray[Common.CheckIndex.INSTDIR_IDX.ordinal()] != null && stringArray[Common.CheckIndex.INSTDIR_IDX.ordinal()].contains("$$CREATE_DIR$$") && !this.dirsToCreate.contains(string22 = string4 + ":" + instance.getLocation())) {
                            this.dirsToCreate.add(string22);
                        }
                        ++this.row;
                    }
                    catch (MySSHException mySSHException) {
                        _logger.log(Level.SEVERE, mySSHException.getMessage());
                        this.error.append(mySSHException.getMessage());
                        return null;
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                customProgressMonitor.close();
                if (this.isCancelled()) {
                    return;
                }
                if (this.error.length() > 0) {
                    TreePath treePath = DataInstancesPanel.this._dataInstTree.getPathForRow(this.row);
                    DataInstancesPanel.this._dataInstTree.getSelectionModel().setSelectionPath(treePath);
                    Common.displayErrorMsg((Component)Ide.getMainWindow(), this.error.toString());
                } else {
                    List list = (List)DataInstancesPanel.this.dataContext.get("DIRS_TO_CREATE");
                    for (String string3 : this.dirsToCreate) {
                        if (list.contains(string3)) continue;
                        list.add(string3);
                    }
                    DataInstancesPanel.this.dataContext.put("DIRS_TO_CREATE", (Object)list);
                    DataInstancesPanel.this.dataContext.put("Ready", (Object)1);
                    DataInstancesPanel.this.dataContext.getWizardCallbacks().nextPage();
                }
            }
        };
        swingWorker.addPropertyChangeListener(customProgressMonitor);
        customProgressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }

    private String checkInstances() {
        ArrayList<Instance> arrayList = new ArrayList<Instance>();
        int n = (Integer)this.dataContext.get("MANAGEMENT_PORT");
        arrayList.add(this.mgmtInstance);
        arrayList.addAll(this.dataInstances);
        for (Instance instance : this.dataInstances) {
            instance.setIsLocalHost(Common.isLocalHost(instance.getExternalAddress()));
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            InetAddress inetAddress;
            Instance instance;
            instance = (Instance)arrayList.get(i);
            String string = instance.getExternalAddress();
            int n2 = instance.getDaemonPort();
            int n3 = instance.getCSPort();
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                _logger.log(Level.INFO, unknownHostException.getMessage());
                continue;
            }
            for (int j = i + 1; j < arrayList.size(); ++j) {
                InetAddress inetAddress2;
                Instance instance2 = (Instance)arrayList.get(j);
                String string2 = instance2.getExternalAddress();
                int n4 = instance2.getDaemonPort();
                int n5 = instance2.getCSPort();
                try {
                    inetAddress2 = InetAddress.getByName(string2);
                }
                catch (UnknownHostException unknownHostException) {
                    _logger.log(Level.INFO, unknownHostException.getMessage());
                    continue;
                }
                TreePath treePath = this._dataInstTree.getPathForRow(j);
                if (instance.equals(instance2)) {
                    this._dataInstTree.getSelectionModel().setSelectionPath(treePath);
                    this._dataInstPanel._nameTxtField.requestFocus();
                    return Messages.getString("TimesTenGrid.repeatedInst");
                }
                if (inetAddress.getHostAddress().equalsIgnoreCase(inetAddress2.getHostAddress())) {
                    if (instance.getLocation().equals(instance2.getLocation()) && instance.getName().equals(instance2.getName())) {
                        this._dataInstTree.getSelectionModel().setSelectionPath(treePath);
                        this._dataInstPanel._locationTxtField.requestFocus();
                        return MessageFormat.format(Messages.getString("TimesTenGrid.sameInstDirNameError"), instance.getCompositeName(), instance2.getCompositeName());
                    }
                    if (n4 == n2 || n4 == n3) {
                        this._dataInstTree.getSelectionModel().setSelectionPath(treePath);
                        this._dataInstPanel._daemonPortTxtField.requestFocus();
                        return MessageFormat.format(Messages.getString("TimesTenGrid.portAlreadySpecified"), n4);
                    }
                    if (n5 == n2 || n5 == n3) {
                        this._dataInstTree.getSelectionModel().setSelectionPath(treePath);
                        this._dataInstPanel._csPortTxtField.requestFocus();
                        return MessageFormat.format(Messages.getString("TimesTenGrid.portAlreadySpecified"), n5);
                    }
                    if (i != 0) continue;
                    if (n4 == n) {
                        this._dataInstTree.getSelectionModel().setSelectionPath(treePath);
                        this._dataInstPanel._daemonPortTxtField.requestFocus();
                        return MessageFormat.format(Messages.getString("TimesTenGrid.portAlreadySpecified"), n4);
                    }
                    if (n5 != n) continue;
                    this._dataInstTree.getSelectionModel().setSelectionPath(treePath);
                    this._dataInstPanel._csPortTxtField.requestFocus();
                    return MessageFormat.format(Messages.getString("TimesTenGrid.portAlreadySpecified"), n5);
                }
                if (!instance.isLocalHost() || !instance2.isLocalHost()) continue;
                if (instance.getName().equalsIgnoreCase(instance2.getName()) && Common.sameDirectories(instance.getLocation(), instance2.getLocation())) {
                    this._dataInstTree.getSelectionModel().setSelectionPath(treePath);
                    this._dataInstPanel._nameTxtField.requestFocus();
                    return MessageFormat.format(Messages.getString("TimesTenGrid.localInstDirNameError"), instance.getCompositeName(), instance2.getCompositeName());
                }
                if (n5 == n2 || n5 == n3) {
                    this._dataInstTree.getSelectionModel().setSelectionPath(treePath);
                    this._dataInstPanel._csPortTxtField.requestFocus();
                    return MessageFormat.format(Messages.getString("TimesTenGrid.portAlreadySpecified"), n5);
                }
                if (n4 != n2 && n4 != n3) continue;
                this._dataInstTree.getSelectionModel().setSelectionPath(treePath);
                this._dataInstPanel._daemonPortTxtField.requestFocus();
                return MessageFormat.format(Messages.getString("TimesTenGrid.portAlreadySpecified"), n4);
            }
        }
        return null;
    }

    @Override
    protected List<Host> getHostList(int n) {
        ArrayList<Host> arrayList = new ArrayList<Host>();
        for (Instance object : this.dataInstances) {
            Host host = new Host(object.getInternalAddress(), object.getExternalAddress());
            host.setName(object.getHostName());
            if (!arrayList.contains(host)) {
                host.getInstances().add(object);
                arrayList.add(host);
                continue;
            }
            int n2 = arrayList.indexOf(host);
            if (n2 < 0) continue;
            ((Host)arrayList.get(n2)).getInstances().add(object);
        }
        if (n > 1 && arrayList.size() < n) {
            int n3 = 0;
            String string = "";
            int n4 = 2;
            while (arrayList.size() < this.dataInstances.size() && n3 < arrayList.size()) {
                Host host = (Host)arrayList.get(n3);
                if (host.getInstances().size() > 1) {
                    String string2 = host.getName();
                    Host host2 = new Host(host.getInternalAddress(), host.getExternalAddress());
                    host2.setName(string2 + "_" + String.valueOf(n4++));
                    Instance instance = host.getInstances().get(1);
                    host2.getInstances().add(instance);
                    host.getInstances().remove(1);
                    arrayList.add(host2);
                    continue;
                }
                n4 = 2;
                ++n3;
            }
        }
        return arrayList;
    }

    @Override
    protected void setDataFromPreviousStep() {
        this.mgmtInstance = new Instance((String)this.dataContext.get("HOSTNAME"), (String)this.dataContext.get("INTADDRESS"), (String)this.dataContext.get("EXTADDRESS"), (String)this.dataContext.get("NAME"), (Integer)this.dataContext.get("CS_PORT"), (Integer)this.dataContext.get("DAEMON_PORT"), (String)this.dataContext.get("INSTANCE_LOCATION"), (String)this.dataContext.get("INSTALLATION_LOCATION"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._new) {
            Instance instance = new Instance(this.getAvailHostName(), "", "", Common.getDefaultInstanceName(), 6625, 6624, this.mgmtInstance.getLocation(), this.mgmtInstance.getInstallLocation());
            this.addInstance(instance);
            this._treeModel.reload(this._treeRoot);
            this._dataInstTree.setSelectionRow(this._dataInstTree.getRowCount() - 1);
            return;
        }
        if (object == this._duplicate) {
            int n = 0;
            for (TreePath treePath : this._dataInstTree.getSelectionModel().getSelectionPaths()) {
                if (treePath.getParentPath() == null) continue;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                int n2 = this._treeRoot.getIndex(defaultMutableTreeNode);
                Instance instance = this.dataInstances.get(n2);
                Instance instance2 = new Instance(this.getAvailHostName(), "", "", instance.getName(), instance.getCSPort(), instance.getDaemonPort(), instance.getLocation(), instance.getInstallLocation());
                n = n2 + 1;
                this.addInstance(instance2, n);
            }
            this._dataInstTree.setSelectionRow(n + 1);
            return;
        }
        if (object == this._delete) {
            for (TreePath treePath : this._dataInstTree.getSelectionModel().getSelectionPaths()) {
                if (treePath.getParentPath() == null) continue;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                int n = this._treeRoot.getIndex(defaultMutableTreeNode);
                Instance instance = this.dataInstances.get(n);
                this.removeInstance(instance, defaultMutableTreeNode);
            }
        }
        this._treeModel.reload(this._treeRoot);
    }

    public void addInstance(Instance instance) {
        this.dataInstances.add(instance);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(instance.getCompositeName());
        this._treeModel.insertNodeInto(defaultMutableTreeNode, this._treeRoot, this._treeRoot.getChildCount());
    }

    public void addInstance(Instance instance, int n) {
        this.dataInstances.add(n, instance);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(instance.getCompositeName());
        this._treeModel.insertNodeInto(defaultMutableTreeNode, this._treeRoot, n);
    }

    public void removeInstance(Instance instance, DefaultMutableTreeNode defaultMutableTreeNode) {
        this.dataInstances.remove(instance);
        this._treeModel.removeNodeFromParent(defaultMutableTreeNode);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (this._dataInstPanel.isEditingInstance()) {
            if (Common.displayConfirm(this, MessageFormat.format(Messages.getString("TimesTenGrid.notSavedInstance"), treeSelectionEvent.getOldLeadSelectionPath().getLastPathComponent().toString()), Messages.getString("TimesTen.common.warning"), null)) {
                this._dataInstPanel.saveInstance();
                defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getOldLeadSelectionPath().getLastPathComponent();
                defaultMutableTreeNode.setUserObject(this._dataInstPanel.getInstanceInPanel().getCompositeName());
                this._treeModel.reload(defaultMutableTreeNode);
            } else {
                this._dataInstPanel.setInstance(this._dataInstPanel.instance);
            }
        }
        defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
        TreeNode treeNode = defaultMutableTreeNode.getParent();
        CardLayout cardLayout = (CardLayout)this._rightPanel.getLayout();
        if (treeNode != null) {
            int n = this._treeRoot.getIndex(defaultMutableTreeNode);
            this._dataInstPanel.setInstance(this.dataInstances.get(n));
            cardLayout.show(this._rightPanel, DATA_INSTANCE_PANEL);
        } else {
            cardLayout.show(this._rightPanel, INSTRUCTIONS_PANEL);
        }
    }

    private String getAvailHostName() {
        return "";
    }

    static enum FocusedComponent {
        HOST_NAME_TXTFIELD,
        INT_ADDR_TXTFIELD,
        EXT_ADDR_TXTFIELD,
        NAME_TXTFIELD,
        LOCATION_TXTFIELD,
        DAEMON_PORT_TXTFIELD,
        CS_PORT_TXTFIELD,
        INSTALL_LOC_TXTFIELD;

    }

    class DataInstancePanel
    extends JPanel
    implements ActionListener,
    DocumentListener {
        private JLabel _hostLabel;
        private JLabel _extAddressLabel;
        private JLabel _intAddressLabel;
        private JLabel _nameLabel;
        private JLabel _daemonPortLabel;
        private JLabel _csPortLabel;
        private JLabel _locationLabel;
        private JLabel _installLocationLabel;
        private AutoCompleteComponent _hostTxtField;
        private AutoCompleteComponent _extAddressTxtField;
        private AutoCompleteComponent _intAddressTxtField;
        private AutoCompleteComponent _nameTxtField;
        private AutoCompleteComponent _daemonPortTxtField;
        private AutoCompleteComponent _csPortTxtField;
        private AutoCompleteComponent _locationTxtField;
        private AutoCompleteComponent _installLocationTxtField;
        private JCheckBox _useDefaultCheckBox;
        private JButton _saveButton;
        private Instance instance;
        boolean[] modified = new boolean[FocusedComponent.values().length];

        public DataInstancePanel() {
            this.init();
        }

        Instance getInstanceInPanel() {
            return this.instance;
        }

        boolean isEditingInstance() {
            return this._saveButton.isEnabled();
        }

        private void init() {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.DataInstances")));
            this._hostTxtField = new AutoCompleteComponent(20, HostObject.getHostNameSuggestions());
            this._hostTxtField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (DataInstancePanel.this._intAddressTxtField.getText().isEmpty()) {
                        DataInstancePanel.this._intAddressTxtField.setText(DataInstancePanel.this._hostTxtField.getText());
                    }
                    if (DataInstancePanel.this._extAddressTxtField.getText().isEmpty()) {
                        DataInstancePanel.this._extAddressTxtField.setText(DataInstancePanel.this._hostTxtField.getText());
                    }
                }
            });
            this._hostTxtField.getDocument().addDocumentListener(this);
            this._useDefaultCheckBox = new JCheckBox(Messages.getString("TimesTenGrid.useDefault"));
            this._useDefaultCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    DataInstancePanel.this._hostTxtField.setEnabled(!DataInstancePanel.this._useDefaultCheckBox.isSelected());
                    if (DataInstancePanel.this._useDefaultCheckBox.isSelected()) {
                        DataInstancePanel.this._hostTxtField.setText("");
                    }
                    DataInstancePanel.this._saveButton.setEnabled(true);
                }
            });
            this._hostLabel = new JLabel(Messages.getString("TimesTenGrid.hostNameLabel"));
            this._hostLabel.setLabelFor(this._useDefaultCheckBox);
            this._intAddressTxtField = new AutoCompleteComponent(20, HostObject.getHostInternalAddressSuggestions());
            this._intAddressTxtField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    DataInstancePanel.this._extAddressTxtField.setText(DataInstancePanel.this._intAddressTxtField.getText());
                }
            });
            this._intAddressTxtField.getDocument().addDocumentListener(this);
            this._extAddressTxtField = new AutoCompleteComponent(20, HostObject.getHostInternalAddressSuggestions());
            this._extAddressTxtField.getDocument().addDocumentListener(this);
            this._nameTxtField = new AutoCompleteComponent(20, InstanceObject.getInstanceNameSuggestions());
            this._nameTxtField.getDocument().addDocumentListener(this);
            this._daemonPortTxtField = new AutoCompleteComponent(20, InstanceObject.getInstanceDaemonPortSuggestions());
            this._daemonPortTxtField.getDocument().addDocumentListener(this);
            this._csPortTxtField = new AutoCompleteComponent(20, InstanceObject.getInstanceCSPortSuggestions());
            this._csPortTxtField.getDocument().addDocumentListener(this);
            this._locationTxtField = new AutoCompleteComponent(20, InstanceObject.getInstanceHomeSuggestions());
            this._locationTxtField.getDocument().addDocumentListener(this);
            this._installLocationTxtField = new AutoCompleteComponent(20, InstallationObject.getInstallationLocationSuggestions());
            this._installLocationTxtField.getDocument().addDocumentListener(this);
            this._saveButton = new JButton(StringUtils.stripMnemonic((String)Messages.getString("TimesTenStatistics.save")));
            this._saveButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("TimesTenStatistics.save")));
            this._saveButton.addActionListener(this);
            this._useDefaultCheckBox.setSelected(true);
            this._saveButton.setEnabled(false);
            this._intAddressLabel = new JLabel(Messages.getString("TimesTenGrid.internalAddrLabel"));
            this._intAddressLabel.setLabelFor(this._intAddressTxtField);
            this._extAddressLabel = new JLabel(Messages.getString("TimesTenGrid.externalAddrLabel"));
            this._extAddressLabel.setLabelFor(this._extAddressTxtField);
            this._nameLabel = new JLabel(Messages.getString("TimesTenGrid.instanceNameLabel"));
            this._nameLabel.setLabelFor(this._nameTxtField);
            this._csPortLabel = new JLabel(Messages.getString("TimesTenGrid.csPortLabel"));
            this._csPortLabel.setLabelFor(this._csPortTxtField);
            this._daemonPortLabel = new JLabel(Messages.getString("TimesTenGrid.daemonPortLabel"));
            this._daemonPortLabel.setLabelFor(this._daemonPortTxtField);
            this._locationLabel = new JLabel(Messages.getString("TimesTenGrid.instLocLabel"));
            this._locationLabel.setLabelFor(this._locationTxtField);
            this._installLocationLabel = new JLabel(Messages.getString("TimesTenGrid.installLocLabel"));
            this._installLocationLabel.setLabelFor(this._installLocationTxtField);
            this.add((Component)this._hostLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(20, 5, 20, 5), 0, 0));
            this.add((Component)this._hostTxtField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(20, 5, 20, 5), 0, 0));
            this.add((Component)this._useDefaultCheckBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(20, 5, 20, 5), 0, 0));
            this.add((Component)this._intAddressLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 23, 0, new Insets(20, 5, 20, 5), 0, 0));
            this.add((Component)this._intAddressTxtField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(20, 5, 20, 5), 0, 0));
            this.add((Component)this._extAddressLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 0, new Insets(20, 5, 20, 5), 0, 0));
            this.add((Component)this._extAddressTxtField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(20, 5, 20, 5), 0, 0));
            this.add((Component)this._nameLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 23, 0, new Insets(20, 5, 20, 5), 0, 0));
            this.add((Component)this._nameTxtField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 21, 2, new Insets(20, 5, 20, 5), 0, 0));
            this.add((Component)this._locationLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 23, 0, new Insets(20, 5, 20, 5), 0, 0));
            this.add((Component)this._locationTxtField, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 21, 2, new Insets(20, 5, 20, 5), 0, 0));
            this.add((Component)this._daemonPortLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 23, 0, new Insets(20, 5, 20, 5), 0, 0));
            this.add((Component)this._daemonPortTxtField, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 21, 2, new Insets(20, 5, 20, 5), 0, 0));
            this.add((Component)this._csPortLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 23, 0, new Insets(20, 5, 20, 5), 0, 0));
            this.add((Component)this._csPortTxtField, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 21, 2, new Insets(20, 5, 20, 5), 0, 0));
            this.add((Component)this._installLocationLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 23, 0, new Insets(20, 5, 20, 5), 0, 0));
            this.add((Component)this._installLocationTxtField, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 21, 2, new Insets(20, 5, 20, 5), 0, 0));
            this.add((Component)this._saveButton, new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 22, 0, new Insets(10, 5, 20, 5), 0, 0));
            this.setNames();
        }

        public void setInstance(Instance instance) {
            this.instance = instance;
            if (instance != null) {
                this._hostTxtField.setText(instance.getHostName());
                this._useDefaultCheckBox.setSelected(instance.getUseDefaultHostName());
                this._saveButton.setEnabled(false);
                this._intAddressTxtField.setText(instance.getInternalAddress());
                this._extAddressTxtField.setText(instance.getExternalAddress());
                this._nameTxtField.setText(instance.getName());
                this._locationTxtField.setText(instance.getLocation());
                this._daemonPortTxtField.setText(String.valueOf(instance.getDaemonPort()));
                this._csPortTxtField.setText(String.valueOf(instance.getCSPort()));
                this._installLocationTxtField.setText(instance.getInstallLocation());
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.saveInstance();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)DataInstancesPanel.this._dataInstTree.getSelectionModel().getSelectionPath().getLastPathComponent();
            defaultMutableTreeNode.setUserObject(this.instance.getCompositeName());
            DataInstancesPanel.this._treeModel.reload(defaultMutableTreeNode);
        }

        public void saveInstance() {
            this.instance.setHostName(this._hostTxtField.getText().trim());
            this.instance.setUseDefaultHostName(this._useDefaultCheckBox.isSelected());
            this.instance.setInternalAddress(this._intAddressTxtField.getText().trim());
            this.instance.setExternalAddress(this._extAddressTxtField.getText().trim());
            this.instance.setName(this._nameTxtField.getText().trim());
            this.instance.setLocation(this._locationTxtField.getText().trim());
            try {
                this.instance.setDaemonPort(Integer.parseInt(this._daemonPortTxtField.getText().trim()));
            }
            catch (NumberFormatException numberFormatException) {
                _logger.log(Level.INFO, numberFormatException.getMessage());
                this.instance.setDaemonPort(0);
            }
            try {
                this.instance.setCSPort(Integer.parseInt(this._csPortTxtField.getText().trim()));
            }
            catch (NumberFormatException numberFormatException) {
                _logger.log(Level.INFO, numberFormatException.getMessage());
                this.instance.setCSPort(0);
            }
            this.instance.setInstallLocation(this._installLocationTxtField.getText().trim());
            for (int i = 0; i < this.modified.length; ++i) {
                this.modified[i] = false;
            }
            this._saveButton.setEnabled(false);
            if (!this._useDefaultCheckBox.isSelected()) {
                TTGridRootNode.getStorage().saveSuggestion("hostName", this.instance.getHostName());
            }
            TTGridRootNode.getStorage().saveSuggestion("externalAddress", this.instance.getExternalAddress());
            TTGridRootNode.getStorage().saveSuggestion("internalAddress", this.instance.getInternalAddress());
            TTGridRootNode.getStorage().saveSuggestion("daemonPort", String.valueOf(this.instance.getDaemonPort()));
            TTGridRootNode.getStorage().saveSuggestion("csPort", String.valueOf(this.instance.getCSPort()));
            TTGridRootNode.getStorage().saveSuggestion("instanceHome", this.instance.getLocation());
            TTGridRootNode.getStorage().saveSuggestion("installationLocation", this.instance.getInstallLocation());
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.verifyChange(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.verifyChange(documentEvent);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.verifyChange(documentEvent);
        }

        private void verifyChange(DocumentEvent documentEvent) {
            Object object;
            Document document = documentEvent.getDocument();
            if (document == this._hostTxtField.getDocument()) {
                this.modified[FocusedComponent.HOST_NAME_TXTFIELD.ordinal()] = !this.instance.getHostName().equals(this._hostTxtField.getText().trim());
            } else if (document == this._intAddressTxtField.getDocument()) {
                this.modified[FocusedComponent.INT_ADDR_TXTFIELD.ordinal()] = !this.instance.getInternalAddress().equals(this._intAddressTxtField.getText().trim());
            } else if (document == this._extAddressTxtField.getDocument()) {
                this.modified[FocusedComponent.EXT_ADDR_TXTFIELD.ordinal()] = !this.instance.getExternalAddress().equals(this._extAddressTxtField.getText().trim());
            } else if (document == this._nameTxtField.getDocument()) {
                this.modified[FocusedComponent.NAME_TXTFIELD.ordinal()] = !this.instance.getName().equals(this._nameTxtField.getText().trim());
            } else if (document == this._locationTxtField.getDocument()) {
                this.modified[FocusedComponent.LOCATION_TXTFIELD.ordinal()] = !this.instance.getLocation().equals(this._locationTxtField.getText().trim());
            } else if (document == this._daemonPortTxtField.getDocument()) {
                object = String.valueOf(this.instance.getDaemonPort());
                this.modified[FocusedComponent.DAEMON_PORT_TXTFIELD.ordinal()] = !((String)object).equals(this._daemonPortTxtField.getText().trim());
            } else if (document == this._csPortTxtField.getDocument()) {
                object = String.valueOf(this.instance.getCSPort());
                this.modified[FocusedComponent.CS_PORT_TXTFIELD.ordinal()] = !((String)object).equals(this._csPortTxtField.getText().trim());
            } else if (document == this._installLocationTxtField.getDocument()) {
                this.modified[FocusedComponent.INSTALL_LOC_TXTFIELD.ordinal()] = !this.instance.getInstallLocation().equals(this._installLocationTxtField.getText().trim());
            }
            for (boolean bl : this.modified) {
                if (!bl) continue;
                this._saveButton.setEnabled(true);
                return;
            }
            this._saveButton.setEnabled(false);
        }

        private void setNames() {
            this._hostLabel.setName(Messages.getString("TimesTenGrid.hostNameLabel"));
            this._extAddressLabel.setName(Messages.getString("TimesTenGrid.externalAddrLabel"));
            this._intAddressLabel.setName(Messages.getString("TimesTenGrid.internalAddrLabel"));
            this._nameLabel.setName(Messages.getString("TimesTenGrid.instanceNameLabel"));
            this._daemonPortLabel.setName(Messages.getString("TimesTenGrid.daemonPortLabel"));
            this._csPortLabel.setName(Messages.getString("TimesTenGrid.csPortLabel"));
            this._locationLabel.setName(Messages.getString("TimesTenGrid.instLocLabel"));
            this._installLocationLabel.setName(Messages.getString("TimesTenGrid.installLocLabel"));
            this._hostTxtField.setName("_hostTxtField", "_hostCmbBox");
            this._extAddressTxtField.setName("_extAddressTxtField", "_extAddressCmbBox");
            this._intAddressTxtField.setName("_intAddressTxtField", "_intAddressCmbBox");
            this._nameTxtField.setName("_nameTxtField", "_nameCmbBox");
            this._daemonPortTxtField.setName("_daemonPortTxtField", "_daemonPortCmbBox");
            this._csPortTxtField.setName("_csPortTxtField", "_csPortCmbBox");
            this._locationTxtField.setName("_locationTxtField", "_locationCmbBox");
            this._installLocationTxtField.setName("_installLocationTxtField", "_installLocationCmbBox");
            this._useDefaultCheckBox.setName(Messages.getString("TimesTenGrid.useDefault"));
            this._saveButton.setName(Messages.getString("TimesTenStatistics.save"));
        }
    }

    private class CustomTreeIconRenderer
    extends DefaultTreeCellRenderer {
        private CustomTreeIconRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                if (defaultMutableTreeNode != DataInstancesPanel.this._treeRoot) {
                    this.setIcon(Common.INSTANCE_ICON);
                } else {
                    this.setIcon(Common.FOLDER_ICON);
                }
            }
            return this;
        }
    }

    class Instance {
        private String hostName;
        private String intAddr;
        private String extAddr;
        private String name;
        private int csPort;
        private int daemonPort;
        private String location;
        private String installLocation;
        private boolean localHost;
        private boolean useDefaultHostName;

        public Instance(String string, String string2, String string3, String string4, int n, int n2, String string5, String string6) {
            this.hostName = string;
            if (string.isEmpty()) {
                this.useDefaultHostName = true;
            }
            this.intAddr = string2;
            this.extAddr = string3;
            this.name = string4;
            this.csPort = n;
            this.daemonPort = n2;
            this.location = string5;
            this.installLocation = string6;
        }

        public String getHostName() {
            return this.hostName;
        }

        public void setHostName(String string) {
            this.hostName = string;
        }

        public String getInternalAddress() {
            return this.intAddr;
        }

        public void setInternalAddress(String string) {
            this.intAddr = string;
        }

        public String getExternalAddress() {
            return this.extAddr;
        }

        public void setExternalAddress(String string) {
            this.extAddr = string;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public int getCSPort() {
            return this.csPort;
        }

        public void setCSPort(int n) {
            this.csPort = n;
        }

        public int getDaemonPort() {
            return this.daemonPort;
        }

        public void setDaemonPort(int n) {
            this.daemonPort = n;
        }

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String string) {
            this.location = string;
        }

        public String getInstallLocation() {
            return this.installLocation;
        }

        public void setInstallLocation(String string) {
            this.installLocation = string;
        }

        public boolean isLocalHost() {
            return this.localHost;
        }

        public void setIsLocalHost(boolean bl) {
            this.localHost = bl;
        }

        public boolean getUseDefaultHostName() {
            return this.useDefaultHostName;
        }

        public void setUseDefaultHostName(boolean bl) {
            this.useDefaultHostName = bl;
        }

        private String getHName() {
            String string = this.hostName;
            if (string.isEmpty() && !this.extAddr.isEmpty()) {
                string = this.extAddr;
            }
            return string;
        }

        public String getCompositeName() {
            return this.getHName() + "." + this.name;
        }

        public boolean equals(Object object) {
            Instance instance = (Instance)object;
            return this.name.equalsIgnoreCase(instance.getName()) && this.getHName().equalsIgnoreCase(instance.getHName());
        }
    }

    public static class Host
    implements TopologyElement {
        String name;
        String intAddr;
        String extAddr;
        List<Instance> instances;
        int dsg;
        boolean editDSG;

        public Host(String string, String string2) {
            this.intAddr = string;
            this.extAddr = string2;
            this.editDSG = true;
            this.instances = new ArrayList<Instance>();
        }

        public String getName() {
            return this.name;
        }

        public String getInternalAddress() {
            return this.intAddr;
        }

        public String getExternalAddress() {
            return this.extAddr;
        }

        public String getInstanceName() {
            if (this.instances.size() > 0) {
                return this.instances.get(0).getCompositeName();
            }
            return null;
        }

        public void setName(String string) {
            this.name = string;
        }

        public List<Instance> getInstances() {
            return this.instances;
        }

        public int getDSG() {
            return this.dsg;
        }

        public void setDSG(int n) {
            this.dsg = n;
        }

        public boolean getEditDSG() {
            return this.editDSG;
        }

        public void setEditDSG(boolean bl) {
            this.editDSG = bl;
        }

        public boolean equals(Object object) {
            try {
                Host host = (Host)object;
                return this.name.equalsIgnoreCase(host.getName());
            }
            catch (Exception exception) {
                _logger.log(Level.INFO, exception.getMessage());
                return false;
            }
        }

        @Override
        public int getDataSpaceGroup() {
            return this.dsg;
        }

        @Override
        public int getReplicaSet() {
            return 0;
        }

        @Override
        public boolean isAppliedInTopology() {
            return false;
        }

        @Override
        public boolean isMarkedToBeAdded() {
            return false;
        }

        @Override
        public boolean isMarkedToBeRemoved() {
            return false;
        }

        @Override
        public boolean hasRS() {
            return false;
        }

        @Override
        public boolean hasDSG() {
            return false;
        }

        @Override
        public boolean isAddableToTopology() {
            return true;
        }

        @Override
        public String getFailStateMessage() {
            return null;
        }

        @Override
        public boolean isSameElement(String string) {
            return string.equals(this.name);
        }

        @Override
        public boolean isRemovableAfterApply() {
            return true;
        }
    }
}

