/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.CreateGridTask;
import oracle.dbtools.raptor.timesten.grid.DataInstancesPanel;
import oracle.dbtools.raptor.timesten.utils.TableColumnSizer;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class SummaryTraversablePanel
extends DefaultTraversablePanel {
    private JTabbedPane _tabbedPane;
    private SummaryPanel _summaryPanel;
    private static final String[] ATTRIBUTES = new String[]{Messages.getString("TimesTenGrid.gridNameLabel"), Messages.getString("TimesTenGrid.kSafetyLabel"), Messages.getString("TimesTenGrid.mgmtInstancesLabel"), Messages.getString("TimesTenGrid.dataInstancesLabel"), Messages.getString("TimesTenGrid.unassignedHostsLabel"), Messages.getString("TimesTenGrid.totalHostsLabel")};
    private static final String[] HEADER = new String[]{Messages.getString("TimesTen.common.attribute"), Messages.getString("TimesTen.common.value")};
    private static final int ATTR_COL = 0;
    private static final int VAL_COL = 1;
    private static final int GRID_NAME_COL = 0;
    private static final int K_SAFETY_COL = 1;
    private static final int MGMT_INSTS_COL = 2;
    private static final int DATA_INSTS_COL = 3;
    private static final int SPARE_HOSTS_COL = 4;
    private static final int TOTAL_HOSTS_COL = 5;
    TraversableContext dataContext;
    List<DataInstancesPanel.Host> hosts;
    int spare;
    int nInstances;

    public SummaryTraversablePanel() {
        this.setLayout(new GridBagLayout());
        this._summaryPanel = new SummaryPanel();
        this._tabbedPane = new JTabbedPane();
        this._tabbedPane.addTab(Messages.getString("TimesTenGrid.summary"), this._summaryPanel);
        this.add(this._tabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        this.dataContext = traversableContext;
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true));
        this.hosts = (List)traversableContext.get("HOSTS");
        if (this.hosts != null) {
            this.spare = 0;
            this.nInstances = 0;
            for (DataInstancesPanel.Host host : this.hosts) {
                if (host.getDSG() == 0) {
                    ++this.spare;
                }
                this.nInstances += host.getInstances().size();
            }
        }
        this._summaryPanel.setAttributesTable();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 2) {
            return;
        }
        this._summaryPanel.createGrid();
    }

    public Object getExitTransition() {
        return this.getTransition();
    }

    private Object getTransition() {
        return null;
    }

    private class SummaryTableModel
    extends AbstractTableModel {
        private SummaryTableModel() {
        }

        @Override
        public int getRowCount() {
            return ATTRIBUTES.length;
        }

        @Override
        public int getColumnCount() {
            return HEADER.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return ATTRIBUTES[n];
                }
                case 1: {
                    if (ATTRIBUTES[n].equals(ATTRIBUTES[0])) {
                        return (String)SummaryTraversablePanel.this.dataContext.get("GRID_NAME");
                    }
                    if (ATTRIBUTES[n].equals(ATTRIBUTES[1])) {
                        return String.valueOf(SummaryTraversablePanel.this.dataContext.get("K_SAFETY"));
                    }
                    if (ATTRIBUTES[n].equals(ATTRIBUTES[2])) {
                        return String.valueOf(1);
                    }
                    if (ATTRIBUTES[n].equals(ATTRIBUTES[3])) {
                        return String.valueOf(SummaryTraversablePanel.this.nInstances);
                    }
                    if (ATTRIBUTES[n].equals(ATTRIBUTES[4])) {
                        return String.valueOf(SummaryTraversablePanel.this.spare);
                    }
                    if (ATTRIBUTES[n].equals(ATTRIBUTES[5])) {
                        if (SummaryTraversablePanel.this.hosts != null) {
                            return String.valueOf(SummaryTraversablePanel.this.hosts.size());
                        }
                        return "0";
                    }
                    return null;
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            return HEADER[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }
    }

    private class SummaryPanel
    extends JPanel {
        private JScrollPane _scrollPane;
        private JTable _summaryTable;
        private SummaryTableModel _model;
        private CreateGridTask task;

        public SummaryPanel() {
            this.setLayout(new GridBagLayout());
            this._model = new SummaryTableModel();
            this._summaryTable = new JTable(this._model);
            this._scrollPane = new JScrollPane(this._summaryTable);
            this.add((Component)this._scrollPane, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 0, 10, 0), 0, 0));
        }

        public void setAttributesTable() {
            TableColumnSizer.setColumnsWidthToFit(this._summaryTable, true, true);
        }

        public void createGrid() {
            this.task = new CreateGridTask(SummaryTraversablePanel.this.dataContext);
            this.task.execute();
        }
    }
}

