/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.database;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.database.DBDetailedConnectionsPanel;
import oracle.dbtools.raptor.timesten.grid.object.DatabaseObject;
import oracle.dbtools.raptor.timesten.grid.object.Element;
import oracle.dbtools.raptor.timesten.utils.TableColumnSizer;

public class DatabaseSummaryPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String EMPTY_STRING = "";
    private ArrayList<DBSummaryEntry> tableData;
    private JLabel dbstatusLabel;
    private JLabel connectionsLabel;
    private JLabel connectionNumberLabel;
    private JLabel sysConnectionsLabel;
    private JLabel distributedInLabel;
    private DatabaseObject currentDB;
    private final String[] HEADER = new String[]{Messages.getString("TimesTenGrid.element"), Messages.getString("TimesTen.common.hostName"), Messages.getString("TimesTenGrid.instanceName"), Messages.getString("TimesTenGrid.elemInDistMap"), Messages.getString("TimesTenGrid.hostDSG"), Messages.getString("TimesTenGrid.replicaSet"), Messages.getString("TimesTenGrid.daemonPortColumn"), Messages.getString("TimesTenGrid.csPortColumn"), Messages.getString("TimesTenGrid.daemonstatus"), Messages.getString("TimesTenGrid.serverstatus"), Messages.getString("TimesTenGrid.dbstatus"), Messages.getString("TimesTenGrid.message")};
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private DatabaseSummaryTableModel _model;
    private JTable _table;
    private JScrollPane _scrollPane;

    public DatabaseSummaryPanel() {
        this.tableData = new ArrayList();
        this.initGUI();
    }

    public void initGUI() {
        this.setLayout(new GridBagLayout());
        this._model = new DatabaseSummaryTableModel();
        this.dbstatusLabel = new JLabel();
        this.connectionsLabel = new JLabel();
        this.sysConnectionsLabel = new JLabel();
        this.connectionNumberLabel = new JLabel();
        this.connectionNumberLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    return;
                }
                if (DatabaseSummaryPanel.this.currentDB == null) {
                    return;
                }
                DBDetailedConnectionsPanel.showDetailedConnections(DatabaseSummaryPanel.this.currentDB);
            }
        });
        this.distributedInLabel = new JLabel();
        this._table = new JTable(this._model){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                String string = DatabaseSummaryPanel.EMPTY_STRING;
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                int n3 = DatabaseSummaryPanel.this._table.convertRowIndexToModel(n);
                try {
                    string = n2 == ColIdx.SERVER_STATUS.ordinal() ? (DatabaseSummaryPanel.this.tableData.get(n3).getServerStatus() ? Messages.getString("TimesTenGrid.up") : Messages.getString("TimesTenGrid.down")) : (n2 == ColIdx.DAEMON_STATUS.ordinal() ? (DatabaseSummaryPanel.this.tableData.get(n3).getDaemonStatus() ? Messages.getString("TimesTenGrid.up") : Messages.getString("TimesTenGrid.down")) : DatabaseSummaryPanel.this._table.getValueAt(n, n2).toString());
                }
                catch (RuntimeException runtimeException) {
                    DatabaseSummaryPanel.this.logger.log(Level.SEVERE, runtimeException.getMessage());
                }
                return string;
            }
        };
        this._table.setAutoResizeMode(0);
        this._table.setRowSelectionAllowed(false);
        this._table.setColumnSelectionAllowed(false);
        this._table.setAutoCreateRowSorter(true);
        TableColumnModel tableColumnModel = this._table.getColumnModel();
        tableColumnModel.getColumn(ColIdx.SERVER_STATUS.ordinal()).setCellRenderer(new IconTextCellRenderer());
        tableColumnModel.getColumn(ColIdx.DAEMON_STATUS.ordinal()).setCellRenderer(new IconTextCellRenderer());
        this._scrollPane = new JScrollPane(this._table);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(this.connectionsLabel);
        jPanel.add(this.connectionNumberLabel);
        jPanel.setBorder(new EmptyBorder(0, -5, 0, 0));
        Common.styleAsHyperLink(this.connectionNumberLabel);
        this.add((Component)this.dbstatusLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 0, new Insets(10, 10, 5, 10), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 21, 0, new Insets(5, 10, 5, 10), 0, 0));
        this.add((Component)this.sysConnectionsLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 21, 0, new Insets(5, 10, 5, 10), 0, 0));
        this.add((Component)this.distributedInLabel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 21, 0, new Insets(5, 10, 5, 10), 0, 0));
        this.add((Component)this._scrollPane, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.setDefaultLabels();
    }

    private void setDefaultLabels() {
        String string = EMPTY_STRING;
        this.dbstatusLabel.setText(MessageFormat.format(Messages.getString("TimesTenGrid.dbStatusLabel"), string, string));
        this.connectionsLabel.setText(MessageFormat.format(Messages.getString("TimesTenGrid.dbAppConnLabel"), EMPTY_STRING));
        this.connectionNumberLabel.setText(string);
        this.sysConnectionsLabel.setText(MessageFormat.format(Messages.getString("TimesTenGrid.dbSysConnLabel"), string, string));
        this.distributedInLabel.setText(MessageFormat.format(Messages.getString("TimesTenGrid.dbDistIn"), string));
        DBSummaryEntry dBSummaryEntry = new DBSummaryEntry();
        dBSummaryEntry.setHostName(string);
        dBSummaryEntry.setInstanceName(string);
        dBSummaryEntry.setServerPort(string);
        dBSummaryEntry.setDaemonPort(string);
        dBSummaryEntry.setDbStatus(string);
        dBSummaryEntry.setDataSpaceGroup(0);
        dBSummaryEntry.setReplicaSet(0);
        dBSummaryEntry.setServerStatus(false);
        dBSummaryEntry.setDaemonStatus(false);
        dBSummaryEntry.setStatusAvailable(false);
        dBSummaryEntry.setInDistMap(false);
        dBSummaryEntry.setMessage(string);
        dBSummaryEntry.setElementId(0);
        this.tableData.add(dBSummaryEntry);
        TableColumnSizer.setColumnsWidthToFit(this._table, true, true);
        this._model.fireTableDataChanged();
    }

    public void update(DatabaseObject databaseObject, boolean bl) {
        DBSummaryEntry dBSummaryEntry = null;
        this.tableData.clear();
        this.currentDB = databaseObject;
        for (Element element : databaseObject.getAllElements()) {
            dBSummaryEntry = new DBSummaryEntry();
            dBSummaryEntry.setHostName(element.getInstance().getHost().getName());
            dBSummaryEntry.setInstanceName(element.getInstance().getName());
            dBSummaryEntry.setServerPort(String.valueOf(element.getInstance().getCSPort()));
            dBSummaryEntry.setDaemonPort(String.valueOf(element.getInstance().getDaemonPort()));
            dBSummaryEntry.setDbStatus(element.getState());
            dBSummaryEntry.setDataSpaceGroup(element.getInstance().getDSG());
            dBSummaryEntry.setReplicaSet(element.getReplicaSet());
            dBSummaryEntry.setServerStatus(element.getInstance().getCSState());
            dBSummaryEntry.setDaemonStatus(element.getInstance().getDaemonStatus());
            dBSummaryEntry.setInDistMap(element.isInCurrentDistMap());
            dBSummaryEntry.setMessage(element.getMessage());
            dBSummaryEntry.setElementId(element.getId());
            dBSummaryEntry.setStatusAvailable(bl);
            this.tableData.add(dBSummaryEntry);
            dBSummaryEntry = null;
        }
        Collections.sort(this.tableData);
        this.updateLabels(databaseObject);
    }

    private void setLabelText(DatabaseObject databaseObject) {
        this.dbstatusLabel.setText(MessageFormat.format(Messages.getString("TimesTenGrid.dbStatusLabel"), databaseObject.getName(), databaseObject.getDBStatus().getSummary()));
        this.connectionsLabel.setText(MessageFormat.format(Messages.getString("TimesTenGrid.dbAppConnLabel"), databaseObject.getName()));
        this.connectionNumberLabel.setText(Integer.toString(databaseObject.getAppConnections()));
        this.sysConnectionsLabel.setText(MessageFormat.format(Messages.getString("TimesTenGrid.dbSysConnLabel"), databaseObject.getName(), databaseObject.getSystemConnections()));
        this.distributedInLabel.setText(MessageFormat.format(Messages.getString("TimesTenGrid.dbDistIn"), databaseObject.getDistributionMap().getElementsInDistMap().size()));
        TableColumnSizer.setColumnsWidthToFit(this._table, true, true);
        this._model.fireTableDataChanged();
    }

    private void updateLabels(final DatabaseObject databaseObject) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setLabelText(databaseObject);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DatabaseSummaryPanel.this.setLabelText(databaseObject);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                this.logger.log(Level.INFO, exception.getMessage());
            }
        }
    }

    private class IconTextCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private IconTextCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            int n3 = DatabaseSummaryPanel.this._table.convertRowIndexToModel(n);
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n3, n2);
            if (!DatabaseSummaryPanel.this.tableData.get(n3).isStatusAvailable()) {
                jLabel.setText(Messages.getString("TimesTen.common.unknown"));
                jLabel.setIcon(null);
                jLabel.setHorizontalAlignment(0);
                return jLabel;
            }
            boolean bl3 = false;
            if (n2 == ColIdx.SERVER_STATUS.ordinal()) {
                bl3 = DatabaseSummaryPanel.this.tableData.get(n3).getServerStatus();
            } else if (n2 == ColIdx.DAEMON_STATUS.ordinal()) {
                bl3 = DatabaseSummaryPanel.this.tableData.get(n3).getDaemonStatus();
            }
            jLabel.setText(bl3 ? Messages.getString("TimesTenGrid.up") : Messages.getString("TimesTenGrid.down"));
            jLabel.setIcon(bl3 ? Common.UP_ICON : Common.DOWN_ICON);
            jLabel.setHorizontalAlignment(0);
            return jLabel;
        }
    }

    private static class DBSummaryEntry
    implements Comparable<DBSummaryEntry> {
        private String instanceName;
        private String hostName;
        private String daemonPort;
        private String serverPort;
        private String dbStatus;
        private boolean serverUp;
        private boolean daemonUp;
        private boolean inDistMap;
        private String message;
        private int elementId;
        private int dataSpaceGroup;
        private int replicaSet;
        private boolean statusAvailable;

        private DBSummaryEntry() {
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String string) {
            this.instanceName = string;
        }

        public String getHostName() {
            return this.hostName;
        }

        public void setHostName(String string) {
            this.hostName = string;
        }

        public String getDaemonPort() {
            return this.daemonPort;
        }

        public void setDaemonPort(String string) {
            this.daemonPort = string;
        }

        public String getServerPort() {
            return this.serverPort;
        }

        public void setServerPort(String string) {
            this.serverPort = string;
        }

        public String getDbStatus() {
            return this.dbStatus;
        }

        public void setDbStatus(String string) {
            this.dbStatus = string;
        }

        public int getDataSpaceGroup() {
            return this.dataSpaceGroup;
        }

        public void setDataSpaceGroup(int n) {
            this.dataSpaceGroup = n;
        }

        public int getReplicaSet() {
            return this.replicaSet;
        }

        public void setReplicaSet(int n) {
            this.replicaSet = n;
        }

        public boolean getServerStatus() {
            return this.serverUp;
        }

        public void setServerStatus(boolean bl) {
            this.serverUp = bl;
        }

        public boolean getDaemonStatus() {
            return this.daemonUp;
        }

        public void setDaemonStatus(boolean bl) {
            this.daemonUp = bl;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String string) {
            this.message = string;
        }

        public boolean isInDistMap() {
            return this.inDistMap;
        }

        public void setInDistMap(boolean bl) {
            this.inDistMap = bl;
        }

        public int getElementId() {
            return this.elementId;
        }

        public void setElementId(int n) {
            this.elementId = n;
        }

        public boolean isStatusAvailable() {
            return this.statusAvailable;
        }

        public void setStatusAvailable(boolean bl) {
            this.statusAvailable = bl;
        }

        @Override
        public int compareTo(DBSummaryEntry dBSummaryEntry) {
            int n = new Boolean(dBSummaryEntry.isInDistMap()).compareTo(this.isInDistMap());
            return n == 0 ? new Integer(this.getElementId()).compareTo(dBSummaryEntry.getElementId()) : n;
        }
    }

    private class DatabaseSummaryTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private DatabaseSummaryTableModel() {
        }

        @Override
        public int getRowCount() {
            return DatabaseSummaryPanel.this.tableData.size();
        }

        @Override
        public int getColumnCount() {
            return DatabaseSummaryPanel.this.HEADER.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == ColIdx.INSTANCE.ordinal()) {
                return DatabaseSummaryPanel.this.tableData.get(n).getInstanceName();
            }
            if (n2 == ColIdx.HOST.ordinal()) {
                return DatabaseSummaryPanel.this.tableData.get(n).getHostName();
            }
            if (n2 == ColIdx.DAEMON_PORT.ordinal()) {
                return DatabaseSummaryPanel.this.tableData.get(n).getDaemonPort();
            }
            if (n2 == ColIdx.SERVER_PORT.ordinal()) {
                return DatabaseSummaryPanel.this.tableData.get(n).getServerPort();
            }
            if (n2 == ColIdx.STATUS.ordinal()) {
                return DatabaseSummaryPanel.this.tableData.get(n).getDbStatus();
            }
            if (n2 == ColIdx.SERVER_STATUS.ordinal()) {
                return DatabaseSummaryPanel.this.tableData.get(n).getServerStatus() ? Common.UP_ICON : Common.DOWN_ICON;
            }
            if (n2 == ColIdx.DAEMON_STATUS.ordinal()) {
                return DatabaseSummaryPanel.this.tableData.get(n).getDaemonStatus() ? Common.UP_ICON : Common.DOWN_ICON;
            }
            if (n2 == ColIdx.IN_DIST_MAP.ordinal()) {
                return DatabaseSummaryPanel.this.tableData.get(n).isInDistMap() ? Messages.getString("TimesTen.common.yes") : Messages.getString("TimesTen.common.no");
            }
            if (n2 == ColIdx.MESSAGE.ordinal()) {
                return DatabaseSummaryPanel.this.tableData.get(n).getMessage();
            }
            if (n2 == ColIdx.ELEMENTID.ordinal()) {
                return DatabaseSummaryPanel.this.tableData.get(n).getElementId();
            }
            if (n2 == ColIdx.DSG.ordinal()) {
                return DatabaseSummaryPanel.this.tableData.get(n).getDataSpaceGroup();
            }
            if (n2 == ColIdx.REPLICA_SET.ordinal()) {
                return DatabaseSummaryPanel.this.tableData.get(n).isInDistMap() ? Integer.valueOf(DatabaseSummaryPanel.this.tableData.get(n).getReplicaSet()) : DatabaseSummaryPanel.EMPTY_STRING;
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            return DatabaseSummaryPanel.this.HEADER[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    static enum ColIdx {
        ELEMENTID,
        HOST,
        INSTANCE,
        IN_DIST_MAP,
        DSG,
        REPLICA_SET,
        DAEMON_PORT,
        SERVER_PORT,
        DAEMON_STATUS,
        SERVER_STATUS,
        STATUS,
        MESSAGE;

    }
}

