/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.database;

import java.awt.Dimension;
import java.awt.Frame;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.database.WizardAttributesDefinition;
import oracle.dbtools.raptor.timesten.grid.database.WizardDistribute;
import oracle.dbtools.raptor.timesten.grid.database.WizardSummary;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.dbtools.raptor.ui.wizard.BigWizardDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;

public class WizardMain {
    static final String DB_DEF_STATE = "DefinitionState";
    static final String DB_DIST_STATE = "DistributeState";
    static final String SUMMARY_STATE = "SummaryState";
    static final String DB_DEF_TRANSITION = "Definition";
    static final String DB_DIST_TRANSITION = "Distribute";
    static final String SUMMARY_TRANSITION = "Summary";
    private static WizardMain INSTANCE;
    private static WizardDialog _currentDialog;
    private static Logger logger;

    public static WizardMain getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WizardMain();
        }
        return INSTANCE;
    }

    public void launchWizard() {
        this.launchWizard(WizardMain.getFSM());
    }

    private static FSM getFSM() {
        Step step = new Step(Messages.getString("TimesTenGrid.dbDef"), WizardAttributesDefinition.class, TimesTenHelpID.DBW_DB_DEF.toString());
        Step step2 = new Step(Messages.getString("TimesTenGrid.dbDist"), WizardDistribute.class, TimesTenHelpID.DBW_DISTRIBUTION.toString());
        Step step3 = new Step(Messages.getString("TimesTenGrid.summary"), WizardSummary.class, TimesTenHelpID.DBW_SUMMARY.toString());
        FSMBuilder fSMBuilder = new FSMBuilder();
        fSMBuilder.newStartState(step, null);
        fSMBuilder.addStateTrans((Object)DB_DIST_TRANSITION, (Object)DB_DIST_STATE);
        fSMBuilder.newState((Object)DB_DIST_STATE, step2, (Object)SUMMARY_STATE);
        fSMBuilder.newFinalState((Object)SUMMARY_STATE, step3);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            logger.log(Level.SEVERE, "Could not fire database wizard\n" + fSMInvalidException.getMessage());
            return null;
        }
    }

    private void launchWizard(FSM fSM) {
        Namespace namespace = new Namespace();
        FSMWizard fSMWizard = new FSMWizard(fSM, namespace);
        BigWizardDialog bigWizardDialog = new BigWizardDialog((BaseWizard)fSMWizard, (Frame)Ide.getMainWindow());
        _currentDialog = bigWizardDialog;
        fSMWizard.setDialog((WizardDialog)bigWizardDialog);
        bigWizardDialog.setPreferredSize(new Dimension(700, 600));
        bigWizardDialog.isCancelled();
        fSMWizard.setWizardTitle(Messages.getString("TimesTenGrid.dbCreatewizardTitle"));
        fSMWizard.setRoadmapVisible(true);
        WizardDialog wizardDialog = fSMWizard.getDialog((Frame)Ide.getMainWindow());
        WizardLauncher.runDialog((JDialog)wizardDialog);
    }

    public synchronized WizardDialog getCurrentWizardDialog() {
        return _currentDialog;
    }

    static {
        logger = Logger.getLogger(WizardMain.class.getName());
    }
}

