/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.editors.SummaryPanel;
import oracle.dbtools.raptor.timesten.grid.editors.TTBaseEditor;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.InstallationObject;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.help.HelpInfo;

public class InstallFolderEditor
extends TTBaseEditor {
    private InstallSummaryPanel _summaryPanel;
    private HostObject currentHost;
    private InstanceObject selectedInstance = null;
    private InstallationObject selectedInstall = null;
    static List<String> ATTRIBUTES = new ArrayList<String>();
    static List<String> ATTRIBUTES_EXT;

    public InstallFolderEditor() {
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        if (!this.initialized) {
            this._summaryPanel = new InstallSummaryPanel();
            this._tabbedPane.addTab(Messages.getString("TimesTenGrid.summary"), this._summaryPanel);
            this.helpInfo = new HelpInfo(TimesTenHelpID.INSTALLATION_FOLDER_EDITOR.toString());
            this.initialized = true;
        }
    }

    @Override
    public void updateContent() {
        this.refresh();
        this._summaryPanel.updateInfo();
    }

    @Override
    public boolean handleEvent(IdeAction ideAction, Context context) {
        super.handleEvent(ideAction, context);
        if (ideAction.getCommandId() == REFRESH_ID) {
            this.refresh();
            this._summaryPanel.updateInstallList();
            this._summaryPanel.updateInstList();
            this.updateContent();
            return true;
        }
        return false;
    }

    private void refresh() {
        boolean bl = this.currentHost == null;
        this.currentHost = this.currentGrid.getHost(TTGridRootNode.getInstance().getCurrentHost());
        if (bl) {
            this._summaryPanel.updateInstallList();
        }
    }

    static {
        ATTRIBUTES.add(Messages.getString("TimesTenGrid.installation"));
        ATTRIBUTES.add(Messages.getString("TimesTenGrid.installLoc"));
        ATTRIBUTES.add(Messages.getString("TimesTenGrid.installSrc"));
        ATTRIBUTES.add(Messages.getString("TimesTenGrid.installRelease"));
        ATTRIBUTES_EXT = new ArrayList<String>();
        ATTRIBUTES_EXT.add("");
        ATTRIBUTES_EXT.add(Messages.getString("TimesTenGrid.instanceName"));
        ATTRIBUTES_EXT.add(Messages.getString("TimesTenGrid.instHome"));
        ATTRIBUTES_EXT.add(Messages.getString("TimesTenGrid.instType"));
    }

    private class InstallSummaryPanel
    extends JPanel
    implements ListSelectionListener {
        private JPanel _leftPanel;
        private JPanel _installPanel;
        private JPanel _instPanel;
        private JList<String> _installList;
        private JList<String> _instList;
        private JScrollPane _installScrollPane;
        private JScrollPane _instScrollPane;
        private DefaultListModel<String> _installListModel;
        private DefaultListModel<String> _instListModel;
        private SummaryPanel _summPanel;

        public InstallSummaryPanel() {
            this.init();
        }

        private void init() {
            this.setLayout(new BorderLayout());
            this.initLeftPanel();
            this.initRightPanel();
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)this._leftPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 5, 5), 0, 0));
            jPanel.add((Component)this._summPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)jPanel, "First");
        }

        private void initRightPanel() {
            this._summPanel = new SummaryPanel();
            this._summPanel.setEmptyBorderOnScrollPane();
        }

        private void initLeftPanel() {
            this._installPanel = new JPanel(new GridBagLayout());
            this._installPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.installations")));
            this._installList = new JList();
            this._installList.getSelectionModel().setSelectionMode(0);
            this._installList.addListSelectionListener(this);
            this._installScrollPane = new JScrollPane(this._installList, 20, 30);
            this._installPanel.add((Component)this._installScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this._instPanel = new JPanel(new GridBagLayout());
            this._instPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.associatedInstances")));
            this._instList = new JList();
            this._instList.getSelectionModel().setSelectionMode(0);
            this._instList.addListSelectionListener(this);
            this._instScrollPane = new JScrollPane(this._instList, 20, 30);
            this._instPanel.add((Component)this._instScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this._leftPanel = new JPanel(new GridBagLayout());
            this._leftPanel.add((Component)this._installPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, new Insets(5, 5, 5, 5), 0, 0));
            this._leftPanel.add((Component)this._instPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 21, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.updateInstallList();
            this.updateInstList();
        }

        public void updateInstallList() {
            this._installListModel = new DefaultListModel();
            this._installList.setModel(this._installListModel);
            if (InstallFolderEditor.this.currentHost == null || InstallFolderEditor.this.currentHost.getInstallations().isEmpty()) {
                return;
            }
            for (InstallationObject installationObject : InstallFolderEditor.this.currentHost.getInstallations()) {
                this._installListModel.insertElementAt(installationObject.getName(), this._installListModel.getSize());
            }
            if (this._installList.getSelectionModel().getMaxSelectionIndex() == -1) {
                this._installList.getSelectionModel().setSelectionInterval(0, 0);
            }
        }

        public void updateInstList() {
            this._instListModel = new DefaultListModel();
            this._instList.setModel(this._instListModel);
            if (InstallFolderEditor.this.selectedInstall == null || InstallFolderEditor.this.selectedInstall.getInstancesUsing().isEmpty()) {
                return;
            }
            Collections.sort(InstallFolderEditor.this.selectedInstall.getInstancesUsing(), Common.INSTANCE_ORDER);
            for (InstanceObject instanceObject : InstallFolderEditor.this.selectedInstall.getInstancesUsing()) {
                this._instListModel.insertElementAt(instanceObject.getName(), this._instListModel.getSize());
            }
            if (this._instList.getSelectionModel().getMaxSelectionIndex() == -1) {
                this._instList.getSelectionModel().setSelectionInterval(0, 0);
            }
        }

        public void updateInfo() {
            ArrayList<String> arrayList;
            ArrayList<String> arrayList2 = arrayList = InstallFolderEditor.this.currentHost.getInstallations().isEmpty() ? new ArrayList<String>() : new ArrayList<String>(ATTRIBUTES);
            if (InstallFolderEditor.this.selectedInstance != null) {
                arrayList.addAll(ATTRIBUTES_EXT);
            }
            List<String> list = this.getValues();
            InstallFolderEditor.this.context.setProperty("SummaryAttr", arrayList);
            InstallFolderEditor.this.context.setProperty("SummaryVals", list);
            this._summPanel.loadContent(InstallFolderEditor.this.context);
        }

        public List<String> getValues() {
            int n;
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = ATTRIBUTES.size();
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                arrayList.add("");
            }
            if (InstallFolderEditor.this.selectedInstance != null) {
                n2 = ATTRIBUTES_EXT.size();
                for (n = 0; n < n2; ++n) {
                    arrayList.add("");
                }
            }
            if (InstallFolderEditor.this.selectedInstall != null) {
                arrayList.set(n3++, InstallFolderEditor.this.selectedInstall.getName());
                arrayList.set(n3++, InstallFolderEditor.this.selectedInstall.getLocation());
                arrayList.set(n3++, InstallFolderEditor.this.selectedInstall.getSource());
                arrayList.set(n3++, InstallFolderEditor.this.selectedInstall.getSourceRelease());
            }
            if (InstallFolderEditor.this.selectedInstance != null) {
                arrayList.set(n3++, "");
                arrayList.set(n3++, InstallFolderEditor.this.selectedInstance.getName());
                arrayList.set(n3++, InstallFolderEditor.this.selectedInstance.getHome());
                arrayList.set(n3++, InstallFolderEditor.this.selectedInstance.isMgmtInstance() ? Messages.getString("TimesTenGrid.management") : Messages.getString("TimesTenGrid.data"));
            }
            return arrayList;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getSource() == this._installList) {
                int n = this._installList.getSelectedIndex();
                InstallFolderEditor.this.selectedInstall = n >= 0 && n < this._installListModel.getSize() ? InstallFolderEditor.this.currentHost.getInstallation(this._installListModel.get(n)) : null;
                this.updateInstList();
                if (InstallFolderEditor.this.selectedInstall == null || InstallFolderEditor.this.selectedInstall.getInstancesUsing().isEmpty()) {
                    InstallFolderEditor.this.updateContent();
                }
                this.updateUI();
            } else if (listSelectionEvent.getSource() == this._instList) {
                int n = this._instList.getSelectedIndex();
                InstallFolderEditor.this.selectedInstance = n >= 0 && n < this._instListModel.getSize() ? InstallFolderEditor.this.currentHost.getInstance(this._instListModel.get(n)) : null;
                InstallFolderEditor.this.updateContent();
            }
        }
    }
}

