/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.editors;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.editors.RepositoryBackupInstancesPanel;
import oracle.dbtools.raptor.timesten.grid.editors.SummaryPanel;
import oracle.dbtools.raptor.timesten.grid.editors.TTBaseEditor;
import oracle.dbtools.raptor.timesten.grid.navigator.AbstractNode;
import oracle.dbtools.raptor.timesten.grid.object.RepositoryObject;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.help.HelpInfo;

public class RepositoryBackupEditor
extends TTBaseEditor {
    protected SummaryPanel _summaryPanel;
    protected RepositoryBackupInstancesPanel _instancesPanel;
    protected RepositoryObject currentRepository;
    protected RepositoryObject.Backup currentBackup;
    static List<String> BACKUP_SUMMARY = new ArrayList<String>();
    private static Logger logger;

    public RepositoryBackupEditor() {
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        if (!this.initialized) {
            this._summaryPanel = new SummaryPanel();
            this._tabbedPane.addTab(Messages.getString("TimesTenGrid.summary"), this._summaryPanel);
            this._instancesPanel = new RepositoryBackupInstancesPanel();
            this._tabbedPane.addTab(Messages.getString("TimesTenGrid.instances"), this._instancesPanel);
            this.helpInfo = new HelpInfo(TimesTenHelpID.REPOSITORY_BACKUP_EDITOR.toString());
            this.initialized = true;
        }
    }

    @Override
    public void updateContent() {
        AbstractNode abstractNode = (AbstractNode)this.context.getNode();
        AbstractNode abstractNode2 = abstractNode.getParentNode();
        this.currentRepository = this.currentGrid.getRepository(abstractNode2.getShortLabel());
        this.currentBackup = abstractNode.isBackupNode() ? this.currentRepository.getBackup(this.context.getNode().getShortLabel()) : this.currentRepository.getExport(this.context.getNode().getShortLabel());
        this.updateContentHelper();
    }

    public List<String> getValues() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = BACKUP_SUMMARY.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add("");
        }
        arrayList.set(0, this.currentBackup.getName());
        arrayList.set(1, this.currentBackup.getDbName());
        arrayList.set(2, this.currentBackup.getRepository());
        arrayList.set(3, this.currentBackup.getState());
        arrayList.set(4, this.currentBackup.getWhenStarted());
        return arrayList;
    }

    protected void updateContentHelper() {
        ArrayList<String> arrayList = new ArrayList<String>(BACKUP_SUMMARY);
        List<String> list = this.getValues();
        this.context.setProperty("SummaryAttr", arrayList);
        this.context.setProperty("SummaryVals", list);
        this._summaryPanel.loadContent(this.context);
        this._instancesPanel.update(this.currentBackup);
    }

    static {
        BACKUP_SUMMARY.add(Messages.getString("TimesTen.common.name"));
        BACKUP_SUMMARY.add(Messages.getString("TimesTenGrid.dbNameLabel"));
        BACKUP_SUMMARY.add(Messages.getString("TimesTenGrid.RepositoryObjectName"));
        BACKUP_SUMMARY.add(Messages.getString("TimesTen.common.state"));
        BACKUP_SUMMARY.add(Messages.getString("TimesTenGrid.Started"));
        logger = Logger.getLogger(RepositoryBackupEditor.class.getName());
    }
}

