/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.loginspector;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.timesten.grid.loginspector.InstanceLogWrapper;

public class TTLogEntry {
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final Pattern TT_MSG_PATTERN = Pattern.compile("^(\\d\\d:\\d\\d:\\d\\d\\.\\d\\d\\d) ([A-Z ][a-z ]*):([ A-Z]+):\\s*(\\d+):\\s*(.*)");
    private static final int HOUR_COL = 1;
    private static final int SEV_COL = 2;
    private static final int SPN_COL = 3;
    private static final int PID_COL = 4;
    private static final int MSG_COL = 5;
    private final Logger logger = Logger.getLogger(TTLogEntry.class.getClass().getName());
    private String hour;
    private int lineNo;
    private String date;
    private TTDiagLogEntryLevel level;
    private String message;
    private String shortProgramName;
    private int PID;

    public TTLogEntry(int n, String string) {
        this.lineNo = n;
        this.parseLine(string);
    }

    public Date getTimeStamp() {
        if (this.date != null) {
            try {
                return this.sdf.parse(this.date + " " + this.hour);
            }
            catch (ParseException parseException) {
                this.logger.severe("Could not parse date:" + this.date + this.hour);
            }
        }
        return null;
    }

    public String getStringTimeStamp() {
        return this.hour + " " + this.date;
    }

    public void setDateString(String string) {
        this.date = string;
    }

    public void setDate(List<InstanceLogWrapper.DateLineMsg> list) {
        if (list.isEmpty()) {
            return;
        }
        if (list.get(0).getLineNo() >= this.getLineNo()) {
            this.setDateString(list.get(0).getDate());
            return;
        }
        if (list.get(list.size() - 1).getLineNo() <= this.getLineNo()) {
            this.setDateString(list.get(list.size() - 1).getDate());
            return;
        }
        for (int i = 0; i < list.size() - 1; ++i) {
            if (this.getLineNo() < list.get(i).getLineNo() || this.getLineNo() > list.get(i + 1).getLineNo()) continue;
            this.setDateString(list.get(i).getDate());
            return;
        }
    }

    public boolean isDateStringNull() {
        return this.date == null || this.date.isEmpty();
    }

    public void setTimeStamp(String string, String string2) {
        this.hour = string;
        this.date = string2;
    }

    public TTDiagLogEntryLevel getLevel() {
        return this.level;
    }

    public void setLevel(TTDiagLogEntryLevel tTDiagLogEntryLevel) {
        this.level = tTDiagLogEntryLevel;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public String getShortProgramName() {
        return this.shortProgramName;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public void setShortProgramName(String string) {
        this.shortProgramName = string;
    }

    public int getPID() {
        return this.PID;
    }

    public String getStrPID() {
        return String.valueOf(this.PID);
    }

    public void setPID(int n) {
        this.PID = n;
    }

    public String toString() {
        String string = String.format("%1$tH:%<tM:%<tS.%<tL %2$-4s:%3$4s: %4$d: %5$s", new Object[]{this.getTimeStamp(), this.getLevel(), this.getShortProgramName(), this.getPID(), this.getMessage()}).toString();
        return string;
    }

    public void parseLine(String string) {
        Matcher matcher = TT_MSG_PATTERN.matcher(string);
        int n = 1;
        if (matcher.find()) {
            while (n <= matcher.groupCount()) {
                String string2 = matcher.group(n);
                block0 : switch (n++) {
                    case 1: {
                        this.setTimeStamp(string2, null);
                        break;
                    }
                    case 2: {
                        switch (string2.trim()) {
                            case "Info": {
                                this.setLevel(TTDiagLogEntryLevel.INFO);
                                break block0;
                            }
                            case "Warn": {
                                this.setLevel(TTDiagLogEntryLevel.WARN);
                                break block0;
                            }
                            case "Err": {
                                this.setLevel(TTDiagLogEntryLevel.ERROR);
                            }
                        }
                        break;
                    }
                    case 3: {
                        this.setShortProgramName(string2.trim());
                        break;
                    }
                    case 4: {
                        this.setPID(Integer.parseInt(string2));
                        break;
                    }
                    case 5: {
                        this.setMessage(string2);
                    }
                }
            }
        }
    }

    public static enum TTDiagLogEntryLevel {
        ERROR("Err"),
        WARN("Warn"),
        INFO("Info");

        String strVal;

        private TTDiagLogEntryLevel(String string2) {
            this.strVal = string2;
        }

        public String toString() {
            return this.strVal;
        }
    }
}

