/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.object;

import java.util.Date;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.grid.topology.TopologyElement;

public class Element
implements TopologyElement {
    private String state;
    private Date lastChangeStart;
    private Date lastChangeEnd;
    private String lastChangeCode;
    private InstanceObject instance;
    private int replicaSet;
    private boolean inCurrentDistMap;
    private boolean inPreviousDistMap;
    private boolean addInNextDistMap;
    private boolean removeInNextDistMap;
    private String message;
    private int id;

    public Element() {
        this.clear();
    }

    public void clear() {
        this.state = Messages.getString("TimesTen.common.unknown");
        this.lastChangeEnd = null;
        this.lastChangeStart = null;
        this.lastChangeCode = null;
        this.message = "";
        this.instance = null;
        this.replicaSet = 0;
        this.removeInNextDistMap = false;
        this.addInNextDistMap = false;
        this.inPreviousDistMap = false;
        this.inCurrentDistMap = false;
        this.id = -1;
    }

    public boolean isInCurrentDistMap() {
        return this.inCurrentDistMap;
    }

    public void setInCurrentDistMap(boolean bl) {
        this.inCurrentDistMap = bl;
    }

    public boolean isInPreviousDistMap() {
        return this.inPreviousDistMap;
    }

    public void setInPreviousDistMap(boolean bl) {
        this.inPreviousDistMap = bl;
    }

    public boolean isAddInNextDistMap() {
        return this.addInNextDistMap;
    }

    public void setAddInNextDistMap(boolean bl) {
        this.addInNextDistMap = bl;
    }

    public boolean isRemoveInNextDistMap() {
        return this.removeInNextDistMap;
    }

    public void setRemoveInNextDistMap(boolean bl) {
        this.removeInNextDistMap = bl;
    }

    public String getLastChangeCode() {
        return this.lastChangeCode;
    }

    public void setReplicaSet(int n) {
        this.replicaSet = n;
    }

    @Override
    public int getReplicaSet() {
        return this.replicaSet;
    }

    public void setInstance(InstanceObject instanceObject) {
        this.instance = instanceObject;
    }

    public InstanceObject getInstance() {
        return this.instance;
    }

    @Override
    public int getDataSpaceGroup() {
        if (this.instance == null) {
            return 0;
        }
        return this.instance.getHost().getDataSpaceGroup();
    }

    public void setLastChangeCode(String string) {
        this.lastChangeCode = string;
    }

    public Date getLastChangeStart() {
        return this.lastChangeStart;
    }

    public void setLastChangeStart(Date date) {
        this.lastChangeStart = date;
    }

    public Date getLastChangeEnd() {
        return this.lastChangeEnd;
    }

    public void setLastChangeEnd(Date date) {
        this.lastChangeEnd = date;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String string) {
        this.state = string;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public String toString() {
        if (this.instance != null) {
            return this.instance.toString();
        }
        return "";
    }

    @Override
    public boolean isAppliedInTopology() {
        return this.isInCurrentDistMap();
    }

    @Override
    public boolean hasRS() {
        return this.replicaSet > 0;
    }

    @Override
    public boolean hasDSG() {
        return true;
    }

    @Override
    public boolean isMarkedToBeAdded() {
        return this.isAddInNextDistMap();
    }

    @Override
    public boolean isMarkedToBeRemoved() {
        return this.isRemoveInNextDistMap();
    }

    @Override
    public boolean isAddableToTopology() {
        return !this.state.equalsIgnoreCase("CreateFailed") && !this.state.equalsIgnoreCase("Uncreated");
    }

    @Override
    public boolean isSameElement(String string) {
        return this.getInstance().getFullName().equals(string);
    }

    @Override
    public String getFailStateMessage() {
        return this.state;
    }

    @Override
    public boolean isRemovableAfterApply() {
        return true;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }
}

