/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.shell.buffer;

import java.awt.Point;
import java.util.Arrays;

public class CurrentScreenBuffer {
    public static int DIRECTION_UP = 1;
    public static int DIRECTION_DOWN = 2;
    private char[] visibleBuffer;
    private static final char EMPTY_CHAR = ' ';
    private int rowCount;
    private int columnCount;
    private boolean[] endOfLines;

    public void clearBuffer() {
        Arrays.fill(this.visibleBuffer, ' ');
    }

    public void setBufferSize(int n, int n2) {
        this.columnCount = n;
        this.rowCount = n2;
        this.endOfLines = new boolean[this.rowCount];
        this.visibleBuffer = new char[n2 * n];
        this.clearBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(int n, int n2) {
        Class<CurrentScreenBuffer> clazz = CurrentScreenBuffer.class;
        synchronized (CurrentScreenBuffer.class) {
            int n3;
            char[] cArray = this.visibleBuffer;
            boolean[] blArray = this.endOfLines;
            int n4 = this.rowCount;
            int n5 = this.columnCount;
            this.setBufferSize(n, n2);
            int n6 = Math.min(n5, this.columnCount);
            int n7 = Math.min(n4, this.rowCount);
            int n8 = n4 - n7;
            int n9 = this.rowCount - n7;
            for (n3 = 0; n3 < n7; ++n3) {
                System.arraycopy(cArray, (n8 + n3) * n5, this.visibleBuffer, (n9 + n3) * this.columnCount, n6);
            }
            if (blArray.length < this.endOfLines.length) {
                System.arraycopy(blArray, 0, this.endOfLines, 0, blArray.length - 1);
            } else {
                n3 = blArray.length - this.endOfLines.length;
                System.arraycopy(blArray, n3, this.endOfLines, 0, this.endOfLines.length - 1);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public char getChar(int n, int n2) {
        return this.visibleBuffer[this.getLinearPosition(n, n2)];
    }

    public void insertChar(int n, int n2, char c) {
        this.visibleBuffer[this.getLinearPosition((int)n, (int)n2)] = c;
    }

    public void insertString(String string, int n, int n2) {
        int n3 = this.getLinearPosition(n, n2);
        int n4 = 0;
        for (int i = n3; i < n3 + string.length(); ++i) {
            this.visibleBuffer[i] = string.charAt(n4);
            ++n4;
        }
    }

    public void insertByteArray(byte[] byArray, int n, int n2, int n3, int n4) {
        int n5 = this.getLinearPosition(n3, n4);
        int n6 = 0;
        for (int i = n5; i < n5 + n2; ++i) {
            this.visibleBuffer[i] = (char)byArray[n + n6];
            ++n6;
        }
    }

    public int getLinearPosition(int n, int n2) {
        int n3 = n * this.columnCount + n2;
        return n3;
    }

    public Point getMatrixPosition(int n) {
        int n2 = n / this.columnCount;
        int n3 = n % this.columnCount;
        return new Point(n3, n2);
    }

    public void scrollUp(int n) {
        this.scrollBuffer(n, DIRECTION_UP);
    }

    public void scrollDown(int n) {
        this.scrollBuffer(n, DIRECTION_DOWN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollBuffer(int n, int n2) {
        Class<CurrentScreenBuffer> clazz = CurrentScreenBuffer.class;
        synchronized (CurrentScreenBuffer.class) {
            int n3 = n * this.columnCount;
            if (DIRECTION_UP == n2) {
                int n4;
                for (n4 = 0; n4 < this.visibleBuffer.length - n3; ++n4) {
                    this.visibleBuffer[n4] = this.visibleBuffer[n3 + n4];
                }
                for (n4 = this.visibleBuffer.length - n3; n4 < this.visibleBuffer.length; ++n4) {
                    this.visibleBuffer[n4] = 32;
                }
                for (n4 = 0; n4 < this.endOfLines.length - n; ++n4) {
                    this.endOfLines[n4] = this.endOfLines[n4 + n];
                }
                Arrays.fill(this.endOfLines, this.endOfLines.length - n, this.endOfLines.length - 1, false);
            } else if (DIRECTION_DOWN == n2) {
                int n5;
                for (n5 = this.visibleBuffer.length - n3; n5 > 0; --n5) {
                    this.visibleBuffer[n5] = this.visibleBuffer[n3 - n5];
                }
                for (n5 = 0; n5 < n3; ++n5) {
                    this.visibleBuffer[n5] = 32;
                }
            } else {
                throw new IllegalArgumentException("The scrolling direction is not supported");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public String toString() {
        int n = this.visibleBuffer.length + this.rowCount;
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        for (int i = 0; i < this.visibleBuffer.length; i += this.columnCount) {
            if (i + this.columnCount > this.visibleBuffer.length) {
                stringBuffer.append(this.visibleBuffer, i, this.visibleBuffer.length % this.columnCount);
                if (this.endOfLines[n2]) {
                    stringBuffer.append("\n");
                }
            } else {
                stringBuffer.append(this.visibleBuffer, i, this.columnCount);
                if (this.endOfLines[n2]) {
                    stringBuffer.append("\n");
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public void cleanRestOfLine(int n, int n2) {
        int n3 = this.getLinearPosition(n, n2);
        int n4 = this.getLinearPosition(n, this.columnCount);
        for (int i = n3; i < n4; ++i) {
            if (i >= this.visibleBuffer.length) continue;
            this.visibleBuffer[i] = 32;
        }
    }

    public String getString(Point point, Point point2) {
        int n;
        int n2 = this.getLinearPosition(point.y, point.x);
        if (n2 <= (n = this.getLinearPosition(point2.y, point2.x))) {
            return this.getStringHelper(n2, n);
        }
        return this.getStringHelper(n, n2);
    }

    private String getStringHelper(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2 - n);
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.visibleBuffer.length) {
            n2 = this.visibleBuffer.length - 1;
        }
        for (int i = n; i < n2; ++i) {
            int n3;
            if (i != 0 && i % this.columnCount == 0 && i != n && this.endOfLines[n3 = i / this.columnCount - 1]) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(this.visibleBuffer[i]);
        }
        return stringBuffer.toString();
    }

    public String getFirstLine() {
        Object object = new String(this.visibleBuffer, 0, this.columnCount);
        if (this.endOfLines[0]) {
            object = (String)object + "\n";
        }
        return object;
    }

    public void newLine(int n) {
        if (n < this.endOfLines.length) {
            this.endOfLines[n] = true;
        }
    }
}

