/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.panels;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.OracleTypeModeImpl;
import oracle.dbtools.raptor.timesten.TimesTenPlugInDatabaseImpl;
import oracle.dbtools.raptor.timesten.panels.PartitionTablePanel;
import oracle.dbtools.raptor.timesten.ttdbobjects.TTPrimaryKeyIndexType;
import oracle.dbtools.raptor.timesten.ttdbobjects.TimestenElement;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.panels.Navigable;
import oracle.ideimpl.db.ora.TablePanelLibrary;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.property.PropertyManager;

public class TTLatestTablePanelLibrary
extends TablePanelLibrary {
    private static final String DISTRIBUTION = Messages.getString("TTTablePanelLibary.distribution");
    private static final String EMPTY_TABLE_QUERY = "SELECT 1 FROM DUAL WHERE EXISTS (SELECT 'X' FROM #TABLE#)";

    public TTLatestTablePanelLibrary() {
        this.addPanel(DISTRIBUTION, PartitionTablePanel.class, TimesTenHelpID.CREATE_TABLE.toString(), new String[]{"TIMESTENELEMENT"});
    }

    protected List<String> getTitles(Table table, DBObjectProvider dBObjectProvider, boolean bl) {
        List list = super.getTitles(table, dBObjectProvider, bl);
        TTLatestTablePanelLibrary.addElementIfSupported(table, dBObjectProvider, bl, list);
        return list;
    }

    public Navigable[] getDefaultPanels(boolean bl) {
        return null;
    }

    protected List<String> getSimpleTitles() {
        return null;
    }

    protected Table newDBObject(DBObjectProvider dBObjectProvider, Schema schema, DBObject dBObject) {
        Table table = super.newDBObject(dBObjectProvider, schema, dBObject);
        TimestenElement timestenElement = (TimestenElement)((Object)table.getProperty("TIMESTENELEMENT"));
        TTPrimaryKeyIndexType tTPrimaryKeyIndexType = (TTPrimaryKeyIndexType)((Object)table.getProperty("TTPrimaryKeyIndexType"));
        if (timestenElement == null) {
            timestenElement = new TimestenElement();
            table.setProperty("TIMESTENELEMENT", (Object)timestenElement);
            timestenElement.setParent((DBObject)table);
        }
        if (tTPrimaryKeyIndexType == null) {
            tTPrimaryKeyIndexType = new TTPrimaryKeyIndexType();
            table.setProperty("TTPrimaryKeyIndexType", (Object)tTPrimaryKeyIndexType);
            tTPrimaryKeyIndexType.setParent((DBObject)table);
        }
        return table;
    }

    public void prepareObjectForEditor(DBEditorConfig dBEditorConfig, List<Navigable> list) throws DBException {
        super.prepareObjectForEditor(dBEditorConfig, list);
        if (dBEditorConfig.getProvider().getPropertyManager().supportsProperty("TABLE", "TIMESTENELEMENT")) {
            DBUtil.ensureObjectBuilt((DBObject)dBEditorConfig.getUpdatedObject(), (String[])new String[]{"TIMESTENELEMENT"});
        }
        DBUtil.ensureObjectBuilt((DBObject)dBEditorConfig.getUpdatedObject(), (String[])new String[]{"TTPrimaryKeyIndexType"});
    }

    static void addElementIfSupported(Table table, DBObjectProvider dBObjectProvider, boolean bl, List<String> list) {
        OracleTypeModeImpl oracleTypeModeImpl;
        Connection connection;
        boolean bl2;
        if (dBObjectProvider instanceof OracleTypeModeImpl && (bl2 = TimesTenPlugInDatabaseImpl.isGridDatabase(connection = (oracleTypeModeImpl = (OracleTypeModeImpl)dBObjectProvider).getConnection()))) {
            boolean bl3;
            PropertyManager propertyManager = dBObjectProvider.getPropertyManager();
            boolean bl4 = bl3 = propertyManager == null || propertyManager.supportsProperty(table.getClass(), "TIMESTENELEMENT");
            if (!(!bl3 || bl && dBObjectProvider instanceof Database && table.getProperty("TIMESTENELEMENT") == null)) {
                list.add(DISTRIBUTION);
                TimestenElement timestenElement = (TimestenElement)((Object)table.getProperty("TIMESTENELEMENT"));
                if (!bl) {
                    timestenElement.setTimestenPartitionType(TimestenElement.TTPartitionType.HASH);
                } else {
                    timestenElement.setTable(table.getName());
                    timestenElement.setEnableDistEdition(TTLatestTablePanelLibrary.isEmptyTable(connection, table.getName()));
                    timestenElement.setOriginalPartitionType(timestenElement.getTimestenPartitionType());
                    if (timestenElement.getTimestenPartitionType() == TimestenElement.TTPartitionType.HASH && timestenElement.getHashColumnCount() > 0) {
                        timestenElement.setOriginalColumnHash(timestenElement.getColumnHash());
                    } else if (timestenElement.getTimestenPartitionType() == TimestenElement.TTPartitionType.REFERENCE) {
                        timestenElement.setOriginalFK(timestenElement.getForeignKey());
                    }
                    timestenElement.setTableAction(TimestenElement.TableAction.EDITION_SAME_DIST);
                }
            }
        }
    }

    public boolean canEditObject(Table table, DBObjectProvider dBObjectProvider) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isEmptyTable(Connection connection, String string) {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(EMPTY_TABLE_QUERY.replace("#TABLE#", string));
            boolean bl = !resultSet.next();
            return bl;
        }
        catch (SQLException sQLException) {
            Logger.getLogger(TTLatestTablePanelLibrary.class.getName()).warning("Error while determining if table " + string + " is empty: " + sQLException.getMessage());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return false;
    }
}

