/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.performancemonitor;

import javafx.scene.Node;
import javafx.scene.chart.PieChart;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.text.Text;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.performancemonitor.GridSummaryPane;
import oracle.dbtools.raptor.timesten.performancemonitor.data.DashboardSummaryInfo;

public class PerformancePieChart
extends BorderPane {
    private DashboardSummaryInfo info;
    private PieChart pieChart;
    private Text text;
    private String title;

    public PerformancePieChart(String string) {
        this.text = new Text(string);
        this.text.setFont(GridSummaryPane.TITLE_FONT);
        this.setTop((Node)this.text);
        this.title = string;
        this.pieChart = new PieChart();
        this.pieChart.setLabelsVisible(false);
        this.setCenter((Node)this.pieChart);
        this.pieChart.getStylesheets().add((Object)PerformancePieChart.class.getResource("ottpiechart.css").toExternalForm());
    }

    public void refreshPane(DashboardSummaryInfo dashboardSummaryInfo) {
        this.pieChart.getData().clear();
        this.pieChart.getData().add((Object)new PieChart.Data(Messages.getString("TimestenGrid.spaceUsed"), dashboardSummaryInfo.getAverage()));
        this.pieChart.getData().add((Object)new PieChart.Data(Messages.getString("TimestenGrid.availableSpace"), 100.0 - dashboardSummaryInfo.getAverage()));
        for (PieChart.Data data : this.pieChart.getData()) {
            Tooltip.install((Node)data.getNode(), (Tooltip)new Tooltip(String.valueOf(data.getPieValue()) + "%"));
        }
    }
}

