/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.performancemonitor.data;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TimesTenPlugInDatabaseImpl;
import oracle.dbtools.raptor.timesten.TimesTenUtil;
import oracle.dbtools.raptor.timesten.performancemonitor.PerformanceConstants;
import oracle.dbtools.raptor.timesten.performancemonitor.data.AlertBean;
import oracle.dbtools.raptor.timesten.performancemonitor.data.DashboardSummaryInfo;
import oracle.dbtools.raptor.timesten.performancemonitor.data.TopSQLCmdBean;
import oracle.dbtools.raptor.timesten.performancemonitor.distribution.TopologyInformer;
import oracle.dbtools.raptor.utils.Connections;

public class SummaryDataProvider
implements TopologyInformer {
    private static Logger logger = Logger.getLogger(SummaryDataProvider.class.getPackage().getName());
    private String[] replicaSetArr;
    private String[] dataSpaceArr;
    private Connection conn;
    private TreeSet<String> instancesNames;
    private HashMap<String, String> hostnameInfo;
    private HashMap<String, String> instancenameInfo;
    private HashMap<String, Integer> elementIDInfo;
    private Method registerIndexTableOutParameterMethod;
    private Method getPlsqlIndexTableMethod;
    private static final String TOPOLOGY_QUERY = "SELECT /* !!!!! SQL Developer Performance Monitor Query !!!!! */ * from sys.GV$DISTRIBUTION_CURRENT";
    private static final String CPU_USAGE_QUERY = "select /* !!!!! SQL Developer Performance Monitor Query !!!!! */ distinct (ELEMENTID), CPU_UTIL, COLLECTED_AT from SYS.GV$TTSTATS_CPU_HIST where (COLLECTED_AT,elementid) in (select max(COLLECTED_AT),elementId from  SYS.GV$TTSTATS_CPU_HIST group by elementid );";
    private static final String AVAIL_DISK_QUERY = "select /* !!!!! SQL Developer Performance Monitor Query !!!!! */ elementid, percent_used ,TT_FILE_TYPE, COLLECTED_AT from SYS.GV$TTSTATS_DISK_HIST where (COLLECTED_AT,elementid)  in  (select MAX(COLLECTED_AT),elementid  from SYS.GV$TTSTATS_DISK_HIST group by elementid)";
    private static final String ALERTS_QUERY = "select /* !!!!! SQL Developer Performance Monitor Query !!!!! */ * from SYS.GV$TTSTATS_ALERTS where AKNOLEDGED NOT NULL ";
    private static final String NETWORK_QUERY = "select /* !!!!! SQL Developer Performance Monitor Query !!!!! */ * from sys.GV$TTSTATS_NETWORK_HIST where COLLECTED_AT = (select max(COLLECTED_AT) from sys.GV$TTSTATS_NETWORK_HIST) ";
    private static final String CONNECTIONS_QUERY = "select /* !!!!! SQL Developer Performance Monitor Query !!!!! */ NAME, VALUE, ELEMENTID from sys.GV$SYSTEMSTATS  where NAME ='connections.established.direct' OR NAME ='connections.established.client_server' order by ELEMENTID ASC ";
    private static final String GRID_STATE = "SELECT * from GV$DISTRIBUTION_STATE";
    private static final String TOP_SQL_CMDS = "select /* !!!!! SQL Developer Performance Monitor Query !!!!! */ first 64 elementid,sqlcmdid,executions,prepares,reprepares,starttime, lastexecutetime,maxexecutetime,trim(owner) owner,querytext from gv$sql_cmd_cache  WHERE QUERYTEXT not LIKE '%!!!!! SQL Developer Performance Monitor Query !!!!!%' order by :ORDERCLAUSE: desc;";
    public static final String ORDER_BY_EXECUTIONS = "executions";
    public static final String ORDER_BY_LAST_EXECUTION_TIME = "lastexecutetime";
    public static final String ORDER_BY_EXECUTIONS_AND_LAST_EXECUTION_TIME = "(executions *lastexecutetime)";
    private static final String AVAIL_MEMORY_QUERY = "SELECT /* !!!!! SQL Developer Performance Monitor Query !!!!! */ PERM_ALLOCATED_SIZE, PERM_IN_USE_SIZE,TEMP_ALLOCATED_SIZE, TEMP_IN_USE_SIZE , ELEMENTID from SYS.GV$MONITOR order by ELEMENTID ";
    public static final String TX_MB_RATE = "TX_MB_RATE";
    public static final String RX_MB_RATE = "RX_MB_RATE";
    public static final String TX_PACKET_RATE = "TX_PACKET_RATE";
    public static final String RX_PACKET_RATE = "RX_PACKET_RATE";
    public static final String DIRECT_CONNECTIONS = "DIRECT_CONNECTIONS";
    public static final String CS_CONNECTIONS = "CS_CONNECTIONS";
    public static final String TEMP_SPACE = "TEMP_SPACE";
    public static final String PERM_SPACE = "PERM_SPACE";
    public static final String DISK_CHECKPOINT = "DISK_CHECKPOINT";
    public static final String DISK_TXN_LOG = "DISK_TXN_LOG";
    private static final int TTSTATS_CHECKPOINT = 1;
    private static final int TTSTATS_TXN_LOG = 2;
    private static final int TTSTATS_CKPT_TXN_LOG = 3;
    public static final String SELECT_STMT = "stmt.executes.selects";
    public static final String UPDATE_STMT = "stmt.executes.updates";
    public static final String INSERTS_STMT = "stmt.executes.inserts";
    public static final String DELETE_STMT = "stmt.executes.deletes";
    public static final int CLEAN_STATUS = 0;
    public static final int ALERT_STATUS = 2;
    public static final int MAJOR_ISSUE_STATUS = 3;
    private static final String ELEMENTS_QUERY = "SELECT DISTINCT(ELEMENTID) from GV$DISTRIBUTION_CURRENT order by ELEMENTID;";

    public SummaryDataProvider(Connection connection) {
        this.conn = connection;
        this.calculateTopology();
    }

    public String getDataStore() {
        String string = TimesTenPlugInDatabaseImpl.getX10Configuration(this.conn, "DataStore");
        if (string == null) {
            return "";
        }
        int n = string.lastIndexOf("/");
        if (n > 0) {
            return string.substring(n + 1);
        }
        n = string.lastIndexOf(92);
        return string.substring(n + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public HashMap<String, DashboardSummaryInfo> getRates() {
        HashMap<String, DashboardSummaryInfo> hashMap = new HashMap<String, DashboardSummaryInfo>();
        hashMap.put(SELECT_STMT, new DashboardSummaryInfo());
        hashMap.put(INSERTS_STMT, new DashboardSummaryInfo());
        hashMap.put(UPDATE_STMT, new DashboardSummaryInfo());
        hashMap.put(DELETE_STMT, new DashboardSummaryInfo());
        CallableStatement callableStatement = null;
        Connections.getInstance().lock(this.conn);
        try {
            callableStatement = this.conn.prepareCall(PerformanceConstants.RATE_QUERY);
            this.discoverCustomMethods(callableStatement);
            this.registerIndexTableOutParameterMethod.invoke((Object)callableStatement, 1, 2048, 12, Short.MAX_VALUE);
            this.registerIndexTableOutParameterMethod.invoke((Object)callableStatement, 2, 2048, 12, Short.MAX_VALUE);
            this.registerIndexTableOutParameterMethod.invoke((Object)callableStatement, 3, 2048, 12, Short.MAX_VALUE);
            this.registerIndexTableOutParameterMethod.invoke((Object)callableStatement, 4, 2048, 12, Short.MAX_VALUE);
            callableStatement.execute();
            SQLWarning sQLWarning = callableStatement.getWarnings();
            if (sQLWarning == null) {
                void var12_31;
                void var11_23;
                Object object2 = this.getPlsqlIndexTableMethod.invoke((Object)callableStatement, 1);
                String[] stringArray = (String[])object2;
                HashMap<Integer, RateUtil> hashMap2 = new HashMap<Integer, RateUtil>();
                for (String string : stringArray) {
                    RateUtil rateUtil;
                    String[] object3 = string.split(",");
                    String string2 = object3[0];
                    int n = Integer.parseInt(object3[1]);
                    Timestamp timestamp = Timestamp.valueOf(object3[2]);
                    int n2 = Integer.parseInt(object3[3]);
                    if (hashMap2.get(n2) == null) {
                        rateUtil = new RateUtil();
                        rateUtil.timestamp = timestamp;
                        rateUtil.value = n;
                        hashMap2.put(n2, rateUtil);
                        continue;
                    }
                    rateUtil = (RateUtil)hashMap2.get(n2);
                    long l = (rateUtil.timestamp.getTime() - timestamp.getTime()) / 1000L;
                    double d = (double)(rateUtil.value - n) / (double)l;
                    hashMap.get(string2).addInformation(n2, d);
                }
                object2 = this.getPlsqlIndexTableMethod.invoke((Object)callableStatement, 2);
                String[] stringArray2 = (String[])object2;
                hashMap2.clear();
                for (String string : stringArray2) {
                    RateUtil rateUtil;
                    String[] stringArray3 = string.split(",");
                    String string3 = stringArray3[0];
                    int n = Integer.parseInt(stringArray3[1]);
                    Timestamp timestamp = Timestamp.valueOf(stringArray3[2]);
                    int n3 = Integer.parseInt(stringArray3[3]);
                    if (hashMap2.get(n3) == null) {
                        rateUtil = new RateUtil();
                        rateUtil.timestamp = timestamp;
                        rateUtil.value = n;
                        hashMap2.put(n3, rateUtil);
                        continue;
                    }
                    rateUtil = (RateUtil)hashMap2.get(n3);
                    long l = (rateUtil.timestamp.getTime() - timestamp.getTime()) / 1000L;
                    double d = (double)(rateUtil.value - n) / (double)l;
                    hashMap.get(string3).addInformation(n3, d);
                }
                object2 = this.getPlsqlIndexTableMethod.invoke((Object)callableStatement, 3);
                String[] stringArray3 = (String[])object2;
                hashMap2.clear();
                String[] stringArray5 = stringArray3;
                int n = stringArray5.length;
                boolean bl = false;
                while (var11_23 < n) {
                    RateUtil rateUtil;
                    String string = stringArray5[var11_23];
                    String[] stringArray4 = string.split(",");
                    String string4 = stringArray4[0];
                    int n4 = Integer.parseInt(stringArray4[1]);
                    Timestamp timestamp = Timestamp.valueOf(stringArray4[2]);
                    int n5 = Integer.parseInt(stringArray4[3]);
                    if (hashMap2.get(n5) == null) {
                        rateUtil = new RateUtil();
                        rateUtil.timestamp = timestamp;
                        rateUtil.value = n4;
                        hashMap2.put(n5, rateUtil);
                    } else {
                        rateUtil = (RateUtil)hashMap2.get(n5);
                        long l = (rateUtil.timestamp.getTime() - timestamp.getTime()) / 1000L;
                        double d = (double)(rateUtil.value - n4) / (double)l;
                        hashMap.get(string4).addInformation(n5, d);
                    }
                    ++var11_23;
                }
                object2 = this.getPlsqlIndexTableMethod.invoke((Object)callableStatement, 4);
                stringArray5 = (String[])object2;
                hashMap2.clear();
                String[] stringArray6 = stringArray5;
                int n6 = stringArray6.length;
                boolean bl2 = false;
                while (var12_31 < n6) {
                    RateUtil rateUtil;
                    String string = stringArray6[var12_31];
                    String[] stringArray7 = string.split(",");
                    String string5 = stringArray7[0];
                    int n7 = Integer.parseInt(stringArray7[1]);
                    Timestamp timestamp = Timestamp.valueOf(stringArray7[2]);
                    int n8 = Integer.parseInt(stringArray7[3]);
                    if (hashMap2.get(n8) == null) {
                        rateUtil = new RateUtil();
                        rateUtil.timestamp = timestamp;
                        rateUtil.value = n7;
                        hashMap2.put(n8, rateUtil);
                    } else {
                        rateUtil = (RateUtil)hashMap2.get(n8);
                        long l = (rateUtil.timestamp.getTime() - timestamp.getTime()) / 1000L;
                        double d = (double)(rateUtil.value - n7) / (double)l;
                        hashMap.get(string5).addInformation(n8, d);
                    }
                    ++var12_31;
                }
            }
        }
        catch (SQLException sQLException) {
            logger.log(Level.SEVERE, "Cannot get rates information", sQLException);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.log(Level.SEVERE, "Cannot get rates information", illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.log(Level.SEVERE, "Cannot get rates information", illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.log(Level.SEVERE, "Cannot get rates information", invocationTargetException);
        }
        finally {
            Connections.getInstance().unlock(this.conn);
        }
        ((DashboardSummaryInfo)hashMap.get(SELECT_STMT)).calculateInformation();
        ((DashboardSummaryInfo)hashMap.get(UPDATE_STMT)).calculateInformation();
        ((DashboardSummaryInfo)hashMap.get(DELETE_STMT)).calculateInformation();
        ((DashboardSummaryInfo)hashMap.get(INSERTS_STMT)).calculateInformation();
        return hashMap;
    }

    public String getTimesTenVersion() {
        return TimesTenUtil.ttFullDotVersion(this.conn);
    }

    @Override
    public String[] getReplicaSets() {
        if (this.replicaSetArr == null) {
            return new String[0];
        }
        return this.replicaSetArr;
    }

    @Override
    public String[] getDataSpaceGroups() {
        if (this.dataSpaceArr == null) {
            return new String[0];
        }
        return this.dataSpaceArr;
    }

    public int getDataSpaceGroupCount() {
        if (this.dataSpaceArr == null) {
            return 0;
        }
        return this.dataSpaceArr.length;
    }

    public int getReplicaSetCount() {
        if (this.replicaSetArr == null) {
            return 0;
        }
        return this.replicaSetArr.length;
    }

    public int getInstancesCount() {
        return this.instancesNames.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DashboardSummaryInfo getCPUInfo() {
        Statement statement = null;
        DashboardSummaryInfo dashboardSummaryInfo = new DashboardSummaryInfo();
        Connections.getInstance().lock(this.conn);
        try {
            statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery(CPU_USAGE_QUERY);
            dashboardSummaryInfo.setTitle("CPU Info");
            dashboardSummaryInfo.setGraphType(PerformanceConstants.PerformanceChartTypes.CPU_CHART);
            while (resultSet.next()) {
                dashboardSummaryInfo.addInformation(resultSet.getInt("ELEMENTID"), resultSet.getDouble("CPU_UTIL"), resultSet.getTimestamp("COLLECTED_AT"));
            }
            dashboardSummaryInfo.setConnection(this.conn);
            dashboardSummaryInfo.calculateInformation();
            DashboardSummaryInfo dashboardSummaryInfo2 = dashboardSummaryInfo;
            return dashboardSummaryInfo2;
        }
        catch (SQLException sQLException) {
            logger.log(Level.SEVERE, "Cannot get cpu information", sQLException);
            DashboardSummaryInfo dashboardSummaryInfo3 = dashboardSummaryInfo;
            return dashboardSummaryInfo3;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            Connections.getInstance().unlock(this.conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, DashboardSummaryInfo> getAvailableMemoryInfo() {
        HashMap<String, DashboardSummaryInfo> hashMap = new HashMap<String, DashboardSummaryInfo>();
        Statement statement = null;
        Connections.getInstance().lock(this.conn);
        try {
            statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery(AVAIL_MEMORY_QUERY);
            DashboardSummaryInfo dashboardSummaryInfo = new DashboardSummaryInfo();
            DashboardSummaryInfo dashboardSummaryInfo2 = new DashboardSummaryInfo();
            while (resultSet.next()) {
                int n = resultSet.getInt("PERM_ALLOCATED_SIZE");
                int n2 = resultSet.getInt("PERM_IN_USE_SIZE");
                int n3 = resultSet.getInt("TEMP_ALLOCATED_SIZE");
                int n4 = resultSet.getInt("TEMP_IN_USE_SIZE");
                int n5 = resultSet.getInt("ELEMENTID");
                dashboardSummaryInfo.addInformation(n5, n2 * 100 / n);
                dashboardSummaryInfo2.addInformation(n5, n4 * 100 / n3);
            }
            dashboardSummaryInfo.calculateInformation();
            dashboardSummaryInfo2.calculateInformation();
            dashboardSummaryInfo.setConnection(this.conn);
            dashboardSummaryInfo2.setConnection(this.conn);
            dashboardSummaryInfo.setGraphType(PerformanceConstants.PerformanceChartTypes.PERM_SPACE_USAGE_CHART);
            dashboardSummaryInfo2.setGraphType(PerformanceConstants.PerformanceChartTypes.TEMP_SPACE_USAGE_CHART);
            hashMap.put(PERM_SPACE, dashboardSummaryInfo);
            hashMap.put(TEMP_SPACE, dashboardSummaryInfo2);
            HashMap<String, DashboardSummaryInfo> hashMap2 = hashMap;
            return hashMap2;
        }
        catch (SQLException sQLException) {
            logger.log(Level.SEVERE, "Cannot get memory info", sQLException);
            HashMap<String, DashboardSummaryInfo> hashMap3 = hashMap;
            return hashMap3;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            Connections.getInstance().unlock(this.conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, DashboardSummaryInfo> getConnectionInformation() {
        HashMap<String, DashboardSummaryInfo> hashMap = new HashMap<String, DashboardSummaryInfo>();
        Connections.getInstance().lock(this.conn);
        Statement statement = null;
        try {
            DashboardSummaryInfo dashboardSummaryInfo = new DashboardSummaryInfo();
            DashboardSummaryInfo dashboardSummaryInfo2 = new DashboardSummaryInfo();
            statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery(CONNECTIONS_QUERY);
            while (resultSet.next()) {
                String string = resultSet.getString("NAME");
                if (string.contains("client_server")) {
                    dashboardSummaryInfo.addInformation(resultSet.getInt("ELEMENTID"), resultSet.getDouble("VALUE"));
                    continue;
                }
                dashboardSummaryInfo2.addInformation(resultSet.getInt("ELEMENTID"), resultSet.getDouble("VALUE"));
            }
            dashboardSummaryInfo.calculateInformation();
            dashboardSummaryInfo2.calculateInformation();
            dashboardSummaryInfo.setConnection(this.conn);
            dashboardSummaryInfo2.setConnection(this.conn);
            hashMap.put(DIRECT_CONNECTIONS, dashboardSummaryInfo2);
            hashMap.put(CS_CONNECTIONS, dashboardSummaryInfo);
        }
        catch (SQLException sQLException) {
            logger.log(Level.SEVERE, "Cannot get connections information", sQLException);
            HashMap<String, DashboardSummaryInfo> hashMap2 = hashMap;
            return hashMap2;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            Connections.getInstance().unlock(this.conn);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, DashboardSummaryInfo> getNetworkInformation() {
        HashMap<String, DashboardSummaryInfo> hashMap = new HashMap<String, DashboardSummaryInfo>();
        Connections.getInstance().lock(this.conn);
        Statement statement = null;
        try {
            DashboardSummaryInfo dashboardSummaryInfo = new DashboardSummaryInfo();
            DashboardSummaryInfo dashboardSummaryInfo2 = new DashboardSummaryInfo();
            DashboardSummaryInfo dashboardSummaryInfo3 = new DashboardSummaryInfo();
            DashboardSummaryInfo dashboardSummaryInfo4 = new DashboardSummaryInfo();
            statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery(NETWORK_QUERY);
            while (resultSet.next()) {
                dashboardSummaryInfo.addInformation(resultSet.getInt("ELEMENTID"), resultSet.getDouble(TX_MB_RATE), resultSet.getTimestamp("COLLECTED_AT"));
                dashboardSummaryInfo2.addInformation(resultSet.getInt("ELEMENTID"), resultSet.getDouble(RX_MB_RATE), resultSet.getTimestamp("COLLECTED_AT"));
                dashboardSummaryInfo3.addInformation(resultSet.getInt("ELEMENTID"), resultSet.getDouble(TX_PACKET_RATE), resultSet.getTimestamp("COLLECTED_AT"));
                dashboardSummaryInfo4.addInformation(resultSet.getInt("ELEMENTID"), resultSet.getDouble(RX_PACKET_RATE), resultSet.getTimestamp("COLLECTED_AT"));
            }
            dashboardSummaryInfo.calculateInformation();
            dashboardSummaryInfo2.calculateInformation();
            dashboardSummaryInfo3.calculateInformation();
            dashboardSummaryInfo4.calculateInformation();
            dashboardSummaryInfo.setGraphType(PerformanceConstants.PerformanceChartTypes.TRANSMISSION_RATE_CHART);
            dashboardSummaryInfo2.setGraphType(PerformanceConstants.PerformanceChartTypes.RECEPTION_RATE_CHART);
            dashboardSummaryInfo2.setConnection(this.conn);
            dashboardSummaryInfo.setConnection(this.conn);
            dashboardSummaryInfo2.setTitle(Messages.getString("TimestenGrid.received"));
            dashboardSummaryInfo.setTitle(Messages.getString("TimestenGrid.sent"));
            hashMap.put(TX_MB_RATE, dashboardSummaryInfo);
            hashMap.put(RX_MB_RATE, dashboardSummaryInfo2);
        }
        catch (SQLException sQLException) {
            logger.log(Level.SEVERE, "Cannot get network information", sQLException);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            Connections.getInstance().unlock(this.conn);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, DashboardSummaryInfo> getUsedDiskInfo() {
        Statement statement = null;
        HashMap<String, DashboardSummaryInfo> hashMap = new HashMap<String, DashboardSummaryInfo>();
        Connections.getInstance().lock(this.conn);
        try {
            statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery(AVAIL_DISK_QUERY);
            DashboardSummaryInfo dashboardSummaryInfo = new DashboardSummaryInfo();
            DashboardSummaryInfo dashboardSummaryInfo2 = new DashboardSummaryInfo();
            while (resultSet.next()) {
                int n = resultSet.getInt("TT_FILE_TYPE");
                int n2 = resultSet.getInt("ELEMENTID");
                double d = resultSet.getInt("PERCENT_USED");
                Timestamp timestamp = resultSet.getTimestamp("COLLECTED_AT");
                switch (n) {
                    case 1: {
                        dashboardSummaryInfo2.addInformation(n2, d, timestamp);
                        break;
                    }
                    case 2: {
                        dashboardSummaryInfo.addInformation(n2, d, timestamp);
                        break;
                    }
                    case 3: {
                        dashboardSummaryInfo2.addInformation(n2, d, timestamp);
                        dashboardSummaryInfo.addInformation(n2, d, timestamp);
                    }
                }
            }
            dashboardSummaryInfo.calculateInformation();
            dashboardSummaryInfo2.calculateInformation();
            dashboardSummaryInfo.setGraphType(PerformanceConstants.PerformanceChartTypes.TRANSACCION_LOG_CHART);
            dashboardSummaryInfo2.setGraphType(PerformanceConstants.PerformanceChartTypes.CHECK_POINT_CHART);
            dashboardSummaryInfo.setConnection(this.conn);
            dashboardSummaryInfo2.setConnection(this.conn);
            hashMap.put(DISK_CHECKPOINT, dashboardSummaryInfo2);
            hashMap.put(DISK_TXN_LOG, dashboardSummaryInfo);
            HashMap<String, DashboardSummaryInfo> hashMap2 = hashMap;
            return hashMap2;
        }
        catch (SQLException sQLException) {
            logger.log(Level.SEVERE, "Cannot get disk information", sQLException);
            HashMap<String, DashboardSummaryInfo> hashMap3 = hashMap;
            return hashMap3;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            Connections.getInstance().unlock(this.conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DashboardSummaryInfo getTransactionLogInfo() {
        Statement statement = null;
        DashboardSummaryInfo dashboardSummaryInfo = new DashboardSummaryInfo();
        Connections.getInstance().lock(this.conn);
        try {
            statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery(AVAIL_DISK_QUERY);
            while (resultSet.next()) {
                dashboardSummaryInfo.addInformation(resultSet.getInt("elementid"), resultSet.getDouble("percent_used"), resultSet.getTimestamp("COLLECTED_AT"));
            }
            dashboardSummaryInfo.calculateInformation();
            DashboardSummaryInfo dashboardSummaryInfo2 = dashboardSummaryInfo;
            return dashboardSummaryInfo2;
        }
        catch (SQLException sQLException) {
            logger.log(Level.SEVERE, "Cannot get transaction log information", sQLException);
            DashboardSummaryInfo dashboardSummaryInfo3 = dashboardSummaryInfo;
            return dashboardSummaryInfo3;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            Connections.getInstance().unlock(this.conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObservableList<AlertBean> getAlertInformation() {
        ObservableList observableList = FXCollections.observableArrayList();
        Statement statement = null;
        Connections.getInstance().lock(this.conn);
        try {
            ArrayList arrayList = new ArrayList();
            statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery(ALERTS_QUERY);
            while (resultSet.next()) {
                AlertBean alertBean = new AlertBean();
                alertBean.setFirstNoticed(resultSet.getTimestamp("FIRST_NOTICED"));
                alertBean.setProblem(resultSet.getString("PROBLEM"));
                alertBean.setSuggestion(resultSet.getString("SUGGESTION"));
                alertBean.setOccurences(resultSet.getLong("OCCURRENCES"));
                alertBean.setLastNoticed(resultSet.getTimestamp("LAST_NOTICED"));
                observableList.add((Object)alertBean);
            }
        }
        catch (SQLException sQLException) {
            logger.log(Level.SEVERE, "Cannot get alerts information", sQLException);
            ObservableList observableList2 = observableList;
            return observableList2;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            Connections.getInstance().unlock(this.conn);
        }
        return observableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObservableList<TopSQLCmdBean> getTopSQLCmds(String string) {
        ObservableList observableList = FXCollections.observableArrayList();
        Statement statement = null;
        Connections.getInstance().lock(this.conn);
        try {
            statement = this.conn.createStatement();
            String string2 = TOP_SQL_CMDS.replace(":ORDERCLAUSE:", string);
            ResultSet resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                TopSQLCmdBean topSQLCmdBean = new TopSQLCmdBean();
                topSQLCmdBean.setElementId(resultSet.getInt("ELEMENTID"));
                topSQLCmdBean.setOwner(resultSet.getString("OWNER"));
                topSQLCmdBean.setQuery(resultSet.getString("QUERYTEXT"));
                topSQLCmdBean.setSqlCmdId(resultSet.getLong("SQLCMDID"));
                topSQLCmdBean.setExecutions(resultSet.getInt(ORDER_BY_EXECUTIONS));
                topSQLCmdBean.setPrepares(resultSet.getInt("prepares"));
                topSQLCmdBean.setReprepares(resultSet.getInt("reprepares"));
                topSQLCmdBean.setStartTime(resultSet.getTimestamp("starttime"));
                topSQLCmdBean.setLastExecutionTime(resultSet.getDouble(ORDER_BY_LAST_EXECUTION_TIME));
                topSQLCmdBean.setMaxExecutionTime(resultSet.getDouble("maxexecutetime"));
                observableList.add((Object)topSQLCmdBean);
            }
        }
        catch (SQLException sQLException) {
            logger.log(Level.SEVERE, "Cannot get TOPSQL  information", sQLException);
            ObservableList observableList2 = observableList;
            return observableList2;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            Connections.getInstance().unlock(this.conn);
        }
        return observableList;
    }

    @Override
    public String[] getElement(int n, int n2) {
        String string = "[" + this.dataSpaceArr[n] + "][" + this.replicaSetArr[n2] + "]";
        String[] stringArray = new String[]{this.hostnameInfo.get(string), this.instancenameInfo.get(string)};
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateTopology() {
        Statement statement = null;
        this.hostnameInfo = new HashMap();
        this.instancenameInfo = new HashMap();
        this.elementIDInfo = new HashMap();
        this.instancesNames = new TreeSet();
        Connections.getInstance().lock(this.conn);
        try {
            int n;
            statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery(TOPOLOGY_QUERY);
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            TreeSet<Integer> treeSet2 = new TreeSet<Integer>();
            while (resultSet.next()) {
                n = resultSet.getInt("MAPPEDELEMENTID");
                int n2 = resultSet.getInt("DATASPACE");
                int n3 = resultSet.getInt("REPSET");
                treeSet2.add(n2);
                treeSet.add(n3);
                String string = "[" + n2 + "][" + n3 + "]";
                String string2 = resultSet.getString("INSTANCENAME");
                String string3 = resultSet.getString("HOSTEXTERNALADDRESS");
                this.instancesNames.add(resultSet.getString("INSTANCENAME"));
                this.instancenameInfo.put(string, string2);
                this.hostnameInfo.put(string, string3);
                this.elementIDInfo.put(string, n);
            }
            this.replicaSetArr = new String[treeSet.size()];
            n = 0;
            for (Integer n4 : treeSet) {
                this.replicaSetArr[n] = Integer.toString(n4);
                ++n;
            }
            this.dataSpaceArr = new String[treeSet2.size()];
            n = 0;
            for (Integer n5 : treeSet2) {
                this.dataSpaceArr[n] = Integer.toString(n5);
                ++n;
            }
        }
        catch (SQLException sQLException) {
            logger.log(Level.SEVERE, "Cannot get topology  information", sQLException);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            Connections.getInstance().unlock(this.conn);
        }
    }

    @Override
    public int getElementCount() {
        return this.getReplicaSetCount() * this.getDataSpaceGroupCount();
    }

    public void refreshStaticInfo() {
        this.calculateTopology();
    }

    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public Integer getElementId(int n, int n2) {
        String string = "[" + this.dataSpaceArr[n] + "][" + this.replicaSetArr[n2] + "]";
        return this.elementIDInfo.get(string);
    }

    private void discoverCustomMethods(Object object) {
        try {
            if (this.registerIndexTableOutParameterMethod == null) {
                this.registerIndexTableOutParameterMethod = object.getClass().getMethod("registerIndexTableOutParameter", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            }
            if (this.getPlsqlIndexTableMethod == null) {
                this.getPlsqlIndexTableMethod = object.getClass().getMethod("getPlsqlIndexTable", Integer.TYPE);
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Exception during method discovery", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGridStatus() {
        int n;
        if (this.dataSpaceArr == null) {
            this.calculateTopology();
        }
        Connections.getInstance().lock(this.conn);
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        try (Statement statement = this.conn.createStatement();){
            ResultSet resultSet = statement.executeQuery(GRID_STATE);
            while (resultSet.next()) {
                n = resultSet.getInt("STATEELEMENTID");
                String string = resultSet.getString("STATE");
                hashMap.put(n, string.toLowerCase());
            }
        }
        catch (SQLException sQLException) {
            logger.log(Level.SEVERE, "Exception getting database state", sQLException);
        }
        finally {
            Connections.getInstance().unlock(this.conn);
        }
        int n2 = 0;
        for (int i = 0; i < this.getReplicaSetCount(); ++i) {
            n = 0;
            for (int j = 0; j < this.getDataSpaceGroupCount(); ++j) {
                int n3 = this.getElementId(j, i);
                String string = (String)hashMap.get(n3);
                if (string != null && string.equals("active")) continue;
                ++n;
            }
            if (n > 0 && n == this.getDataSpaceGroupCount()) {
                return 3;
            }
            if (n <= 0) continue;
            ++n2;
        }
        if (n2 > 0) {
            return 2;
        }
        return 0;
    }

    private class RateUtil {
        public int value;
        public Timestamp timestamp;

        private RateUtil() {
        }
    }
}

