/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.performancemonitor.distribution;

import java.sql.Connection;
import java.util.TreeSet;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.performancemonitor.PerformanceConstants;
import oracle.dbtools.raptor.timesten.performancemonitor.distribution.ComparableGraphPane;
import oracle.dbtools.raptor.timesten.performancemonitor.distribution.ElementSelectionListener;
import oracle.dbtools.raptor.timesten.performancemonitor.distribution.TopologyInformer;
import oracle.dbtools.raptor.timesten.performancemonitor.distribution.TopologyPanel;

public class TopologyInfoSplitPane
extends SplitPane
implements ElementSelectionListener {
    private TopologyPanel topology;
    private TabPane tabPane;
    private Tab comparePane;
    private ComparableGraphPane compareGraph;

    public TopologyInfoSplitPane(Connection connection, TopologyInformer topologyInformer) {
        this.topology = new TopologyPanel(topologyInformer);
        this.tabPane = new TabPane();
        this.compareGraph = new ComparableGraphPane(this, connection);
        this.topology.setElementSelection(this);
        this.setupTabs();
        this.getItems().addAll((Object[])new Node[]{this.topology, this.tabPane});
        this.setOrientation(Orientation.HORIZONTAL);
    }

    public String getElementsIdAsStringList() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (Integer n : this.topology.getSelectedElements()) {
            if (bl) {
                bl = false;
                stringBuffer.append(n);
                continue;
            }
            stringBuffer.append("," + n);
        }
        return stringBuffer.toString();
    }

    private void setupTabs() {
        this.comparePane = new Tab(Messages.getString("TimestenGrid.compareHeader"), (Node)this.compareGraph);
        this.comparePane.setClosable(false);
        this.tabPane.getTabs().addAll((Object[])new Tab[]{this.comparePane});
    }

    public void showTimeInformation(TreeSet<Integer> treeSet, PerformanceConstants.PerformanceChartTypes performanceChartTypes) {
        this.topology.setSelected(treeSet);
        this.compareGraph.showTimeInformation(performanceChartTypes);
    }

    @Override
    public void elementSelectionChanged() {
        this.compareGraph.refreshCharts();
    }
}

