/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.boot;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import oracle.ide.osgi.boot.LauncherBundle;
import oracle.ide.osgi.boot.LauncherUtil;
import oracle.ide.osgi.boot.api.BundlesInfoUtil;
import oracle.ide.osgi.boot.api.CacheUtil;
import oracle.ide.osgi.boot.api.ConfigurationAreaScanner;
import oracle.ide.osgi.boot.api.DeadlockDetector;
import oracle.ide.osgi.boot.api.IdeBootProperties;
import oracle.ide.osgi.boot.api.SplashScreen;
import org.netbeans.Main;
import org.netbeans.TopSecurityManager;
import org.openide.LifecycleManager;
import org.openide.util.NbBundle;

public class OracleIdeLauncher {
    private static final String DEFAULT_SYSTEM_CACHE_DIR = "system_cache";
    private static final String DROPINS_SUPPORT_DIR = "dropins_support";
    private static final String MAIN_DROPINS_DIR_RELATIVE_PATH = "../../../dropins";
    private static final String COLUMN_PATH_SEPARATOR = ":";
    private static SplashScreen _splashScreen = null;

    private OracleIdeLauncher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        block41: {
            System.setProperty("oracle.ide.launcher.startup.time", "" + System.currentTimeMillis());
            LauncherUtil.initialize(args);
            args = LauncherUtil.checkForDeferredUpdates(args);
            if (IdeBootProperties.isDebugBuild().booleanValue()) {
                DeadlockDetector.getInstance().start();
            }
            if (Boolean.getBoolean("com.oracle.jdev.measure.disk.touches")) {
                System.out.println("Installing Security manager");
                System.setSecurityManager((SecurityManager)((Object)new CountingSecurityManager()));
            }
            Logger log = Logger.getLogger(OracleIdeLauncher.class.getName());
            try {
                String cacheDir;
                int maxNumberOfProcessesAllowed;
                String propertiesPath;
                String consoleProperty;
                File patchesDir;
                String systemDirectory;
                File systemDirectoryFile;
                boolean headless = GraphicsEnvironment.isHeadless();
                boolean noSplash = LauncherUtil.containsArgument(args, "-nosplash");
                boolean noNag = LauncherUtil.containsArgument(args, "-nonag");
                log.log(Level.FINEST, "Show Product Splash == {0}", noSplash || noNag);
                if (!headless) {
                    OracleIdeLauncher.showSplashScreen(noSplash, noNag);
                }
                if (!(systemDirectoryFile = new File(systemDirectory = LauncherUtil.getSystemDirectory())).exists()) {
                    systemDirectoryFile.mkdirs();
                }
                String home = IdeBootProperties.getNetbeansHome();
                File nbHome = OracleIdeLauncher.abs(new File(home));
                IdeBootProperties.setNetbeansHome(nbHome.getPath());
                if (OracleIdeLauncher.isCriticallyLowDiskSpace(nbHome, systemDirectoryFile)) {
                    log.log(Level.SEVERE, "Shutting down because of critically low free disk space! ");
                    System.exit(1);
                    return;
                }
                String oracleDotHome = IdeBootProperties.getOracleHome();
                String middlewareHome = IdeBootProperties.getMiddlewareHome();
                if (oracleDotHome != null && middlewareHome == null) {
                    File f = new File(oracleDotHome);
                    String mwHomeRelative = System.getProperty("ide.mw.relative.home");
                    middlewareHome = mwHomeRelative != null ? new File(f, mwHomeRelative).getPath() : f.getParent();
                    IdeBootProperties.setMiddlewareHome(middlewareHome);
                }
                if ((patchesDir = OracleIdeLauncher.determinePatchesDir(oracleDotHome)).isAbsolute() && patchesDir.exists()) {
                    File[] patches = OracleIdeLauncher.listPatches(patchesDir);
                    if (patches != null) {
                        String patchesPropValue = OracleIdeLauncher.computePatchesPropertyValue(patches);
                        System.setProperty("oracle.ide.apply.patches", patchesPropValue);
                    } else {
                        System.err.println("WARNING: " + patchesDir + " was a file instead of a directory and will be ignored. Be sure that patches/ is a directory having <bundle id>.jar files that contains only the classes patched in the respective bundle.");
                    }
                }
                System.setProperty("osgi.framework.useSystemProperties", "true");
                boolean flushCache = false;
                String cleanProperty = IdeBootProperties.getOsgiCleanProperty();
                if (OracleIdeLauncher.isDropinsInfoOutOfDate(OracleIdeLauncher.getDropInDirectories(), log)) {
                    log.finer("dropins directory out of date");
                    flushCache = true;
                }
                if ("true".equals(cleanProperty)) {
                    log.finer("clean property specified");
                    flushCache = true;
                } else if (LauncherUtil.containsArgument(args, "-clean")) {
                    log.finer("contains -clean argument");
                    flushCache = true;
                    IdeBootProperties.setOsgiCleanProperty("true");
                }
                boolean triedOracleHomeAndFailed = false;
                if (flushCache && !CacheUtil.invalidateCacheFromOracleHome(log)) {
                    log.fine("Failed to invalidate the cache, will try again, but from the system directory");
                    triedOracleHomeAndFailed = true;
                }
                DynamicClusterFinder dcf = new DynamicClusterFinder();
                String absNetbeansDirs = OracleIdeLauncher.computeNetbeansDirsProperty(dcf);
                System.setProperty("netbeans.dirs", absNetbeansDirs);
                if (dcf.containsDynamicClusters() && LauncherUtil.isFirstStartUp()) {
                    flushCache = true;
                }
                if (!"true".equals(consoleProperty = IdeBootProperties.getOsgiConsoleProperty()) && LauncherUtil.containsArgument(args, "-console")) {
                    IdeBootProperties.setOsgiConsoleProperty("true");
                    System.setProperty("osgi.console.enable.builtin", "true");
                }
                if ((propertiesPath = System.getProperty("oracle.ide.print.launch.properties")) != null) {
                    try {
                        System.getProperties().store(new FileOutputStream(propertiesPath), null);
                    }
                    catch (IOException e) {
                        System.err.println("Exception printing launch properties to " + propertiesPath + " (System property oracle.ide.print.launch.properties): " + e);
                    }
                }
                NbBundle.setBranding((String)"jdev");
                int DEFAULT_MAX_NUMBER_OF_PROCESSES = 10;
                String maxNumberOfProcessesProp = System.getProperty("oracle.ide.maxNumberOfProcesses");
                if (maxNumberOfProcessesProp != null) {
                    try {
                        maxNumberOfProcessesAllowed = Integer.parseInt(maxNumberOfProcessesProp);
                        if (maxNumberOfProcessesAllowed < 1) {
                            System.err.println("max number of allowed processes can't be " + maxNumberOfProcessesAllowed + " .Setting it back to the default, " + 10);
                            maxNumberOfProcessesAllowed = 10;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        System.err.println("Can't parse " + maxNumberOfProcessesProp + " to an integer. Setting the value of max number of processes to " + 10);
                        maxNumberOfProcessesAllowed = 10;
                    }
                } else {
                    maxNumberOfProcessesAllowed = 10;
                }
                if ((cacheDir = IdeBootProperties.getNetbeansCacheDirectory()) == null) {
                    log.finer("About to find cacheDir");
                    for (int i = 0; i < maxNumberOfProcessesAllowed; ++i) {
                        File nbLockFile;
                        String scn = i == 0 ? "" : "_" + i;
                        File userDir = new File(systemDirectory, DEFAULT_SYSTEM_CACHE_DIR + scn);
                        if (!userDir.exists() && !Boolean.getBoolean("osgi.clean")) {
                            userDir.mkdirs();
                        }
                        if ((nbLockFile = new File(userDir, "lock")).exists()) {
                            log.log(Level.FINER, "lock file {0} found, trying to lock it", nbLockFile);
                            try (RandomAccessFile nioLockFile = new RandomAccessFile(nbLockFile, "rw");){
                                nioLockFile.getChannel().tryLock().release();
                            }
                        }
                        log.log(Level.FINE, "setting nb user directory to {0}", userDir);
                        IdeBootProperties.setNetbeansCacheDirectory(userDir.getPath());
                        if (flushCache) {
                            CacheUtil.invalidateCacheFromSystemDirectory(log);
                            if (!triedOracleHomeAndFailed) {
                                if (CacheUtil.invalidateCacheFromOracleHome(log)) {
                                    log.fine("Invalidated the NB cache from ${oracle.home}/netbeans/bridge");
                                } else {
                                    log.fine("Failed to invalidate the NB cache from ${oracle.home}/netbeans/bridge. Setting netbeans.fallback.cache=none for NB to ignore the fallback cache");
                                    System.setProperty("netbeans.fallback.cache", "none");
                                }
                            }
                        }
                        OracleIdeLauncher.attachExitHandlerIfNeeded();
                        if (!OracleIdeLauncher.launchNbMain(log)) continue;
                        return;
                    }
                    System.err.println("Maximum number of simultaneous IDE processes exceeded.");
                    break block41;
                }
                OracleIdeLauncher.attachExitHandlerIfNeeded();
                OracleIdeLauncher.launchNbMain(log);
            }
            catch (Exception e) {
                OracleIdeLauncher.disposeSplashScreen();
                e.printStackTrace(System.err);
                System.err.println("A fatal error in the IDE boostraping code. Exiting ...");
                System.exit(1);
            }
        }
    }

    private static void attachExitHandlerIfNeeded() {
        if (Boolean.getBoolean("oracle.ide.printStackTraceOnExit")) {
            System.setSecurityManager((SecurityManager)((Object)new PrintStackOnExitSecurityManager()));
        }
    }

    private static String computeNetbeansDirsProperty(DynamicClusterFinder dcf) {
        String productClusterDirs;
        ClusterDirBuilder clusterBuilder = new ClusterDirBuilder();
        String ideClusterDirs = IdeBootProperties.getIDEClusterDirectories();
        if (ideClusterDirs != null) {
            clusterBuilder.addClusters(OracleIdeLauncher.filterNonExistentPaths(OracleIdeLauncher.absolutizePaths(ideClusterDirs)));
        }
        if ((productClusterDirs = IdeBootProperties.getProductClusterDirectories()) != null) {
            clusterBuilder.addClusters(OracleIdeLauncher.filterNonExistentPaths(OracleIdeLauncher.absolutizePaths(productClusterDirs)));
        }
        Collection<String> currentlyKnownClusters = clusterBuilder.getClusters();
        dcf.computeDynamicClusters(currentlyKnownClusters.toArray(new String[currentlyKnownClusters.size()]));
        clusterBuilder.addClusters(dcf.getDynamicClusters()).addClusters(OracleIdeLauncher.getDropInDirectories());
        return clusterBuilder.buildClusterString();
    }

    private static boolean launchNbMain(Logger log) throws Exception {
        Main.main((String[])new String[0]);
        if (IdeBootProperties.getOsgiFrameworkVersion() != null) {
            if (Boolean.getBoolean("netbeans.close")) {
                log.info("netbeans.close property set, about to exit in 10s");
                Thread.sleep(10000L);
                log.info("10s passed. Exiting");
                LifecycleManager.getDefault().exit();
            }
            return true;
        }
        return false;
    }

    private static Collection<String> getDropInDirectories() {
        Properties systemProperties = System.getProperties();
        String confFilePath = systemProperties.getProperty("ide.conf");
        String mainDropinsDirPath = OracleIdeLauncher.abs(new File(confFilePath, MAIN_DROPINS_DIR_RELATIVE_PATH)).getPath();
        String bundleSearchPath = IdeBootProperties.getBundleSearchPath();
        ArrayList<String> absDropInDirsCollection = new ArrayList<String>();
        if (bundleSearchPath != null) {
            boolean containsPathSeparator = bundleSearchPath.contains(File.pathSeparator);
            if (containsPathSeparator) {
                for (String filePath : bundleSearchPath.split(File.pathSeparator)) {
                    absDropInDirsCollection.add(filePath);
                }
            } else {
                absDropInDirsCollection.add(bundleSearchPath);
            }
            if (!absDropInDirsCollection.contains(mainDropinsDirPath)) {
                absDropInDirsCollection.add(mainDropinsDirPath);
            }
        } else {
            bundleSearchPath = mainDropinsDirPath;
            IdeBootProperties.setBundleSearchPath(bundleSearchPath);
        }
        if (absDropInDirsCollection.isEmpty()) {
            absDropInDirsCollection.add(mainDropinsDirPath);
        }
        return absDropInDirsCollection;
    }

    private static Collection<String> filterNonExistentPaths(Collection<String> absFilePaths) {
        ArrayList<String> existingFilePaths = new ArrayList<String>();
        for (String absPath : absFilePaths) {
            File absFile = new File(absPath);
            if (!absFile.exists() || !absFile.isDirectory()) continue;
            existingFilePaths.add(absPath);
        }
        return existingFilePaths;
    }

    private static Collection<String> absolutizePaths(String paths) {
        String[] tokens = paths.split(COLUMN_PATH_SEPARATOR);
        String driveLetter = "";
        ArrayList<String> resultList = new ArrayList<String>();
        for (String token : tokens) {
            if (token.length() == 1) {
                driveLetter = token + COLUMN_PATH_SEPARATOR;
                continue;
            }
            token = driveLetter + token;
            File f = OracleIdeLauncher.abs(new File(token));
            String nextPath = f.getPath();
            if (!resultList.contains(nextPath)) {
                resultList.add(f.getPath());
            }
            driveLetter = "";
        }
        return resultList;
    }

    private static File abs(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (IOException ex) {
            return f.getAbsoluteFile();
        }
    }

    private static boolean isDropinsInfoOutOfDate(Collection<String> dropinsDirectories, Logger log) {
        return dropinsDirectories != null ? OracleIdeLauncher.processDropInsDirectories(dropinsDirectories, log) : false;
    }

    private static boolean processDropInsDirectories(Collection<String> dropInsDirectories, Logger log) {
        boolean isCacheOutOfDate = false;
        for (String path : dropInsDirectories) {
            String realPath = path.replace("/", File.separator);
            File dropInsDir = new File(realPath);
            File[] arr = dropInsDir.listFiles();
            if (arr != null) {
                Map<Object, Object> bundleEntries = new HashMap();
                String systemDirectory = LauncherUtil.getSystemDirectory();
                File supportDirectory = new File(systemDirectory, DROPINS_SUPPORT_DIR);
                if (!supportDirectory.exists()) {
                    supportDirectory.mkdir();
                }
                String bundlesInfoName = OracleIdeLauncher.computeBundlesInfoName(realPath);
                String bundlesInfoPath = new File(supportDirectory, bundlesInfoName).getPath();
                try {
                    bundleEntries = BundlesInfoUtil.readBundlesInfo(bundlesInfoPath);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                log.log(Level.FINE, "Processing dropins at {0}", dropInsDir);
                HashSet<Object> unprocessedEntries = !bundleEntries.isEmpty() ? new HashSet<Object>(bundleEntries.keySet()) : new HashSet();
                boolean wereDifferencesFound = false;
                for (File jarCandidate : arr) {
                    BundlesInfoUtil.BundleData data;
                    if (!OracleIdeLauncher.isCandidateExtensionArchive(jarCandidate)) continue;
                    String jarName = jarCandidate.getName();
                    if (bundleEntries.containsKey(jarName)) {
                        data = (BundlesInfoUtil.BundleData)bundleEntries.get(jarName);
                        if (jarCandidate.lastModified() != data.getTimestamp()) {
                            BundlesInfoUtil.BundleData updatedData = OracleIdeLauncher.getDropInBundleData(jarName, jarCandidate, log);
                            if (data != null) {
                                bundleEntries.put(jarName, updatedData);
                            }
                            wereDifferencesFound = true;
                        }
                        unprocessedEntries.remove(jarName);
                        continue;
                    }
                    data = OracleIdeLauncher.getDropInBundleData(jarName, jarCandidate, log);
                    if (data != null) {
                        bundleEntries.put(jarName, data);
                    }
                    wereDifferencesFound = true;
                }
                for (String string : unprocessedEntries) {
                    bundleEntries.remove(string);
                }
                if (bundlesInfoPath == null || !wereDifferencesFound && unprocessedEntries.isEmpty()) continue;
                BundlesInfoUtil.writeBundlesInfo(bundlesInfoPath, bundleEntries.values(), false);
                isCacheOutOfDate = true;
                continue;
            }
            log.log(Level.FINER, "No dropins found at {0}", dropInsDir);
        }
        return isCacheOutOfDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BundlesInfoUtil.BundleData getDropInBundleData(String relativePath, File file, Logger log) {
        JarFile jarFile = null;
        try {
            String symbolicName;
            jarFile = new JarFile(file);
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = null;
            if (manifest != null && (attributes = manifest.getMainAttributes()) != null && (symbolicName = attributes.getValue("Bundle-SymbolicName")) != null) {
                int semicolonIndex = symbolicName.indexOf(59);
                if (semicolonIndex != -1) {
                    symbolicName = symbolicName.substring(0, semicolonIndex);
                }
                String version = attributes.getValue("Bundle-Version");
                String bundleRelativePath = relativePath;
                int runLevel = 4;
                boolean enabled = false;
                long timestamp = file.lastModified();
                BundlesInfoUtil.BundleData bundleData = new BundlesInfoUtil.BundleData(symbolicName, version, bundleRelativePath, runLevel, enabled, timestamp);
                return bundleData;
            }
        }
        catch (IOException e) {
            log.log(Level.INFO, "Ignoring jar " + file, e);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    log.log(Level.FINE, "Failed to close jar " + file, e);
                }
            }
        }
        return null;
    }

    private static boolean isCandidateExtensionArchive(File f) {
        return f.getName().toUpperCase().endsWith(".JAR");
    }

    public static String computeBundlesInfoName(String dirPath) {
        String proposedName;
        try {
            byte[] bytesOfMessage = dirPath.getBytes("UTF-8");
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(bytesOfMessage);
            BigInteger bigInt = new BigInteger(1, digest);
            String suffix = bigInt.toString(16);
            int dirPathLength = dirPath.length();
            proposedName = "bundles_" + suffix + ".info";
            if (dirPathLength + proposedName.length() > 254) {
                proposedName = proposedName.substring(0, 254 - dirPathLength);
            }
        }
        catch (UnsupportedEncodingException e) {
            proposedName = OracleIdeLauncher.getSimpleBundlesInfoName(dirPath);
        }
        catch (NoSuchAlgorithmException e) {
            proposedName = OracleIdeLauncher.getSimpleBundlesInfoName(dirPath);
        }
        return proposedName;
    }

    private static String getSimpleBundlesInfoName(String dirPath) {
        String proposedName;
        int dirPathLength = dirPath.length();
        if (dirPathLength + (proposedName = "bundles_" + dirPath.replace(File.separator, "_") + ".info").length() > 254) {
            proposedName = proposedName.substring(0, 254 - dirPathLength);
        }
        return proposedName;
    }

    private static File[] listPatches(File patchesDirectory) {
        return patchesDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String lcName = name.toLowerCase();
                return lcName.endsWith(".jar") || lcName.endsWith(".zip") || lcName.endsWith(".rar");
            }
        });
    }

    private static String computePatchesPropertyValue(File[] patches) {
        StringBuffer buf = new StringBuffer();
        for (File patch : patches) {
            String fileName;
            int lastDotIndex;
            if (buf.length() > 0) {
                buf.append(";");
            }
            if ((lastDotIndex = (fileName = patch.getName()).lastIndexOf(".")) == -1) continue;
            buf.append(fileName.substring(0, lastDotIndex)).append(",").append(patch.getAbsolutePath());
        }
        return buf.toString();
    }

    private static File determinePatchesDir(String oracleHome) {
        File patchesDirPossiblyRelative;
        String patchesDirPropValue = IdeBootProperties.getPatchesDirectory();
        if (patchesDirPropValue == null) {
            patchesDirPropValue = "ide/lib/patches";
        }
        File patchesDirAbsolute = (patchesDirPossiblyRelative = new File(patchesDirPropValue)).isAbsolute() ? patchesDirPossiblyRelative : new File(oracleHome + File.separator + patchesDirPropValue);
        return patchesDirAbsolute;
    }

    public static void showSplashScreen(boolean noSplash, boolean noNag) {
        SplashScreen.IHiddenWindowFactory hiddenWindowFactory = new SplashScreen.IHiddenWindowFactory(){

            @Override
            public JFrame getHiddenWindow() {
                JFrame result = new JFrame();
                result.setUndecorated(true);
                result.setSize(0, 0);
                result.setLocationRelativeTo(null);
                result.setName("hiddenwindow");
                result.setTitle(LauncherUtil.getApplicationName());
                result.setIconImage(LauncherUtil.getHiddenFrameIcon());
                return result;
            }
        };
        if (noSplash || noNag) {
            JFrame hiddenWindow = hiddenWindowFactory.getHiddenWindow();
            SplashScreen.setHiddenWindow(hiddenWindow);
            if (hiddenWindow != null) {
                hiddenWindow.setVisible(true);
            }
        } else {
            _splashScreen = SplashScreen.createInstance(hiddenWindowFactory);
            if (_splashScreen != null) {
                _splashScreen.allocateIndeterminateProgress("startup", 10);
                _splashScreen.finalizeIndeterminateProgress("startup", 10, 500);
                String startupTitle = LauncherBundle.get("SPLASH_SCREEN_LOADING_TITLE");
                _splashScreen.updateProgressTitle("startup", startupTitle);
                _splashScreen.allocateDeterminateProgress("extensions", 40);
                _splashScreen.allocateDeterminateProgress("migration", 5);
                _splashScreen.allocateDeterminateProgress("initializing", 35);
                _splashScreen.allocateDeterminateProgress("windows", 5);
                _splashScreen.allocateDeterminateProgress("editors", 5);
                _splashScreen.display(true);
            }
        }
    }

    public static synchronized void disposeSplashScreen() {
        if (_splashScreen != null) {
            _splashScreen = null;
        }
    }

    private static boolean isCriticallyLowDiskSpace(File ... files) {
        long minimumDiskSpace = Long.getLong("ide.minimum.diskspace", 0x100000L);
        boolean isCritical = false;
        Logger log = Logger.getLogger(OracleIdeLauncher.class.getName());
        for (File file : files) {
            long timeBeforeTest = System.currentTimeMillis();
            long usableSpace = file.getUsableSpace();
            if (usableSpace < minimumDiskSpace) {
                isCritical = true;
                Object[] msgParams = new String[]{Long.toString(usableSpace), file.getAbsolutePath()};
                log.log(Level.SEVERE, "Critically low free disk space == {0} in the partition named by this path {1}.", msgParams);
                continue;
            }
            long testTime = System.currentTimeMillis() - timeBeforeTest;
            if (testTime <= 50L) continue;
            boolean slow = testTime > 200L;
            Level level = slow ? Level.INFO : Level.FINE;
            log.log(level, "File.getUsableSpace() took {0}ms", new String[]{Long.toString(testTime)});
            if (slow) break;
        }
        return isCritical;
    }

    static final class TouchesCounter {
        private static final String PROPERTY_OFF = "com.oracle.jdev.measure.disk.touches.off";
        private static int cnt;
        private static int ignored;
        private static StringWriter msgs;
        private static PrintWriter pw;
        private static String prefix;
        private static Map<String, Exception> who;
        private static Set<String> allowed;
        private static Mode mode;
        static boolean acceptAll;
        private static int limit;
        private static Map<StackTrace, StackTrace> traces;

        TouchesCounter() {
        }

        public static void initialize(String prefix, Mode mode, Set<String> allowedFiles) {
            TouchesCounter.setCnt(0);
            msgs = new StringWriter();
            pw = new PrintWriter(msgs);
            TouchesCounter.prefix = prefix;
            TouchesCounter.mode = mode;
            allowed = allowedFiles;
            Integer l = Integer.getInteger("com.oracle.jdev.measure.disk.touches.limit");
            if (l != null) {
                limit = l;
            }
            Logger.getLogger("org.netbeans.TopSecurityManager").setLevel(Level.OFF);
            System.setProperty("org.netbeans.TopSecurityManager.level", "3000");
            System.setProperty("counting.security.disabled", "false");
        }

        public String toString() {
            return msgs.toString();
        }

        public static void assertCounts(String msg, int expectedCnt) {
            System.out.println("Ignored touches : " + ignored);
            System.out.println("Illegal touches : " + cnt);
            TouchesCounter.printTracesByCount();
        }

        private static void printTracesByCount() {
            ArrayList<StackTrace> l = new ArrayList<StackTrace>(traces.keySet());
            Collections.sort(l);
            for (StackTrace st : l) {
                System.out.println("Invocations: " + st.count + " Files: " + st.files.size());
                for (StackTraceElement ste : st.elements) {
                    System.out.println(ste);
                }
                for (Map.Entry entry : st.files.entrySet()) {
                    System.out.println("  File: " + (String)entry.getKey() + (((int[])entry.getValue())[1] == -1 ? " OK " : " BAD ") + ((int[])entry.getValue())[0]);
                }
                System.out.println();
            }
        }

        public static int getCnt() {
            return cnt;
        }

        public static void setCnt(int aCnt) {
            cnt = aCnt;
        }

        public static void checkRead(String file) {
            if (limit >= 0 && traces.size() >= limit) {
                return;
            }
            if (mode != Mode.CHECK_READ) {
                return;
            }
            Exception now = new Exception("checkRead: " + file);
            boolean illegal = TouchesCounter.acceptFileRead(file);
            if (illegal) {
                String dirs = System.getProperty("netbeans.dirs");
                if (dirs == null && !acceptAll) {
                    return;
                }
                TouchesCounter.setCnt(TouchesCounter.getCnt() + 1);
                pw.println("checkRead: " + file);
                if (who.get(file) == null) {
                    who.put(file, now);
                    now.printStackTrace(pw);
                    pw.flush();
                }
            } else {
                ++ignored;
            }
            StackTrace st = new StackTrace(now.getStackTrace());
            StackTrace ext = traces.get(st);
            if (ext == null) {
                ext = st;
                traces.put(ext, ext);
            }
            ext.count++;
            ext.addFile(file, !illegal);
        }

        private static boolean acceptFileRead(String file) {
            if (Boolean.getBoolean(PROPERTY_OFF)) {
                return false;
            }
            return !TouchesCounter.isAllowedPrefix(file);
        }

        private static boolean isAllowedPrefix(String fname) {
            for (String ap : allowed) {
                if (!fname.startsWith(ap)) continue;
                return true;
            }
            return false;
        }

        static {
            who = new HashMap<String, Exception>();
            allowed = Collections.emptySet();
            limit = -1;
            traces = new HashMap<StackTrace, StackTrace>();
        }

        private static class StackTrace
        implements Comparable<StackTrace> {
            private int count;
            private Map<String, int[]> files;
            private StackTraceElement[] elements;

            public StackTrace(StackTraceElement[] elements) {
                this.elements = Arrays.copyOfRange(elements, 2, elements.length);
                this.files = new HashMap<String, int[]>();
            }

            public int hashCode() {
                int hash = 7;
                hash = 17 * hash + Arrays.hashCode(this.elements);
                return hash;
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                StackTrace other = (StackTrace)obj;
                return Arrays.equals(this.elements, other.elements);
            }

            @Override
            public int compareTo(StackTrace o) {
                return this.count - o.count;
            }

            private void addFile(String file, boolean ignored) {
                int[] tc = this.files.get(file);
                if (tc == null) {
                    tc = new int[]{0, ignored ? -1 : 1};
                    this.files.put(file, tc);
                }
                tc[0] = tc[0] + 1;
            }
        }

        public static enum Mode {
            CHECK_READ,
            CHECK_WRITE;

        }
    }

    private static class NonZeroExitCodePseudoException
    extends Exception {
        private NonZeroExitCodePseudoException() {
        }
    }

    private static final class PrintStackOnExitSecurityManager
    extends TopSecurityManager {
        private PrintStackOnExitSecurityManager() {
        }

        public void checkExit(int i) throws SecurityException {
            if (i != 0) {
                NonZeroExitCodePseudoException fakeException = new NonZeroExitCodePseudoException();
                String runnerClassName = System.getProperty("ide.runner.class");
                if (runnerClassName != null) {
                    StackTraceElement[] stackTraceElements;
                    for (StackTraceElement stackTraceElement : stackTraceElements = fakeException.getStackTrace()) {
                        if (!stackTraceElement.getClassName().equals(runnerClassName)) continue;
                        return;
                    }
                }
                System.out.println("Exiting with status " + i);
                fakeException.printStackTrace();
            }
        }
    }

    private static final class CountingSecurityManager
    extends TopSecurityManager {
        private static final String[] props = new String[]{"java.home", "java.class.path", "java.endorsed.libs", "java.ext.dirs", "sun.boot.class.path"};

        CountingSecurityManager() {
            HashSet<String> allowed = new HashSet<String>();
            for (String prop : props) {
                String pVal = System.getProperty(prop);
                if (pVal == null) continue;
                for (String cpfn : pVal.split(File.pathSeparator)) {
                    try {
                        allowed.add(new File(cpfn).getCanonicalPath());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            this.resolveManifests(allowed);
            allowed.add(LauncherUtil.getSystemDirectory());
            TouchesCounter.initialize("", TouchesCounter.Mode.CHECK_READ, allowed);
        }

        private void resolveManifests(Set<String> allowed) {
            try {
                Enumeration<URL> jars = ((Object)((Object)this)).getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
                while (jars.hasMoreElements()) {
                    File jar;
                    URL url = jars.nextElement();
                    String path = url.getPath();
                    int emi = path.indexOf(33);
                    if (emi < 0) continue;
                    path = path.substring(0, emi);
                    URL jarUrl = new URL(path);
                    allowed.add(jarUrl.getPath());
                    try {
                        jar = new File(jarUrl.toURI());
                    }
                    catch (URISyntaxException e) {
                        continue;
                    }
                    Manifest mf = new Manifest(url.openStream());
                    Attributes a = mf.getMainAttributes();
                    String cp = a.getValue("Class-Path");
                    if (cp == null) continue;
                    for (String cpf : cp.split(" ")) {
                        allowed.add(new File(jar, cpf).getAbsolutePath());
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void checkPermission(Permission perm) {
        }

        public void checkRead(String file) {
            TouchesCounter.checkRead(file);
            super.checkRead(file);
        }

        public void checkExit(int status) throws SecurityException {
            TouchesCounter.assertCounts("No Touches", 0);
        }
    }

    static class DynamicClusterFinder {
        Collection<String> dynamicClusters = null;
        Set<String> staticClusters = new HashSet<String>();

        DynamicClusterFinder() {
        }

        boolean containsDynamicClusters() {
            return this.dynamicClusters != null && this.dynamicClusters.size() > 0;
        }

        Collection<String> getDynamicClusters() {
            return this.dynamicClusters;
        }

        private void computeDynamicClusters(String ... knownClusters) {
            this.dynamicClusters = new ArrayList<String>();
            List<String> listOfKnownClusters = Arrays.asList(knownClusters);
            Collection<String> clustersFound = ConfigurationAreaScanner.getScanner().getDynamicClusters();
            for (String cluster : clustersFound) {
                if (listOfKnownClusters.contains(cluster)) continue;
                this.dynamicClusters.add(cluster);
            }
        }
    }

    private static class ClusterDirBuilder {
        Collection<Collection<String>> absoluteClusterDirsCollection = new ArrayList<Collection<String>>();

        private ClusterDirBuilder() {
        }

        ClusterDirBuilder addClusters(Collection<String> clusterDirs) {
            if (!clusterDirs.isEmpty()) {
                this.absoluteClusterDirsCollection.add(clusterDirs);
            }
            return this;
        }

        String buildClusterString() {
            StringBuilder sb = new StringBuilder();
            HashSet<String> addedAlready = new HashSet<String>();
            for (Collection<String> absoluteClusterDirs : this.absoluteClusterDirsCollection) {
                for (String cluster : absoluteClusterDirs) {
                    if (addedAlready.contains(cluster)) continue;
                    sb.append(sb.length() > 0 ? File.pathSeparator : "").append(cluster);
                }
                addedAlready.addAll(absoluteClusterDirs);
            }
            return sb.toString();
        }

        Collection<String> getClusters() {
            ArrayList<String> flatList = new ArrayList<String>();
            for (Collection<String> absoluteClusterDirs : this.absoluteClusterDirsCollection) {
                for (String cluster : absoluteClusterDirs) {
                    flatList.add(cluster);
                }
            }
            return flatList;
        }
    }
}

