/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.boot;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.Timer;
import oracle.ide.osgi.boot.ProgressBar;
import oracle.ide.osgi.boot.SplashScreenImpl;

public class SplashScreenProgressPlugin
implements SplashScreenImpl.ISplashScreenPlugin,
SplashScreenImpl.IProgressDialog {
    private static final Font PROGRESS_TITLE_FONT = new Font("SansSerif", 0, 9);
    private static final Font PROGRESS_DESCRIPTION_FONT = new Font("SansSerif", 0, 10);
    private static final Color PROGRESS_TITLE_COLOR = Color.BLACK;
    private static final Color PROGRESS_DESCRIPTION_COLOR = Color.BLACK;
    private static final int PROGRESS_BAR_TOP = 150;
    private static final int PROGRESS_BAR_WIDTH = 505;
    private static final int PROGRESS_BAR_HEIGHT = 60;
    private SplashScreenProgressBar _progressBar;
    private Object _progressBarMonitor = new Object();
    private int _width = -1;
    private int _height = -1;
    private LinkedList<SplashScreenImpl.IProgress> _progressItems = new LinkedList();
    private Map<String, SplashScreenImpl.IProgress> _progressItemsHash = new HashMap<String, SplashScreenImpl.IProgress>();
    private boolean _initialized = false;
    private static SplashScreenProgressPlugin _instance = null;
    private static Object _instanceMonitor = new Object();
    private SplashScreenImpl _splashScreen = null;
    private static long _lastRedraw = 0L;
    private static int _progressValue = 0;

    private SplashScreenProgressPlugin(SplashScreenImpl splashScreen) {
        this._splashScreen = splashScreen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SplashScreenProgressPlugin createInstance(SplashScreenImpl splashScreen) {
        Object object = _instanceMonitor;
        synchronized (object) {
            if (_instance == null) {
                _instance = new SplashScreenProgressPlugin(splashScreen);
                splashScreen.setPlugin(_instance);
            }
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SplashScreenProgressPlugin getInstance() {
        Object object = _instanceMonitor;
        synchronized (object) {
            return _instance;
        }
    }

    public void display(boolean value) {
        if (this._splashScreen != null) {
            this._splashScreen.display(value);
        }
    }

    @Override
    public SplashScreenImpl.IIndeterminateProgress allocateIndeterminateProgress(String name, int percentage) {
        IndeterminateProgress result = null;
        if (!this._initialized && this.findProgress(name) == null) {
            result = new IndeterminateProgress(name, percentage);
            this._progressItems.add(result);
            this._progressItemsHash.put(name, result);
        }
        return result;
    }

    @Override
    public SplashScreenImpl.IDeterminateProgress allocateDeterminateProgress(String name, int percentage) {
        DeterminateProgress result = null;
        if (!this._initialized && this.findProgress(name) == null) {
            result = new DeterminateProgress(name, percentage);
            this._progressItems.add(result);
            this._progressItemsHash.put(name, result);
        }
        return result;
    }

    @Override
    public void finalizeDeterminateProgress(String name, int count) {
        SplashScreenImpl.IDeterminateProgress determinateProgress;
        SplashScreenImpl.IProgress progress = this._progressItemsHash.get(name);
        if (progress != null && progress instanceof SplashScreenImpl.IDeterminateProgress && !(determinateProgress = (SplashScreenImpl.IDeterminateProgress)progress).initialized()) {
            determinateProgress.initialize(count);
        }
    }

    @Override
    public void finalizeIndeterminateProgress(String name, int count, int timeout) {
        SplashScreenImpl.IIndeterminateProgress determinateProgress;
        SplashScreenImpl.IProgress progress = this._progressItemsHash.get(name);
        if (progress != null && progress instanceof SplashScreenImpl.IIndeterminateProgress && !(determinateProgress = (SplashScreenImpl.IIndeterminateProgress)progress).initialized()) {
            determinateProgress.initialize(count, timeout);
        }
    }

    @Override
    public void completeProgress(String name) {
        SplashScreenImpl.IProgress progress = this._progressItemsHash.get(name);
        if (progress != null) {
            progress.stop();
        }
    }

    @Override
    public SplashScreenImpl.IProgress findProgress(String name) {
        SplashScreenImpl.IProgress result = this._progressItemsHash.get(name);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JComponent getComponent() {
        Object object = this._progressBarMonitor;
        synchronized (object) {
            if (this._progressBar == null) {
                this._progressBar = new SplashScreenProgressBar();
                this._progressBar.setSize(505, 60);
                int left = SplashScreenProgressPlugin.center(this._width, 505);
                this._progressBar.setLocation(left, 150);
            }
        }
        return this._progressBar;
    }

    private SplashScreenProgressBar getProgressBar() {
        return (SplashScreenProgressBar)this.getComponent();
    }

    @Override
    public void stop() {
        this.getProgressBar().stop();
    }

    @Override
    public void setSize(int width, int height) {
        this._width = width;
        this._height = height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        SplashScreenProgressPlugin splashScreenProgressPlugin = this;
        synchronized (splashScreenProgressPlugin) {
            if (!this._initialized) {
                this._initialized = true;
                int max = 0;
                for (SplashScreenImpl.IProgress progress : this._progressItems) {
                    SplashScreenImpl.IDeterminateProgress determinateProgress;
                    if (!(progress instanceof SplashScreenImpl.IDeterminateProgress) || !((determinateProgress = (SplashScreenImpl.IDeterminateProgress)progress) instanceof IInternalProgress)) continue;
                    max += ((IInternalProgress)((Object)determinateProgress)).getPercentage();
                }
                this.getProgressBar().setMax(max);
            }
        }
    }

    private void update(String title, String description, int value) {
        SplashScreenProgressBar progressBar = this.getProgressBar();
        int max = progressBar.getMax();
        if (progressBar.getValue() < max) {
            _progressValue += value;
            long now = System.nanoTime();
            if (now - _lastRedraw >= 50000000L) {
                _lastRedraw = now;
                progressBar.update(title, description, _progressValue);
                _progressValue = 0;
            }
            if (progressBar.getValue() >= max) {
                progressBar.stop();
            }
        }
    }

    private static int center(int p1, int p2) {
        return p1 / 2 - p2 / 2;
    }

    private final class IndeterminateProgress
    extends DeterminateProgress
    implements SplashScreenImpl.IIndeterminateProgress {
        private Timer _animationTimer;

        public IndeterminateProgress(String name, int percentage) {
            super(name, percentage);
        }

        @Override
        public void initialize(int count, int timeout) {
            super.initialize(count);
            this._animationTimer = new Timer(timeout, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!IndeterminateProgress.this.isCompleted()) {
                        IndeterminateProgress.this.incrementProgress(1);
                    }
                }
            });
            this._animationTimer.start();
        }

        @Override
        public void stop() {
            if (this._animationTimer != null) {
                this._animationTimer.stop();
                this._animationTimer = null;
            }
            super.stop();
        }
    }

    private class DeterminateProgress
    extends Progress
    implements SplashScreenImpl.IDeterminateProgress {
        private int _count;
        private int _remaining;
        private float _hold;
        private int _remainingPercentage;

        public DeterminateProgress(String name, int percentage) {
            super(name, percentage);
            this._count = -1;
            this._hold = 0.0f;
            this._remainingPercentage = percentage;
        }

        public boolean isCompleted() {
            return this._remaining <= 0;
        }

        @Override
        public boolean initialized() {
            return this._count != -1;
        }

        @Override
        public void initialize(int count) {
            this._count = count;
            this._remaining = count;
        }

        @Override
        public void stop() {
            if (this._progressState != SplashScreenImpl.ProgressState.COMPLETED) {
                if (this._remaining > 0) {
                    this.incrementProgress(this._remaining);
                } else {
                    super.stop();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void incrementProgress(int value) {
            if (this._count > 0 && this._remaining > 0) {
                int wholePercentage = 0;
                if (this._remaining >= value) {
                    this._remaining -= value;
                    float a = this._percentage;
                    float b = this._count;
                    float x = a / b;
                    this._hold += (x *= (float)value);
                    wholePercentage = (int)this._hold;
                } else {
                    wholePercentage = this._remaining;
                    this._remaining = 0;
                }
                if (this._remaining == 0) {
                    SplashScreenImpl.ProgressState progressState = this._progressState;
                    synchronized (progressState) {
                        this._progressState = SplashScreenImpl.ProgressState.COMPLETED;
                    }
                    if (this._remainingPercentage > wholePercentage) {
                        wholePercentage = this._remainingPercentage;
                    }
                }
                if (wholePercentage > 0) {
                    this._remainingPercentage -= wholePercentage;
                    this._hold -= (float)wholePercentage;
                    SplashScreenProgressPlugin.this.update(this._title, this._description, wholePercentage);
                    return;
                }
            }
            SplashScreenProgressPlugin.this.update(this._title, this._description, 0);
        }
    }

    private class Progress
    implements SplashScreenImpl.IProgress,
    IInternalProgress {
        private String _name;
        protected SplashScreenImpl.ProgressState _progressState = SplashScreenImpl.ProgressState.NOTSTARTED;
        protected String _title = "";
        protected String _description = "";
        protected int _percentage;

        public Progress(String name, int percentage) {
            this._name = name;
            this._percentage = percentage;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public int getPercentage() {
            return this._percentage;
        }

        @Override
        public void setTitle(String value) {
            this._title = value;
            SplashScreenProgressPlugin.this.update(this._title, this._description, 0);
        }

        @Override
        public String getTitle() {
            return this._title;
        }

        @Override
        public void setDescription(String value) {
            this._description = value;
        }

        @Override
        public String getDescription() {
            return this._description;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean start() {
            boolean result = false;
            SplashScreenImpl.ProgressState progressState = this._progressState;
            synchronized (progressState) {
                if (this._progressState == SplashScreenImpl.ProgressState.NOTSTARTED) {
                    this._progressState = SplashScreenImpl.ProgressState.RUNNING;
                    result = true;
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            if (this._progressState != SplashScreenImpl.ProgressState.COMPLETED) {
                SplashScreenImpl.ProgressState progressState = this._progressState;
                synchronized (progressState) {
                    this._progressState = SplashScreenImpl.ProgressState.COMPLETED;
                }
                if (this._percentage > 0) {
                    SplashScreenProgressPlugin.this.update(this._title, this._description, this._percentage);
                }
            }
        }

        @Override
        public SplashScreenImpl.ProgressState getProgressState() {
            return this._progressState;
        }
    }

    private static interface IInternalProgress {
        public int getPercentage();
    }

    private final class SplashScreenProgressBar
    extends ProgressBar {
        private String _title;
        private String _description;
        private final Runnable _repainter;
        private boolean _initialized;
        private int _descriptionTextHeight;
        private int _titleTextHeight;

        public SplashScreenProgressBar() {
            super(0, 0);
            this._title = "";
            this._description = "";
            this._initialized = false;
            this._repainter = new Runnable(){

                @Override
                public void run() {
                    SplashScreenProgressBar.this.repaint();
                }
            };
        }

        @Override
        public void paintComponent(Graphics g) {
            int padding = 5;
            Graphics2D graphics = (Graphics2D)g;
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics.setFont(PROGRESS_TITLE_FONT);
            graphics.setColor(PROGRESS_TITLE_COLOR);
            if (!this._initialized) {
                FontMetrics fm = graphics.getFontMetrics();
                this._titleTextHeight = fm.getHeight();
            }
            if (this._title != null) {
                graphics.drawString(this._title, 0, this._titleTextHeight);
            }
            int y = this._titleTextHeight + padding;
            int progressBarHeight = 16;
            this.paintProgressBar(g, 0, y, this.getWidth(), progressBarHeight);
            y += progressBarHeight;
            graphics.setFont(PROGRESS_DESCRIPTION_FONT);
            graphics.setColor(PROGRESS_DESCRIPTION_COLOR);
            if (!this._initialized) {
                this._initialized = true;
                FontMetrics fm = graphics.getFontMetrics();
                this._descriptionTextHeight = fm.getHeight();
            }
            if (this._description != null) {
                graphics.drawString(this._description, 0, y + this._descriptionTextHeight);
            }
        }

        public void update(String title, String description, int value) {
            if (this._title != title) {
                this._title = title;
            }
            if (this._description != description) {
                this._description = description;
            }
            this.setValue(this.getValue() + value);
        }
    }
}

