/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.deferredupdate.task;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import oracle.ideimpl.deferredupdate.UpdateArb;
import oracle.ideimpl.deferredupdate.task.AtomicTask;
import oracle.ideimpl.deferredupdate.task.TaskContext;
import oracle.ideimpl.deferredupdate.task.TaskFailedException;

final class CopyFile
extends AtomicTask {
    private File _originalFile;
    private File _newFile;

    CopyFile(File originalFile, File newFile) {
        this._originalFile = originalFile;
        this._newFile = newFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(TaskContext tc) throws TaskFailedException {
        if (this._originalFile == null || this._newFile == null || !this._originalFile.exists()) {
            this._newFile = null;
            return;
        }
        try {
            FileInputStream in = null;
            FileOutputStream out = null;
            try {
                int len;
                in = new FileInputStream(this._originalFile);
                out = new FileOutputStream(this._newFile);
                byte[] bytes = new byte[4096];
                while ((len = in.read(bytes)) > 0) {
                    out.write(bytes, 0, len);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (Exception ex) {
            throw new TaskFailedException(UpdateArb.format("COPY_FAILED", this._originalFile.getPath(), this._newFile.getPath()));
        }
    }

    @Override
    public void rollback(TaskContext tc) throws TaskFailedException {
        if (this._newFile != null && this._newFile.exists()) {
            this._newFile.delete();
        }
    }
}

