/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.deferredupdate.task;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Logger;
import oracle.ideimpl.deferredupdate.UpdateArb;
import oracle.ideimpl.deferredupdate.task.AtomicTask;
import oracle.ideimpl.deferredupdate.task.DeleteFile;
import oracle.ideimpl.deferredupdate.task.PatchUnzipTask;
import oracle.ideimpl.deferredupdate.task.TaskContext;
import oracle.ideimpl.deferredupdate.task.TaskFailedException;
import oracle.ideimpl.deferredupdate.task.TaskStack;

class InstallPatchTask
extends AtomicTask {
    private static final String META_INF_PATTERN = "^meta-inf.*";
    private static final Logger LOG = Logger.getLogger(InstallPatchTask.class.getName());
    private TaskStack _tasks;
    private List<String> patchUpdateNames = new ArrayList<String>();
    private List<String> patchNames = new ArrayList<String>();
    private String command;
    private String zipFileName;
    private String destinationDir;
    private boolean deleteZip;
    private String oracleHome;

    InstallPatchTask(String command, String zipFileName, String destinationDir, boolean deleteZip, List<String> updateIds, String oracleHome) {
        this.command = command;
        this.zipFileName = zipFileName;
        this.destinationDir = destinationDir;
        this.deleteZip = deleteZip;
        this.oracleHome = oracleHome;
        this.patchUpdateNames.addAll(updateIds);
        if (this.patchUpdateNames.size() > 1) {
            LOG.warning("Multiple OPatches In Bundle" + zipFileName);
        }
    }

    @Override
    public void perform(TaskContext tc) throws TaskFailedException {
        this._tasks = new TaskStack();
        File zipFile = new File(this.zipFileName);
        if (!zipFile.exists() || !zipFile.canRead()) {
            throw new TaskFailedException(UpdateArb.format("READ_FAILED", zipFile.getPath()));
        }
        File destinationFile = new File(this.zipFileName.substring(0, this.zipFileName.lastIndexOf(File.separator)));
        PatchUnzipTask unzipTask = new PatchUnzipTask(zipFile, destinationFile, this.patchNames);
        unzipTask.addSkipPattern(META_INF_PATTERN);
        this._tasks.performTask(unzipTask, tc);
        for (String patchName : this.patchNames) {
            String patchPath = destinationFile.getPath() + File.separator + patchName;
            this.installPatch(patchPath);
        }
        if (this.deleteZip) {
            this._tasks.performTask(new DeleteFile(zipFile), tc);
        }
    }

    private void installPatch(String patchPath) throws TaskFailedException {
        LOG.info(UpdateArb.format("PATCH_INSTALLING", patchPath));
        int retCode = 0;
        try {
            String mwHome = this.oracleHome + (this.oracleHome.substring(this.oracleHome.length() - 1).equals(File.separator) ? "" : File.separator) + "..";
            ProcessBuilder pb = new ProcessBuilder((mwHome + File.separator + this.command + ";" + patchPath).split(";"));
            Map<String, String> env = pb.environment();
            env.put("ORACLE_HOME", this.destinationDir);
            pb.redirectErrorStream(true);
            Process p = pb.start();
            final BufferedWriter stdOutput = new BufferedWriter(new OutputStreamWriter(p.getOutputStream()));
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            final Scanner scan = new Scanner(System.in);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (scan.hasNext()) {
                        String input = scan.nextLine();
                        try {
                            stdOutput.write(input + "\n");
                            stdOutput.flush();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                }
            }).start();
            String s = stdInput.readLine();
            while (s != null) {
                LOG.info(s);
                s = stdInput.readLine();
            }
            retCode = p.waitFor();
            if (retCode == 0) {
                LOG.info(UpdateArb.format("PATCH_INSTALL_SUCCESS", patchPath));
            } else {
                LOG.warning(UpdateArb.format("PATCH_INSTALL_FAILED", patchPath));
            }
        }
        catch (IOException ioe) {
            throw new TaskFailedException(UpdateArb.format("PATCH_NOT_FOUND", new Object[0]));
        }
        catch (InterruptedException ir) {
            throw new TaskFailedException(UpdateArb.format("PATCH_INSTALL_INTERRUPTED", patchPath));
        }
    }

    @Override
    public void rollback(TaskContext tc) throws TaskFailedException {
        if (this._tasks != null) {
            this._tasks.rollbackTasks(tc);
        }
    }

    @Override
    public void commit(TaskContext tc) throws TaskFailedException {
        this._tasks.commitTasks(tc);
    }
}

