/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.security;

import java.util.Base64;
import oracle.spatial.security.SecureRandom;

public class ChecksumHelper {
    private static final byte[] _k = new byte[]{76, 42, 44, 32, 122, 10, 51, 106, 48, 81};
    private static final byte[] _iv = new byte[]{65, 51, 115, 13, 122, 48, 113, 93};
    private static final String MALFORMED_PASSWORD = "Malformed passwords detected. Please check your config file.";
    protected static final int SEASONING = 8;
    private static final CEng _osdeng = new CEng(ChecksumHelper.iv());
    private static final CEng _eng = new CEng(ChecksumHelper.iv(false));
    private static final Base64.Encoder _b64enc = Base64.getEncoder();
    private static final Base64.Decoder _b64dec = Base64.getDecoder();
    private static final SecureRandom _rand = new SecureRandom();

    private static final byte[] iv() {
        return ChecksumHelper.iv(true);
    }

    private static final byte[] iv(boolean bl) {
        return _iv;
    }

    static synchronized byte[] enc(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        Object object;
        if (byArray == null) {
            return null;
        }
        byte[] byArray5 = new byte[8];
        System.arraycopy(byArray4, 0, byArray5, 0, byArray5.length);
        byte[] byArray6 = new byte[byArray.length + 8];
        System.arraycopy(byArray5, 0, byArray6, 0, byArray5.length);
        System.arraycopy(byArray, 0, byArray6, byArray5.length, byArray.length);
        byte[] byArray7 = null;
        if (byArray2 != null) {
            object = new CEng(byArray2);
            byArray7 = ((CEng)object).processBuffer(byArray6, byArray3, true);
        } else {
            byArray7 = _eng.processBuffer(byArray6, byArray3, true);
        }
        object = new byte[byArray7.length + 8];
        System.arraycopy(byArray5, 0, object, 0, byArray5.length);
        System.arraycopy(byArray7, 0, object, byArray5.length, byArray7.length);
        return object;
    }

    static synchronized byte[] enc(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (byArray == null) {
            return null;
        }
        byte[] byArray4 = new byte[8];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray4.length);
        byte[] byArray5 = new byte[byArray.length + 8];
        System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
        System.arraycopy(byArray, 0, byArray5, byArray4.length, byArray.length);
        byte[] byArray6 = _eng.processBuffer(byArray5, byArray2, true);
        byte[] byArray7 = new byte[byArray6.length + 8];
        System.arraycopy(byArray4, 0, byArray7, 0, byArray4.length);
        System.arraycopy(byArray6, 0, byArray7, byArray4.length, byArray6.length);
        return byArray7;
    }

    static byte[] enc(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[8];
        _rand.nextBytes(byArray3);
        return ChecksumHelper.enc(byArray, byArray2, byArray3);
    }

    static byte[] encWithSalt(byte[] byArray, byte[] byArray2) {
        return ChecksumHelper.enc(byArray, _k, byArray2);
    }

    static byte[] enc(byte[] byArray) {
        return ChecksumHelper.enc(byArray, _k);
    }

    static byte[] enc(String string, String string2) {
        return ChecksumHelper.enc(string.getBytes(), string2.getBytes());
    }

    public static byte[] enc(String string) {
        return ChecksumHelper.enc(string.getBytes(), _k);
    }

    static String encAsc(byte[] byArray, byte[] byArray2) {
        return _b64enc.encodeToString(ChecksumHelper.enc(byArray, byArray2));
    }

    public static String encAsc(byte[] byArray) {
        return _b64enc.encodeToString(ChecksumHelper.enc(byArray, _k));
    }

    static String encAsc(String string, String string2) {
        return ChecksumHelper.encAsc(string.getBytes(), string2.getBytes());
    }

    public static String encAsc(String string) {
        return ChecksumHelper.encAsc(string.getBytes(), _k);
    }

    static byte[] dec(byte[] byArray, byte[] byArray2) {
        try {
            if (byArray == null) {
                return null;
            }
            byte[] byArray3 = new byte[byArray.length - 8];
            System.arraycopy(byArray, 8, byArray3, 0, byArray3.length);
            byte[] byArray4 = _eng.processBuffer(byArray3, byArray2, false);
            byte[] byArray5 = new byte[byArray4.length - 8];
            System.arraycopy(byArray4, 8, byArray5, 0, byArray4.length - 8);
            return byArray5;
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            return null;
        }
    }

    static byte[] dec(byte[] byArray) {
        return ChecksumHelper.dec(byArray, _k);
    }

    static byte[] dec(String string, String string2) {
        return ChecksumHelper.dec(string.getBytes(), string2.getBytes());
    }

    static byte[] dec(String string) {
        return ChecksumHelper.dec(string.getBytes(), _k);
    }

    static String decAsc(String string, String string2) {
        if (string == null) {
            return null;
        }
        try {
            Base64.Decoder decoder = Base64.getDecoder();
            byte[] byArray = decoder.decode(string);
            return new String(ChecksumHelper.dec(byArray, string2.getBytes()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            throw illegalArgumentException;
        }
    }

    public static String decAsc(String string) {
        return ChecksumHelper.decAsc(string, new String(_k));
    }

    static byte[] ob(String string) {
        if (string.equals("")) {
            return null;
        }
        return ChecksumHelper.ob(string.getBytes());
    }

    static byte[] ob(byte[] byArray) {
        byte[] byArray2 = new byte[8];
        _rand.nextBytes(byArray2);
        return ChecksumHelper.ob(byArray, byArray2);
    }

    static synchronized byte[] ob(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        Object object;
        if (byArray == null) {
            return null;
        }
        byte[] byArray4 = new byte[8];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray4.length);
        byte[] byArray5 = new byte[byArray.length + 8];
        System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
        System.arraycopy(byArray, 0, byArray5, byArray4.length, byArray.length);
        byte[] byArray6 = null;
        if (byArray2 != null) {
            object = new CEng(byArray2);
            byArray6 = ((CEng)object).processBuffer(byArray5, _k, true);
        } else {
            byArray6 = _osdeng.processBuffer(byArray5, _k, true);
        }
        object = new byte[byArray6.length + 8];
        System.arraycopy(byArray4, 0, object, 0, byArray4.length);
        System.arraycopy(byArray6, 0, object, byArray4.length, byArray6.length);
        return object;
    }

    static synchronized byte[] ob(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return null;
        }
        byte[] byArray3 = new byte[8];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
        byte[] byArray4 = new byte[byArray.length + 8];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        System.arraycopy(byArray, 0, byArray4, byArray3.length, byArray.length);
        byte[] byArray5 = _osdeng.processBuffer(byArray4, _k, true);
        byte[] byArray6 = new byte[byArray5.length + 8];
        System.arraycopy(byArray3, 0, byArray6, 0, byArray3.length);
        System.arraycopy(byArray5, 0, byArray6, byArray3.length, byArray5.length);
        return byArray6;
    }

    public static String obAsc(byte[] byArray) {
        return _b64enc.encodeToString(ChecksumHelper.ob(byArray));
    }

    public static String obAsc(String string) {
        return _b64enc.encodeToString(ChecksumHelper.ob(string));
    }

    public static byte[] db(byte[] byArray) {
        try {
            if (byArray == null) {
                return null;
            }
            byte[] byArray2 = new byte[byArray.length - 8];
            System.arraycopy(byArray, 8, byArray2, 0, byArray2.length);
            byte[] byArray3 = _osdeng.processBuffer(byArray2, _k, false);
            byte[] byArray4 = new byte[byArray3.length - 8];
            System.arraycopy(byArray3, 8, byArray4, 0, byArray3.length - 8);
            return byArray4;
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            return null;
        }
    }

    static byte[] db(String string) {
        return ChecksumHelper.db(string.getBytes());
    }

    static String dbAsc(String string) {
        if (string == null) {
            return null;
        }
        try {
            byte[] byArray = _b64dec.decode(string);
            return new String(ChecksumHelper.db(byArray));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            throw illegalArgumentException;
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            return null;
        }
    }

    public static void main(String[] stringArray) {
        String string = "asdf;lkj";
        String string2 = "Your lips are smoother than vaseline!";
        String string3 = ChecksumHelper.encAsc(string2, string);
        String string4 = ChecksumHelper.decAsc(string3, string);
        System.out.println("decrypted from this encryption : " + string4);
        string3 = "tZubGcmUTfqjhkCNCsJDAb49+jpeatNpog+y8H+Bftp6QEyeTsEGz1WL5ixzH5BMriEQNnClIuo=";
        string4 = ChecksumHelper.decAsc(string3, string);
        System.out.println("decrypted from saved encryption :" + string4);
        string3 = ChecksumHelper.encAsc(string2);
        string4 = ChecksumHelper.decAsc(string3);
        System.out.println("decrypted (default key): " + string4);
    }

    private static class CEng {
        private static final int DES_BLOCKLEN = 8;
        private int[] _ks;
        private int _opm;
        private byte[] _chainBlock;
        private byte[] _myIV;
        private byte[] _previous;
        private static final int DESKEYLEN = 8;
        private static byte[] bytebit = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
        private static int[] bigbyte = new int[]{0x800000, 0x400000, 0x200000, 0x100000, 524288, 262144, 131072, 65536, 32768, 16384, 8192, 4096, 2048, 1024, 512, 256, 128, 64, 32, 16, 8, 4, 2, 1};
        private static int[] totrot = new int[]{1, 2, 4, 6, 8, 10, 12, 14, 15, 17, 19, 21, 23, 25, 27, 28};
        private static byte[] PC1 = new byte[]{56, 48, 40, 32, 24, 16, 8, 0, 57, 49, 41, 33, 25, 17, 9, 1, 58, 50, 42, 34, 26, 18, 10, 2, 59, 51, 43, 35, 62, 54, 46, 38, 30, 22, 14, 6, 61, 53, 45, 37, 29, 21, 13, 5, 60, 52, 44, 36, 28, 20, 12, 4, 27, 19, 11, 3};
        private static byte[] PC2 = new byte[]{13, 16, 10, 23, 0, 4, 2, 27, 14, 5, 20, 9, 22, 18, 11, 3, 25, 7, 15, 6, 26, 19, 12, 1, 40, 51, 30, 36, 46, 54, 29, 39, 50, 44, 32, 47, 43, 48, 38, 55, 33, 52, 45, 41, 49, 35, 28, 31};
        private static final int[] SP1 = new int[]{0x1010400, 0, 65536, 0x1010404, 0x1010004, 66564, 4, 65536, 1024, 0x1010400, 0x1010404, 1024, 0x1000404, 0x1010004, 0x1000000, 4, 1028, 0x1000400, 0x1000400, 66560, 66560, 0x1010000, 0x1010000, 0x1000404, 65540, 0x1000004, 0x1000004, 65540, 0, 1028, 66564, 0x1000000, 65536, 0x1010404, 4, 0x1010000, 0x1010400, 0x1000000, 0x1000000, 1024, 0x1010004, 65536, 66560, 0x1000004, 1024, 4, 0x1000404, 66564, 0x1010404, 65540, 0x1010000, 0x1000404, 0x1000004, 1028, 66564, 0x1010400, 1028, 0x1000400, 0x1000400, 0, 65540, 66560, 0, 0x1010004};
        private static final int[] SP2 = new int[]{-2146402272, -2147450880, 32768, 1081376, 0x100000, 32, -2146435040, -2147450848, -2147483616, -2146402272, -2146402304, Integer.MIN_VALUE, -2147450880, 0x100000, 32, -2146435040, 0x108000, 0x100020, -2147450848, 0, Integer.MIN_VALUE, 32768, 1081376, -2146435072, 0x100020, -2147483616, 0, 0x108000, 32800, -2146402304, -2146435072, 32800, 0, 1081376, -2146435040, 0x100000, -2147450848, -2146435072, -2146402304, 32768, -2146435072, -2147450880, 32, -2146402272, 1081376, 32, 32768, Integer.MIN_VALUE, 32800, -2146402304, 0x100000, -2147483616, 0x100020, -2147450848, -2147483616, 0x100020, 0x108000, 0, -2147450880, 32800, Integer.MIN_VALUE, -2146435040, -2146402272, 0x108000};
        private static final int[] SP3 = new int[]{520, 0x8020200, 0, 0x8020008, 0x8000200, 0, 131592, 0x8000200, 131080, 0x8000008, 0x8000008, 131072, 0x8020208, 131080, 0x8020000, 520, 0x8000000, 8, 0x8020200, 512, 131584, 0x8020000, 0x8020008, 131592, 0x8000208, 131584, 131072, 0x8000208, 8, 0x8020208, 512, 0x8000000, 0x8020200, 0x8000000, 131080, 520, 131072, 0x8020200, 0x8000200, 0, 512, 131080, 0x8020208, 0x8000200, 0x8000008, 512, 0, 0x8020008, 0x8000208, 131072, 0x8000000, 0x8020208, 8, 131592, 131584, 0x8000008, 0x8020000, 0x8000208, 520, 0x8020000, 131592, 8, 0x8020008, 131584};
        private static final int[] SP4 = new int[]{8396801, 8321, 8321, 128, 0x802080, 0x800081, 0x800001, 8193, 0, 0x802000, 0x802000, 8396929, 129, 0, 0x800080, 0x800001, 1, 8192, 0x800000, 8396801, 128, 0x800000, 8193, 8320, 0x800081, 1, 8320, 0x800080, 8192, 0x802080, 8396929, 129, 0x800080, 0x800001, 0x802000, 8396929, 129, 0, 0, 0x802000, 8320, 0x800080, 0x800081, 1, 8396801, 8321, 8321, 128, 8396929, 129, 1, 8192, 0x800001, 8193, 0x802080, 0x800081, 8193, 8320, 0x800000, 8396801, 128, 0x800000, 8192, 0x802080};
        private static final int[] SP5 = new int[]{256, 34078976, 0x2080000, 1107296512, 524288, 256, 0x40000000, 0x2080000, 1074266368, 524288, 0x2000100, 1074266368, 1107296512, 1107820544, 524544, 0x40000000, 0x2000000, 0x40080000, 0x40080000, 0, 0x40000100, 1107820800, 1107820800, 0x2000100, 1107820544, 0x40000100, 0, 0x42000000, 34078976, 0x2000000, 0x42000000, 524544, 524288, 1107296512, 256, 0x2000000, 0x40000000, 0x2080000, 1107296512, 1074266368, 0x2000100, 0x40000000, 1107820544, 34078976, 1074266368, 256, 0x2000000, 1107820544, 1107820800, 524544, 0x42000000, 1107820800, 0x2080000, 0, 0x40080000, 0x42000000, 524544, 0x2000100, 0x40000100, 524288, 0, 0x40080000, 34078976, 0x40000100};
        private static final int[] SP6 = new int[]{0x20000010, 0x20400000, 16384, 541081616, 0x20400000, 16, 541081616, 0x400000, 0x20004000, 0x404010, 0x400000, 0x20000010, 0x400010, 0x20004000, 0x20000000, 16400, 0, 0x400010, 536887312, 16384, 0x404000, 536887312, 16, 541065232, 541065232, 0, 0x404010, 0x20404000, 16400, 0x404000, 0x20404000, 0x20000000, 0x20004000, 16, 541065232, 0x404000, 541081616, 0x400000, 16400, 0x20000010, 0x400000, 0x20004000, 0x20000000, 16400, 0x20000010, 541081616, 0x404000, 0x20400000, 0x404010, 0x20404000, 0, 541065232, 16, 16384, 0x20400000, 0x404010, 16384, 0x400010, 536887312, 0, 0x20404000, 0x20000000, 0x400010, 536887312};
        private static final int[] SP7 = new int[]{0x200000, 0x4200002, 67110914, 0, 2048, 67110914, 0x200802, 69208064, 69208066, 0x200000, 0, 0x4000002, 2, 0x4000000, 0x4200002, 2050, 0x4000800, 0x200802, 0x200002, 0x4000800, 0x4000002, 0x4200000, 69208064, 0x200002, 0x4200000, 2048, 2050, 69208066, 0x200800, 2, 0x4000000, 0x200800, 0x4000000, 0x200800, 0x200000, 67110914, 67110914, 0x4200002, 0x4200002, 2, 0x200002, 0x4000000, 0x4000800, 0x200000, 69208064, 2050, 0x200802, 69208064, 2050, 0x4000002, 69208066, 0x4200000, 0x200800, 0, 2, 69208066, 0, 0x200802, 0x4200000, 2048, 0x4000002, 0x4000800, 2048, 0x200002};
        private static final int[] SP8 = new int[]{0x10001040, 4096, 262144, 0x10041040, 0x10000000, 0x10001040, 64, 0x10000000, 262208, 0x10040000, 0x10041040, 266240, 0x10041000, 266304, 4096, 64, 0x10040000, 0x10000040, 0x10001000, 4160, 266240, 262208, 0x10040040, 0x10041000, 4160, 0, 0, 0x10040040, 0x10000040, 0x10001000, 266304, 262144, 266304, 262144, 0x10041000, 4096, 64, 0x10040040, 4096, 266304, 0x10001000, 64, 0x10000040, 0x10040000, 0x10040040, 0x10000000, 262144, 0x10001040, 0, 0x10041040, 262208, 0x10000040, 0x10040000, 0x10001000, 0x10001040, 0, 0x10041040, 266240, 266240, 4160, 4160, 262208, 0x10000000, 0x10041000};

        public CEng(byte[] byArray) {
            this._myIV = byArray;
            this._chainBlock = new byte[8];
        }

        protected byte[] processBuffer(byte[] byArray, byte[] byArray2, boolean bl) {
            int n;
            if (byArray2.length < 8) {
                return "Error".getBytes();
            }
            byte[] byArray3 = new byte[CEng.getEncryptedLen(byArray.length)];
            byte[] byArray4 = new byte[8];
            this.parityKey(byArray2);
            this._ks = this.generateKey(byArray2, bl);
            System.arraycopy(this._myIV, 0, this._chainBlock, 0, 8);
            if (bl) {
                for (n = 0; n < byArray.length - 8; n += 8) {
                    System.arraycopy(byArray, n, byArray4, 0, 8);
                    this.encryptBlock(byArray4, byArray3, n);
                }
                int n2 = CEng.getEncryptedLen(byArray.length) - byArray.length;
                System.arraycopy(byArray, n, byArray4, 0, byArray.length - n);
                for (int i = 0; i < n2; ++i) {
                    byArray4[7 - i] = 0;
                }
                this.encryptBlock(byArray4, byArray3, n);
                return byArray3;
            }
            if (byArray.length % 8 != 0) {
                return "Error".getBytes();
            }
            for (n = 0; n < byArray.length; n += 8) {
                System.arraycopy(byArray, n, byArray4, 0, 8);
                this.decryptBlock(byArray4, byArray3, n);
            }
            int n3 = 0;
            n = byArray.length;
            while (byArray3[--n] == 0) {
                ++n3;
            }
            if (n3 >= 8) {
                return "Error".getBytes();
            }
            byte[] byArray5 = new byte[byArray.length - n3];
            System.arraycopy(byArray3, 0, byArray5, 0, byArray5.length);
            return byArray5;
        }

        private void encryptBlock(byte[] byArray, byte[] byArray2, int n) {
            byte[] byArray3 = new byte[8];
            CEng.byteXOR(byArray, this._chainBlock, byArray, 0);
            this.encryptBlk(byArray, this._chainBlock);
            System.arraycopy(this._chainBlock, 0, byArray2, n, 8);
        }

        private void decryptBlock(byte[] byArray, byte[] byArray2, int n) {
            byte[] byArray3 = new byte[8];
            this.decryptBlk(byArray, byArray3);
            CEng.byteXOR(this._chainBlock, byArray3, byArray2, n);
            System.arraycopy(byArray, 0, this._chainBlock, 0, 8);
        }

        public void encryptBlk(byte[] byArray, byte[] byArray2) {
            System.arraycopy(byArray, 0, byArray2, 0, 8);
            this.des_blk(byArray2, this._ks);
        }

        private void decryptBlk(byte[] byArray, byte[] byArray2) {
            System.arraycopy(byArray, 0, byArray2, 0, 8);
            this.des_blk(byArray2, this._ks);
        }

        private void des_blk(byte[] byArray, int[] nArray) {
            int[] nArray2 = new int[2];
            this.bytesToInts(byArray, nArray2);
            this.desfunc(nArray2, nArray);
            this.intsToBytes(nArray2, byArray);
        }

        private void bytesToInts(byte[] byArray, int[] nArray) {
            int n = 0;
            nArray[0] = (byArray[n] & 0xFF) << 24;
            nArray[0] = nArray[0] | (byArray[++n] & 0xFF) << 16;
            nArray[0] = nArray[0] | (byArray[++n] & 0xFF) << 8;
            nArray[0] = nArray[0] | byArray[++n] & 0xFF;
            nArray[1] = (byArray[++n] & 0xFF) << 24;
            nArray[1] = nArray[1] | (byArray[++n] & 0xFF) << 16;
            nArray[1] = nArray[1] | (byArray[++n] & 0xFF) << 8;
            nArray[1] = nArray[1] | byArray[++n] & 0xFF;
        }

        private void intsToBytes(int[] nArray, byte[] byArray) {
            int n = 0;
            byArray[n] = (byte)(nArray[0] >> 24 & 0xFF);
            byArray[++n] = (byte)(nArray[0] >> 16 & 0xFF);
            byArray[++n] = (byte)(nArray[0] >> 8 & 0xFF);
            byArray[++n] = (byte)(nArray[0] & 0xFF);
            byArray[++n] = (byte)(nArray[1] >> 24 & 0xFF);
            byArray[++n] = (byte)(nArray[1] >> 16 & 0xFF);
            byArray[++n] = (byte)(nArray[1] >> 8 & 0xFF);
            byArray[++n] = (byte)(nArray[1] & 0xFF);
        }

        private boolean isWeak(byte[] byArray, int n) {
            if (n + 8 > byArray.length) {
                return true;
            }
            int n2 = (byArray[n] & 0xFE) << 8 | byArray[n + 1] & 0xFE;
            int n3 = (byArray[n + 2] & 0xFE) << 8 | byArray[n + 3] & 0xFE;
            int n4 = (byArray[n + 4] & 0xFE) << 8 | byArray[n + 5] & 0xFE;
            int n5 = (byArray[n + 6] & 0xFE) << 8 | byArray[n + 7] & 0xFE;
            return !(n2 != 0 && n2 != 65278 || n3 != 0 && n3 != 65278 || n4 != 0 && n4 != 65278 || n5 != 0 && n5 != 65278);
        }

        private void parityKey(byte[] byArray) {
            for (int i = 0; i < byArray.length; ++i) {
                int n = 0;
                for (int j = 7; j >= 0; --j) {
                    n += byArray[i] >>> j & 1;
                }
                if (n & true) continue;
                int n2 = i;
                byArray[n2] = (byte)(byArray[n2] ^ 1);
            }
        }

        private int[] generateKey(byte[] byArray, boolean bl) {
            int n;
            int n2;
            int n3;
            byte[] byArray2 = new byte[56];
            byte[] byArray3 = new byte[56];
            int[] nArray = new int[32];
            for (n3 = 0; n3 < 56; ++n3) {
                n2 = PC1[n3];
                n = n2 & 7;
                byArray2[n3] = (byte)((byArray[n2 >>> 3] & bytebit[n]) != 0 ? 1 : 0);
            }
            for (int i = 0; i < 16; ++i) {
                n = bl ? i << 1 : 15 - i << 1;
                int n4 = n + 1;
                nArray[n4] = 0;
                nArray[n] = 0;
                for (n3 = 0; n3 < 28; ++n3) {
                    n2 = n3 + totrot[i];
                    byArray3[n3] = n2 < 28 ? byArray2[n2] : byArray2[n2 - 28];
                }
                for (n3 = 28; n3 < 56; ++n3) {
                    n2 = n3 + totrot[i];
                    byArray3[n3] = n2 < 56 ? byArray2[n2] : byArray2[n2 - 28];
                }
                for (n3 = 0; n3 < 24; ++n3) {
                    if (byArray3[PC2[n3]] != 0) {
                        int n5 = n;
                        nArray[n5] = nArray[n5] | bigbyte[n3];
                    }
                    if (byArray3[PC2[n3 + 24]] == 0) continue;
                    int n6 = n4;
                    nArray[n6] = nArray[n6] | bigbyte[n3];
                }
            }
            return this.cookey(nArray);
        }

        private void desfunc(int[] nArray, int[] nArray2) {
            boolean bl = false;
            int n = 0;
            int n2 = nArray[0];
            int n3 = nArray[1];
            int n4 = (n2 >>> 4 ^ n3) & 0xF0F0F0F;
            n3 ^= n4;
            n2 ^= n4 << 4;
            n4 = (n2 >>> 16 ^ n3) & 0xFFFF;
            n3 ^= n4;
            n2 ^= n4 << 16;
            n4 = (n3 >>> 2 ^ n2) & 0x33333333;
            n2 ^= n4;
            n3 ^= n4 << 2;
            n4 = (n3 >>> 8 ^ n2) & 0xFF00FF;
            n2 ^= n4;
            n3 ^= n4 << 8;
            n3 = (n3 << 1 | n3 >>> 31 & 1) & 0xFFFFFFFF;
            n4 = (n2 ^ n3) & 0xAAAAAAAA;
            n2 ^= n4;
            n3 ^= n4;
            n2 = (n2 << 1 | n2 >>> 31 & 1) & 0xFFFFFFFF;
            for (int i = 0; i < 8; ++i) {
                n4 = n3 << 28 | n3 >>> 4;
                long l = 0L;
                l = nArray2[n] | 0;
                n4 ^= nArray2[n];
                int n5 = SP7[n4 & 0x3F];
                n5 |= SP5[n4 >>> 8 & 0x3F];
                n5 |= SP3[n4 >>> 16 & 0x3F];
                n5 |= SP1[n4 >>> 24 & 0x3F];
                n4 = n3 ^ nArray2[++n];
                ++n;
                n5 |= SP8[n4 & 0x3F];
                n5 |= SP6[n4 >>> 8 & 0x3F];
                n5 |= SP4[n4 >>> 16 & 0x3F];
                n2 ^= (n5 |= SP2[n4 >>> 24 & 0x3F]);
                n4 = n2 << 28 | n2 >>> 4;
                n4 ^= nArray2[n];
                n5 = SP7[n4 & 0x3F];
                n5 |= SP5[n4 >>> 8 & 0x3F];
                n5 |= SP3[n4 >>> 16 & 0x3F];
                n5 |= SP1[n4 >>> 24 & 0x3F];
                n4 = n2 ^ nArray2[++n];
                ++n;
                n5 |= SP8[n4 & 0x3F];
                n5 |= SP6[n4 >>> 8 & 0x3F];
                n5 |= SP4[n4 >>> 16 & 0x3F];
                n3 ^= (n5 |= SP2[n4 >>> 24 & 0x3F]);
            }
            n3 = n3 << 31 | n3 >>> 1;
            n4 = (n2 ^ n3) & 0xAAAAAAAA;
            n2 ^= n4;
            n3 ^= n4;
            n2 = n2 << 31 | n2 >>> 1;
            n4 = (n2 >>> 8 ^ n3) & 0xFF00FF;
            n3 ^= n4;
            n2 ^= n4 << 8;
            n4 = (n2 >>> 2 ^ n3) & 0x33333333;
            n3 ^= n4;
            n2 ^= n4 << 2;
            n4 = (n3 >>> 16 ^ n2) & 0xFFFF;
            n2 ^= n4;
            n3 ^= n4 << 16;
            n4 = (n3 >>> 4 ^ n2) & 0xF0F0F0F;
            nArray[0] = n3 ^= n4 << 4;
            nArray[1] = n2 ^= n4;
        }

        private int[] cookey(int[] nArray) {
            int[] nArray2 = new int[32];
            int[] nArray3 = nArray;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n < 16) {
                n2 = n3++;
                nArray2[n4] = (nArray3[n2] & 0xFC0000) << 6;
                int n5 = n4;
                nArray2[n5] = nArray2[n5] | (nArray3[n2] & 0xFC0) << 10;
                int n6 = n4;
                nArray2[n6] = nArray2[n6] | (nArray[n3] & 0xFC0000) >> 10;
                int n7 = n4++;
                nArray2[n7] = nArray2[n7] | (nArray[n3] & 0xFC0) >> 6;
                nArray2[n4] = (nArray3[n2] & 0x3F000) << 12;
                int n8 = n4;
                nArray2[n8] = nArray2[n8] | (nArray3[n2] & 0x3F) << 16;
                int n9 = n4;
                nArray2[n9] = nArray2[n9] | (nArray[n3] & 0x3F000) >> 4;
                int n10 = n4++;
                nArray2[n10] = nArray2[n10] | nArray[n3] & 0x3F;
                ++n;
                ++n3;
            }
            return nArray2;
        }

        private static int getEncryptedLen(int n) {
            if (n % 8 == 0) {
                return n;
            }
            return (n / 8 + 1) * 8;
        }

        protected static void byteXOR(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
            for (int i = 0; i < 8; ++i) {
                byArray3[i + n] = (byte)(byArray[i] ^ byArray2[i]);
            }
        }
    }
}

