/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.Serializable;
import oracle.spatial.geometry.JPoint2DD;
import oracle.spatial.geometry.Mer;

public class GeoHash
implements Serializable {
    private static final long serialVersionUID = -7226377382696157205L;
    public static final String base32 = "0123456789bcdefghjkmnpqrstuvwxyz";
    private static final int MAX_BITS = 64;
    private static final int MAX_HASH_LENGTH = 12;
    protected long bitsValue = 0L;
    protected short numberOfBits = 0;
    private JPoint2DD point;
    private double[] mer;
    private String ghString;
    private long value = 0L;
    private static final long MOST_SIGNIFICANT_BIT = Long.MIN_VALUE;

    public GeoHash() {
    }

    public GeoHash(double d, double d2, int n) {
        double d3 = -180.0;
        double d4 = 180.0;
        double d5 = -90.0;
        double d6 = 90.0;
        if (d < d3 || d > d4) {
            throw new IllegalArgumentException("Longitude is outside the range (-180 to +180)");
        }
        if (d2 < d5 || d2 > d6) {
            throw new IllegalArgumentException("Latitude is outside the range (-90 to +90)");
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        int n3 = 0;
        long l = 0L;
        while (stringBuffer.length() < n) {
            n2 *= 2;
            double d7 = (d3 + d4) / 2.0;
            if (d >= d7) {
                ++n2;
                d3 = d7;
            } else {
                d4 = d7;
            }
            n2 *= 2;
            d7 = (d5 + d6) / 2.0;
            if (d2 >= d7) {
                ++n2;
                d5 = d7;
            } else {
                d6 = d7;
            }
            if ((n3 += 2) < 5) continue;
            int n4 = n2 >> n3 - 5;
            n2 -= n4 << n3 - 5;
            n3 -= 5;
            l += l * 5L + (long)n4;
            stringBuffer.append(base32.charAt(n4));
        }
        this.ghString = stringBuffer.toString();
        GeoHash.setMer(this, GeoHash.asMer(this.ghString));
        this.bitsValue = GeoHash.decimalValue(this.ghString);
        this.numberOfBits = (short)GeoHash.geohashBits(d, d2, n * 5).length;
        this.value = this.bitsValue << 64 - this.numberOfBits;
    }

    public static GeoHash geohash(double d, double d2, int n) {
        if (n > 12) {
            throw new IllegalArgumentException("Geohash length is greater than maximum");
        }
        return new GeoHash(d, d2, n);
    }

    public static GeoHash geohashWithBitsLength(double d, double d2, int n) {
        if (n > 60) {
            throw new IllegalArgumentException("Number of geohash bits is greater than maximum");
        }
        if (n % 5 != 0) {
            throw new IllegalArgumentException("Number of geohash bits must be a multiple of the base");
        }
        return new GeoHash(d, d2, n / 5);
    }

    public static GeoHash geohash(String string) {
        if (string.length() > 60) {
            throw new IllegalArgumentException("Length of bit string is greater than maximum");
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() / 5);
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            n2 = 2 * n2 + Character.getNumericValue(Character.valueOf(string.charAt(i)).charValue());
            if (++n < 5) continue;
            stringBuffer.append(base32.charAt(n2));
            n = 0;
            n2 = 0;
        }
        if (n > 0) {
            throw new IllegalArgumentException("Number of geohash bits must be a multiple of the base");
        }
        String string2 = stringBuffer.toString();
        if (stringBuffer.charAt(0) == '0') {
            string2 = stringBuffer.substring(1);
        }
        GeoHash geoHash = new GeoHash();
        geoHash.ghString = string2;
        geoHash.mer = GeoHash.asMer(geoHash.ghString);
        geoHash.bitsValue = GeoHash.decimalValue(geoHash.ghString);
        geoHash.numberOfBits = (short)(string2.length() * 5);
        geoHash.value = geoHash.bitsValue << 64 - geoHash.numberOfBits;
        return geoHash;
    }

    public static GeoHash geohash(long l, int n) {
        if (n > 12) {
            throw new IllegalArgumentException("Hash length is greater than maximum");
        }
        String string = Long.toBinaryString(l);
        if (string.length() % 5 != 0) {
            string = GeoHash.addZeroesToLength(string, n);
        }
        return GeoHash.geohash(string);
    }

    public static GeoHash geohashFromString(String string) {
        if (string.length() > 12) {
            throw new IllegalArgumentException("Hash length is greater than maximum");
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (base32.indexOf(c) == -1) {
                throw new IllegalArgumentException("Character '" + string.charAt(i) + "' at position " + i + " not a valid NiemeyerGeohash charcter");
            }
            stringBuffer.append(c);
        }
        GeoHash geoHash = new GeoHash();
        geoHash.ghString = stringBuffer.toString();
        geoHash.mer = GeoHash.asMer(geoHash.ghString);
        geoHash.bitsValue = GeoHash.decimalValue(geoHash.ghString);
        geoHash.numberOfBits = (short)(string.length() * 5);
        geoHash.value = geoHash.bitsValue << 64 - geoHash.numberOfBits;
        return geoHash;
    }

    public static int[] geohashBits(double d, double d2, int n) {
        int[] nArray = new int[n];
        double d3 = -180.0;
        double d4 = 180.0;
        double d5 = -90.0;
        double d6 = 90.0;
        for (int i = 0; i < n; ++i) {
            double d7 = (d3 + d4) / 2.0;
            if (d >= d7) {
                nArray[i] = 1;
                d3 = d7;
            } else {
                nArray[i] = 0;
                d4 = d7;
            }
            if (++i >= n) break;
            d7 = (d5 + d6) / 2.0;
            if (d2 >= d7) {
                nArray[i] = 1;
                d5 = d7;
                continue;
            }
            nArray[i] = 0;
            d6 = d7;
        }
        return nArray;
    }

    public String getGeoHashString() {
        return this.ghString;
    }

    public double[] getMer() {
        return this.mer;
    }

    public short getNumberOfBits() {
        return this.numberOfBits;
    }

    public long getDecimalValue() {
        return this.bitsValue;
    }

    public JPoint2DD getCenterPoint() {
        double d = (this.mer[0] + this.mer[2]) / 2.0;
        double d2 = (this.mer[1] + this.mer[3]) / 2.0;
        return new JPoint2DD(d, d2);
    }

    public long getValue() {
        return this.value;
    }

    public String toBinaryString() {
        String string = Long.toBinaryString(this.bitsValue);
        int n = 0;
        while (n < this.numberOfBits - string.length()) {
            string = "0" + string;
        }
        return string;
    }

    public GeoHash next(int n) {
        return GeoHash.geohash(this.bitsValue + (long)n, this.numberOfBits / 5);
    }

    public GeoHash next() {
        return this.next(1);
    }

    public GeoHash prev() {
        return this.next(-1);
    }

    public static double[] asMer(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        double d = -180.0;
        double d2 = 180.0;
        double d3 = -90.0;
        double d4 = 90.0;
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        while (n2 > 0 || n3 < string.length()) {
            double d5;
            if (n2 == 0) {
                n = base32.indexOf(Character.toLowerCase(string.charAt(n3)));
                if (n == -1) {
                    throw new IllegalArgumentException("Character '" + string.charAt(n3) + "' at position " + n3 + " not a valid NiemeyerGeohash charcter");
                }
                n2 += 5;
                ++n3;
            }
            boolean bl2 = (n & 1 << n2 - 1) != 0;
            --n2;
            if (bl) {
                d5 = (d + d2) / 2.0;
                if (bl2) {
                    d = d5;
                    stringBuffer.append("1");
                } else {
                    d2 = d5;
                    stringBuffer.append("0");
                }
            } else {
                d5 = (d3 + d4) / 2.0;
                if (bl2) {
                    d3 = d5;
                    stringBuffer2.append("1");
                } else {
                    d4 = d5;
                    stringBuffer2.append("0");
                }
            }
            bl = !bl;
        }
        return new double[]{d, d3, d2, d4};
    }

    public static long numberOfStepsBetween(GeoHash geoHash, GeoHash geoHash2) {
        if (geoHash.numberOfBits != geoHash2.numberOfBits) {
            throw new IllegalArgumentException("Geohashes must be of same length");
        }
        return geoHash2.bitsValue - geoHash.bitsValue;
    }

    public GeoHash getGeoHashToTheNorth() {
        GeoHash geoHash = new GeoHash();
        geoHash = this.moveByACell(0, 1);
        return geoHash;
    }

    public GeoHash getGeoHashToTheEast() {
        GeoHash geoHash = new GeoHash();
        geoHash = this.moveByACell(1, 0);
        return geoHash;
    }

    public GeoHash getGeoHashToTheSouth() {
        GeoHash geoHash = new GeoHash();
        geoHash = this.moveByACell(0, -1);
        return geoHash;
    }

    public GeoHash getGeoHashToTheWest() {
        GeoHash geoHash = new GeoHash();
        geoHash = this.moveByACell(-1, 0);
        return geoHash;
    }

    public GeoHash[] getEightNeighbors() {
        GeoHash geoHash = this.getGeoHashToTheNorth();
        GeoHash geoHash2 = this.getGeoHashToTheEast();
        GeoHash geoHash3 = this.getGeoHashToTheSouth();
        GeoHash geoHash4 = this.getGeoHashToTheWest();
        GeoHash[] geoHashArray = new GeoHash[]{geoHash, geoHash.getGeoHashToTheEast(), geoHash2, geoHash2.getGeoHashToTheSouth(), geoHash3, geoHash3.getGeoHashToTheWest(), geoHash4, geoHash4.getGeoHashToTheNorth()};
        return geoHashArray;
    }

    public boolean within(GeoHash geoHash) {
        boolean bl = false;
        short s = this.numberOfBits;
        short s2 = geoHash.getNumberOfBits();
        if (s >= s2) {
            return false;
        }
        short s3 = (short)(s2 - s);
        long l = geoHash.getDecimalValue() >> s3;
        long l2 = this.bitsValue;
        long l3 = geoHash.getDecimalValue();
        bl = l == l2;
        return bl;
    }

    public boolean within(JPoint2DD jPoint2DD) {
        double[] dArray = this.getMer();
        return Mer.interacts((double[])dArray, (JPoint2DD)jPoint2DD);
    }

    public static long decimalValue(String string) {
        long l = 0L;
        for (int i = 0; i < string.length(); ++i) {
            int n = base32.indexOf(string.charAt(i));
            long l2 = Math.round(Math.pow(32.0, string.length() - (i + 1)));
            l += (long)n * l2;
        }
        return l;
    }

    public String geohashString(double d, double d2, int n) {
        GeoHash geoHash = GeoHash.geohash(d, d2, n);
        return this.ghString;
    }

    private static void setMer(GeoHash geoHash, double[] dArray) {
        geoHash.mer = dArray;
    }

    private int[] getAlternateBits(int[] nArray, int n) {
        int n2 = nArray.length / 2;
        if (nArray.length % 2 != 0 && n == 0) {
            ++n2;
        }
        int[] nArray2 = new int[n2];
        for (int i = n; i < nArray.length; i += 2) {
            nArray2[i / 2] = nArray[i];
        }
        return nArray2;
    }

    private long getAlternateBits(long l, int n) {
        long l2 = 0L;
        int n2 = this.numberOfBits / 2;
        if (n == 0 && this.numberOfBits % 2 != 0) {
            ++n2;
        }
        for (int i = 0; i < n2; ++i) {
            if ((l & Long.MIN_VALUE) == Long.MIN_VALUE) {
                l2 |= 1L;
            }
            l2 <<= 1;
            l <<= 2;
        }
        return l2 >>>= 1;
    }

    private static String addZeroesToLength(String string, int n) {
        int n2 = string.length();
        if (n2 == n || string == null) {
            return string;
        }
        String string2 = string;
        for (int i = 0; i < 5 * n - n2; ++i) {
            string2 = "0" + string2;
        }
        return string2;
    }

    private static long bitsToDecimalValue(int[] nArray) {
        long l = 0L;
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            long l2 = Math.round(Math.pow(2.0, nArray.length - (i + 1)));
            l += (long)n * l2;
        }
        return l;
    }

    private int[] toBinaryArrayWithoutPadding() {
        String string = Long.toBinaryString(this.bitsValue);
        int[] nArray = new int[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '0') {
                nArray[i] = 0;
            } else if (string.charAt(i) == '1') {
                nArray[i] = 1;
            } else {
                throw new IllegalArgumentException("Character '" + string.charAt(i) + "' at position " + i + " not a valid binary character");
            }
            int n = Character.getNumericValue(string.charAt(i));
        }
        return nArray;
    }

    private GeoHash moveByACell(int n, int n2) {
        long l = this.value;
        long l2 = this.value << 1;
        String string = Long.toBinaryString(this.value);
        int[] nArray = GeoHash.toBinaryArray(string);
        long l3 = this.getAlternateBits(l, 0);
        long l4 = this.getAlternateBits(l2, 1);
        l4 += (long)n2;
        l4 = this.maskLastNBits(l4, this.numberOfLonLatBits()[1]);
        String string2 = Long.toBinaryString(l4);
        String string3 = Long.toBinaryString(l3 += (long)n);
        int[] nArray2 = GeoHash.toBinaryArray(string2);
        int[] nArray3 = GeoHash.toBinaryArray(string3);
        GeoHash geoHash = this.interWeave(l3, l4);
        return geoHash;
    }

    private int[] numberOfLonLatBits() {
        if (this.numberOfBits % 2 == 0) {
            return new int[]{this.numberOfBits / 2, this.numberOfBits / 2};
        }
        return new int[]{this.numberOfBits / 2 + 1, this.numberOfBits / 2};
    }

    private long maskLastNBits(long l, long l2) {
        long l3 = -1L;
        return l & (l3 >>>= (int)(64L - l2));
    }

    private static long value(int[] nArray) {
        long l = nArray[nArray.length - 1];
        int n = nArray.length - 2;
        for (int i = 0; i < nArray.length; ++i) {
            long l2 = 2 << n;
            l += (long)nArray[i] * l2;
            --n;
        }
        return l;
    }

    private static int[] toBinaryArray(String string) {
        int n = 0;
        if (string.length() % 5 != 0) {
            n = 5 - string.length() % 5;
        }
        for (int i = 0; i < n; ++i) {
            string = "0" + string;
        }
        int[] nArray = new int[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '0') {
                nArray[i] = 0;
            } else if (string.charAt(i) == '1') {
                nArray[i] = 1;
            } else {
                throw new IllegalArgumentException("Character '" + string.charAt(i) + "' at position " + i + " not a valid binary character");
            }
            int n2 = Character.getNumericValue(string.charAt(i));
        }
        return nArray;
    }

    private static int[] convertToBinaryArray(String string) {
        int[] nArray = new int[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '0') {
                nArray[i] = 0;
                continue;
            }
            if (string.charAt(i) == '1') {
                nArray[i] = 1;
                continue;
            }
            throw new IllegalArgumentException("Character '" + string.charAt(i) + "' at position " + i + " not a valid binary character");
        }
        return nArray;
    }

    private static String interWeave(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length + nArray2.length];
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray3[n] = nArray[n2++];
            n += 2;
        }
        n = 1;
        int n3 = 0;
        while (n3 < nArray2.length) {
            nArray3[n] = nArray2[n3++];
            n += 2;
        }
        String string = "";
        for (int i = 0; i < nArray3.length; ++i) {
            if (nArray3[i] == 0) {
                string = string + "0";
                continue;
            }
            if (nArray3[i] == 1) {
                string = string + "1";
                continue;
            }
            throw new IllegalArgumentException("Character ' at position " + i + " not a valid binary character");
        }
        return string;
    }

    private GeoHash interWeave(long l, long l2) {
        GeoHash geoHash = new GeoHash();
        int[] nArray = this.numberOfLonLatBits();
        int n = nArray[0] + nArray[1];
        long l3 = l;
        long l4 = l2;
        double d = 180.0;
        double d2 = -180.0;
        double d3 = 90.0;
        double d4 = -90.0;
        double d5 = (d + d2) / 2.0;
        double d6 = (d3 + d4) / 2.0;
        l3 <<= 64 - nArray[0];
        l4 <<= 64 - nArray[1];
        for (int i = 0; i < n; ++i) {
            boolean bl;
            if (i % 2 == 0) {
                boolean bl2 = bl = (l3 & Long.MIN_VALUE) == Long.MIN_VALUE;
                if (bl) {
                    geoHash.value <<= 1;
                    geoHash.value |= 1L;
                    d2 = d5;
                } else {
                    geoHash.value <<= 1;
                    d = d5;
                }
                geoHash.numberOfBits = (short)(geoHash.numberOfBits + 1);
                l3 <<= 1;
                continue;
            }
            boolean bl3 = bl = (l4 & Long.MIN_VALUE) == Long.MIN_VALUE;
            if (bl) {
                geoHash.value <<= 1;
                geoHash.value |= 1L;
                d4 = d6;
            } else {
                geoHash.value <<= 1;
                d3 = d6;
            }
            geoHash.numberOfBits = (short)(geoHash.numberOfBits + 1);
            l4 <<= 1;
        }
        geoHash.value <<= 64 - geoHash.numberOfBits;
        long l5 = -576460752303423488L;
        GeoHash.setMer(geoHash, new double[]{d2, d4, d, d3});
        if (geoHash.numberOfBits % 5 != 0) {
            throw new IllegalStateException("Cannot convert a geohash if the number of bits is not a multiple of 5. (" + geoHash.numberOfBits + ")");
        }
        StringBuilder stringBuilder = new StringBuilder();
        long l6 = geoHash.value;
        int n2 = (int)Math.ceil(geoHash.numberOfBits / 5);
        for (int i = 0; i < n2; ++i) {
            int n3 = (int)((l6 & l5) >>> 59);
            stringBuilder.append(base32.charAt(n3));
            l6 <<= 5;
        }
        geoHash.ghString = stringBuilder.toString();
        geoHash.bitsValue = GeoHash.decimalValue(geoHash.ghString);
        GeoHash.setMer(geoHash, GeoHash.asMer(geoHash.ghString));
        return geoHash;
    }
}

