/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Base64;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.util.AdapterShapefileJGeom;
import oracle.spatial.util.DBFieldDesc;
import oracle.spatial.util.DBFileHdr;
import oracle.spatial.util.ShapefileFeatureJGeom;
import oracle.spatial.util.ShapefileHdr;
import oracle.spatial.util.ShapefileReaderJGeom;

public class ObjectStoreGeometryReader {
    private static double toleranceM = 5.0E-9;
    private static double tolerance = 0.05;
    private static double minXGeodetic = -180.0;
    private static double maxXGeodetic = 180.0;
    private static double minYGeodetic = -90.0;
    private static double maxYGeodetic = 90.0;

    public static String getColumnType(byte by, short s) throws IllegalArgumentException {
        String string = "";
        switch (by) {
            case 67: 
            case 76: {
                string = "VARCHAR2(" + s + " CHAR)";
                break;
            }
            case 68: 
            case 70: 
            case 73: 
            case 78: {
                string = "NUMBER";
                break;
            }
            default: {
                throw new IllegalArgumentException("Field type " + (char)by + " is not supported");
            }
        }
        return string;
    }

    public static int getNumberOfDimensions(String string, String string2, String string3, String string4) {
        int n = 100;
        int n2 = 100;
        int n3 = 2;
        try {
            int n4;
            String string5 = string + ":" + string2;
            Base64.Encoder encoder = Base64.getEncoder();
            byte[] byArray = encoder.encode(string5.getBytes("UTF-8"));
            String string6 = "Basic " + new String(byArray, "UTF-8");
            String string7 = string4 + "_shp";
            URL uRL = new URL(string3 + "/" + string7);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("Authorization", string6);
            httpURLConnection.setRequestProperty("Accept", "*.*");
            if (httpURLConnection.getResponseCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + httpURLConnection.getResponseCode());
            }
            DataInputStream dataInputStream = new DataInputStream(httpURLConnection.getInputStream());
            byte[] byArray2 = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray2[i] = dataInputStream.readByte();
            }
            ShapefileHdr shapefileHdr = new ShapefileHdr();
            shapefileHdr.fromBuffer(byArray2);
            int n5 = shapefileHdr.getVersion();
            int n6 = shapefileHdr.getFileCode();
            int n7 = n4 = shapefileHdr.getShapeType();
            double d = shapefileHdr.getMmin();
            double d2 = shapefileHdr.getMmax();
            if (d2 <= -1.0E39) {
                d2 = Double.NaN;
            }
            n3 = ShapefileReaderJGeom.getShpDims(n7, d2);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            System.out.println("IO Exception");
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n3;
    }

    public static String getDimensionArray(String string, String string2, String string3, String string4, boolean bl) {
        String string5 = "";
        int n = 100;
        int n2 = 100;
        try {
            int n3;
            String string6 = string + ":" + string2;
            Base64.Encoder encoder = Base64.getEncoder();
            byte[] byArray = encoder.encode(string6.getBytes("UTF-8"));
            String string7 = "Basic " + new String(byArray, "UTF-8");
            String string8 = string4 + "_shp";
            URL uRL = new URL(string3 + "/" + string8);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("Authorization", string7);
            httpURLConnection.setRequestProperty("Accept", "*.*");
            if (httpURLConnection.getResponseCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + httpURLConnection.getResponseCode());
            }
            DataInputStream dataInputStream = new DataInputStream(httpURLConnection.getInputStream());
            byte[] byArray2 = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray2[i] = dataInputStream.readByte();
            }
            ShapefileHdr shapefileHdr = new ShapefileHdr();
            shapefileHdr.fromBuffer(byArray2);
            int n4 = shapefileHdr.getVersion();
            int n5 = shapefileHdr.getFileCode();
            int n6 = n3 = shapefileHdr.getShapeType();
            double d = bl ? minXGeodetic : shapefileHdr.getXmin();
            double d2 = bl ? maxXGeodetic : shapefileHdr.getXmax();
            double d3 = bl ? minYGeodetic : shapefileHdr.getYmin();
            double d4 = bl ? maxYGeodetic : shapefileHdr.getYmax();
            double d5 = shapefileHdr.getZmin();
            double d6 = shapefileHdr.getZmax();
            double d7 = shapefileHdr.getMmin();
            double d8 = shapefileHdr.getMmax();
            if (d8 <= -1.0E39) {
                d8 = Double.NaN;
            }
            int n7 = ShapefileReaderJGeom.getShpDims(n6, d8);
            string5 = ShapefileFeatureJGeom.getDimArray(n7, Double.toString(tolerance), Double.toString(d), Double.toString(d2), Double.toString(d3), Double.toString(d4), d5, d6, d7, d8);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            System.out.println("IO Exception");
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string5;
    }

    public static Clob getTableSchema(String string, String string2, String string3, String string4) {
        Connection connection = null;
        String string5 = "";
        Clob clob = null;
        try {
            connection = DriverManager.getConnection("jdbc:default:connection");
            string5 = ObjectStoreGeometryReader.getTableSchema(connection, string, string2, string3, string4);
            clob = connection.createClob();
            clob.setString(1L, string5);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return clob;
    }

    public static String getTableSchema(Connection connection, String string, String string2, String string3, String string4) {
        int n = 32;
        int n2 = 32;
        int n3 = 0;
        String string5 = "";
        try {
            int n4;
            String string6 = string + ":" + string2;
            Base64.Encoder encoder = Base64.getEncoder();
            byte[] byArray = encoder.encode(string6.getBytes("UTF-8"));
            String string7 = "Basic " + new String(byArray, "UTF-8");
            String string8 = string4 + "_dbf";
            URL uRL = new URL(string3 + "/" + string8);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("Authorization", string7);
            httpURLConnection.setRequestProperty("Accept", "*.*");
            if (httpURLConnection.getResponseCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + httpURLConnection.getResponseCode());
            }
            DataInputStream dataInputStream = new DataInputStream(httpURLConnection.getInputStream());
            byte[] byArray2 = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray2[i] = dataInputStream.readByte();
            }
            DBFileHdr dBFileHdr = new DBFileHdr();
            dBFileHdr.fromBuffer(byArray2);
            byte by = dBFileHdr.getVersion();
            n3 = dBFileHdr.getNumberOfRecords();
            short s = dBFileHdr.getHeaderSize();
            short s2 = dBFileHdr.getRecordSize();
            int n5 = (s - (n + 1)) / n;
            DBFieldDesc[] dBFieldDescArray = new DBFieldDesc[n5];
            byte[] byArray3 = new byte[n5 * n2];
            for (n4 = 0; n4 < n5 * n2; ++n4) {
                byArray3[n4] = dataInputStream.readByte();
            }
            for (n4 = 0; n4 < n5; ++n4) {
                dBFieldDescArray[n4] = new DBFieldDesc();
                dBFieldDescArray[n4].fromBuffer(byArray3);
                System.arraycopy(byArray3, n2, byArray3, 0, (n5 - (n4 + 1)) * n2);
            }
            string5 = string5 + " {";
            for (n4 = 0; n4 < n5; ++n4) {
                String string9 = new String(dBFieldDescArray[n4].getName());
                int n6 = dBFieldDescArray[n4].getFieldOffset();
                byte by2 = dBFieldDescArray[n4].getFieldType();
                short s3 = dBFieldDescArray[n4].getFieldLength();
                String string10 = ObjectStoreGeometryReader.getColumnType(by2, s3);
                string5 = string5 + "\"" + string9.trim() + "\":\"" + string10.trim() + "\", ";
            }
            string5 = string5 + " \"geometry\":\"MDSYS.SDO_GEOMETRY\"}";
            dataInputStream.close();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            System.out.println("IO Exception");
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string5;
    }

    public void readFromObjectStore(String string, String string2, String string3, String string4) {
        try {
            String string5;
            String string6 = string + ":" + string2;
            URL uRL = new URL(string3 + "/" + string4);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            Base64.Encoder encoder = Base64.getEncoder();
            byte[] byArray = encoder.encode(string6.getBytes("UTF-8"));
            String string7 = "Basic " + new String(byArray, "UTF-8");
            httpURLConnection.setRequestProperty("Authorization", string7);
            httpURLConnection.setRequestProperty("Accept", "application/json");
            if (httpURLConnection.getResponseCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + httpURLConnection.getResponseCode());
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            boolean bl = false;
            long l = System.currentTimeMillis();
            while ((string5 = bufferedReader.readLine()) != null) {
                System.out.println(string5);
            }
            long l2 = System.currentTimeMillis();
            httpURLConnection.disconnect();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            System.out.println("IO Exception");
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void readFromShapeFileObjects(String string, String string2, String string3, String string4, int n) {
        int n2 = 32;
        int n3 = 32;
        int n4 = 100;
        int n5 = 100;
        int n6 = 0;
        try {
            int n7;
            int n8;
            String string5 = string + ":" + string2;
            Base64.Encoder encoder = Base64.getEncoder();
            byte[] byArray = encoder.encode(string5.getBytes("UTF-8"));
            String string6 = "Basic " + new String(byArray, "UTF-8");
            String string7 = string4 + "_dbf";
            URL uRL = new URL(string3 + "/" + string7);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("Authorization", string6);
            httpURLConnection.setRequestProperty("Accept", "*.*");
            if (httpURLConnection.getResponseCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + httpURLConnection.getResponseCode());
            }
            DataInputStream dataInputStream = new DataInputStream(httpURLConnection.getInputStream());
            String string8 = string4 + "_shp";
            URL uRL2 = new URL(string3 + "/" + string8);
            HttpURLConnection httpURLConnection2 = (HttpURLConnection)uRL2.openConnection();
            httpURLConnection2.setRequestMethod("GET");
            httpURLConnection2.setRequestProperty("Authorization", string6);
            httpURLConnection2.setRequestProperty("Accept", "*.*");
            if (httpURLConnection2.getResponseCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + httpURLConnection2.getResponseCode());
            }
            DataInputStream dataInputStream2 = new DataInputStream(httpURLConnection2.getInputStream());
            String string9 = string4 + "_shx";
            URL uRL3 = new URL(string3 + "/" + string9);
            HttpURLConnection httpURLConnection3 = (HttpURLConnection)uRL3.openConnection();
            httpURLConnection3.setRequestMethod("GET");
            httpURLConnection3.setRequestProperty("Authorization", string6);
            httpURLConnection3.setRequestProperty("Accept", "*.*");
            if (httpURLConnection3.getResponseCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + httpURLConnection3.getResponseCode());
            }
            DataInputStream dataInputStream3 = new DataInputStream(httpURLConnection3.getInputStream());
            byte[] byArray2 = new byte[n2];
            for (int i = 0; i < n2; ++i) {
                byArray2[i] = dataInputStream.readByte();
            }
            DBFileHdr dBFileHdr = new DBFileHdr();
            dBFileHdr.fromBuffer(byArray2);
            byte by = dBFileHdr.getVersion();
            n6 = dBFileHdr.getNumberOfRecords();
            short s = dBFileHdr.getHeaderSize();
            int n9 = dBFileHdr.getRecordSize();
            int n10 = (s - (n2 + 1)) / n2;
            DBFieldDesc[] dBFieldDescArray = new DBFieldDesc[n10];
            byte[] byArray3 = new byte[n10 * n3];
            for (n8 = 0; n8 < n10 * n3; ++n8) {
                byArray3[n8] = dataInputStream.readByte();
            }
            for (n8 = 0; n8 < n10; ++n8) {
                dBFieldDescArray[n8] = new DBFieldDesc();
                dBFieldDescArray[n8].fromBuffer(byArray3);
                System.arraycopy(byArray3, n3, byArray3, 0, (n10 - (n8 + 1)) * n3);
            }
            byte[] byArray4 = new byte[n4];
            for (int i = 0; i < n4; ++i) {
                byArray4[i] = dataInputStream2.readByte();
            }
            ShapefileHdr shapefileHdr = new ShapefileHdr();
            shapefileHdr.fromBuffer(byArray4);
            int n11 = shapefileHdr.getVersion();
            int n12 = shapefileHdr.getFileCode();
            int n13 = n7 = shapefileHdr.getShapeType();
            double d = shapefileHdr.getXmin();
            double d2 = shapefileHdr.getXmax();
            double d3 = shapefileHdr.getYmin();
            double d4 = shapefileHdr.getYmax();
            double d5 = shapefileHdr.getZmin();
            double d6 = shapefileHdr.getZmax();
            double d7 = shapefileHdr.getMmin();
            double d8 = shapefileHdr.getMmax();
            byte[] byArray5 = new byte[n4];
            for (int i = 0; i < n4; ++i) {
                byArray5[i] = dataInputStream3.readByte();
            }
            ShapefileHdr shapefileHdr2 = new ShapefileHdr();
            shapefileHdr2.fromBuffer(byArray5);
            n6 = (shapefileHdr2.getFileLength() * 2 - 100) / 8;
            byte by2 = dataInputStream.readByte();
            byte by3 = dataInputStream.readByte();
            byte[] byArray6 = new byte[n9];
            int n14 = 0;
            AdapterShapefileJGeom adapterShapefileJGeom = new AdapterShapefileJGeom();
            JGeometry jGeometry = null;
            for (int i = 0; i < n6; ++i) {
                byte[] byArray7;
                int n15;
                int n16;
                int n17;
                int n18;
                ++n14;
                String string10 = "";
                for (n18 = 0; n18 < n9; ++n18) {
                    byArray6[n18] = dataInputStream.readByte();
                }
                n18 = 0;
                int n19 = 0;
                for (n17 = 0; n17 < n10; ++n17) {
                    String string11 = new String(dBFieldDescArray[n17].getName());
                    n16 = dBFieldDescArray[n17].getFieldLength();
                    n15 = n19 + n16;
                    byArray7 = new byte[n16];
                    System.arraycopy(byArray6, n19, byArray7, 0, n16);
                    String string12 = new String(byArray7);
                    string10 = string10 + string12.trim() + ";";
                    n19 += n16;
                }
                n17 = n4 + i * 8;
                int n20 = dataInputStream3.readInt() * 2;
                n16 = dataInputStream3.readInt() * 2;
                n15 = n16 + 8;
                byArray7 = new byte[n15];
                for (int j = 0; j < n15; ++j) {
                    byArray7[j] = dataInputStream2.readByte();
                }
                jGeometry = adapterShapefileJGeom.importGeometry(byArray7, n);
                string10 = string10 + jGeometry.toGeoJson();
                System.out.println(string10);
            }
            dataInputStream.close();
            dataInputStream2.close();
            dataInputStream3.close();
            httpURLConnection.disconnect();
            httpURLConnection2.disconnect();
            httpURLConnection3.disconnect();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            int n = 8307;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase("-username")) {
                    string = stringArray[i + 1];
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-password")) {
                    string2 = stringArray[i + 1];
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-url")) {
                    string3 = stringArray[i + 1];
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-object")) {
                    string4 = stringArray[i + 1];
                    continue;
                }
                if (!stringArray[i].equalsIgnoreCase("-srid")) continue;
                n = Integer.parseInt(stringArray[i + 1]);
            }
            ObjectStoreGeometryReader objectStoreGeometryReader = new ObjectStoreGeometryReader();
            objectStoreGeometryReader.readFromShapeFileObjects(string, string2, string3, string4, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

