/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util.placekey;

import java.util.ArrayList;
import oracle.spatial.geometry.JGeometry;

public class Face {
    static final double EPSILON = 1.0E-16;
    static final double M2PI = Math.PI * 2;
    static final double M_PI = Math.PI;
    static final double M_AP7_ROT_RADS = 0.3334731722518321;
    static final double RES0_U_GNOMONIC = 0.3819660112501;
    static final double M_SQRT7 = 2.6457513110645907;
    static final double M_SIN60 = 0.8660254037844386;
    static final double M_PI_2 = 1.5707963267948966;
    static final int MAX_FACE_COORD = 2;
    static final double[][] faceCenterLL = new double[][]{{0.80358264971899, 1.2483974196173961}, {1.3077478834556382, 2.5369450098779214}, {1.054751253523952, -1.3475173589003966}, {0.6001915955381868, -0.45060390946975576}, {0.49171542819877384, 0.40198820291130694}, {0.1727453274156187, 1.6781468852804338}, {0.6059293215713507, 2.9539233298124117}, {0.42737051832897965, -1.8888762003362853}, {-0.07906611854921283, -0.7334295133808677}, {-0.23096164445538364, 0.506495587332349}, {0.07906611854921283, 2.4081631402089254}, {0.23096164445538364, -2.635097066257444}, {-0.1727453274156187, -1.4634457683093596}, {-0.6059293215713507, -0.18766932377738163}, {-0.42737051832897965, 1.2527164532535078}, {-0.6001915955381868, 2.6909887441200375}, {-0.49171542819877384, -2.7396044506784865}, {-0.80358264971899, -1.8931952339723972}, {-1.3077478834556382, -0.6046476437118721}, {-1.054751253523952, 1.7940752946893965}};
    static final double[][] faceCenterCoord = new double[][]{{0.2199307791404606, 0.6583691780274996, 0.7198475378926182}, {-0.2139234834501421, 0.1478171829550703, 0.9656017935214205}, {0.1092625278784797, -0.481195157287321, 0.8697775121287253}, {0.7428567301586791, -0.3593941678278028, 0.5648005936517033}, {0.8112534709140969, 0.3448953237639384, 0.472138773641393}, {-0.1055498149613921, 0.9794457296411413, 0.1718874610009365}, {-0.8075407579970092, 0.1533552485898818, 0.5695261994882688}, {-0.2846148069787907, -0.8644080972654206, 0.4144792552473539}, {0.7405621473854482, -0.6673299564565524, -0.0789837646326737}, {0.8512303986474293, 0.4722343788582681, -0.2289137388687808}, {-0.7405621473854481, 0.6673299564565524, 0.0789837646326737}, {-0.8512303986474292, -0.4722343788582682, 0.2289137388687808}, {0.1055498149613919, -0.9794457296411413, -0.1718874610009365}, {0.8075407579970092, -0.1533552485898819, -0.5695261994882688}, {0.2846148069787908, 0.8644080972654204, -0.4144792552473539}, {-0.7428567301586791, 0.3593941678278027, -0.5648005936517033}, {-0.811253470914097, -0.3448953237639382, -0.472138773641393}, {-0.2199307791404607, -0.6583691780274996, -0.7198475378926182}, {0.213923483450142, -0.1478171829550704, -0.9656017935214205}, {-0.1092625278784796, 0.481195157287321, -0.8697775121287253}};
    static final double[][] faceAxesAzRadsCII = new double[][]{{5.6199582685239395, 3.5255631661307447, 1.4311680637375488}, {5.7603390817141875, 3.665943979320992, 1.571548876927796}, {0.78021365439343, 4.969003859179821, 2.8746087567866256}, {0.4304693639799999, 4.619259568766391, 2.5248644663731956}, {6.130269123335111, 4.0358740209419155, 1.9414789185487202}, {2.692877706530643, 0.5984826041374471, 4.787272808923838}, {2.982963003477244, 0.8885679010840484, 5.07735810587044}, {3.532912002790141, 1.4385169003969456, 5.627307105183337}, {3.494305004259568, 1.3999099018663728, 5.588700106652764}, {3.0032141694995382, 0.908819067106343, 5.0976092718927335}, {5.930472956509812, 3.836077854116616, 1.7416827517234204}, {0.13837848409025486, 4.327168688876646, 2.23277358648345}, {0.4487149470591504, 4.6375051518455415, 2.543110049452346}, {0.15862965011254937, 4.3474198548989405, 2.2530247525057447}, {5.891865957979238, 3.797470855586043, 1.7030757531928475}, {2.711123289609793, 0.6167281872165977, 4.8055183920029885}, {3.294508837434268, 1.2001137350410729, 5.388903939827464}, {3.80481969224544, 1.7104245898522445, 5.8992147946386355}, {3.6644388790551923, 1.570043776661997, 5.758833981448388}, {2.361378999196363, 0.2669838968031676, 4.455774101589559}};
    final FaceOrient[][] faceNeighbours = new FaceOrient[][]{{new FaceOrient(0, 0.0, 0.0, 0.0, 0), new FaceOrient(4, 2.0, 0.0, 2.0, 1), new FaceOrient(1, 2.0, 2.0, 0.0, 5), new FaceOrient(5, 0.0, 2.0, 2.0, 3)}, {new FaceOrient(1, 0.0, 0.0, 0.0, 0), new FaceOrient(0, 2.0, 0.0, 2.0, 1), new FaceOrient(2, 2.0, 2.0, 0.0, 5), new FaceOrient(6, 0.0, 2.0, 2.0, 3)}, {new FaceOrient(2, 0.0, 0.0, 0.0, 0), new FaceOrient(1, 2.0, 0.0, 2.0, 1), new FaceOrient(3, 2.0, 2.0, 0.0, 5), new FaceOrient(7, 0.0, 2.0, 2.0, 3)}, {new FaceOrient(3, 0.0, 0.0, 0.0, 0), new FaceOrient(2, 2.0, 0.0, 2.0, 1), new FaceOrient(4, 2.0, 2.0, 0.0, 5), new FaceOrient(8, 0.0, 2.0, 2.0, 3)}, {new FaceOrient(4, 0.0, 0.0, 0.0, 0), new FaceOrient(3, 2.0, 0.0, 2.0, 1), new FaceOrient(0, 2.0, 2.0, 0.0, 5), new FaceOrient(9, 0.0, 2.0, 2.0, 3)}, {new FaceOrient(5, 0.0, 0.0, 0.0, 0), new FaceOrient(10, 2.0, 2.0, 0.0, 3), new FaceOrient(14, 2.0, 0.0, 2.0, 3), new FaceOrient(0, 0.0, 2.0, 2.0, 3)}, {new FaceOrient(6, 0.0, 0.0, 0.0, 0), new FaceOrient(11, 2.0, 2.0, 0.0, 3), new FaceOrient(10, 2.0, 0.0, 2.0, 3), new FaceOrient(1, 0.0, 2.0, 2.0, 3)}, {new FaceOrient(7, 0.0, 0.0, 0.0, 0), new FaceOrient(12, 2.0, 2.0, 0.0, 3), new FaceOrient(11, 2.0, 0.0, 2.0, 3), new FaceOrient(2, 0.0, 2.0, 2.0, 3)}, {new FaceOrient(8, 0.0, 0.0, 0.0, 0), new FaceOrient(13, 2.0, 2.0, 0.0, 3), new FaceOrient(12, 2.0, 0.0, 2.0, 3), new FaceOrient(3, 0.0, 2.0, 2.0, 3)}, {new FaceOrient(9, 0.0, 0.0, 0.0, 0), new FaceOrient(14, 2.0, 2.0, 0.0, 3), new FaceOrient(13, 2.0, 0.0, 2.0, 3), new FaceOrient(4, 0.0, 2.0, 2.0, 3)}, {new FaceOrient(10, 0.0, 0.0, 0.0, 0), new FaceOrient(5, 2.0, 2.0, 0.0, 3), new FaceOrient(6, 2.0, 0.0, 2.0, 3), new FaceOrient(15, 0.0, 2.0, 2.0, 3)}, {new FaceOrient(11, 0.0, 0.0, 0.0, 0), new FaceOrient(6, 2.0, 2.0, 0.0, 3), new FaceOrient(7, 2.0, 0.0, 2.0, 3), new FaceOrient(16, 0.0, 2.0, 2.0, 3)}, {new FaceOrient(12, 0.0, 0.0, 0.0, 0), new FaceOrient(7, 2.0, 2.0, 0.0, 3), new FaceOrient(8, 2.0, 0.0, 2.0, 3), new FaceOrient(17, 0.0, 2.0, 2.0, 3)}, {new FaceOrient(13, 0.0, 0.0, 0.0, 0), new FaceOrient(8, 2.0, 2.0, 0.0, 3), new FaceOrient(9, 2.0, 0.0, 2.0, 3), new FaceOrient(18, 0.0, 2.0, 2.0, 3)}, {new FaceOrient(14, 0.0, 0.0, 0.0, 0), new FaceOrient(9, 2.0, 2.0, 0.0, 3), new FaceOrient(5, 2.0, 0.0, 2.0, 3), new FaceOrient(19, 0.0, 2.0, 2.0, 3)}, {new FaceOrient(15, 0.0, 0.0, 0.0, 0), new FaceOrient(16, 2.0, 0.0, 2.0, 1), new FaceOrient(19, 2.0, 2.0, 0.0, 5), new FaceOrient(10, 0.0, 2.0, 2.0, 3)}, {new FaceOrient(16, 0.0, 0.0, 0.0, 0), new FaceOrient(17, 2.0, 0.0, 2.0, 1), new FaceOrient(15, 2.0, 2.0, 0.0, 5), new FaceOrient(11, 0.0, 2.0, 2.0, 3)}, {new FaceOrient(17, 0.0, 0.0, 0.0, 0), new FaceOrient(18, 2.0, 0.0, 2.0, 1), new FaceOrient(16, 2.0, 2.0, 0.0, 5), new FaceOrient(12, 0.0, 2.0, 2.0, 3)}, {new FaceOrient(18, 0.0, 0.0, 0.0, 0), new FaceOrient(19, 2.0, 0.0, 2.0, 1), new FaceOrient(17, 2.0, 2.0, 0.0, 5), new FaceOrient(13, 0.0, 2.0, 2.0, 3)}, {new FaceOrient(19, 0.0, 0.0, 0.0, 0), new FaceOrient(15, 2.0, 0.0, 2.0, 1), new FaceOrient(18, 2.0, 2.0, 0.0, 5), new FaceOrient(14, 0.0, 2.0, 2.0, 3)}};
    static final int[][] adjacentFaceDir = new int[][]{{0, 2, -1, -1, 1, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {1, 0, 2, -1, -1, -1, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, 1, 0, 2, -1, -1, -1, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, 1, 0, 2, -1, -1, -1, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {2, -1, -1, 1, 0, -1, -1, -1, -1, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {3, -1, -1, -1, -1, 0, -1, -1, -1, -1, 1, -1, -1, -1, 2, -1, -1, -1, -1, -1}, {-1, 3, -1, -1, -1, -1, 0, -1, -1, -1, 2, 1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, 3, -1, -1, -1, -1, 0, -1, -1, -1, 2, 1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, 3, -1, -1, -1, -1, 0, -1, -1, -1, 2, 1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, 3, -1, -1, -1, -1, 0, -1, -1, -1, 2, 1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, 1, 2, -1, -1, -1, 0, -1, -1, -1, -1, 3, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, 1, 2, -1, -1, -1, 0, -1, -1, -1, -1, 3, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, 1, 2, -1, -1, -1, 0, -1, -1, -1, -1, 3, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, 1, 2, -1, -1, -1, 0, -1, -1, -1, -1, 3, -1}, {-1, -1, -1, -1, -1, 2, -1, -1, -1, 1, -1, -1, -1, -1, 0, -1, -1, -1, -1, 3}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3, -1, -1, -1, -1, 0, 1, -1, -1, 2}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3, -1, -1, -1, 2, 0, 1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3, -1, -1, -1, 2, 0, 1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3, -1, -1, -1, 2, 0, 1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3, 1, -1, -1, 2, 0}};
    static final int[] maxDimByCIIres = new int[]{2, -1, 14, -1, 98, -1, 686, -1, 4802, -1, 33614, -1, 235298, -1, 1647086, -1, 11529602};
    static final int[] unitScaleByCIIres = new int[]{1, -1, 7, -1, 49, -1, 343, -1, 2401, -1, 16807, -1, 117649, -1, 823543, -1, 5764801};
    static final double[][] unitVectors = new double[][]{{0.0, 0.0, 0.0}, {0.0, 0.0, 1.0}, {0.0, 1.0, 0.0}, {0.0, 1.0, 1.0}, {1.0, 0.0, 0.0}, {1.0, 0.0, 1.0}, {1.0, 1.0, 0.0}};
    public JGeometry coords;
    public int face;

    public Face() {
        this.face = -1;
        this.coords = new JGeometry(0.0, 0.0, 0.0, 4326);
    }

    public Face(int n, int n2, int n3, int n4) {
        this.face = n;
        this.coords = new JGeometry((double)n2, (double)n3, (double)n4, 4326);
    }

    public Face(Face face) {
        this.face = face.face;
        this.coords = face.coords;
    }

    public void lonlatToFaceCoord(double d, double d2, int n) {
        JGeometry jGeometry = this.lonlatToHexCoords(d, d2, n);
        this.hexToFaceCoords(jGeometry);
    }

    public JGeometry lonlatToHexCoords(double d, double d2, int n) {
        JGeometry jGeometry = this.lonlatTo3dCoords(d, d2);
        this.face = 0;
        double d3 = this.squareDist(new JGeometry(faceCenterCoord[0][0], faceCenterCoord[0][1], faceCenterCoord[0][2], 4326), jGeometry);
        for (int i = 1; i < 20; ++i) {
            double d4 = this.squareDist(new JGeometry(faceCenterCoord[i][0], faceCenterCoord[i][1], faceCenterCoord[i][2], 4326), jGeometry);
            if (!(d4 < d3)) continue;
            this.face = i;
            d3 = d4;
        }
        double d5 = Math.acos(1.0 - d3 / 2.0);
        if (d5 < 1.0E-16) {
            return new JGeometry(0.0, 0.0, 4326);
        }
        double d6 = this.normalizeRads(faceAxesAzRadsCII[this.face][0] - this.normalizeRads(this.azimuthRadsLL(faceCenterLL[this.face][0], faceCenterLL[this.face][1], d2, d)));
        if (this.isResClass3(n)) {
            d6 = this.normalizeRads(d6 - 0.3334731722518321);
        }
        d5 = Math.tan(d5);
        d5 /= 0.3819660112501;
        for (int i = 0; i < n; ++i) {
            d5 *= 2.6457513110645907;
        }
        return new JGeometry(d5 * Math.cos(d6), d5 * Math.sin(d6), 4326);
    }

    public void hexToFaceCoords(JGeometry jGeometry) {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        double[] dArray = jGeometry.getPoint();
        double d = Math.abs(dArray[0]);
        double d2 = Math.abs(dArray[1]);
        double d3 = d2 / 0.8660254037844386;
        double d4 = d + d3 / 2.0;
        int n3 = (int)d4;
        int n4 = (int)d3;
        double d5 = d4 - (double)n3;
        double d6 = d3 - (double)n4;
        if (d5 < 0.5) {
            if (d5 < 0.3333333333333333) {
                if (d6 < (1.0 + d5) / 2.0) {
                    n = n3;
                    n2 = n4;
                } else {
                    n = n3;
                    n2 = n4 + 1;
                }
            } else {
                n2 = d6 < 1.0 - d5 ? n4 : n4 + 1;
                n = 1.0 - d5 <= d6 && d6 < 2.0 * d5 ? n3 + 1 : n3;
            }
        } else if (d5 < 0.6666666666666666) {
            n2 = d6 < 1.0 - d5 ? n4 : n4 + 1;
            n = 2.0 * d5 - 1.0 < d6 && d6 < 1.0 - d5 ? n3 : n3 + 1;
        } else if (d6 < d5 / 2.0) {
            n = n3 + 1;
            n2 = n4;
        } else {
            n = n3 + 1;
            n2 = n4 + 1;
        }
        if (dArray[0] < 0.0) {
            if (n2 % 2 == 0) {
                double d7 = (int)((double)n2 / 2.0);
                double d8 = (int)((double)n - d7);
                n = (int)((double)n - 2.0 * d8);
            } else {
                double d9 = (int)(((double)n2 + 1.0) / 2.0);
                double d10 = (int)((double)n - d9);
                n = (int)((double)n - (2.0 * d10 + 1.0));
            }
        }
        if (dArray[1] < 0.0) {
            n = (int)((double)n - (2.0 * (double)n2 + 1.0) / 2.0);
            n2 = (int)(-1.0 * (double)n2);
        }
        this.coords = this.norm(new JGeometry((double)n, (double)n2, (double)bl, 4326));
    }

    public JGeometry norm(JGeometry jGeometry) {
        int n;
        double[] dArray = jGeometry.getPoint();
        if (dArray[0] < 0.0) {
            dArray[1] = dArray[1] - dArray[0];
            dArray[2] = dArray[2] - dArray[0];
            dArray[0] = 0.0;
        }
        if (dArray[1] < 0.0) {
            dArray[0] = dArray[0] - dArray[1];
            dArray[2] = dArray[2] - dArray[1];
            dArray[1] = 0.0;
        }
        if (dArray[2] < 0.0) {
            dArray[0] = dArray[0] - dArray[2];
            dArray[1] = dArray[1] - dArray[2];
            dArray[2] = 0.0;
        }
        if (dArray[1] < (double)(n = (int)dArray[0])) {
            n = (int)dArray[1];
        }
        if (dArray[2] < (double)n) {
            n = (int)dArray[2];
        }
        if (n > 0) {
            dArray[0] = dArray[0] - (double)n;
            dArray[1] = dArray[1] - (double)n;
            dArray[2] = dArray[2] - (double)n;
        }
        return new JGeometry(dArray[0], dArray[1], dArray[2], 4326);
    }

    public double normalizeRads(double d) {
        double d2;
        double d3 = d2 = d < 0.0 ? d + Math.PI * 2 : d;
        if (d >= Math.PI * 2) {
            d2 -= Math.PI * 2;
        }
        return d2;
    }

    public boolean isResClass3(int n) {
        return n % 2 != 0;
    }

    public double azimuthRadsLL(double d, double d2, double d3, double d4) {
        return Math.atan2(Math.cos(d3) * Math.sin(d4 - d2), Math.cos(d) * Math.sin(d3) - Math.sin(d) * Math.cos(d3) * Math.cos(d4 - d2));
    }

    public double squareDist(JGeometry jGeometry, JGeometry jGeometry2) {
        double[] dArray = jGeometry.getPoint();
        double[] dArray2 = jGeometry2.getPoint();
        return (dArray[0] - dArray2[0]) * (dArray[0] - dArray2[0]) + (dArray[1] - dArray2[1]) * (dArray[1] - dArray2[1]) + (dArray[2] - dArray2[2]) * (dArray[2] - dArray2[2]);
    }

    public JGeometry lonlatTo3dCoords(double d, double d2) {
        double d3 = Math.cos(d2);
        JGeometry jGeometry = new JGeometry(Math.cos(d) * d3, Math.sin(d) * d3, Math.sin(d2), 4326);
        return jGeometry;
    }

    public JGeometry ccwParentAp7(JGeometry jGeometry) {
        double[] dArray = jGeometry.getPoint();
        int n = (int)(dArray[0] - dArray[2]);
        int n2 = (int)(dArray[1] - dArray[2]);
        dArray[0] = (int)Math.round((double)(3 * n - n2) / 7.0);
        dArray[1] = (int)Math.round((double)(n + 2 * n2) / 7.0);
        dArray[2] = 0.0;
        return this.norm(new JGeometry(dArray[0], dArray[1], dArray[2], 4326));
    }

    public JGeometry cwParentAp7(JGeometry jGeometry) {
        double[] dArray = jGeometry.getPoint();
        int n = (int)(dArray[0] - dArray[2]);
        int n2 = (int)(dArray[1] - dArray[2]);
        dArray[0] = (int)Math.round((double)(2 * n + n2) / 7.0);
        dArray[1] = (int)Math.round((double)(3 * n2 - n) / 7.0);
        dArray[2] = 0.0;
        return this.norm(new JGeometry(dArray[0], dArray[1], dArray[2], 4326));
    }

    public JGeometry ccwChildrenAp7(JGeometry jGeometry) {
        double[] dArray = jGeometry.getPoint();
        JGeometry jGeometry2 = new JGeometry(3.0, 0.0, 1.0, 4326);
        JGeometry jGeometry3 = new JGeometry(1.0, 3.0, 0.0, 4326);
        JGeometry jGeometry4 = new JGeometry(0.0, 1.0, 3.0, 4326);
        jGeometry2 = this.scaleCoordinate(jGeometry2, (int)dArray[0]);
        jGeometry3 = this.scaleCoordinate(jGeometry3, (int)dArray[1]);
        jGeometry4 = this.scaleCoordinate(jGeometry4, (int)dArray[2]);
        jGeometry = this.addCoordinates(jGeometry2.getPoint(), jGeometry3.getPoint(), jGeometry4.getPoint());
        return this.norm(jGeometry);
    }

    public JGeometry cwChildrenAp7(JGeometry jGeometry) {
        double[] dArray = jGeometry.getPoint();
        JGeometry jGeometry2 = new JGeometry(3.0, 1.0, 0.0, 4326);
        JGeometry jGeometry3 = new JGeometry(0.0, 3.0, 1.0, 4326);
        JGeometry jGeometry4 = new JGeometry(1.0, 0.0, 3.0, 4326);
        jGeometry2 = this.scaleCoordinate(jGeometry2, (int)dArray[0]);
        jGeometry3 = this.scaleCoordinate(jGeometry3, (int)dArray[1]);
        jGeometry4 = this.scaleCoordinate(jGeometry4, (int)dArray[2]);
        jGeometry = this.addCoordinates(jGeometry2.getPoint(), jGeometry3.getPoint(), jGeometry4.getPoint());
        return this.norm(jGeometry);
    }

    public JGeometry ccwChildrenAp3(JGeometry jGeometry) {
        double[] dArray = jGeometry.getPoint();
        JGeometry jGeometry2 = new JGeometry(2.0, 0.0, 1.0, 4326);
        JGeometry jGeometry3 = new JGeometry(1.0, 2.0, 0.0, 4326);
        JGeometry jGeometry4 = new JGeometry(0.0, 1.0, 2.0, 4326);
        jGeometry2 = this.scaleCoordinate(jGeometry2, (int)dArray[0]);
        jGeometry3 = this.scaleCoordinate(jGeometry3, (int)dArray[1]);
        jGeometry4 = this.scaleCoordinate(jGeometry4, (int)dArray[2]);
        jGeometry = this.addCoordinates(jGeometry2.getPoint(), jGeometry3.getPoint(), jGeometry4.getPoint());
        return this.norm(jGeometry);
    }

    public JGeometry cwChildrenAp3(JGeometry jGeometry) {
        double[] dArray = jGeometry.getPoint();
        JGeometry jGeometry2 = new JGeometry(2.0, 1.0, 0.0, 4326);
        JGeometry jGeometry3 = new JGeometry(0.0, 2.0, 1.0, 4326);
        JGeometry jGeometry4 = new JGeometry(1.0, 0.0, 2.0, 4326);
        jGeometry2 = this.scaleCoordinate(jGeometry2, (int)dArray[0]);
        jGeometry3 = this.scaleCoordinate(jGeometry3, (int)dArray[1]);
        jGeometry4 = this.scaleCoordinate(jGeometry4, (int)dArray[2]);
        jGeometry = this.addCoordinates(jGeometry2.getPoint(), jGeometry3.getPoint(), jGeometry4.getPoint());
        return this.norm(jGeometry);
    }

    public JGeometry addCoordinates(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray[0] = dArray[0] + dArray2[0] + dArray3[0];
        dArray[1] = dArray[1] + dArray2[1] + dArray3[1];
        dArray[2] = dArray[2] + dArray2[2] + dArray3[2];
        return new JGeometry(dArray[0], dArray[1], dArray[2], 4326);
    }

    public JGeometry addCoordinates(double[] dArray, double[] dArray2) {
        dArray[0] = dArray[0] + dArray2[0];
        dArray[1] = dArray[1] + dArray2[1];
        dArray[2] = dArray[2] + dArray2[2];
        return new JGeometry(dArray[0], dArray[1], dArray[2], 4326);
    }

    public JGeometry subtractCoordinates(double[] dArray, double[] dArray2) {
        dArray[0] = dArray[0] - dArray2[0];
        dArray[1] = dArray[1] - dArray2[1];
        dArray[2] = dArray[2] - dArray2[2];
        return new JGeometry(dArray[0], dArray[1], dArray[2], 4326);
    }

    public JGeometry scaleCoordinate(JGeometry jGeometry, int n) {
        double[] dArray = jGeometry.getPoint();
        dArray[0] = dArray[0] * (double)n;
        dArray[1] = dArray[1] * (double)n;
        dArray[2] = dArray[2] * (double)n;
        return new JGeometry(dArray[0], dArray[1], dArray[2], 4326);
    }

    public int coordToDigit(JGeometry jGeometry) {
        JGeometry jGeometry2 = this.norm(jGeometry);
        int n = 7;
        for (int i = 0; i < 7; ++i) {
            if (!this.matchCoord(jGeometry2.getPoint(), unitVectors[i])) continue;
            n = i;
            break;
        }
        return n;
    }

    public boolean matchCoord(double[] dArray, double[] dArray2) {
        return dArray[0] == dArray2[0] && dArray[1] == dArray2[1] && dArray[2] == dArray2[2];
    }

    public JGeometry neighbor(JGeometry jGeometry, int n) {
        if (n > 0 && n < 7) {
            JGeometry jGeometry2 = this.addCoordinates(jGeometry.getPoint(), unitVectors[n]);
            return this.norm(jGeometry2);
        }
        return null;
    }

    public int adjustClass2Overage(int n, boolean bl, int n2) {
        int n3 = 0;
        int n4 = maxDimByCIIres[n];
        if (n2 != 0) {
            n4 *= 3;
        }
        double[] dArray = this.coords.getPoint();
        if (n2 != 0 && dArray[0] + dArray[1] + dArray[2] == (double)n4) {
            n3 = 1;
        } else if (dArray[0] + dArray[1] + dArray[2] > (double)n4) {
            FaceOrient faceOrient;
            n3 = 2;
            if (dArray[2] > 0.0) {
                if (dArray[1] > 0.0) {
                    faceOrient = this.faceNeighbours[this.face][3];
                } else {
                    faceOrient = this.faceNeighbours[this.face][2];
                    if (bl) {
                        JGeometry jGeometry = new JGeometry((double)n4, 0.0, 0.0, 4326);
                        JGeometry jGeometry2 = this.subtractCoordinates(dArray, jGeometry.getPoint());
                        jGeometry2 = this.rotateCoordinates60cw(jGeometry2.getPoint());
                        this.coords = this.addCoordinates(jGeometry2.getPoint(), jGeometry.getPoint());
                    }
                }
            } else {
                faceOrient = this.faceNeighbours[this.face][1];
            }
            this.face = faceOrient.face;
            for (int i = 0; i < faceOrient.nccw60; ++i) {
                this.coords = this.rotateCoordinates60ccw(this.coords.getPoint());
            }
            JGeometry jGeometry = faceOrient.trans;
            int n5 = unitScaleByCIIres[n];
            if (n2 != 0) {
                n5 *= 3;
            }
            jGeometry = this.scaleCoordinate(jGeometry, n5);
            this.coords = this.norm(this.addCoordinates(this.coords.getPoint(), jGeometry.getPoint()));
            if (n2 != 0 && dArray[0] + dArray[1] + dArray[2] == (double)n4) {
                n3 = 1;
            }
        }
        return n3;
    }

    public JGeometry rotateCoordinates60cw(double[] dArray) {
        JGeometry jGeometry = new JGeometry(1.0, 0.0, 1.0, 4326);
        JGeometry jGeometry2 = new JGeometry(1.0, 1.0, 0.0, 4326);
        JGeometry jGeometry3 = new JGeometry(0.0, 1.0, 1.0, 4326);
        jGeometry = this.scaleCoordinate(jGeometry, (int)dArray[0]);
        jGeometry2 = this.scaleCoordinate(jGeometry2, (int)dArray[1]);
        jGeometry3 = this.scaleCoordinate(jGeometry3, (int)dArray[2]);
        return this.norm(this.addCoordinates(jGeometry.getPoint(), jGeometry2.getPoint(), jGeometry3.getPoint()));
    }

    public JGeometry rotateCoordinates60ccw(double[] dArray) {
        JGeometry jGeometry = new JGeometry(1.0, 1.0, 0.0, 4326);
        JGeometry jGeometry2 = new JGeometry(0.0, 1.0, 1.0, 4326);
        JGeometry jGeometry3 = new JGeometry(1.0, 0.0, 1.0, 4326);
        jGeometry = this.scaleCoordinate(jGeometry, (int)dArray[0]);
        jGeometry2 = this.scaleCoordinate(jGeometry2, (int)dArray[1]);
        jGeometry3 = this.scaleCoordinate(jGeometry3, (int)dArray[2]);
        return this.norm(this.addCoordinates(jGeometry.getPoint(), jGeometry2.getPoint(), jGeometry3.getPoint()));
    }

    public JGeometry faceCoordToLonLat(int n) {
        JGeometry jGeometry = this.coordsToHexCoords();
        JGeometry jGeometry2 = this.hexCoordsToLonLat(jGeometry.getPoint(), n, false);
        return jGeometry2;
    }

    public JGeometry coordsToHexCoords() {
        double[] dArray = this.coords.getPoint();
        int n = (int)(dArray[0] - dArray[2]);
        int n2 = (int)(dArray[1] - dArray[2]);
        dArray[0] = (double)n - 0.5 * (double)n2;
        dArray[1] = (double)n2 * 0.8660254037844386;
        return new JGeometry(dArray[0], dArray[1], 4326);
    }

    public JGeometry hexCoordsToLonLat(double[] dArray, int n, boolean bl) {
        double d = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
        if (d < 1.0E-16) {
            return new JGeometry(faceCenterLL[this.face][0], faceCenterLL[this.face][1], 4326);
        }
        double d2 = Math.atan2(dArray[1], dArray[0]);
        for (int i = 0; i < n; ++i) {
            d /= 2.6457513110645907;
        }
        if (bl) {
            d /= 3.0;
            if (this.isResClass3(n)) {
                d /= 2.6457513110645907;
            }
        }
        d *= 0.3819660112501;
        d = Math.atan(d);
        if (!bl && this.isResClass3(n)) {
            d2 = this.normalizeRads(d2 + 0.3334731722518321);
        }
        d2 = this.normalizeRads(faceAxesAzRadsCII[this.face][0] - d2);
        return this.lonLatAZDistanceRads(faceCenterLL[this.face], d2, d);
    }

    public JGeometry lonLatAZDistanceRads(double[] dArray, double d, double d2) {
        if (d2 < 1.0E-16) {
            return new JGeometry(dArray[1], dArray[0], 4326);
        }
        d = this.normalizeRads(d);
        double[] dArray2 = new double[dArray.length];
        if (d < 1.0E-16 || Math.abs(d - Math.PI) < 1.0E-16) {
            dArray2[1] = d < 1.0E-16 ? dArray[1] + d2 : dArray[1] - d2;
            if (Math.abs(dArray2[1] - 1.5707963267948966) < 1.0E-16) {
                dArray2[1] = 1.5707963267948966;
                dArray2[0] = 0.0;
            } else if (Math.abs(dArray2[1] + 1.5707963267948966) < 1.0E-16) {
                dArray2[1] = -1.5707963267948966;
                dArray2[0] = 0.0;
            } else {
                dArray2[0] = this.clipLongitude(dArray2[0]);
            }
        } else {
            double d3 = Math.sin(dArray[0]) * Math.cos(d2) + Math.cos(dArray[0]) * Math.sin(d2) * Math.cos(d);
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            if (d3 < -1.0) {
                d3 = -1.0;
            }
            dArray2[1] = Math.asin(d3);
            if (Math.abs(dArray2[1] - 1.5707963267948966) < 1.0E-16) {
                dArray2[1] = 1.5707963267948966;
                dArray2[0] = 0.0;
            } else if (Math.abs(dArray2[1] + 1.5707963267948966) < 1.0E-16) {
                dArray2[1] = -1.5707963267948966;
                dArray2[0] = 0.0;
            } else {
                double d4 = Math.sin(d) * Math.sin(d2) / Math.cos(dArray2[1]);
                double d5 = (Math.cos(d2) - Math.sin(dArray[0]) * Math.sin(dArray2[1])) / Math.cos(dArray[0]) / Math.cos(dArray2[1]);
                if (d4 > 1.0) {
                    d4 = 1.0;
                }
                if (d4 < -1.0) {
                    d4 = -1.0;
                }
                if (d5 > 1.0) {
                    d5 = 1.0;
                }
                if (d5 < -1.0) {
                    d5 = -1.0;
                }
                dArray2[0] = this.clipLongitude(dArray[1] + Math.atan2(d4, d5));
            }
        }
        return new JGeometry(dArray2[0], dArray2[1], 4326);
    }

    public double clipLongitude(double d) {
        while (d > Math.PI) {
            d -= Math.PI * 2;
        }
        while (d < -Math.PI) {
            d += Math.PI * 2;
        }
        return d;
    }

    public JGeometry faceCoordsToBoundary(int n, int n2, int n3) {
        int n4;
        int n5 = n;
        Face[] faceArray = this.faceCoordsToVerts(n5);
        if (this.isResClass3(n5)) {
            ++n5;
        }
        int n6 = n3 == 6 ? 1 : 0;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n7 = -1;
        int n8 = 0;
        for (int i = n2; i < n2 + n3 + n6; ++i) {
            Object object;
            JGeometry jGeometry;
            n4 = i % 6;
            Face face = new Face(faceArray[n4]);
            int n9 = face.adjustClass2Overage(n5, false, 1);
            if (this.isResClass3(n) && i > n2 && face.face != n7 && n8 != 1) {
                boolean bl;
                JGeometry jGeometry2;
                JGeometry jGeometry3;
                int n10 = (n4 + 5) % 6;
                jGeometry = faceArray[n10].coordsToHexCoords();
                object = faceArray[n4].coordsToHexCoords();
                int n11 = maxDimByCIIres[n5];
                JGeometry jGeometry4 = new JGeometry(3.0 * (double)n11, 0.0, 4326);
                JGeometry jGeometry5 = new JGeometry(-1.5 * (double)n11, 2.598076211353316 * (double)n11, 4326);
                JGeometry jGeometry6 = new JGeometry(-1.5 * (double)n11, -2.598076211353316 * (double)n11, 4326);
                int n12 = n7 == this.face ? face.face : n7;
                switch (adjacentFaceDir[this.face][n12]) {
                    case 1: {
                        jGeometry3 = jGeometry4;
                        jGeometry2 = jGeometry5;
                        break;
                    }
                    case 3: {
                        jGeometry3 = jGeometry5;
                        jGeometry2 = jGeometry6;
                        break;
                    }
                    default: {
                        assert (adjacentFaceDir[this.face][n12] == 2);
                        jGeometry3 = jGeometry6;
                        jGeometry2 = jGeometry4;
                    }
                }
                JGeometry jGeometry7 = this.intersection(jGeometry.getPoint(), object.getPoint(), jGeometry3.getPoint(), jGeometry2.getPoint());
                boolean bl2 = bl = jGeometry7.equals((Object)jGeometry) || jGeometry7.equals(object);
                if (!bl) {
                    JGeometry jGeometry8 = this.hexCoordsToLonLat(jGeometry7.getPoint(), n5, true);
                    double[] dArray = jGeometry8.getPoint();
                    arrayList.add(dArray[0]);
                    arrayList.add(dArray[1]);
                }
            }
            if (i < n2 + 6) {
                JGeometry jGeometry9 = face.coordsToHexCoords();
                jGeometry = face.hexCoordsToLonLat(jGeometry9.getPoint(), n5, true);
                object = jGeometry.getPoint();
                arrayList.add(object[0]);
                arrayList.add(object[1]);
            }
            n7 = face.face;
            n8 = n9;
        }
        double[] dArray = new double[arrayList.size()];
        for (n4 = 0; n4 < arrayList.size(); ++n4) {
            dArray[n4] = (Double)arrayList.get(n4);
        }
        return JGeometry.createLinearPolygon((double[])dArray, (int)2, (int)4326);
    }

    public JGeometry faceCoordsToBoundaryPent(int n, int n2, int n3) {
        int n4;
        int n5 = n;
        Face[] faceArray = this.faceCoordsPentToVerts(n5);
        if (this.isResClass3(n5)) {
            ++n5;
        }
        int n6 = n3 == 5 ? 1 : 0;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        Face face = new Face();
        for (int i = n2; i < n2 + n3 + n6; ++i) {
            JGeometry jGeometry;
            Face face2;
            n4 = i % 5;
            Face face3 = new Face(faceArray[n4]);
            int n7 = face3.adjustPentOverage(n5);
            if (this.isResClass3(n) && i > n2) {
                JGeometry jGeometry2;
                JGeometry jGeometry3;
                face2 = face3;
                jGeometry = face.coordsToHexCoords();
                int n8 = adjacentFaceDir[face2.face][face.face];
                FaceOrient faceOrient = this.faceNeighbours[face2.face][n8];
                face2.face = faceOrient.face;
                for (int j = 0; j < faceOrient.nccw60; ++j) {
                    face2.coords = this.rotateCoordinates60ccw(face2.coords.getPoint());
                }
                faceOrient.trans = this.scaleCoordinate(faceOrient.trans, unitScaleByCIIres[n5] * 3);
                face2.coords = this.norm(this.addCoordinates(face2.coords.getPoint(), faceOrient.trans.getPoint()));
                JGeometry jGeometry4 = face2.coordsToHexCoords();
                int n9 = maxDimByCIIres[n5];
                JGeometry jGeometry5 = new JGeometry(3.0 * (double)n9, 0.0, 4326);
                JGeometry jGeometry6 = new JGeometry(-1.5 * (double)n9, 2.598076211353316 * (double)n9, 4326);
                JGeometry jGeometry7 = new JGeometry(-1.5 * (double)n9, -2.598076211353316 * (double)n9, 4326);
                switch (adjacentFaceDir[face2.face][face3.face]) {
                    case 1: {
                        jGeometry3 = jGeometry5;
                        jGeometry2 = jGeometry6;
                        break;
                    }
                    case 3: {
                        jGeometry3 = jGeometry6;
                        jGeometry2 = jGeometry7;
                        break;
                    }
                    default: {
                        assert (adjacentFaceDir[face2.face][face3.face] == 2);
                        jGeometry3 = jGeometry7;
                        jGeometry2 = jGeometry5;
                    }
                }
                JGeometry jGeometry8 = this.intersection(jGeometry.getPoint(), jGeometry4.getPoint(), jGeometry3.getPoint(), jGeometry2.getPoint());
                JGeometry jGeometry9 = face2.hexCoordsToLonLat(jGeometry8.getPoint(), n5, true);
                double[] dArray = jGeometry9.getPoint();
                arrayList.add(dArray[0]);
                arrayList.add(dArray[1]);
            }
            if (i < n2 + 5) {
                face2 = face3.coordsToHexCoords();
                jGeometry = face3.hexCoordsToLonLat(face2.getPoint(), n5, true);
                double[] dArray = jGeometry.getPoint();
                arrayList.add(dArray[0]);
                arrayList.add(dArray[1]);
            }
            face = face3;
        }
        double[] dArray = new double[arrayList.size()];
        for (n4 = 0; n4 < arrayList.size(); ++n4) {
            dArray[n4] = (Double)arrayList.get(n4);
        }
        return JGeometry.createLinearPolygon((double[])dArray, (int)2, (int)4326);
    }

    public JGeometry intersection(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        dArray2[0] = dArray2[0] - dArray[0];
        dArray2[1] = dArray2[1] - dArray[1];
        dArray4[0] = dArray4[0] - dArray3[0];
        dArray4[1] = dArray4[1] - dArray3[1];
        double d = (dArray4[0] * (dArray[1] - dArray3[1]) - dArray4[1] * (dArray[0] - dArray3[0])) / (-dArray4[0] * dArray2[1] + dArray2[0] * dArray4[1]);
        return new JGeometry(dArray[0] + d * dArray2[0], dArray[1] + d * dArray2[1], 4326);
    }

    public Face[] faceCoordsToVerts(int n) {
        double[][] dArrayArray = new double[][]{{2.0, 1.0, 0.0}, {1.0, 2.0, 0.0}, {0.0, 2.0, 1.0}, {0.0, 1.0, 2.0}, {1.0, 0.0, 2.0}, {2.0, 0.0, 1.0}};
        double[][] dArrayArray2 = new double[][]{{5.0, 4.0, 0.0}, {1.0, 5.0, 0.0}, {0.0, 5.0, 4.0}, {0.0, 1.0, 5.0}, {4.0, 0.0, 5.0}, {5.0, 0.0, 1.0}};
        double[][] dArrayArray3 = this.isResClass3(n) ? dArrayArray2 : dArrayArray;
        this.coords = this.ccwChildrenAp3(this.coords);
        this.coords = this.cwChildrenAp3(this.coords);
        if (this.isResClass3(n)) {
            this.coords = this.cwChildrenAp7(this.coords);
        }
        Face[] faceArray = new Face[6];
        for (int i = 0; i < 6; ++i) {
            faceArray[i] = new Face();
            faceArray[i].face = this.face;
            faceArray[i].coords = this.norm(this.addCoordinates(this.coords.getPoint(), dArrayArray3[i]));
        }
        return faceArray;
    }

    public Face[] faceCoordsPentToVerts(int n) {
        double[][] dArrayArray = new double[][]{{2.0, 1.0, 0.0}, {1.0, 2.0, 0.0}, {0.0, 2.0, 1.0}, {0.0, 1.0, 2.0}, {1.0, 0.0, 2.0}};
        double[][] dArrayArray2 = new double[][]{{5.0, 4.0, 0.0}, {1.0, 5.0, 0.0}, {0.0, 5.0, 4.0}, {0.0, 1.0, 5.0}, {4.0, 0.0, 5.0}};
        double[][] dArrayArray3 = this.isResClass3(n) ? dArrayArray2 : dArrayArray;
        this.coords = this.ccwChildrenAp3(this.coords);
        this.coords = this.cwChildrenAp3(this.coords);
        if (this.isResClass3(n)) {
            this.coords = this.cwChildrenAp7(this.coords);
        }
        Face[] faceArray = new Face[5];
        for (int i = 0; i < 5; ++i) {
            faceArray[i] = new Face();
            faceArray[i].face = this.face;
            faceArray[i].coords = this.norm(this.addCoordinates(this.coords.getPoint(), dArrayArray3[i]));
        }
        return faceArray;
    }

    public int adjustPentOverage(int n) {
        int n2;
        while ((n2 = this.adjustClass2Overage(n, false, 1)) == 2) {
        }
        return n2;
    }

    public class FaceOrient {
        int face;
        JGeometry trans;
        int nccw60;

        public FaceOrient(int n, double d, double d2, double d3, int n2) {
            this.face = n;
            this.trans = new JGeometry(d, d2, d3, 4326);
            this.nccw60 = n2;
        }
    }
}

