/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import oracle.dbtools.raptor.ssh.InteractionSupport;
import oracle.dbtools.raptor.ssh.RaptorStore;
import oracle.dbtools.raptor.ssh.config.SshConfiguration;
import oracle.dbtools.raptor.ssh.core.Client;
import oracle.dbtools.raptor.ssh.core.ConfigFile;
import oracle.dbtools.raptor.ssh.core.HostDescriptor;
import oracle.dbtools.raptor.ssh.core.KnownHosts;
import oracle.dbtools.raptor.ssh.core.Store;
import oracle.dbtools.util.Logger;
import oracle.ide.ExtensionRegistry;
import oracle.ide.net.URLFactory;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.config.keys.loader.KeyPairResourceParser;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.putty.PuttyKeyUtils;

public final class ClientImpl
extends Client {
    static final String EXT_ID = "oracle.sqldeveloper.ssh";
    static final String STORE_FNAME = "ssh.xml";
    private static final Duration HEARTBEAT_INTERVAL = Duration.ofSeconds(2L);

    protected Store createStore() {
        URL uRL = this.getStoreURL();
        return RaptorStore.createStore(uRL);
    }

    protected URL getStoreURL() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        URL uRL = extensionRegistry.getSystemDirectory(EXT_ID);
        return URLFactory.newURL((URL)uRL, (String)STORE_FNAME);
    }

    protected void initSSHClient() {
        URL uRL;
        Path path;
        SshClient sshClient = this.getSSHClient();
        sshClient.setFilePasswordProvider(InteractionSupport.getPasswordProvider());
        CoreModuleProperties.HEARTBEAT_INTERVAL.set((PropertyResolver)sshClient, (Object)HEARTBEAT_INTERVAL);
        CoreModuleProperties.HEARTBEAT_REPLY_WAIT.set((PropertyResolver)sshClient, (Object)Duration.ofMillis(300L));
        KeyPairResourceParser keyPairResourceParser = SecurityUtils.getKeyPairResourceParser();
        SecurityUtils.setKeyPairResourceParser((KeyPairResourceParser)KeyPairResourceParser.aggregate((KeyPairResourceParser[])new KeyPairResourceParser[]{keyPairResourceParser, PuttyKeyUtils.DEFAULT_INSTANCE}));
        SshConfiguration sshConfiguration = SshConfiguration.getInstance();
        URL uRL2 = sshConfiguration.getKnownHostsFile();
        Path path2 = ClientImpl.convertToPath(uRL2);
        if (path2 != null) {
            this.setKnownHosts(KnownHosts.knownHostsFor((Path)path2, (boolean)false));
        }
        if ((path = ClientImpl.convertToPath(uRL = sshConfiguration.getConfigFile())) != null) {
            this.setConfigFile(ConfigFile.configFileFor((Path)path));
        } else {
            this.setConfigFile(ConfigFile.DEFAULT);
        }
        this.setStrictKeyfilePermissions(sshConfiguration.isStrictKeyfilePermissions());
        sshConfiguration.addStructureChangeListener(new StructureChangeListener(){

            public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
                for (ChangeInfo changeInfo : structureChangeEvent.getChangeDetails()) {
                    Path path;
                    URL uRL;
                    String string = changeInfo.getPropertyLocalName();
                    if ("KnownHosts".equals(string)) {
                        switch (changeInfo.getChangeType()) {
                            case 3: {
                                ClientImpl.this.setKnownHosts(KnownHosts.DEFAULT_LENIENT);
                                break;
                            }
                            case 0: 
                            case 1: {
                                uRL = changeInfo.getNewValueAsURL();
                                path = ClientImpl.convertToPath(uRL);
                                if (path != null) {
                                    ClientImpl.this.setKnownHosts(KnownHosts.knownHostsFor((Path)path, (boolean)false));
                                    break;
                                }
                                ClientImpl.this.setKnownHosts(KnownHosts.DEFAULT_LENIENT);
                            }
                        }
                        continue;
                    }
                    if ("ConfigFile".equals(string)) {
                        switch (changeInfo.getChangeType()) {
                            case 3: {
                                ClientImpl.this.setConfigFile(ConfigFile.DEFAULT);
                                break;
                            }
                            case 0: 
                            case 1: {
                                uRL = changeInfo.getNewValueAsURL();
                                path = ClientImpl.convertToPath(uRL);
                                if (path != null) {
                                    ClientImpl.this.setConfigFile(ConfigFile.configFileFor((Path)path));
                                    break;
                                }
                                ClientImpl.this.setConfigFile(ConfigFile.DEFAULT);
                            }
                        }
                        continue;
                    }
                    if (!"StrictPerms".equals(string) || changeInfo.getChangeType() != 0) continue;
                    ClientImpl.this.setStrictKeyfilePermissions(changeInfo.getNewValueAsBoolean());
                }
            }
        });
        this.setTimeout(120000);
    }

    protected void initSession(ClientSession clientSession, HostDescriptor hostDescriptor) {
        clientSession.setUserInteraction(InteractionSupport.getUserInteraction());
        clientSession.setPasswordIdentityProvider(sessionContext -> ClientImpl.wrap(InteractionSupport.promptForPassword(clientSession)));
    }

    private static Collection<String> wrap(String string) {
        return string != null ? Arrays.asList(string) : Collections.emptyList();
    }

    private static Path convertToPath(URL uRL) {
        Path path = null;
        if (uRL != null) {
            try {
                URI uRI = uRL.toURI();
                path = Paths.get(uRI);
            }
            catch (URISyntaxException uRISyntaxException) {
                Logger.warn(ClientImpl.class, (Throwable)uRISyntaxException);
            }
        }
        return path;
    }
}

