/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.client;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import oracle.spatial.rdf.server.LogUtils;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.RDFLogger;
import oracle.spatial.rdf.server.SPARQLEngine;
import oracle.spatial.rdf.server.TranslateEngine;
import oracle.spatial.rdf.server.URIset;
import oracle.spatial.rdf.server.UpdateEngine;
import oracle.spatial.rdf.server.parser.sparql.ParseException;

public final class SPARQLClientUtils {
    private static final String NULL_MODEL_MSG = "Model names parameter is null.";
    private static final String NULL_SPARQL_MSG = "SPARQL string is null or empty.";
    private static final String MODEL_NOT_EXIST_MSG = "Unable to retrieve model.";
    private static final String CLASS_LOG_PFX = "oracle.spatial.rdf.client.SPARQLClientUtils: ";
    private static final String DEFAULT_RULES_INDEX_STATUS = "INVALID";

    public static String sparqlToSql(Connection connection, String string, String string2, String string3, String[] stringArray, String[] stringArray2, Map<String, String> map, String string4, String string5) throws SQLException, RDFException, ParseException {
        return SPARQLClientUtils.sparqlToSql(connection, string, string2, string3, stringArray, stringArray2, map, string4, string5, null);
    }

    public static String sparqlToSql(Connection connection, String string, String string2, String string3, String[] stringArray, String[] stringArray2, Map<String, String> map, String string4, String string5, RDFLogger rDFLogger) throws SQLException, RDFException, ParseException {
        String string6 = QueryUtils.getNetworkOwnerOrMdsys((String)string4);
        String string7 = QueryUtils.getNetworkNameOrEmptyString((String)string5);
        String string8 = "";
        if (string3 != null && !string3.trim().isEmpty()) {
            string8 = " " + string3.trim().toUpperCase() + " ";
        }
        StringBuffer stringBuffer = new StringBuffer().append("\n").append("----------------- sparqlToSql ----------------\n").append("query=[" + string + "]\n").append("model=[" + string2 + "]\n").append("options=[" + string8 + "]\n").append("defaultUris=").append(Arrays.toString(stringArray)).append("\n").append("ngUris=[").append(Arrays.toString(stringArray2)).append("\n").append("networkOwner=[").append(string6).append("]\n").append("networkName=[").append(string7).append("]\n").append("----------------------------------------------\n");
        LogUtils.info((String)(CLASS_LOG_PFX + stringBuffer.toString()), (RDFLogger)rDFLogger);
        int n = 5;
        TranslateEngine translateEngine = new TranslateEngine(n, connection);
        translateEngine.setOptions(string8);
        String string9 = DEFAULT_RULES_INDEX_STATUS;
        String string10 = QueryUtils.simpleSQLName((String)string2.toUpperCase().trim(), (int)25);
        long[] lArray = new long[1];
        String[] stringArray3 = new String[1];
        String[] stringArray4 = new String[1];
        String[] stringArray5 = new String[1];
        String[] stringArray6 = new String[1];
        String[] stringArray7 = new String[1];
        String[] stringArray8 = new String[1];
        SPARQLClientUtils.getRowSourceInfo(connection, string10, lArray, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, stringArray8, string6, string7, rDFLogger);
        String string11 = "";
        if (string8 != null) {
            string11 = string8.toUpperCase();
        }
        String string12 = null;
        if (stringArray4[0].equals("V")) {
            string12 = string11.contains("ALLOW_DUP=T") ? string6 + "." + QueryUtils.simpleSQLName((String)stringArray8[0], (int)30) : string6 + "." + QueryUtils.simpleSQLName((String)stringArray7[0], (int)30);
        }
        int n2 = 0;
        int[] nArray = new int[]{0};
        if (stringArray4[0].equals("D") && !string11.contains("RDB2RDF_METADATA=T")) {
            n2 = 1;
            nArray[0] = 1;
        }
        HashMap hashMap = SPARQLEngine.setupNamespaceMap();
        long[][] lArrayArray = new long[1][];
        long[][] lArrayArray2 = new long[1][];
        SPARQLClientUtils.populateGraphIds(connection, string, translateEngine, hashMap, stringArray, stringArray2, lArrayArray, lArrayArray2);
        long[] lArray2 = lArrayArray[0];
        long[] lArray3 = lArrayArray2[0];
        int[] nArray2 = null;
        String[] stringArray9 = new String[]{string10};
        String string13 = null;
        long l = 0L;
        long[] lArray4 = new long[]{};
        Object[] objectArray = new String[]{};
        String[][] stringArray10 = new String[1][];
        int[] nArray3 = new int[1];
        ArrayList arrayList = new ArrayList();
        String[] stringArray11 = new String[1];
        String string14 = "\nCalling translateQueryPattern:\n            plist=" + Arrays.toString(nArray2) + "\n            query=[" + string + "]\n precompIndexName=[" + string13 + "]\n     precompIdxID=[" + l + "]\n        idxStatus=[" + string9 + "]\n            dGIDs=" + Arrays.toString(lArray2) + "\n            nGIDs=" + Arrays.toString(lArray3) + "\n            dMIDs=" + Arrays.toString(lArray4) + "\n          dModels=" + Arrays.toString(objectArray) + "\n       vmViewName=[" + string12 + "]\n      model_types=" + Arrays.toString(nArray) + "\n     isRdfVWModel=[" + n2 + "]";
        LogUtils.info((String)(CLASS_LOG_PFX + string14), (RDFLogger)rDFLogger);
        String string15 = translateEngine.translateQueryPattern(nArray2, string, stringArray9, string13, l, string9, lArray2, lArray3, lArray4, (String[])objectArray, hashMap, string12, stringArray10, nArray3, arrayList, stringArray11, nArray, n2, map, string6, string7);
        return string15;
    }

    public static boolean executeSparqlUpdate(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7) throws SQLException, RDFException, ParseException {
        return SPARQLClientUtils.executeSparqlUpdate(connection, string, string2, string3, string4, string5, string6, string7, null);
    }

    public static boolean executeSparqlUpdate(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7, RDFLogger rDFLogger) throws SQLException, RDFException, ParseException {
        if (string2 == null) {
            throw new RDFException(NULL_MODEL_MSG);
        }
        if (string == null) {
            throw new RDFException(NULL_SPARQL_MSG);
        }
        String string8 = QueryUtils.getNetworkOwnerOrMdsys((String)string6);
        String string9 = QueryUtils.getNetworkNameOrEmptyString((String)string7);
        long l = System.currentTimeMillis();
        LogUtils.info((String)("oracle.spatial.rdf.client.SPARQLClientUtils: SPARQL update params: network owner [" + string8 + "], network name [" + string9 + "], model [" + string2 + "]"), (RDFLogger)rDFLogger);
        LogUtils.info((String)("oracle.spatial.rdf.client.SPARQLClientUtils: SPARQL update: " + string), (RDFLogger)rDFLogger);
        String string10 = null;
        String string11 = string10 = QueryUtils.simpleSQLName((String)string2.toUpperCase().trim(), (int)25);
        boolean bl = false;
        if (string3 != null) {
            string11 = QueryUtils.simpleSQLName((String)string3.toUpperCase().trim(), (int)25);
            bl = true;
        }
        LogUtils.info((String)"oracle.spatial.rdf.client.SPARQLClientUtils: getting row source info for apply model", (RDFLogger)rDFLogger);
        long[] lArray = new long[1];
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        String[] stringArray3 = new String[1];
        String[] stringArray4 = new String[1];
        String[] stringArray5 = new String[1];
        String[] stringArray6 = new String[1];
        SPARQLClientUtils.getRowSourceInfo(connection, string10, lArray, stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, string8, string9, rDFLogger);
        long[] lArray2 = new long[1];
        String[] stringArray7 = new String[1];
        String[] stringArray8 = new String[1];
        String[] stringArray9 = new String[1];
        String[] stringArray10 = new String[1];
        String[] stringArray11 = new String[1];
        String[] stringArray12 = new String[1];
        if (bl) {
            LogUtils.info((String)"oracle.spatial.rdf.client.SPARQLClientUtils: getting row source info for different match model", (RDFLogger)rDFLogger);
            SPARQLClientUtils.getRowSourceInfo(connection, string11, lArray2, stringArray7, stringArray8, stringArray9, stringArray10, stringArray11, stringArray12, string8, string9, rDFLogger);
        } else {
            LogUtils.info((String)"oracle.spatial.rdf.client.SPARQLClientUtils: using same row source for match model", (RDFLogger)rDFLogger);
            lArray2[0] = lArray[0];
            stringArray7[0] = stringArray[0];
            stringArray8[0] = stringArray2[0];
            stringArray9[0] = stringArray3[0];
            stringArray10[0] = stringArray4[0];
            stringArray11[0] = stringArray5[0];
            stringArray12[0] = stringArray6[0];
        }
        String string12 = "";
        if (string4 != null) {
            string12 = string4.toUpperCase();
        }
        String string13 = "";
        if (string5 != null) {
            string13 = string5;
        }
        String string14 = null;
        if (stringArray8[0].equals("V")) {
            string14 = string12.contains("ALLOW_DUP=T") ? string8 + "." + QueryUtils.simpleSQLName((String)stringArray12[0], (int)30) : string8 + "." + QueryUtils.simpleSQLName((String)stringArray11[0], (int)30);
        }
        int n = 0;
        int[] nArray = new int[]{0};
        if (stringArray8[0].equals("D") && !string12.contains("RDB2RDF_METADATA=T")) {
            n = 1;
            nArray[0] = 1;
        }
        String string15 = SPARQLClientUtils.getNetTablespace(connection, string8, string9, rDFLogger);
        String string16 = SPARQLClientUtils.getCurrentSchema(connection, rDFLogger);
        String string17 = SPARQLClientUtils.getCurrentUser(connection, rDFLogger);
        long l2 = System.currentTimeMillis();
        LogUtils.info((String)("oracle.spatial.rdf.client.SPARQLClientUtils: time to get metadata information (ms): " + (l2 - l)), (RDFLogger)rDFLogger);
        UpdateEngine updateEngine = new UpdateEngine(connection, string10, lArray[0], stringArray[0], stringArray3[0], stringArray4[0], new String[]{string11}, null, 0L, DEFAULT_RULES_INDEX_STATUS, string14, n, string12, string13, string16, string17, string15, 0, true, string8, string9);
        long l3 = System.currentTimeMillis();
        LogUtils.info((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Time to initialize update engine (ms): " + (l3 - l2)), (RDFLogger)rDFLogger);
        updateEngine.doUpdate(string);
        long l4 = System.currentTimeMillis();
        LogUtils.info((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Time to execute SPARQL update (ms): " + (l4 - l3)), (RDFLogger)rDFLogger);
        LogUtils.info((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Total time for SPARQL update (ms): " + (l4 - l)), (RDFLogger)rDFLogger);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getRowSourceInfo(Connection connection, String string, long[] lArray, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String[] stringArray6, String string2, String string3, RDFLogger rDFLogger) throws SQLException, RDFException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String string4 = SPARQLClientUtils.addPfxForRdfObjName("RDF_MODEL$", string2, string3);
            String string5 = SPARQLClientUtils.addPfxForRdfObjName("SEM_VMODEL_INFO", string2, string3);
            String string6 = "SELECT m.model_id, m.owner, m.model_type, m.table_name, m.column_name, v.unique_view_name, v.duplicate_view_name FROM " + string4 + " m, " + string5 + " v WHERE m.model_name = v.virtual_model_name(+) AND m.model_name = ?";
            statement = connection.prepareStatement(string6);
            statement.setString(1, string);
            LogUtils.trace((String)("oracle.spatial.rdf.client.SPARQLClientUtils: RowSourceInfo SQL: " + string6), (RDFLogger)rDFLogger);
            resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                LogUtils.error((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Unable to find model: " + string), (RDFLogger)rDFLogger);
                throw new RDFException(MODEL_NOT_EXIST_MSG);
            }
            lArray[0] = resultSet.getLong(1);
            stringArray[0] = resultSet.getString(2);
            stringArray2[0] = resultSet.getString(3);
            stringArray3[0] = resultSet.getString(4);
            stringArray4[0] = resultSet.getString(5);
            stringArray5[0] = resultSet.getString(6);
            stringArray6[0] = resultSet.getString(7);
            String string7 = "\n---------------- Row Source Info -----------------\n   modelName=[" + string + "]\n     modelId=[" + lArray[0] + "]\n  modelOwner=[" + stringArray[0] + "]\n   modelType=[" + stringArray2[0] + "]\n   tableName=[" + stringArray3[0] + "]\n  columnName=[" + stringArray4[0] + "]\nvmUniqueView=[" + stringArray5[0] + "]\n   vmDupView=[" + stringArray6[0] + "]\n--------------------------------------------------";
            LogUtils.info((String)(CLASS_LOG_PFX + string7), (RDFLogger)rDFLogger);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing rs:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing ps:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
        }
    }

    private static void populateGraphIds(Connection connection, String string, TranslateEngine translateEngine, HashMap hashMap, String[] stringArray, String[] stringArray2, long[][] lArray, long[][] lArray2) throws SQLException, RDFException, ParseException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add("<" + stringArray[i] + ">");
            }
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                arrayList2.add("<" + stringArray2[i] + ">");
            }
        }
        translateEngine.getSources(string, hashMap, arrayList, arrayList2);
        URIset uRIset = new URIset();
        for (String string2 : arrayList) {
            uRIset.put(string2.substring(1, string2.length() - 1));
        }
        for (String string2 : arrayList2) {
            uRIset.put(string2.substring(1, string2.length() - 1));
        }
        uRIset.resolve(connection);
        Object object = new long[arrayList.size()];
        int n = 0;
        for (String object2 : arrayList) {
            String string2 = uRIset.get(object2.substring(1, object2.length() - 1));
            object[n] = string2 != null ? (Object)Long.parseLong(string2) : (Object)0L;
            ++n;
        }
        Object object3 = new long[arrayList2.size()];
        n = 0;
        for (String string2 : arrayList2) {
            String string3 = uRIset.get(string2.substring(1, string2.length() - 1));
            object3[n] = string3 != null ? (Object)Long.parseLong(string3) : (Object)0L;
            ++n;
        }
        lArray[0] = (long[])object;
        lArray2[0] = (long[])object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCurrentSchema(Connection connection, RDFLogger rDFLogger) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        String string = null;
        try {
            String string2 = "select sys_context('userenv','current_schema') from sys.dual";
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                string = resultSet.getString(1);
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing rs:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing stmt:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCurrentUser(Connection connection, RDFLogger rDFLogger) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        String string = null;
        try {
            String string2 = "select sys_context('userenv','current_user') from sys.dual";
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                string = resultSet.getString(1);
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing rs:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing stmt:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getNetTablespace(Connection connection, String string, String string2, RDFLogger rDFLogger) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string3 = null;
        String string4 = QueryUtils.getNetworkNamePfx((String)string2) + "RDF_VALUE$";
        String string5 = QueryUtils.getNetworkOwnerOrMdsys((String)string);
        try {
            String string6 = "select /*+ result_cache dynamic_sampling(0) parallel(1) */ tablespace_name from sys.all_tables where table_name=? and owner=?";
            preparedStatement = connection.prepareStatement(string6);
            preparedStatement.setString(1, string4);
            preparedStatement.setString(2, QueryUtils.checkRemoveEnclosingQuotes((String)string5));
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string3 = resultSet.getString(1);
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing rs:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing ps:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
        }
        return string3;
    }

    private static String addPfxForRdfObjName(String string, String string2, String string3) throws SQLException {
        String string4 = QueryUtils.getNetworkOwnerOrMdsys((String)string2);
        String string5 = QueryUtils.getNetworkNameOrEmptyString((String)string3);
        String string6 = QueryUtils.getPfxForRdfObjName((String)string4, (String)string5);
        return string6 + QueryUtils.simpleSQLName((String)string, (int)30);
    }
}

