/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.inspector;

import java.awt.Component;
import javax.swing.JTable;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.xml.gui.base.inspector.XmlDomPropertyModel;
import oracle.bali.xml.gui.swing.inspector.SwingInspectorGui;
import oracle.bali.xml.gui.swing.inspector.XmlInspectorCellRenderer;

class IconAddingCellRenderer
extends XmlInspectorCellRenderer {
    private final SwingInspectorGui _gui;

    IconAddingCellRenderer(SwingInspectorGui gui) {
        this._gui = gui;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        PropertyModel model = (PropertyModel)table.getModel();
        Object modelMessages = model.getData(PropertyModel.COLUMN_VALIDATION_ISSUES, row);
        if (this._gui.containsErrorMessage(modelMessages)) {
            this.setIcon(this._gui.getErrorIcon());
        } else if (this._gui.containsWarningMessage(modelMessages)) {
            this.setIcon(this._gui.getWarningIcon());
        } else {
            Object o = model.getData(XmlDomPropertyModel.COLUMN_IS_DATABOUND, row);
            if (Boolean.TRUE.equals(o)) {
                this.setIcon(this._gui.getDataboundIcon());
            } else if (Boolean.TRUE.equals(model.getData(XmlDomPropertyModel.COLUMN_IS_SET, row))) {
                this.setIcon(this._gui.getAttributeSetIcon());
            } else if (Boolean.FALSE.equals(model.getData(PropertyModel.COLUMN_IS_DRILLABLE, row))) {
                this.setIcon(this._gui.getSpacerIcon());
            } else {
                this.setIcon(null);
            }
        }
        this.setDeprecatedStatus(row, model);
        this.setToolTip(row, model);
        return super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
    }
}

